/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class BaseProperty<T extends BaseProperty<T>> {
    public PropMap propertyHolder;
    public Runnable onDependenciesChanged;
    protected Map<String, Object> providerData = new HashMap<String, Object>();

    public BaseProperty() {
        this(new PropMap());
    }

    public BaseProperty(PropMap propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public ResourceLocation getId() {
        return ParticlePropertyRegistry.PARTICLE_PROPERTY_REGISTRY.getKey(this.getType());
    }

    public Component getName() {
        return Component.translatable((String)(this.getId().getNamespace() + ".particle.property." + this.getId().getPath()));
    }

    public abstract ParticleConfigWidgetProvider buildWidgets(int var1, int var2, int var3, int var4);

    public abstract IPropertyType<T> getType();

    public void setChangedListener(Runnable onDependenciesChanged) {
        this.onDependenciesChanged = onDependenciesChanged;
    }

    public List<BaseProperty<?>> subProperties() {
        return new ArrayList();
    }

    public boolean survivesMotionChange() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.propertyHolder);
    }
}

