/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.google.common.collect.Maps;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.SconceTile;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SconceBlock
extends TickableModBlock {
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap(Map.of(Direction.NORTH, Block.box((double)5.0, (double)3.0, (double)10.0, (double)11.0, (double)13.0, (double)16.0), Direction.SOUTH, Block.box((double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)6.0), Direction.WEST, Block.box((double)10.0, (double)3.0, (double)5.0, (double)16.0, (double)13.0, (double)11.0), Direction.EAST, Block.box((double)0.0, (double)3.0, (double)5.0, (double)6.0, (double)13.0, (double)11.0)));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final Property<Integer> LIGHT_LEVEL = IntegerProperty.create((String)"level", (int)0, (int)15);

    public SconceBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.0f, 3.0f).noOcclusion().noCollission().lightLevel(b -> (Integer)b.getValue(LIGHT_LEVEL)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis().isHorizontal()) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
        }
        return null;
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AABBS.get(p_220053_1_.getValue((Property)FACING));
    }

    public BlockState updateShape(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return p_196271_2_.getOpposite() == p_196271_1_.getValue((Property)FACING) && !p_196271_1_.canSurvive((LevelReader)p_196271_4_, p_196271_5_) ? Blocks.AIR.defaultBlockState() : p_196271_1_;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{LIGHT_LEVEL});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SconceTile(pos, state);
    }
}

