/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SingleItemTile
extends ModdedTile
implements Container {
    protected ItemStack stack = ItemStack.EMPTY;
    public ItemEntity renderEntity;

    public SingleItemTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public ItemStack getItem(int pSlot) {
        return this.stack;
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        ItemStack copyStack = this.stack.copy().split(pAmount);
        this.stack.shrink(pAmount);
        this.updateBlock();
        return copyStack;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack stack = this.stack.copy();
        this.stack = ItemStack.EMPTY;
        this.updateBlock();
        return stack;
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.stack = pStack;
        this.updateBlock();
    }

    public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        return this.stack.isEmpty();
    }

    public boolean stillValid(Player pPlayer) {
        return false;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.updateBlock();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack otherStack) {
        this.stack = otherStack;
        this.updateBlock();
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compound.getCompound("itemStack"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (!this.stack.isEmpty()) {
            try {
                Tag stackTag = this.stack.save(pRegistries);
                tag.put("itemStack", stackTag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

