/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.event.SpellProjectileHitEvent;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.ProjectileTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataSerializers;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityProjectileSpell
extends ColoredProjectile
implements GeoEntity {
    public int age;
    protected boolean playedSpawnParticle;
    @Deprecated(forRemoval=true)
    public SpellResolver spellResolver;
    public int pierceLeft;
    public int numSensitive;
    public boolean isNoGravity = true;
    public boolean canTraversePortals = true;
    public int prismRedirect;
    public ParticleEmitter tickEmitter;
    public ParticleEmitter resolveEmitter;
    public ParticleEmitter onSpawnEmitter;
    public ParticleEmitter flairEmitter;
    public ConfiguredSpellSound castSound;
    public ConfiguredSpellSound resolveSound;
    public static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.defineId(EntityProjectileSpell.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<SpellResolver> SPELL_RESOLVER = SynchedEntityData.defineId(EntityProjectileSpell.class, (EntityDataSerializer)((EntityDataSerializer)DataSerializers.SPELL_RESOLVER.get()));
    @Deprecated
    public int expireTime = 1200;
    public Set<BlockPos> hitList = new HashSet<BlockPos>();
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, Level world, double x, double y, double z) {
        super(entityType, world, x, y, z);
    }

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn, LivingEntity shooter) {
        super(type, worldIn, shooter);
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
    }

    public EntityProjectileSpell(Level world, double x, double y, double z) {
        this((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.SPELL_PROJ.get()), world, x, y, z);
    }

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, Level world, SpellResolver resolver) {
        this(entityType, world, resolver.spellContext.getUnwrappedCaster());
        this.setResolver(resolver);
        this.pierceLeft = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.getUnwrappedCaster(), AugmentPierce.INSTANCE);
        this.numSensitive = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.getUnwrappedCaster(), AugmentSensitive.INSTANCE);
    }

    public EntityProjectileSpell(Level world, SpellResolver resolver) {
        this((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.SPELL_PROJ.get()), world, resolver);
    }

    public EntityProjectileSpell(Level world, LivingEntity shooter) {
        this((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.SPELL_PROJ.get()), world, shooter);
    }

    public SpellResolver resolver() {
        return (SpellResolver)this.entityData.get(SPELL_RESOLVER);
    }

    public void setResolver(SpellResolver resolver) {
        this.entityData.set(SPELL_RESOLVER, (Object)resolver);
        this.spellResolver = resolver;
        this.buildEmitters();
    }

    protected boolean canRide(Entity vehicle) {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.age == 0 && this.castSound != null && !this.level.isClientSide) {
            this.castSound.playSound(this.level, this.getX(), this.getY(), this.getZ());
        }
        ++this.age;
        if (!this.level.isClientSide && this.age > this.getExpirationTime() || !this.level.isClientSide && this.resolver() == null) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        Vec3 thisPosition = this.position();
        Vec3 nextPosition = this.getNextHitPosition();
        this.traceAnyHit(this.getHitResult(), thisPosition, nextPosition);
        this.tickNextPosition();
        if (this.level.isClientSide && this.age >= this.getParticleDelay()) {
            this.playParticles();
        }
    }

    public HitResult getHitResult() {
        Vec3 thisPosition = this.position();
        Vec3 nextPosition = this.getNextHitPosition();
        return this.level.clip(new ClipContext(thisPosition, nextPosition, this.numSensitive > 0 ? ClipContext.Block.OUTLINE : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OWNER_ID, (Object)-1);
        pBuilder.define(SPELL_RESOLVER, (Object)new SpellResolver(new SpellContext(this.level, new Spell(), null, null)));
    }

    public Vec3 getNextHitPosition() {
        return this.position().add(this.getDeltaMovement());
    }

    public void traceAnyHit(@javax.annotation.Nullable HitResult raytraceresult, Vec3 thisPosition, Vec3 nextPosition) {
        EntityHitResult entityraytraceresult;
        if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
            nextPosition = raytraceresult.getLocation();
        }
        if ((entityraytraceresult = this.findHitEntity(thisPosition, nextPosition)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.onHit(raytraceresult);
            this.hasImpulse = true;
        }
        if (raytraceresult != null && raytraceresult.getType() == HitResult.Type.MISS && raytraceresult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)raytraceresult;
            if (this.canTraversePortals()) {
                ((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).onProjectileHit(this.level, this.level.getBlockState(BlockPos.containing((Position)raytraceresult.getLocation())), blockHitResult, this);
            }
        }
    }

    @javax.annotation.Nullable
    public HitResult transformHitResult(@javax.annotation.Nullable HitResult hitResult) {
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitResult1 = (BlockHitResult)hitResult;
            return new BlockHitResult(hitResult1.getLocation(), hitResult1.getDirection(), hitResult1.getBlockPos(), false);
        }
        return hitResult;
    }

    public boolean canTraversePortals() {
        return this.canTraversePortals;
    }

    public int getExpirationTime() {
        return MethodProjectile.INSTANCE.getProjectileLifespan() * 20;
    }

    public void tickNextPosition() {
        Vec3 vec3d = this.getDeltaMovement();
        double x = this.getX() + vec3d.x;
        double y = this.getY() + vec3d.y;
        double z = this.getZ() + vec3d.z;
        if (!this.isNoGravity()) {
            this.setDeltaMovement(vec3d.x * 0.96, (vec3d.y > 0.0 ? vec3d.y * 0.97 : vec3d.y) - (double)0.03f, vec3d.z * 0.96);
        }
        this.setPos(x, y, z);
    }

    public int getParticleDelay() {
        return 2;
    }

    public void buildEmitters() {
        TimelineMap timelineMap = this.resolver().spell.particleTimeline();
        ProjectileTimeline projectileTimeline = (ProjectileTimeline)timelineMap.get((IParticleTimelineType)ParticleTimelineRegistry.PROJECTILE_TIMELINE.get());
        TimelineEntryData trailConfig = projectileTimeline.trailEffect;
        TimelineEntryData resolveConfig = projectileTimeline.onResolvingEffect;
        TimelineEntryData spawnConfig = projectileTimeline.onSpawnEffect;
        TimelineEntryData flairConfig = projectileTimeline.flairEffect;
        this.tickEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityProjectileSpell)this).getRotationVector(), trailConfig);
        this.resolveEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityProjectileSpell)this).getRotationVector(), resolveConfig);
        this.onSpawnEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityProjectileSpell)this).getRotationVector(), spawnConfig);
        this.flairEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityProjectileSpell)this).getRotationVector(), flairConfig);
        Vec3 center = this.getDimensions(this.getPose()).makeBoundingBox(0.0, 0.0, 0.0).getCenter();
        this.tickEmitter.setPositionOffset(center);
        this.resolveEmitter.setPositionOffset(center);
        this.onSpawnEmitter.setPositionOffset(center);
        this.flairEmitter.setPositionOffset(center);
        this.castSound = projectileTimeline.castSound.sound;
        this.resolveSound = projectileTimeline.resolveSound.sound;
    }

    public void playParticles() {
        if (this.tickEmitter == null && this.resolver() != null) {
            this.buildEmitters();
        }
        if (this.tickEmitter != null) {
            this.tickEmitter.tick(this.level);
        }
        if (this.flairEmitter != null) {
            this.flairEmitter.tick(this.level);
        }
        if (!this.playedSpawnParticle && this.onSpawnEmitter != null) {
            this.onSpawnEmitter.tick(this.level);
            this.playedSpawnParticle = true;
        }
    }

    @Override
    @javax.annotation.Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level, (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vec3d);
        float f = Mth.sqrt((float)((float)vec3d.horizontalDistanceSqr()));
        this.yRot = (float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875);
        this.xRot = (float)(Mth.atan2((double)vec3d.y, (double)f) * 57.2957763671875);
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
    }

    public void setRemoved(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
            reason = Entity.RemovalReason.DISCARDED;
        }
        super.setRemoved(reason);
    }

    public EntityProjectileSpell setGravity(boolean noGravity) {
        this.isNoGravity = !noGravity;
        return this;
    }

    public boolean isNoGravity() {
        return this.isNoGravity;
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.SPELL_PROJ.get();
    }

    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.level.broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean canBounce() {
        return !this.isNoGravity() && this.pierceLeft > 0;
    }

    public void bounce(BlockHitResult blockHitResult) {
        Direction direction = blockHitResult.getDirection();
        float factor = -0.9f;
        switch (direction) {
            case UP: 
            case DOWN: {
                Vec3 vel = this.getDeltaMovement();
                this.setDeltaMovement(vel.x(), (double)factor * vel.y(), vel.z());
                break;
            }
            case EAST: 
            case WEST: {
                Vec3 vel = this.getDeltaMovement();
                this.setDeltaMovement((double)factor * vel.x(), vel.y(), vel.z());
                break;
            }
            case NORTH: 
            case SOUTH: {
                Vec3 vel = this.getDeltaMovement();
                this.setDeltaMovement(vel.x(), vel.y(), (double)factor * vel.z());
            }
        }
    }

    protected void onHit(HitResult result) {
        result = this.transformHitResult(result);
        if (!this.level.isClientSide) {
            SpellProjectileHitEvent event = new SpellProjectileHitEvent(this, result);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (entityHitResult.getEntity().equals((Object)this.getOwner())) {
                    return;
                }
                if (this.resolver() != null) {
                    this.resolver().onResolveEffect(this.level, result);
                    this.sendResolveParticles();
                    this.attemptRemoval();
                }
            }
            if (result instanceof BlockHitResult) {
                BlockHitResult blockraytraceresult = (BlockHitResult)result;
                if (!this.isRemoved() && !this.hitList.contains(blockraytraceresult.getBlockPos())) {
                    BlockState state = this.level.getBlockState(blockraytraceresult.getBlockPos());
                    Block block = state.getBlock();
                    if (block instanceof IPrismaticBlock) {
                        IPrismaticBlock prismaticBlock = (IPrismaticBlock)block;
                        prismaticBlock.onHit((ServerLevel)this.level, blockraytraceresult.getBlockPos(), this);
                        return;
                    }
                    if (state.is(BlockTags.PORTALS)) {
                        state.entityInside(this.level, blockraytraceresult.getBlockPos(), (Entity)this);
                        return;
                    }
                    if (state.getBlock() instanceof TargetBlock) {
                        this.onHitBlock(blockraytraceresult);
                    }
                    if (this.canBounce()) {
                        this.bounce(blockraytraceresult);
                        if (this.numSensitive > 1) {
                            --this.pierceLeft;
                            return;
                        }
                    }
                    if (this.resolver() != null) {
                        this.hitList.add(blockraytraceresult.getBlockPos());
                        this.resolver().onResolveEffect(this.level, (HitResult)blockraytraceresult);
                    }
                    this.sendResolveParticles();
                    this.attemptRemoval();
                }
            }
        }
    }

    public void sendResolveParticles() {
        this.resolveEmitter.tick(this.level);
        if (!this.level.isClientSide && this.resolveSound != null) {
            this.resolveSound.playSound(this.level, this.getX(), this.getY(), this.getZ());
        }
    }

    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) || entity.getType().is(EntityTags.SPELL_CAN_HIT);
    }

    @Deprecated(forRemoval=true)
    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isNoGravity);
        buffer.writeInt(this.numSensitive);
    }

    @Deprecated(forRemoval=true)
    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.isNoGravity = additionalData.readBoolean();
        this.numSensitive = additionalData.readInt();
    }

    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        Entity entity = this.level.getEntity(pPacket.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public void setOwner(@Nullable Entity pOwner) {
        super.setOwner(pOwner);
        if (pOwner != null) {
            this.entityData.set(OWNER_ID, (Object)pOwner.getId());
        } else {
            this.entityData.set(OWNER_ID, (Object)-1);
        }
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (this.resolver() != null) {
            this.resolver().spellContext.level = this.level;
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.spellResolver = null;
        if (tag.contains("pierce")) {
            this.pierceLeft = tag.getInt("pierce");
        }
        this.isNoGravity = tag.getBoolean("gravity");
        this.entityData.set(OWNER_ID, (Object)tag.getInt("ownerId"));
        if (tag.contains("resolver")) {
            this.setResolver((SpellResolver)ANCodecs.decode(SpellResolver.CODEC.codec(), tag.get("resolver")));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("pierce", this.pierceLeft);
        tag.putBoolean("gravity", this.isNoGravity);
        tag.putInt("ownerId", ((Integer)this.entityData.get(OWNER_ID)).intValue());
        if (this.resolver() != null) {
            tag.put("resolver", ANCodecs.encode(SpellResolver.CODEC.codec(), this.resolver()));
        }
    }

    public Entity changeDimension(@NotNull DimensionTransition transition) {
        Entity changed = super.changeDimension(transition);
        if (!(changed instanceof EntityProjectileSpell)) {
            return changed;
        }
        EntityProjectileSpell spell = (EntityProjectileSpell)changed;
        spell.setResolver(this.resolver());
        spell.resolver().spellContext.level = transition.newLevel();
        spell.prismRedirect = this.prismRedirect;
        spell.age = this.age;
        spell.numSensitive = this.numSensitive;
        return changed;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

