/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wealdwalker;

import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.entity.goal.AnimatedAttackGoal;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;

public class SmashGoal
extends AnimatedAttackGoal {
    WealdWalker walker;

    public SmashGoal(WealdWalker entity, boolean followUnseen, Supplier<Boolean> canAttack, int animationID, int animationLength, int attackRange) {
        super((Mob)entity, followUnseen, canAttack, animationID, animationLength, attackRange, 1.2f);
        this.walker = entity;
    }

    @Override
    public boolean canUse() {
        return super.canUse() && !(this.mob.getTarget() instanceof Creeper);
    }

    @Override
    public void stop() {
        super.stop();
        this.walker.getEntityData().set(WealdWalker.SMASHING, (Object)false);
    }

    @Override
    protected void attack(LivingEntity target) {
        super.attack(target);
        target.knockback((double)1.2f, (double)Mth.sin((float)(this.walker.yRot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.walker.yRot * ((float)Math.PI / 180)))));
        this.walker.smashCooldown = 60;
    }

    @Override
    public void onArrive() {
        super.onArrive();
        this.walker.getEntityData().set(WealdWalker.SMASHING, (Object)true);
    }

    @Override
    public void look(LivingEntity entity) {
    }
}

