/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketMountCamera
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketMountCamera> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("mount_camera"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketMountCamera> CODEC = StreamCodec.ofMember(PacketMountCamera::encode, PacketMountCamera::decode);
    private BlockPos pos;

    public PacketMountCamera() {
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
    }

    public PacketMountCamera(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(PacketMountCamera message, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos);
    }

    public static PacketMountCamera decode(RegistryFriendlyByteBuf buf) {
        return new PacketMountCamera(buf.readBlockPos());
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Level level = player.level;
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof ICameraMountable) {
            ICameraMountable mountable = (ICameraMountable)blockEntity;
            mountable.mountCamera(level, this.pos, (Player)player);
            return;
        }
        PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.camera.not_loaded"));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

