/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.ValueSource;
import org.apache.lucene.ars_nouveau.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.BoolFunction;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;

public abstract class ComparisonBoolFunction
extends BoolFunction {
    private final ValueSource lhs;
    private final ValueSource rhs;
    private final String name;

    public ComparisonBoolFunction(ValueSource lhs, ValueSource rhs, String name) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.name = name;
    }

    public abstract boolean compare(int var1, FunctionValues var2, FunctionValues var3) throws IOException;

    public String name() {
        return this.name;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues lhsVal = this.lhs.getValues(context, readerContext);
        final FunctionValues rhsVal = this.rhs.getValues(context, readerContext);
        final String compLabel = this.name();
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc) throws IOException {
                return ComparisonBoolFunction.this.compare(doc, lhsVal, rhsVal);
            }

            @Override
            public String toString(int doc) throws IOException {
                return compLabel + "(" + lhsVal.toString(doc) + "," + rhsVal.toString(doc) + ")";
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return lhsVal.exists(doc) && rhsVal.exists(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonBoolFunction other = (ComparisonBoolFunction)o;
        return this.name().equals(other.name()) && this.lhs.equals(other.lhs) && this.rhs.equals(other.rhs);
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        h = h * 31 + this.name().hashCode();
        h = h * 31 + this.lhs.hashCode();
        h = h * 31 + this.rhs.hashCode();
        return h;
    }

    @Override
    public String description() {
        return this.name() + "(" + this.lhs.description() + "," + this.rhs.description() + ")";
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        this.lhs.createWeight(context, searcher);
        this.rhs.createWeight(context, searcher);
    }
}

