package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

import static com.hollingsworth.arsnouveau.ArsNouveau.MODID;

public class SoundRegistry {
    public static final DeferredRegister<SoundEvent> SOUND_REG = DeferredRegister.create(BuiltInRegistries.SOUND_EVENT, MODID);
    public static final String DEFAULT_SOUND_LIB = "fire_family";
    public static final String GAIA_SOUND_LIB = "gaia_family";
    public static final String TEMPESTRY_SOUND_LIB = "tempestry_family";
    public static final String FIRE_SOUND_LIB = "fire_family_2";
    public static final String NO_SOUND_LIB = "empty";

    public static final String EA_CHANNEL = "ea_channel";
    public static final String EA_FINISH = "ea_finish";

    public static DeferredHolder<SoundEvent, SoundEvent> DEFAULT_FAMILY = SOUND_REG.register(DEFAULT_SOUND_LIB, () -> makeSound(DEFAULT_SOUND_LIB));
    public static DeferredHolder<SoundEvent, SoundEvent> EMPTY_SOUND_FAMILY = SOUND_REG.register(NO_SOUND_LIB, () -> makeSound(NO_SOUND_LIB));
    public static DeferredHolder<SoundEvent, SoundEvent> APPARATUS_CHANNEL = SOUND_REG.register(EA_CHANNEL, () -> makeSound(EA_CHANNEL));
    public static DeferredHolder<SoundEvent, SoundEvent> APPARATUS_FINISH = SOUND_REG.register(EA_FINISH, () -> makeSound(EA_FINISH));

    public static DeferredHolder<SoundEvent, SoundEvent> GAIA_FAMILY = SOUND_REG.register(GAIA_SOUND_LIB, () -> makeSound(GAIA_SOUND_LIB));
    public static DeferredHolder<SoundEvent, SoundEvent> TEMPESTRY_FAMILY = SOUND_REG.register(TEMPESTRY_SOUND_LIB, () -> makeSound(TEMPESTRY_SOUND_LIB));
    public static DeferredHolder<SoundEvent, SoundEvent> FIRE_FAMILY = SOUND_REG.register(FIRE_SOUND_LIB, () -> makeSound(FIRE_SOUND_LIB));
    public static DeferredHolder<SoundEvent, SoundEvent> ARIA_BIBLIO = SOUND_REG.register("aria_biblio", () -> makeSound("aria_biblio"));
    public static DeferredHolder<SoundEvent, SoundEvent> WILD_HUNT = SOUND_REG.register("firel_the_wild_hunt", () -> makeSound("firel_the_wild_hunt"));

    public static DeferredHolder<SoundEvent, SoundEvent> SOUND_OF_GLASS = SOUND_REG.register("thistle_the_sound_of_glass", () -> makeSound("thistle_the_sound_of_glass"));
    public static DeferredHolder<SoundEvent, SoundEvent> DOMINION_WAND_FAIL = SOUND_REG.register("dominion_wand_fail", () -> makeSound("dominion_wand_fail"));
    public static DeferredHolder<SoundEvent, SoundEvent> DOMINION_WAND_SUCCESS = SOUND_REG.register("dominion_wand_success", () -> makeSound("dominion_wand_success"));
    public static DeferredHolder<SoundEvent, SoundEvent> DOMINION_WAND_SELECT = SOUND_REG.register("dominion_wand_select", () -> makeSound("dominion_wand_select"));
    public static DeferredHolder<SoundEvent, SoundEvent> DOMINION_WAND_CLEAR = SOUND_REG.register("dominion_wand_clear", () -> makeSound("dominion_wand_clear"));

    public static SpellSound DEFAULT_SPELL_SOUND = new SpellSound(SoundRegistry.DEFAULT_FAMILY, Component.translatable("ars_nouveau.sound.fire_family"), ArsNouveau.prefix(DEFAULT_SOUND_LIB)).withSortNum(5);
    public static SpellSound EMPTY_SPELL_SOUND = new SpellSound(SoundRegistry.EMPTY_SOUND_FAMILY, Component.translatable("ars_nouveau.sound.empty"), ArsNouveau.prefix(NO_SOUND_LIB)).withSortNum(1);
    public static SpellSound GAIA_SPELL_SOUND = new SpellSound(SoundRegistry.GAIA_FAMILY, Component.translatable("ars_nouveau.sound.gaia_family"), ArsNouveau.prefix(GAIA_SOUND_LIB)).withSortNum(5);
    public static SpellSound TEMPESTRY_SPELL_SOUND = new SpellSound(SoundRegistry.TEMPESTRY_FAMILY, Component.translatable("ars_nouveau.sound.tempestry_family"), ArsNouveau.prefix(TEMPESTRY_SOUND_LIB)).withSortNum(5);
    public static SpellSound FIRE_SPELL_SOUND = new SpellSound(SoundRegistry.FIRE_FAMILY, Component.translatable("ars_nouveau.sound.pyro"), ArsNouveau.prefix(FIRE_SOUND_LIB)).withSortNum(5);
    public static SpellSound ALLAY_AMBIENT_WITH_ITEM = register(SoundEvents.ALLAY_AMBIENT_WITH_ITEM, "allay_ambient_with_item");
    public static SpellSound ALLAY_AMBIENT_WITHOUT_ITEM = register(SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, "allay_ambient_without_item");
    public static SpellSound ALLAY_DEATH = register(SoundEvents.ALLAY_DEATH, "allay_death");
    public static SpellSound ALLAY_HURT = register(SoundEvents.ALLAY_HURT, "allay_hurt");
    public static SpellSound AMBIENT_UNDERWATER_ENTER = register(SoundEvents.AMBIENT_UNDERWATER_ENTER, "ambient_underwater_enter");
    public static SpellSound AMETHYST_BLOCK_BREAK = register(SoundEvents.AMETHYST_BLOCK_BREAK, "amethyst_block_break");
    public static SpellSound AMETHYST_BLOCK_CHIME = register(SoundEvents.AMETHYST_BLOCK_CHIME, "amethyst_block_chime");
    public static SpellSound ANVIL_LAND = register(SoundEvents.ANVIL_LAND, "anvil_land");
    public static SpellSound ARROW_HIT = register(SoundEvents.ARROW_HIT, "arrow_hit");
    public static SpellSound ARROW_SHOOT = register(SoundEvents.ARROW_SHOOT, "arrow_shoot");
    public static SpellSound AXE_STRIP = register(SoundEvents.AXE_STRIP, "axe_strip");
    public static SpellSound AXE_SCRAPE = register(SoundEvents.AXE_SCRAPE, "axe_scrape");
    public static SpellSound BAMBOO_FALL = register(SoundEvents.BAMBOO_FALL, "bamboo_fall");
    public static SpellSound BAT_AMBIENT = register(SoundEvents.BAT_AMBIENT, "bat_ambient");
    public static SpellSound BEACON_ACTIVATE = register(SoundEvents.BEACON_ACTIVATE, "beacon_activate");
    public static SpellSound BEACON_DEACTIVATE = register(SoundEvents.BEACON_DEACTIVATE, "beacon_deactivate");
    public static SpellSound BEACON_POWER_SELECT = register(SoundEvents.BEACON_POWER_SELECT, "beacon_power_select");
    public static SpellSound BEE_STING = register(SoundEvents.BEE_STING, "bee_sting");
    public static SpellSound BEEHIVE_WORK = register(SoundEvents.BEEHIVE_WORK, "beehive_work");
    public static SpellSound BELL_BLOCK = register(SoundEvents.BELL_BLOCK, "bell_block");
    public static SpellSound BELL_RESONATE = register(SoundEvents.BELL_RESONATE, "bell_resonate");
    public static SpellSound BLAZE_BURN = register(SoundEvents.BLAZE_BURN, "blaze_burn");
    public static SpellSound BLAZE_SHOOT = register(SoundEvents.BLAZE_SHOOT, "blaze_shoot");
    public static SpellSound BOGGED_AMBIENT = register(SoundEvents.BOGGED_AMBIENT, "bogged_ambient");
    public static SpellSound BOGGED_HURT = register(SoundEvents.BOGGED_HURT, "bogged_hurt");
    public static SpellSound BONE_MEAL_USE = register(SoundEvents.BONE_MEAL_USE, "bone_meal_use");
    public static SpellSound BOTTLE_EMPTY = register(SoundEvents.BOTTLE_EMPTY, "bottle_empty");
    public static SpellSound BOTTLE_FILL = register(SoundEvents.BOTTLE_FILL, "bottle_fill");
    public static SpellSound BOTTLE_FILL_DRAGONBREATH = register(SoundEvents.BOTTLE_FILL_DRAGONBREATH, "bottle_fill_dragonbreath");
    public static SpellSound BREEZE_CHARGE = register(SoundEvents.BREEZE_CHARGE, "breeze_charge");
    public static SpellSound BREEZE_DEFLECT = register(SoundEvents.BREEZE_DEFLECT, "breeze_deflect");
    public static SpellSound BREEZE_SHOOT = register(SoundEvents.BREEZE_SHOOT, "breeze_shoot");
    public static SpellSound BREEZE_JUMP = register(SoundEvents.BREEZE_JUMP, "breeze_jump");
    public static SpellSound BREEZE_WIND_CHARGE_BURST = register(SoundEvents.BREEZE_WIND_CHARGE_BURST, "breeze_wind_charge_burst");
    public static SpellSound BREWING_STAND_BREW = register(SoundEvents.BREWING_STAND_BREW, "brewing_stand_brew");
    public static SpellSound BUBBLE_COLUMN_UPWARDS_INSIDE = register(SoundEvents.BUBBLE_COLUMN_UPWARDS_INSIDE, "bubble_column_upwards_inside");
    public static SpellSound BUCKET_EMPTY = register(SoundEvents.BUCKET_EMPTY, "bucket_empty");
    public static SpellSound BUCKET_FILL = register(SoundEvents.BUCKET_FILL, "bucket_fill");
    public static SpellSound CAT_AMBIENT = register(SoundEvents.CAT_AMBIENT, "cat_ambient");
    public static SpellSound CAT_HISS = register(SoundEvents.CAT_HISS, "cat_hiss");
    public static SpellSound CHAIN_BREAK = register(SoundEvents.CHAIN_BREAK, "chain_break");
    public static SpellSound CHAIN_FALL = register(SoundEvents.CHAIN_FALL, "chain_fall");
    public static SpellSound CHICKEN_EGG = register(SoundEvents.CHICKEN_EGG, "chicken_egg");
    public static SpellSound CHICKEN_AMBIENT = register(SoundEvents.CHICKEN_AMBIENT, "chicken_ambient");
    public static SpellSound CHORUS_FRUIT_TELEPORT = register(SoundEvents.CHORUS_FRUIT_TELEPORT, "chorus_fruit_teleport");
    public static SpellSound COMPARATOR_CLICK = register(SoundEvents.COMPARATOR_CLICK, "comparator_click");
    public static SpellSound COW_AMBIENT = register(SoundEvents.COW_AMBIENT, "cow_ambient");
    public static SpellSound CREEPER_PRIMED = register(SoundEvents.CREEPER_PRIMED, "creeper_primed");
    public static SpellSound DOLPHIN_AMBIENT = register(SoundEvents.DOLPHIN_AMBIENT, "dolphin_ambient");
    public static SpellSound DOLPHIN_ATTACK = register(SoundEvents.DOLPHIN_ATTACK, "dolphin_attack");
    public static SpellSound DOLPHIN_PLAY = register(SoundEvents.DOLPHIN_PLAY, "dolphin_play");
    public static SpellSound DONKEY_AMBIENT = register(SoundEvents.DONKEY_AMBIENT, "donkey_ambient");
    public static SpellSound DROWNED_AMBIENT = register(SoundEvents.DROWNED_AMBIENT, "drowned_ambient");
    public static SpellSound ELDER_GUARDIAN_CURSE = register(SoundEvents.ELDER_GUARDIAN_CURSE, "elder_guardian_curse");
    public static SpellSound ENCHANTMENT_TABLE_USE = register(SoundEvents.ENCHANTMENT_TABLE_USE, "enchantment_table_use");
    public static SpellSound DRAGON_FIREBALL_EXPLODE = register(SoundEvents.DRAGON_FIREBALL_EXPLODE, "dragon_fireball_explode");
    public static SpellSound ENDER_DRAGON_FLAP = register(SoundEvents.ENDER_DRAGON_FLAP, "ender_dragon_flap");
    public static SpellSound ENDER_EYE_DEATH = register(SoundEvents.ENDER_EYE_DEATH, "ender_eye_death");
    public static SpellSound ENDERMAN_AMBIENT = register(SoundEvents.ENDERMAN_AMBIENT, "enderman_ambient");
    public static SpellSound ENDERMAN_TELEPORT = register(SoundEvents.ENDERMAN_TELEPORT, "enderman_teleport");
    public static SpellSound ENDERMITE_AMBIENT = register(SoundEvents.ENDERMITE_AMBIENT, "endermite_ambient");
    public static SpellSound END_GATEWAY_SPAWN = register(SoundEvents.END_GATEWAY_SPAWN, "end_gateway_spawn");
    public static SpellSound END_PORTAL_FRAME_FILL = register(SoundEvents.END_PORTAL_FRAME_FILL, "end_portal_frame_fill");
    public static SpellSound EVOKER_AMBIENT = register(SoundEvents.EVOKER_AMBIENT, "evoker_ambient");
    public static SpellSound EVOKER_CAST_SPELL = register(SoundEvents.EVOKER_CAST_SPELL, "evoker_cast_spell");
    public static SpellSound EVOKER_FANGS_ATTACK = register(SoundEvents.EVOKER_FANGS_ATTACK, "evoker_fangs_attack");
    public static SpellSound EXPERIENCE_ORB_PICKUP = register(SoundEvents.EXPERIENCE_ORB_PICKUP, "experience_orb_pickup");
    public static SpellSound FIREWORK_ROCKET_BLAST = register(SoundEvents.FIREWORK_ROCKET_BLAST, "firework_rocket_blast");
    public static SpellSound FIREWORK_ROCKET_LARGE_BLAST = register(SoundEvents.FIREWORK_ROCKET_LARGE_BLAST, "firework_rocket_large_blast");
    public static SpellSound FIREWORK_ROCKET_LAUNCH = register(SoundEvents.FIREWORK_ROCKET_LAUNCH, "firework_rocket_launch");
    public static SpellSound FIREWORK_ROCKET_TWINKLE = register(SoundEvents.FIREWORK_ROCKET_TWINKLE, "firework_rocket_twinkle");
    public static SpellSound FIRE_AMBIENT = register(SoundEvents.FIRE_AMBIENT, "fire_ambient");
    public static SpellSound FIRE_EXTINGUISH = register(SoundEvents.FIRE_EXTINGUISH, "fire_extinguish");
    public static SpellSound FOX_AMBIENT = register(SoundEvents.FOX_AMBIENT, "fox_ambient");
    public static SpellSound FOX_SCREECH = register(SoundEvents.FOX_SCREECH, "fox_screech");
    public static SpellSound FROG_AMBIENT = register(SoundEvents.FROG_AMBIENT, "frog_ambient");
    public static SpellSound GENERIC_DRINK = register(SoundEvents.GENERIC_DRINK, "generic_drink");
    public static SpellSound GENERIC_EAT = register(SoundEvents.GENERIC_EAT, "generic_eat");
    public static SpellSound GHAST_AMBIENT = register(SoundEvents.GHAST_AMBIENT, "ghast_ambient");
    public static SpellSound GHAST_SCREAM = register(SoundEvents.GHAST_SCREAM, "ghast_scream");
    public static SpellSound GHAST_WARN = register(SoundEvents.GHAST_WARN, "ghast_warn");
    public static SpellSound GLASS_BREAK = register(SoundEvents.GLASS_BREAK, "glass_break");
    public static SpellSound GRINDSTONE_USE = register(SoundEvents.GRINDSTONE_USE, "grindstone_use");
    public static SpellSound GROWING_PLANT_CROP = register(SoundEvents.GROWING_PLANT_CROP, "growing_plant_crop");
    public static SpellSound GUARDIAN_HURT = register(SoundEvents.GUARDIAN_HURT, "guardian_hurt");
    public static SpellSound TRIAL_SPAWNER_SPAWN_MOB = register(SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, "trial_spawner_spawn_mob");
    public static SpellSound TRIAL_SPAWNER_DETECT_PLAYER = register(SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, "trial_spawner_detect_player");
    public static SpellSound HONEY_DRINK = register(SoundEvents.HONEY_DRINK, "honey_drink");
    public static SpellSound HORSE_GALLOP = register(SoundEvents.HORSE_GALLOP, "horse_gallop");
    public static SpellSound HORSE_AMBIENT = register(SoundEvents.HORSE_AMBIENT, "horse_ambient");
    public static SpellSound HOSTILE_HURT = register(SoundEvents.HOSTILE_HURT, "hostile_hurt");
    public static SpellSound ILLUSIONER_AMBIENT = register(SoundEvents.ILLUSIONER_AMBIENT, "illusioner_ambient");
    public static SpellSound ILLUSIONER_CAST_SPELL = register(SoundEvents.ILLUSIONER_CAST_SPELL, "illusioner_cast_spell");
    public static SpellSound ILLUSIONER_MIRROR_MOVE = register(SoundEvents.ILLUSIONER_MIRROR_MOVE, "illusioner_mirror_move");
    public static SpellSound LAVA_EXTINGUISH = register(SoundEvents.LAVA_EXTINGUISH, "lava_extinguish");
    public static SpellSound LAVA_POP = register(SoundEvents.LAVA_POP, "lava_pop");
    public static SpellSound LIGHTNING_BOLT_IMPACT = register(SoundEvents.LIGHTNING_BOLT_IMPACT, "lightning_bolt_impact");
    public static SpellSound MACE_SMASH_AIR = register(SoundEvents.MACE_SMASH_AIR, "mace_smash_air");
    public static SpellSound MACE_SMASH_GROUND = register(SoundEvents.MACE_SMASH_GROUND, "mace_smash_ground");
    public static SpellSound MACE_SMASH_GROUND_HEAVY = register(SoundEvents.MACE_SMASH_GROUND_HEAVY, "mace_smash_ground_heavy");
    public static SpellSound MOOSHROOM_CONVERT = register(SoundEvents.MOOSHROOM_CONVERT, "mooshroom_convert");
    public static SpellSound PHANTOM_BITE = register(SoundEvents.PHANTOM_BITE, "phantom_bite");
    public static SpellSound PIGLIN_CONVERTED_TO_ZOMBIFIED = register(SoundEvents.PIGLIN_CONVERTED_TO_ZOMBIFIED, "piglin_converted_to_zombified");
    public static SpellSound PISTON_CONTRACT = register(SoundEvents.PISTON_CONTRACT, "piston_contract");
    public static SpellSound PISTON_EXTEND = register(SoundEvents.PISTON_EXTEND, "piston_extend");
    public static SpellSound PLAYER_ATTACK_CRIT = register(SoundEvents.PLAYER_ATTACK_CRIT, "player_attack_crit");
    public static SpellSound PLAYER_LEVELUP = register(SoundEvents.PLAYER_LEVELUP, "player_levelup");
    public static SpellSound PORTAL_TRIGGER = register(SoundEvents.PORTAL_TRIGGER, "portal_trigger");
    public static SpellSound POINTED_DRIPSTONE_WATER = register(SoundEvents.POINTED_DRIPSTONE_DRIP_WATER, "pointed_dripstone_drip_water");
    public static SpellSound POINTED_DRIPSTONE_LAVA = register(SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA, "pointed_dripstone_drip_lava");
    public static SpellSound PUFFER_FISH_BLOW_OUT = register(SoundEvents.PUFFER_FISH_BLOW_OUT, "puffer_fish_blow_out");
    public static SpellSound PUFFER_FISH_BLOW_UP = register(SoundEvents.PUFFER_FISH_BLOW_UP, "puffer_fish_blow_up");
    public static SpellSound PUFFER_FISH_STING = register(SoundEvents.PUFFER_FISH_STING, "puffer_fish_sting");
    public static SpellSound PUMPKIN_CARVE = register(SoundEvents.PUMPKIN_CARVE, "pumpkin_carve");
    public static SpellSound RAVAGER_STUNNED = register(SoundEvents.RAVAGER_STUNNED, "ravager_stunned");
    public static SpellSound RAVAGER_ROAR = register(SoundEvents.RAVAGER_ROAR, "ravager_roar");
    public static SpellSound SCULK_CLICKING = register(SoundEvents.SCULK_CLICKING, "sculk_clicking");
    public static SpellSound SCULK_SHRIEKER_SHRIEK = register(SoundEvents.SCULK_SHRIEKER_SHRIEK, "sculk_shrieker_shriek");
    public static SpellSound SHIELD_BLOCK = register(SoundEvents.SHIELD_BLOCK, "shield_block");
    public static SpellSound SHIELD_BREAK = register(SoundEvents.SHIELD_BREAK, "shield_break");
    public static SpellSound SHULKER_BULLET_HIT = register(SoundEvents.SHULKER_BULLET_HIT, "shulker_bullet_hit");
    public static SpellSound SKELETON_CONVERTED_TO_STRAY = register(SoundEvents.SKELETON_CONVERTED_TO_STRAY, "skeleton_converted_to_stray");
    public static SpellSound SILVERFISH_AMBIENT = register(SoundEvents.SILVERFISH_AMBIENT, "silverfish_ambient");
    public static SpellSound SKELETON_SHOOT = register(SoundEvents.SKELETON_SHOOT, "skeleton_shoot");
    public static SpellSound SNIFFER_SNIFFING = register(SoundEvents.SNIFFER_SNIFFING, "sniffer_sniffing");
    public static SpellSound SNIFFER_HAPPY = register(SoundEvents.SNIFFER_HAPPY, "sniffer_happy");
    public static SpellSound SNIFFER_EGG_CRACK = register(SoundEvents.SNIFFER_EGG_CRACK, "sniffer_egg_crack");
    public static SpellSound SPONGE_ABSORB = register(SoundEvents.SPONGE_ABSORB, "sponge_absorb");
    public static SpellSound TNT_PRIMED = register(SoundEvents.TNT_PRIMED, "tnt_primed");
    public static SpellSound THORNS_HIT = register(SoundEvents.THORNS_HIT, "thorns_hit");
    public static SpellSound TRIDENT_RETURN = register(SoundEvents.TRIDENT_RETURN, "trident_return");
    public static SpellSound TRIDENT_RIPTIDE_3 = register(SoundEvents.TRIDENT_RIPTIDE_3, "trident_riptide_3");
    public static SpellSound VAULT_ACTIVATE = register(SoundEvents.VAULT_ACTIVATE, "vault_activate");
    public static SpellSound VEX_CHARGE = register(SoundEvents.VEX_CHARGE, "vex_charge");
    public static SpellSound VILLAGER_AMBIENT = register(SoundEvents.VILLAGER_AMBIENT, "villager_ambient");
    public static SpellSound WARDEN_ATTACK_IMPACT = register(SoundEvents.WARDEN_ATTACK_IMPACT, "warden_attack_impact");
    public static SpellSound WARDEN_HEARTBEAT = register(SoundEvents.WARDEN_HEARTBEAT, "warden_heartbeat");
    public static SpellSound WARDEN_LISTENING = register(SoundEvents.WARDEN_LISTENING, "warden_listening");
    public static SpellSound WARDEN_SONIC_BOOM = register(SoundEvents.WARDEN_SONIC_BOOM, "warden_sonic_boom");
    public static SpellSound WARDEN_SONIC_CHARGE = register(SoundEvents.WARDEN_SONIC_CHARGE, "warden_sonic_charge");
    public static SpellSound WARDEN_TENDRIL_CLICKS = register(SoundEvents.WARDEN_TENDRIL_CLICKS, "warden_tendril_clicks");
    public static SpellSound WEATHER_RAIN = register(SoundEvents.WEATHER_RAIN, "weather_rain");
    public static SpellSound WIND_CHARGE_BURST = register(SoundEvents.WIND_CHARGE_BURST, "wind_charge_burst");
    public static SpellSound WITCH_AMBIENT = register(SoundEvents.WITCH_AMBIENT, "witch_ambient");
    public static SpellSound WITCH_CELEBRATE = register(SoundEvents.WITCH_CELEBRATE, "witch_celebrate");
    public static SpellSound WITCH_DRINK = register(SoundEvents.WITCH_DRINK, "witch_drink");
    public static SpellSound WOLF_ARMOR_BREAK = register(SoundEvents.WOLF_ARMOR_BREAK, "wolf_armor_break");
    public static SpellSound WOLF_ARMOR_CRACK = register(SoundEvents.WOLF_ARMOR_CRACK, "wolf_armor_crack");
    public static SpellSound WOLF_AMBIENT = register(SoundEvents.WOLF_AMBIENT, "wolf_ambient");
    public static SpellSound WOLF_HOWL = register(SoundEvents.WOLF_HOWL, "wolf_howl");
    public static SpellSound WOLF_SHAKE = register(SoundEvents.WOLF_SHAKE, "wolf_shake");
    public static SpellSound ZOMBIE_INFECT = register(SoundEvents.ZOMBIE_INFECT, "zombie_infect");
    public static SpellSound ZOMBIE_VILLAGER_CONVERTED = register(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, "zombie_villager_converted");
    public static SpellSound ZOMBIE_VILLAGER_CURE = register(SoundEvents.ZOMBIE_VILLAGER_CURE, "zombie_villager_cure");
    public static SpellSound APPLY_EFFECT_BAD_OMEN = register(SoundEvents.APPLY_EFFECT_BAD_OMEN, "apply_effect_bad_omen");
    public static SpellSound APPLY_EFFECT_TRIAL_OMEN = register(SoundEvents.APPLY_EFFECT_TRIAL_OMEN, "apply_effect_trial_omen");
    public static SpellSound APPLY_EFFECT_RAID_OMEN = register(SoundEvents.APPLY_EFFECT_RAID_OMEN, "apply_effect_raid_omen");
    
    public static final SpellSound HORSE_DEATH = register(SoundEvents.HORSE_DEATH, "horse_death");
    public static final SpellSound ARMADILLO_HURT_REDUCED = register(SoundEvents.ARMADILLO_HURT_REDUCED, "armadillo_hurt_reduced");
    public static final SpellSound WITHER_AMBIENT = register(SoundEvents.WITHER_AMBIENT, "wither_ambient");
    public static final SpellSound WITHER_DEATH = register(SoundEvents.WITHER_DEATH, "wither_death");
    public static final SpellSound WITHER_HURT = register(SoundEvents.WITHER_HURT, "wither_hurt");
    public static final SpellSound WITHER_SHOOT = register(SoundEvents.WITHER_SHOOT, "wither_shoot");
    public static final SpellSound WITHER_BREAK_BLOCK = register(SoundEvents.WITHER_BREAK_BLOCK, "wither_break_block");
    public static final SpellSound ZOGLIN_AMBIENT = register(SoundEvents.ZOGLIN_AMBIENT, "zoglin_ambient");
    public static final SpellSound ZOGLIN_ANGRY = register(SoundEvents.ZOGLIN_ANGRY, "zoglin_angry");
    public static final SpellSound ZOGLIN_ATTACK = register(SoundEvents.ZOGLIN_ATTACK, "zoglin_attack");
    public static final SpellSound WATER_AMBIENT = register(SoundEvents.WATER_AMBIENT, "water_ambient");
    public static final SpellSound WARDEN_AGITATED = register(SoundEvents.WARDEN_AGITATED, "warden_agitated");
    public static final SpellSound WARDEN_AMBIENT = register(SoundEvents.WARDEN_AMBIENT, "warden_ambient");
    public static final SpellSound WARDEN_DEATH = register(SoundEvents.WARDEN_DEATH, "warden_death");
    public static final SpellSound WARDEN_DIG = register(SoundEvents.WARDEN_DIG, "warden_dig");
    public static final SpellSound WARDEN_EMERGE = register(SoundEvents.WARDEN_EMERGE, "warden_emerge");
    public static final SpellSound WARDEN_HURT = register(SoundEvents.WARDEN_HURT, "warden_hurt");
    public static final SpellSound WARDEN_SNIFF = register(SoundEvents.WARDEN_SNIFF, "warden_sniff");
    public static final SpellSound TRIDENT_THUNDER = register(SoundEvents.TRIDENT_THUNDER, "trident_thunder");
    public static final SpellSound TRIDENT_THROW = register(SoundEvents.TRIDENT_THROW, "trident_throw");
    public static final SpellSound TOTEM_USE = register(SoundEvents.TOTEM_USE, "totem_use");
    public static final SpellSound SQUID_SQUIRT = register(SoundEvents.SQUID_SQUIRT, "squid_squirt");

    public static SpellSound register(Holder<SoundEvent> soundEvent, String name) {
        return SpellSoundRegistry.registerSpellSound(new SpellSound(soundEvent, Component.translatable("ars_nouveau.sound." + name), ArsNouveau.prefix(name)));
    }

    public static SpellSound register(SoundEvent soundEvent, String name) {
        return SpellSoundRegistry.registerSpellSound(new SpellSound(Holder.direct(soundEvent), Component.translatable("ars_nouveau.sound." + name), ArsNouveau.prefix(name)));
    }

    static SoundEvent makeSound(String name) {
        return SoundEvent.createVariableRangeEvent(ArsNouveau.prefix(name));
    }

}
