/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class ChimeraSummonEvent
implements ITimedEvent {
    int duration;
    int phase;
    Level world;
    BlockPos pos;
    int ownerID;
    public static final String ID = "chimera";

    public ChimeraSummonEvent(int duration, int phase, Level world, BlockPos pos, int ownerID) {
        this.duration = duration;
        this.phase = phase;
        this.world = world;
        this.pos = pos;
        this.ownerID = ownerID;
    }

    public static ChimeraSummonEvent get(CompoundTag tag) {
        return new ChimeraSummonEvent(tag.getInt("duration"), tag.getInt("phase"), ArsNouveau.proxy.getClientWorld(), NBTUtil.getBlockPos(tag, "loc"), -1);
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (serverSide) {
            Entity owner = this.world.getEntity(this.ownerID);
            if (!(owner instanceof WildenChimera)) {
                this.duration = 0;
                return;
            }
            WildenChimera boss = (WildenChimera)owner;
            boolean summonedWilden = false;
            if (this.duration % 20 == 0) {
                RandomSource random = boss.getRandom();
                SummonWolf wolf = new SummonWolf((EntityType<? extends Wolf>)((EntityType)ModEntities.SUMMON_WOLF.get()), this.world);
                wolf.setPos(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
                wolf.isWildenSummon = true;
                wolf.ticksLeft = 600 + this.phase * 60;
                this.summon((Mob)wolf, this.getPos(), boss.getTarget());
                int randBound = 8 - boss.getPhase();
                if (boss.hasWings() && boss.level.random.nextInt(randBound) == 0) {
                    WildenStalker stalker = new WildenStalker((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_STALKER.get()), this.world);
                    this.summon((Mob)stalker, this.getPos(), boss.getTarget());
                    summonedWilden = true;
                }
                if (!summonedWilden && boss.hasHorns() && boss.level.random.nextInt(randBound) == 0) {
                    WildenHunter hunter = new WildenHunter((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_HUNTER.get()), this.world);
                    this.summon((Mob)hunter, this.getPos(), boss.getTarget());
                    summonedWilden = true;
                }
                if (!summonedWilden && boss.hasSpikes() && boss.level.random.nextInt(randBound) == 0) {
                    WildenGuardian guardian = new WildenGuardian((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_GUARDIAN.get()), this.world);
                    this.summon((Mob)guardian, this.getPos(), boss.getTarget());
                    summonedWilden = true;
                }
            }
        } else {
            ParticleUtil.spawnRitualAreaEffect(this.pos, this.world, this.world.random, ParticleColor.defaultParticleColor(), 1 + this.phase * 2);
        }
    }

    public void summon(Mob mob, BlockPos pos, @Nullable LivingEntity target) {
        mob.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        mob.setTarget(target);
        mob.setAggressive(true);
        mob.level.addFreshEntity((Entity)mob);
    }

    public BlockPos getPos() {
        double spawnArea = 2.5 + (double)(this.phase * 2);
        return BlockPos.containing((double)((double)this.pos.getX() + ParticleUtil.inRange(-spawnArea, spawnArea)), (double)(this.pos.getY() + 2), (double)((double)this.pos.getZ() + ParticleUtil.inRange(-spawnArea, spawnArea)));
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        ITimedEvent.super.serialize(tag);
        tag.putInt("duration", this.duration);
        tag.putInt("phase", this.phase);
        NBTUtil.storeBlockPos(tag, "loc", this.pos);
        return tag;
    }

    @Override
    public String getID() {
        return ID;
    }
}

