/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineOption;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectedParticleButton;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class MotionProperty
extends BaseProperty<MotionProperty> {
    private static MotionProperty instance = new MotionProperty();
    public static MapCodec<MotionProperty> CODEC = MapCodec.unit((Object)instance);
    public static StreamCodec<RegistryFriendlyByteBuf, MotionProperty> STREAM_CODEC = StreamCodec.unit((Object)instance);
    TimelineOption timelineOption;
    List<BaseProperty<?>> nestedProps;

    private MotionProperty() {
    }

    public MotionProperty(TimelineOption timelineOption) {
        this(timelineOption, new ArrayList());
    }

    public MotionProperty(TimelineOption timelineOption, List<BaseProperty<?>> props) {
        super(timelineOption.entry().particleOptions().map);
        this.timelineOption = timelineOption;
        this.nestedProps = props;
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        return new ParticleConfigWidgetProvider(x, y, width, height){

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(MotionProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void addWidgets(List<AbstractWidget> widgets) {
                ImmutableList<IParticleMotionType<?>> options = MotionProperty.this.timelineOption.options();
                for (int i = 0; i < options.size(); ++i) {
                    IParticleMotionType type = (IParticleMotionType)options.get(i);
                    SelectedParticleButton widget = new SelectedParticleButton(this.x + 5 + i % 7 * 16, this.y + 20 + 18 * (i / 7), 14, 14, type.getIconLocation(), button -> {
                        PropMap motionMap = MotionProperty.this.timelineOption.entry().motion().propertyMap;
                        motionMap.removePropsOnMotionChange();
                        MotionProperty.this.timelineOption.entry().particleOptions().map.removePropsOnMotionChange();
                        MotionProperty.this.timelineOption.entry().setMotion((ParticleMotion)type.create(motionMap));
                        if (MotionProperty.this.onDependenciesChanged != null) {
                            MotionProperty.this.onDependenciesChanged.run();
                        }
                    });
                    widget.withTooltip(type.getName());
                    widgets.add((AbstractWidget)widget);
                }
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                graphics.blit(MotionProperty.this.timelineOption.entry().motion().getType().getIconLocation(), x, y, 0, 0.0f, 14.0f, 14, 14, 14, 14);
            }

            public Component timelineName() {
                ResourceLocation id = MotionProperty.this.timelineOption.id();
                return Component.translatable((String)(id.getNamespace() + ".timeline." + id.getPath()));
            }

            @Override
            public Component getButtonTitle() {
                return Component.literal((String)(this.timelineName().getString() + ": " + MotionProperty.this.timelineOption.entry().motion().getType().getName().getString()));
            }

            @Override
            public void getButtonTooltips(List<Component> tooltip) {
                super.getButtonTooltips(tooltip);
                tooltip.add(MotionProperty.this.timelineOption.tooltip());
            }
        };
    }

    @Override
    public IPropertyType<MotionProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.MOTION_PROPERTY.get();
    }

    @Override
    public List<BaseProperty<?>> subProperties() {
        ArrayList allProps = new ArrayList(this.nestedProps);
        allProps.addAll(this.timelineOption.entry().motion().getProperties(this.propertyHolder));
        return allProps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof MotionProperty)) return false;
        MotionProperty that = (MotionProperty)obj;
        if (!this.timelineOption.equals(that.timelineOption)) return false;
        if (!this.propertyHolder.equals(that.propertyHolder)) return false;
        if (!this.nestedProps.equals(that.nestedProps)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timelineOption, this.propertyHolder, this.nestedProps);
    }
}

