/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.buttons.ANButton;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

public class GlyphButton
extends ANButton {
    public AbstractSpellPart abstractSpellPart;
    public List<SpellValidationError> validationErrors;
    public AbstractSpellPart augmentingParent;

    public GlyphButton(int x, int y, AbstractSpellPart abstractSpellPart, Button.OnPress onPress) {
        super(x, y, 16, 16, onPress);
        this.abstractSpellPart = abstractSpellPart;
        this.validationErrors = new LinkedList<SpellValidationError>();
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.visible) {
            return;
        }
        RenderUtils.drawSpellPart(this.abstractSpellPart, graphics, this.x, this.y, 16, !this.validationErrors.isEmpty(), 0);
    }

    @Override
    public void getTooltip(List<Component> tip) {
        if (!GlyphRegistry.getSpellpartMap().containsKey(this.abstractSpellPart.getRegistryName())) {
            return;
        }
        AbstractSpellPart spellPart = GlyphRegistry.getSpellpartMap().get(this.abstractSpellPart.getRegistryName());
        tip.add((Component)Component.translatable((String)spellPart.getLocalizationKey()));
        for (SpellValidationError spellValidationError : this.validationErrors) {
            tip.add((Component)spellValidationError.makeTextComponentAdding().withStyle(ChatFormatting.RED));
        }
        if (Screen.hasShiftDown()) {
            tip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_level", (Object[])new Object[]{spellPart.getConfigTier().value}).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
            tip.add((Component)Component.translatable((String)"ars_nouveau.schools"));
            for (SpellSchool spellSchool : spellPart.spellSchools) {
                tip.add(spellSchool.getTextComponent());
            }
            tip.add(spellPart.getBookDescLang());
        } else {
            tip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getKey().getDisplayName()}));
            String modName = ModList.get().getModContainerById(spellPart.getRegistryName().getNamespace()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(spellPart.getRegistryName().getNamespace());
            tip.add((Component)Component.literal((String)modName).withStyle(ChatFormatting.BLUE));
        }
        AbstractSpellPart abstractSpellPart = this.abstractSpellPart;
        if (abstractSpellPart instanceof AbstractAugment) {
            AbstractAugment augment = (AbstractAugment)abstractSpellPart;
            if (this.augmentingParent != null) {
                if (this.validationErrors != null && !this.validationErrors.isEmpty()) {
                    return;
                }
                Component component = this.augmentingParent.augmentDescriptions.get(augment);
                if (component != null) {
                    tip.add((Component)Component.translatable((String)"ars_nouveau.augmenting", (Object[])new Object[]{this.augmentingParent.getLocaleName()}));
                    tip.add((Component)component.copy().withStyle(ChatFormatting.GOLD));
                }
            }
        }
    }
}

