/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ParticleRenderTypes;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class ParticleGlow
extends TextureSheetParticle {
    public float colorR = 0.0f;
    public float colorG = 0.0f;
    public float colorB = 0.0f;
    public float initScale = 0.0f;
    public float initAlpha = 0.0f;
    public boolean disableDepthTest;

    public ParticleGlow(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float a, float scale, int lifetime, SpriteSet sprite, boolean disableDepthTest) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.hasPhysics = false;
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        if ((double)this.colorR > 1.0) {
            this.colorR /= 255.0f;
        }
        if ((double)this.colorG > 1.0) {
            this.colorG /= 255.0f;
        }
        if ((double)this.colorB > 1.0) {
            this.colorB /= 255.0f;
        }
        this.setColor(this.colorR, this.colorG, this.colorB);
        this.lifetime = (int)((float)lifetime * 0.5f);
        this.quadSize = 0.0f;
        this.initScale = scale;
        this.xd = vx * 2.0;
        this.yd = vy * 2.0;
        this.zd = vz * 2.0;
        this.initAlpha = a;
        this.pickSprite(sprite);
        this.disableDepthTest = disableDepthTest;
    }

    public ParticleRenderType getRenderType() {
        return this.disableDepthTest ? ParticleRenderTypes.EMBER_RENDER_NO_MASK : ParticleRenderTypes.EMBER_RENDER;
    }

    public int getLightColor(float pTicks) {
        return 255;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.render(buffer, renderInfo, partialTicks);
    }

    public void tick() {
        super.tick();
        if (this.level.random.nextInt(6) == 0) {
            ++this.age;
        }
        float lifeCoeff = (float)this.age / (float)this.lifetime;
        this.quadSize = this.initScale - this.initScale * lifeCoeff;
        this.alpha = this.initAlpha * (1.0f - lifeCoeff);
        this.oRoll = this.roll;
        this.roll += 1.0f;
    }
}

