/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.mixin.BlockBehaviourAccessor;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemGrate
extends ModBlock
implements BucketPickup {
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public ItemGrate() {
        super(ItemGrate.defaultProperties().noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockState below = pLevel.getBlockState(pPos.below());
        BlockHitResult belowRes = new BlockHitResult(pHitResult.getLocation().add(0.0, -1.0, 0.0), pHitResult.getDirection(), pPos.below(), pHitResult.isInside());
        return below.useItemOn(pStack, pLevel, pPlayer, pHand, belowRes);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockState below = pLevel.getBlockState(pPos.below());
        return below.useWithoutItem(pLevel, pPlayer, new BlockHitResult(pHitResult.getLocation().add(0.0, -1.0, 0.0), pHitResult.getDirection(), pPos.below(), pHitResult.isInside()));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        LiquidBlockContainer blockContainer;
        super.tick(pState, pLevel, pPos, pRandom);
        BlockPos below = pPos.below();
        BlockState stateAbove = pLevel.getBlockState(pPos.above());
        BlockState stateBelow = pLevel.getBlockState(below);
        if (!stateAbove.getFluidState().isSource()) {
            return;
        }
        Block block = stateBelow.getBlock();
        if (block instanceof LiquidBlockContainer && (blockContainer = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)pLevel, pPos.below(), stateBelow, stateAbove.getFluidState().getType())) {
            if (blockContainer.placeLiquid((LevelAccessor)pLevel, pPos.below(), stateBelow, stateAbove.getFluidState())) {
                Block block2 = stateAbove.getBlock();
                if (block2 instanceof BucketPickup) {
                    bucketPickup = (BucketPickup)block2;
                    bucketPickup.pickupBlock(null, (LevelAccessor)pLevel, pPos.above(), stateAbove);
                }
                if (pLevel.getBlockState(pPos.above()).getFluidState().isSource()) {
                    pLevel.setBlockAndUpdate(pPos.above(), Blocks.AIR.defaultBlockState());
                }
            }
        } else if (stateBelow.canBeReplaced()) {
            ItemStack bucket;
            Item item;
            Block block3 = stateAbove.getBlock();
            if (block3 instanceof BucketPickup && (item = (bucket = (bucketPickup = (BucketPickup)block3).pickupBlock(null, (LevelAccessor)pLevel, pPos.above(), stateAbove)).getItem()) instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                pLevel.setBlockAndUpdate(below, stateAbove.getFluidState().createLegacyBlock());
            }
        } else {
            ItemStack stack;
            Block bucket;
            CauldronBlock cauldronBlock;
            bucketPickup = stateBelow.getBlock();
            if (bucketPickup instanceof CauldronBlock && !(cauldronBlock = (CauldronBlock)bucketPickup).isFull(stateBelow) && (bucket = stateAbove.getBlock()) instanceof BucketPickup && !(stack = (bucketPickup = (BucketPickup)bucket).pickupBlock(null, (LevelAccessor)pLevel, pPos.above(), stateAbove)).isEmpty()) {
                BlockBehaviourAccessor accessor = (BlockBehaviourAccessor)cauldronBlock;
                ANFakePlayer fakePlayer = ANFakePlayer.getPlayer(pLevel);
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack.copy());
                ItemInteractionResult result = accessor.callUseItemOn(stack, stateBelow, (Level)pLevel, pPos.below(), (Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3((double)below.getX(), (double)below.getY(), (double)below.getZ()), Direction.UP, pPos.below(), false));
                if (!ItemStack.isSameItem((ItemStack)fakePlayer.getItemInHand(InteractionHand.MAIN_HAND), (ItemStack)stack) && pLevel.getBlockState(pPos.above()).getFluidState().isSource()) {
                    pLevel.setBlockAndUpdate(pPos.above(), Blocks.AIR.defaultBlockState());
                }
            }
        }
    }

    protected void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        super.neighborChanged(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
        if (!pLevel.isClientSide && pLevel.getBlockState(pPos.above()).getFluidState().isSource()) {
            pLevel.scheduleTick(pPos, (Block)this, 10);
        }
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)BlockStateProperties.FACING);
        if (direction == Direction.DOWN) {
            return TOP_AABB;
        }
        if (direction == Direction.WEST) {
            return WEST_OPEN_AABB;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_OPEN_AABB;
        }
        if (direction == Direction.NORTH) {
            return NORTH_OPEN_AABB;
        }
        if (direction == Direction.EAST) {
            return EAST_OPEN_AABB;
        }
        return BOTTOM_AABB;
    }

    protected VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)pContext;
            Entity entity = entityCollisionContext.getEntity();
            if (entity == null || entity.getType().is(EntityTags.ITEM_GRATE_COLLIDE)) {
                return super.getCollisionShape(pState, pLevel, pPos, pContext);
            }
            if (entity instanceof ItemEntity || entity instanceof Projectile || entity.getType().is(EntityTags.ITEM_GRATE_PASSABLE)) {
                return Shapes.empty();
            }
        }
        return super.getCollisionShape(pState, pLevel, pPos, pContext);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    public ItemStack pickupBlock(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        BlockState belowState = pLevel.getBlockState(pPos.below());
        Block block = belowState.getBlock();
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            return bucketPickup.pickupBlock(pPlayer, pLevel, pPos.below(), belowState);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }
}

