/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.MirrorWeave;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MirrorWeaveTile
extends ModdedTile
implements GeoBlockEntity,
ILightable,
IDispellable {
    public BlockState mimicState;
    public BlockState nextState = BlockRegistry.MIRROR_WEAVE.defaultBlockState();
    public boolean renderInvalid = true;
    public long lastUpdateTick = 0L;
    protected boolean[] renderDirections = new boolean[6];
    public boolean disableRender = false;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MirrorWeaveTile(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.mimicState = this.getDefaultBlockState();
    }

    public MirrorWeaveTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockRegistry.MIRROR_WEAVE_TILE.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("mimic_state", (Tag)NbtUtils.writeBlockState((BlockState)this.mimicState));
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.renderInvalid = true;
        if (pTag.contains("mimic_state")) {
            HolderLookup.RegistryLookup holdergetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
            this.mimicState = NbtUtils.readBlockState((HolderGetter)holdergetter, (CompoundTag)pTag.getCompound("mimic_state"));
        } else {
            this.mimicState = this.getDefaultBlockState();
        }
    }

    public boolean shouldRenderFace(BlockState state, BlockState blockstate, Level level, BlockPos offset, Direction face, BlockPos pos) {
        if (state.skipRendering(blockstate, face)) {
            return false;
        }
        if (blockstate.hidesNeighborFace((BlockGetter)level, pos, state, face.getOpposite()) && state.supportsExternalFaceHiding()) {
            return false;
        }
        if (blockstate.canOcclude()) {
            Block.BlockStatePairKey block$blockstatepairkey = new Block.BlockStatePairKey(state, blockstate, face);
            Object2ByteLinkedOpenHashMap object2bytelinkedopenhashmap = (Object2ByteLinkedOpenHashMap)Block.OCCLUSION_CACHE.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$blockstatepairkey);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = state.getFaceOcclusionShape((BlockGetter)level, offset, face);
            if (voxelshape.isEmpty()) {
                return true;
            }
            VoxelShape voxelshape1 = blockstate.getFaceOcclusionShape((BlockGetter)level, pos, face.getOpposite());
            boolean flag = Shapes.joinIsNotEmpty((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (BooleanOp)BooleanOp.ONLY_FIRST);
            if (object2bytelinkedopenhashmap.size() == 2048) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$blockstatepairkey, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    public BlockState getDefaultBlockState() {
        return BlockRegistry.MIRROR_WEAVE.defaultBlockState();
    }

    public BlockState getStateForCulling() {
        if (this.mimicState.is(BlockTagProvider.FALSE_OCCLUSION)) {
            return Blocks.COBBLESTONE.defaultBlockState();
        }
        return this.mimicState;
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockState state = world.getBlockState(((BlockHitResult)rayTraceResult).getBlockPos());
            world.setBlock(this.getBlockPos(), (BlockState)state.setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - stats.getBuffCount(AugmentDampen.INSTANCE)), 15))), 3);
            world.sendBlockUpdated(((BlockHitResult)rayTraceResult).getBlockPos(), state, (BlockState)state.setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - stats.getBuffCount(AugmentDampen.INSTANCE)), 15))), 3);
        }
        this.updateBlock();
    }

    public void setRenderDirection(Direction direction, boolean render) {
        this.renderDirections[direction.ordinal()] = render;
    }

    public boolean shouldRenderDirection(Direction direction) {
        return this.renderDirections[direction.ordinal()];
    }

    public void onLoad() {
        super.onLoad();
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        if (this.mimicState.getBlock() == this.getDefaultBlockState().getBlock()) {
            return false;
        }
        Block block = this.level.getBlockState(this.worldPosition).getBlock();
        if (block instanceof MirrorWeave) {
            MirrorWeave mirrorWeave = (MirrorWeave)block;
            this.nextState = this.getDefaultBlockState();
            mirrorWeave.setMimicState(this.level, this.worldPosition, true);
        }
        return true;
    }
}

