/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityChimeraProjectile
extends AbstractArrow
implements GeoEntity {
    int groundMax;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EntityChimeraProjectile(Level world) {
        super((EntityType)ModEntities.ENTITY_CHIMERA_SPIKE.get(), world);
    }

    public EntityChimeraProjectile(EntityType<EntityChimeraProjectile> entityChimeraProjectileEntityType, Level world) {
        super(entityChimeraProjectileEntityType, world);
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.inGroundTime >= 1) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected boolean tryPickup(Player pPlayer) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    protected void onHitEntity(EntityHitResult rayTraceResult) {
        DamageSource damagesource;
        Entity entity = rayTraceResult.getEntity();
        float damage = 7.5f;
        Entity entity1 = this.getOwner();
        if (entity1 == null) {
            damagesource = this.level.damageSources().indirectMagic((Entity)this, null);
        } else {
            damagesource = this.level.damageSources().magic();
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).setLastHurtMob(entity);
            }
        }
        boolean isEnderman = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (this.isOnFire() && !isEnderman) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, damage)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doPostHurtEffects(livingentity);
            }
            this.playSound(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            entity.setRemainingFireTicks(k);
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
            this.setYRot(this.getYRot() + 180.0f);
            this.yRotO += 180.0f;
            if (!this.level.isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        if (!this.level.isClientSide) {
            MobEffectInstance[] array;
            Collection effects = entity.getActiveEffects();
            for (MobEffectInstance e : array = effects.toArray(new MobEffectInstance[0])) {
                if (!((MobEffect)e.getEffect().value()).isBeneficial()) continue;
                entity.removeEffect(e.getEffect());
            }
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2));
        }
    }

    protected boolean canHitEntity(Entity entity) {
        ISummon summon;
        LivingEntity entity1;
        if (entity instanceof EntityChimeraProjectile) {
            return false;
        }
        if (entity instanceof LivingEntity && ((entity1 = (LivingEntity)entity) instanceof WildenStalker || entity1 instanceof WildenGuardian || entity instanceof WildenHunter || entity instanceof ISummon && (summon = (ISummon)entity).getOwnerUUID() != null && summon.getOwnerUUID().equals(this.getUUID()) || entity1 instanceof SummonWolf && ((SummonWolf)entity1).isWildenSummon)) {
            return false;
        }
        return !(entity instanceof WildenChimera) && super.canHitEntity(entity);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_CHIMERA_SPIKE.get();
    }
}

