/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class IceShardEntity
extends EnchantedFallingBlock {
    public LivingEntity shooter;

    public IceShardEntity(EntityType<? extends ColoredProjectile> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
    }

    public IceShardEntity(Level worldIn, double x, double y, double z, BlockState fallingBlockState, SpellResolver resolver) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ICE_SHARD.get()), worldIn, x, y, z, fallingBlockState, resolver);
    }

    @Override
    public void callOnBrokenAfterFall(Block p_149651_, BlockPos p_149652_) {
        super.callOnBrokenAfterFall(p_149651_, p_149652_);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (LivingEntity living : world.getEntitiesOfClass(LivingEntity.class, new AABB(BlockPos.containing((Position)this.position)).inflate(1.25))) {
                if (living == this.shooter || living.isAlliedTo((Entity)this.shooter)) continue;
                living.hurt(DamageUtil.source((LevelAccessor)world, DamageTypesRegistry.COLD_SNAP, (Entity)(this.shooter == null ? ANFakePlayer.getPlayer(world) : this.shooter)), this.baseDamage);
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
            }
            world.sendParticles((ParticleOptions)ParticleTypes.SPIT, this.position.x, this.position.y + 0.5, this.position.z, 10, ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), 0.3);
            world.playSound(null, BlockPos.containing((Position)this.position), SoundEvents.GLASS_FALL, SoundSource.BLOCKS, 0.8f, 0.8f);
        }
    }

    @Override
    public void doPostHurtEffects(LivingEntity livingentity) {
        super.doPostHurtEffects(livingentity);
        livingentity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
    }

    @Override
    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ICE_SHARD.get();
    }
}

