/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import com.hollingsworth.arsnouveau.common.util.ArrayUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;

public class GrowClusterGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    BlockPos pathPos;
    int usingTicks;
    boolean isDone;

    public GrowClusterGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public void tick() {
        super.tick();
        --this.usingTicks;
        if (this.pathPos != null) {
            this.golem.getNavigation().tryMoveToBlockPos(this.pathPos, 1.3f);
            if (BlockUtil.distanceFrom(this.golem.blockPosition(), this.pathPos) <= 2.0) {
                this.golem.setImbueing(true);
                this.golem.setImbuePos(this.pathPos);
            }
        }
        if (this.usingTicks <= 0) {
            this.growCluster();
        }
    }

    public void start() {
        this.usingTicks = 120;
        this.isDone = false;
        BlockPos p = ArrayUtil.getRandomElement(this.golem.buddingBlocks);
        this.golem.getNavigation().tryMoveToBlockPos(p, 1.0);
        this.pathPos = p;
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.GROW;
    }

    public void growCluster() {
        int numGrown = 0;
        for (BlockPos p : this.golem.buddingBlocks) {
            if (numGrown > 3) break;
            if (!this.golem.level.getBlockState(p).is(BlockTagProvider.BUDDING_BLOCKS)) continue;
            this.golem.level.getBlockState(p).randomTick((ServerLevel)this.golem.level, p, this.golem.getRandom());
            ++numGrown;
        }
        this.isDone = true;
        this.golem.growCooldown = 300;
        this.golem.setImbueing(false);
    }

    public void stop() {
        this.golem.setImbueing(false);
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canContinueToUse() {
        return !this.isDone;
    }

    public boolean canUse() {
        return this.canUse.get() != false && this.golem.growCooldown <= 0 && !this.golem.buddingBlocks.isEmpty();
    }
}

