/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.tile.GhostWeaveTile;
import com.hollingsworth.arsnouveau.common.block.tile.SpellSensorTile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectInvisibility;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="ars_nouveau")
public class ArsEvents {
    @SubscribeEvent
    public static void costCalc(SpellCostCalcEvent e) {
        if (e.context.getCasterTool().isEmpty()) {
            return;
        }
        IWrappedCaster iWrappedCaster = e.context.getCaster();
        if (iWrappedCaster instanceof PlayerCaster) {
            PlayerCaster livingCaster = (PlayerCaster)iWrappedCaster;
            if (e.context.getCasterTool().is((Item)ItemsRegistry.CASTER_TOME.get())) {
                int maxMana = ManaUtil.getMaxMana(livingCaster.player);
                e.currentCost = e.currentCost > maxMana ? maxMana : (e.currentCost /= 2);
            }
        }
    }

    @SubscribeEvent
    public static void castEvent(SpellCastEvent castEvent) {
        SpellSensorTile.onSpellCast(castEvent);
    }

    @SubscribeEvent
    public static void spellResolve(SpellResolveEvent.Post e) {
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        HitResult hitResult;
        SpellSensorTile.onSpellResolve(e);
        if (e.spell.unsafeList().contains(EffectInvisibility.INSTANCE) && (hitResult = e.rayTraceResult) instanceof BlockHitResult && (blockEntity = e.world.getBlockEntity((blockHitResult = (BlockHitResult)hitResult).getBlockPos())) instanceof GhostWeaveTile) {
            GhostWeaveTile ghostWeaveTile = (GhostWeaveTile)blockEntity;
            ghostWeaveTile.setVisibility(true);
        }
    }

    @SubscribeEvent
    public static void preSpellDamage(SpellDamageEvent.Pre e) {
        if (e.damageSource.is(DamageTypeTags.IS_FIRE) && e.caster.hasEffect(ModPotions.IMMOLATE_EFFECT)) {
            e.damage += (float)(2 * (e.caster.getEffect(ModPotions.IMMOLATE_EFFECT).getAmplifier() + 1));
        }
    }
}

