/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.codecs.lucene90;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.codecs.StoredFieldsFormat;
import org.apache.lucene.ars_nouveau.codecs.StoredFieldsReader;
import org.apache.lucene.ars_nouveau.codecs.StoredFieldsWriter;
import org.apache.lucene.ars_nouveau.codecs.compressing.CompressionMode;
import org.apache.lucene.ars_nouveau.codecs.lucene90.DeflateWithPresetDictCompressionMode;
import org.apache.lucene.ars_nouveau.codecs.lucene90.LZ4WithPresetDictCompressionMode;
import org.apache.lucene.ars_nouveau.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.ars_nouveau.index.FieldInfos;
import org.apache.lucene.ars_nouveau.index.SegmentInfo;
import org.apache.lucene.ars_nouveau.store.Directory;
import org.apache.lucene.ars_nouveau.store.IOContext;

public class Lucene90StoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene90StoredFieldsFormat.class.getSimpleName() + ".mode";
    final Mode mode;
    private static final int BEST_COMPRESSION_BLOCK_LENGTH = 491520;
    public static final CompressionMode BEST_COMPRESSION_MODE = new DeflateWithPresetDictCompressionMode();
    private static final int BEST_SPEED_BLOCK_LENGTH = 81920;
    public static final CompressionMode BEST_SPEED_MODE = new LZ4WithPresetDictCompressionMode();

    public Lucene90StoredFieldsFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene90StoredFieldsFormat(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        String value = si.getAttribute(MODE_KEY);
        if (value == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
        }
        Mode mode = Mode.valueOf(value);
        return this.impl(mode).fieldsReader(directory, si, fn, context);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + "old=" + previous + ", new=" + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(directory, si, context);
    }

    StoredFieldsFormat impl(Mode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return new Lucene90CompressingStoredFieldsFormat("Lucene90StoredFieldsFastData", BEST_SPEED_MODE, 81920, 1024, 10);
            }
            case 1: {
                return new Lucene90CompressingStoredFieldsFormat("Lucene90StoredFieldsHighData", BEST_COMPRESSION_MODE, 491520, 4096, 10);
            }
        }
        throw new AssertionError();
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

