/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.store;

import org.apache.lucene.ars_nouveau.store.DataOutput;
import org.apache.lucene.ars_nouveau.util.BitUtil;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class ByteArrayDataOutput
extends DataOutput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataOutput(byte[] bytes) {
        this.reset(bytes);
    }

    public ByteArrayDataOutput(byte[] bytes, int offset, int len) {
        this.reset(bytes, offset, len);
    }

    public ByteArrayDataOutput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public void writeByte(byte b) {
        assert (this.pos < this.limit);
        this.bytes[this.pos++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        assert (this.pos + length <= this.limit);
        System.arraycopy(b, offset, this.bytes, this.pos, length);
        this.pos += length;
    }

    @Override
    public void writeShort(short i) {
        assert (this.pos + 2 <= this.limit);
        BitUtil.VH_LE_SHORT.set(this.bytes, this.pos, i);
        this.pos += 2;
    }

    @Override
    public void writeInt(int i) {
        assert (this.pos + 4 <= this.limit);
        BitUtil.VH_LE_INT.set(this.bytes, this.pos, i);
        this.pos += 4;
    }

    @Override
    public void writeLong(long i) {
        assert (this.pos + 8 <= this.limit);
        BitUtil.VH_LE_LONG.set(this.bytes, this.pos, i);
        this.pos += 8;
    }
}

