/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public class FishItem {
    private final ConfigManager configManager;
    private final JavaPlugin plugin;
    public static final String NBT_FISH_ID = "muf_fish_id";
    public static final String NBT_FISH_RARITY = "muf_fish_rarity";
    public static final String NBT_FISH_PRICE = "muf_fish_price";

    private static String getPluginNamespace() {
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
        return plugin.getName().toLowerCase();
    }

    public FishItem(ConfigManager configManager) {
        this.configManager = configManager;
        this.plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
    }

    public ItemStack createFishItem(String fishId, Player caughtBy) {
        Material material;
        if (fishId == null || caughtBy == null) {
            return null;
        }
        String materialName = this.configManager.getFishMaterial(fishId);
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.COD;
        }
        ItemStack fishItem = new ItemStack(material, 1);
        ItemMeta meta = fishItem.getItemMeta();
        if (meta == null) {
            return fishItem;
        }
        String displayName = this.configManager.getFishDisplayName(fishId);
        if (displayName != null) {
            meta.setDisplayName(ColorSystem.colorize(displayName));
        }
        List<String> lore = this.createFishLore(fishId, caughtBy);
        meta.setLore(lore);
        this.addStackableNBTData(meta, fishId);
        fishItem.setItemMeta(meta);
        String verifyFishId = FishItem.getFishId(fishItem);
        String verifyRarity = FishItem.getFishRarity(fishItem);
        return fishItem;
    }

    private List<String> createFishLore(String fishId, Player caughtBy) {
        double sellPrice;
        String rarityName;
        String fishDescription;
        ArrayList<String> lore = new ArrayList<String>();
        String rarityId = this.configManager.getFishRarity(fishId);
        if (rarityId == null) {
            return lore;
        }
        List<String> rarityLore = this.configManager.getRarityFishLore(rarityId);
        if (rarityLore == null || rarityLore.isEmpty()) {
            return lore;
        }
        String fishName = this.configManager.getFishDisplayName(fishId);
        if (fishName == null) {
            fishName = fishId;
        }
        if ((fishDescription = this.configManager.getFishDescription(fishId)) == null) {
            fishDescription = "A mysterious fish";
        }
        if ((rarityName = this.configManager.getRarityName(rarityId)) == null) {
            rarityName = rarityId;
        }
        String priceString = (sellPrice = this.getFishSellPrice(fishId)) > 0.0 ? String.valueOf(sellPrice) : "Unknown";
        double weight = this.configManager.getFishWeight(fishId);
        String weightString = weight + "kg";
        List<String> biomes = this.configManager.getFishBiomes(fishId);
        String biomeString = biomes.isEmpty() ? "Any" : String.join((CharSequence)", ", biomes);
        MrUltimateFishing mrPlugin = (MrUltimateFishing)this.plugin;
        String firstCatcher = mrPlugin.getPlayerDataManager().getFirstCatchPlayer(fishId);
        if (firstCatcher == null) {
            firstCatcher = "Unknown";
        }
        int catchCount = mrPlugin.getPlayerDataManager().getFishCatchCount(fishId);
        String catchCountString = String.valueOf(catchCount);
        for (String loreLine : rarityLore) {
            String processedLine = loreLine.replace("[FishName]", fishName).replace("[FishDescription]", fishDescription).replace("[SellPrice]", priceString).replace("[FishWeight]", weightString).replace("[FishBiomes]", biomeString).replace("[Rarity]", rarityName).replace("[rarity]", rarityName).replace("[FirstCatcher]", firstCatcher).replace("[Catched]", catchCountString).replace("{fish_description}", fishDescription).replace("{fish_rarity}", rarityName).replace("{fish_price}", priceString).replace("{fish_weight}", weightString).replace("{fish_biomes}", biomeString).replace("{first_catcher}", firstCatcher).replace("{catch_count}", catchCountString);
            lore.add(ColorSystem.colorize(processedLine));
        }
        return lore;
    }

    private void addStackableNBTData(ItemMeta meta, String fishId) {
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey fishIdKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_ID);
        container.set(fishIdKey, PersistentDataType.STRING, (Object)fishId);
        String rarityId = this.configManager.getFishRarity(fishId);
        if (rarityId != null) {
            NamespacedKey rarityKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_RARITY);
            container.set(rarityKey, PersistentDataType.STRING, (Object)rarityId);
        }
        boolean hasOverrideRarity = this.configManager.getFishOverrideRarity(fishId);
        double fishPrice = 0.0;
        fishPrice = hasOverrideRarity ? this.configManager.getFishSellPrice(fishId) : this.getFishSellPrice(fishId);
        if (fishPrice > 0.0) {
            NamespacedKey priceKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_PRICE);
            container.set(priceKey, PersistentDataType.DOUBLE, (Object)fishPrice);
        }
    }

    public static String getFishId(ItemStack item) {
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
        if (item == null || item.getItemMeta() == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey fishIdKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_ID);
        String fishId = (String)container.get(fishIdKey, PersistentDataType.STRING);
        return fishId;
    }

    public static String getFishRarity(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
        NamespacedKey rarityKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_RARITY);
        return (String)container.get(rarityKey, PersistentDataType.STRING);
    }

    public static Double getFishPrice(ItemStack item) {
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
        if (item == null || item.getItemMeta() == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey priceKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_PRICE);
        Double price = (Double)container.get(priceKey, PersistentDataType.DOUBLE);
        return price;
    }

    public static void setFishPrice(ItemStack item, double price) {
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey priceKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_PRICE);
        container.set(priceKey, PersistentDataType.DOUBLE, (Object)price);
        item.setItemMeta(meta);
    }

    public static boolean isCustomFish(ItemStack item) {
        String string;
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(FishItem.class);
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey fishIdKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_ID);
        NamespacedKey fishRarityKey = new NamespacedKey(FishItem.getPluginNamespace(), NBT_FISH_RARITY);
        boolean hasFishId = container.has(fishIdKey, PersistentDataType.STRING);
        boolean hasFishRarity = container.has(fishRarityKey, PersistentDataType.STRING);
        if (hasFishId) {
            string = (String)container.get(fishIdKey, PersistentDataType.STRING);
        }
        if (hasFishRarity) {
            string = (String)container.get(fishRarityKey, PersistentDataType.STRING);
        }
        boolean result = hasFishId && hasFishRarity;
        return result;
    }

    public static boolean canStackWith(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null) {
            return false;
        }
        if (!FishItem.isCustomFish(item1) || !FishItem.isCustomFish(item2)) {
            return false;
        }
        String fishId1 = FishItem.getFishId(item1);
        String fishId2 = FishItem.getFishId(item2);
        String rarity1 = FishItem.getFishRarity(item1);
        String rarity2 = FishItem.getFishRarity(item2);
        return fishId1 != null && fishId1.equals(fishId2) && rarity1 != null && rarity1.equals(rarity2);
    }

    private double getFishSellPrice(String fishId) {
        boolean hasOverrideRarity = this.configManager.getFishOverrideRarity(fishId);
        if (hasOverrideRarity) {
            return this.configManager.getFishSellPrice(fishId);
        }
        String rarityId = this.configManager.getFishRarity(fishId);
        if (rarityId != null) {
            return this.configManager.getRaritySellPrice(rarityId);
        }
        return 0.0;
    }

    public String getDisplayName() {
        return "Unknown Fish";
    }
}

