/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.java.JavaPlugin;

public class HologramManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private HologramProvider provider;
    private boolean hologramsEnabled = false;

    public HologramManager(JavaPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.setupHologramProvider();
    }

    private void setupHologramProvider() {
        block13: {
            String configProvider = this.plugin.getConfig().getString("MrUltimateFishing.HologramProvider", "DecentHolograms");
            if (configProvider.equalsIgnoreCase("CMIHolograms")) {
                if (this.plugin.getServer().getPluginManager().getPlugin("CMI") != null) {
                    try {
                        if (CMI.getInstance().getHologramManager() != null) {
                            this.provider = HologramProvider.CMI_HOLOGRAMS;
                            this.hologramsEnabled = true;
                            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aCMIHolograms integration enabled!"));
                            break block13;
                        }
                        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cCMI plugin found but hologram module is disabled! Hologram features will not be functional."));
                        this.provider = HologramProvider.NONE;
                    }
                    catch (Exception e) {
                        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to initialize CMIHolograms integration: " + e.getMessage() + ". Hologram features will not be functional."));
                        this.provider = HologramProvider.NONE;
                    }
                } else {
                    Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cCMI plugin not found! Hologram features will not be functional."));
                    this.provider = HologramProvider.NONE;
                }
            } else if (configProvider.equalsIgnoreCase("DecentHolograms")) {
                if (this.plugin.getServer().getPluginManager().getPlugin("DecentHolograms") != null) {
                    try {
                        DHAPI.class.getName();
                        this.provider = HologramProvider.DECENT_HOLOGRAMS;
                        this.hologramsEnabled = true;
                        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aDecentHolograms integration enabled!"));
                    }
                    catch (Exception e) {
                        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to initialize DecentHolograms integration: " + e.getMessage() + ". Hologram features will not be functional."));
                        this.provider = HologramProvider.NONE;
                    }
                } else {
                    Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cDecentHolograms plugin not found! Hologram features will not be functional."));
                    this.provider = HologramProvider.NONE;
                }
            } else {
                Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cUnknown hologram provider '" + configProvider + "'. Valid options: CMIHolograms, DecentHolograms. Hologram features will not be functional."));
                this.provider = HologramProvider.NONE;
            }
        }
    }

    public boolean isHologramsEnabled() {
        return this.hologramsEnabled && this.provider != HologramProvider.NONE;
    }

    public HologramProvider getProvider() {
        return this.provider;
    }

    public boolean createHologram(String id, Location location, List<String> lines) {
        if (!this.isHologramsEnabled()) {
            return false;
        }
        try {
            switch (this.provider.ordinal()) {
                case 0: {
                    return this.createCMIHologram(id, location, lines);
                }
                case 1: {
                    return this.createDecentHologram(id, location, lines);
                }
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError creating hologram '" + id + "': " + e.getMessage()));
            return false;
        }
    }

    public boolean createHologram(String id, Location location, String line) {
        return this.createHologram(id, location, Arrays.asList(line));
    }

    public boolean removeHologram(String id) {
        if (!this.isHologramsEnabled()) {
            return false;
        }
        try {
            switch (this.provider.ordinal()) {
                case 0: {
                    return this.removeCMIHologram(id);
                }
                case 1: {
                    return this.removeDecentHologram(id);
                }
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError removing hologram '" + id + "': " + e.getMessage()));
            return false;
        }
    }

    public boolean updateHologram(String id, List<String> lines) {
        if (!this.isHologramsEnabled()) {
            return false;
        }
        try {
            switch (this.provider.ordinal()) {
                case 0: {
                    return this.updateCMIHologram(id, lines);
                }
                case 1: {
                    return this.updateDecentHologram(id, lines);
                }
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError updating hologram '" + id + "': " + e.getMessage()));
            return false;
        }
    }

    private boolean createCMIHologram(String id, Location location, List<String> lines) {
        try {
            CMIHologram hologram = new CMIHologram(id, location);
            hologram.setLines(lines);
            CMI.getInstance().getHologramManager().addHologram(hologram);
            return true;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to create CMI hologram: " + e.getMessage()));
            return false;
        }
    }

    private boolean removeCMIHologram(String id) {
        try {
            CMIHologram hologram = CMI.getInstance().getHologramManager().getByName(id);
            if (hologram != null) {
                CMI.getInstance().getHologramManager().removeHolo(hologram);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to remove CMI hologram: " + e.getMessage()));
            return false;
        }
    }

    private boolean updateCMIHologram(String id, List<String> lines) {
        try {
            CMIHologram hologram = CMI.getInstance().getHologramManager().getByName(id);
            if (hologram != null) {
                hologram.setLines(lines);
                hologram.update();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to update CMI hologram: " + e.getMessage()));
            return false;
        }
    }

    private boolean createDecentHologram(String id, Location location, List<String> lines) {
        try {
            Hologram hologram = DHAPI.createHologram((String)id, (Location)location, lines);
            return hologram != null;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to create Decent hologram: " + e.getMessage()));
            return false;
        }
    }

    private boolean removeDecentHologram(String id) {
        try {
            Hologram hologram = DHAPI.getHologram((String)id);
            if (hologram != null) {
                hologram.delete();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to remove Decent hologram: " + e.getMessage()));
            return false;
        }
    }

    private boolean updateDecentHologram(String id, List<String> lines) {
        try {
            Hologram hologram = DHAPI.getHologram((String)id);
            if (hologram != null) {
                DHAPI.setHologramLines((Hologram)hologram, lines);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cFailed to update Decent hologram: " + e.getMessage()));
            return false;
        }
    }

    public static enum HologramProvider {
        CMI_HOLOGRAMS,
        DECENT_HOLOGRAMS,
        NONE;

    }
}

