/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.VaultManager;
import eu.mrneznamy.mrultimatefishing.managers.DeliveryMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.FishMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.GuttingMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.RarityMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.RecipeMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.SellFishMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.ShopMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.TotemMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.UpgradeMenuManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class MenuManager
implements Listener {
    private final JavaPlugin plugin;
    private final FishMenuManager fishMenuManager;
    private final RarityMenuManager rarityMenuManager;
    private final SellFishMenuManager sellFishMenuManager;
    private final GuttingMenuManager guttingMenuManager;
    private final UpgradeMenuManager upgradeMenuManager;
    private final RecipeMenuManager recipeMenuManager;
    private final ShopMenuManager shopMenuManager;
    private final TotemMenuManager totemMenuManager;
    private final DeliveryMenuManager deliveryMenuManager;

    public MenuManager(JavaPlugin plugin, MessageManager messageManager, VaultManager vaultManager) {
        this.plugin = plugin;
        MrUltimateFishing mrPlugin = (MrUltimateFishing)plugin;
        this.fishMenuManager = new FishMenuManager(mrPlugin);
        this.rarityMenuManager = mrPlugin.getRarityMenuManager();
        this.sellFishMenuManager = new SellFishMenuManager(mrPlugin);
        this.guttingMenuManager = new GuttingMenuManager(mrPlugin, messageManager, vaultManager);
        this.upgradeMenuManager = new UpgradeMenuManager(mrPlugin);
        this.recipeMenuManager = mrPlugin.getRecipeMenuManager();
        this.shopMenuManager = mrPlugin.getShopMenuManager();
        this.totemMenuManager = new TotemMenuManager(mrPlugin, mrPlugin.getTotemManager());
        this.deliveryMenuManager = new DeliveryMenuManager(mrPlugin);
    }

    public void openHeadMenu(Player player) {
        this.fishMenuManager.openHeadMenu(player);
    }

    public void openRarityCategoryMenu(Player player) {
        this.rarityMenuManager.openRarityCategoryMenu(player);
    }

    public void openRarityMenu(Player player, String rarity, int page) {
        this.rarityMenuManager.openRarityMenu(player, rarity, page);
    }

    public void openSellFishMenu(Player player) {
        this.sellFishMenuManager.openSellFishMenu(player);
    }

    public void openGuttingMenu(Player player) {
        this.guttingMenuManager.openGuttingMenu(player);
    }

    public void openUpgradeMenu(Player player) {
        this.upgradeMenuManager.openUpgradeMenu(player);
    }

    public void openRecipeMenu(Player player) {
        this.recipeMenuManager.openRecipeMenu(player);
    }

    public void openShopMenu(Player player) {
        this.shopMenuManager.openShopMenu(player);
    }

    public void openDeliveryMenu(Player player) {
        this.deliveryMenuManager.openDeliveryMenu(player);
    }

    public GuttingMenuManager getGuttingMenuManager() {
        return this.guttingMenuManager;
    }

    public UpgradeMenuManager getUpgradeMenuManager() {
        return this.upgradeMenuManager;
    }

    public RecipeMenuManager getRecipeMenuManager() {
        return this.recipeMenuManager;
    }

    public TotemMenuManager getTotemMenuManager() {
        return this.totemMenuManager;
    }

    public DeliveryMenuManager getDeliveryMenuManager() {
        return this.deliveryMenuManager;
    }

    public void cleanupPlayerData(Player player) {
        this.fishMenuManager.cleanupPlayerData(player);
        this.rarityMenuManager.cleanupPlayerData(player);
        this.sellFishMenuManager.cleanupPlayerData(player);
        this.guttingMenuManager.cleanupPlayerData(player);
        this.upgradeMenuManager.cleanupPlayerData(player);
        this.recipeMenuManager.cleanupPlayerData(player);
        this.shopMenuManager.cleanupPlayerData(player);
        this.totemMenuManager.cleanupPlayerData(player);
        this.deliveryMenuManager.cleanupPlayerData(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        this.rarityMenuManager.handleInventoryClick(event);
        if (this.fishMenuManager.handleInventoryClick(event)) {
            return;
        }
        if (this.sellFishMenuManager.handleInventoryClick(event)) {
            return;
        }
        if (this.upgradeMenuManager.handleInventoryClick(event)) {
            return;
        }
        if (this.recipeMenuManager.handleInventoryClick(event)) {
            return;
        }
        if (this.shopMenuManager.handleInventoryClick(event)) {
            return;
        }
        if (this.totemMenuManager.handleInventoryClick(event)) {
            return;
        }
        if (this.deliveryMenuManager.handleInventoryClick(event)) {
            return;
        }
        this.guttingMenuManager.handleInventoryClick(event);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.fishMenuManager.handleInventoryClose(event);
        this.rarityMenuManager.handleInventoryClose(event);
        this.sellFishMenuManager.handleInventoryClose(event);
        this.guttingMenuManager.handleInventoryClose(event);
        this.upgradeMenuManager.handleInventoryClose(event);
        this.recipeMenuManager.handleInventoryClose(event);
        this.shopMenuManager.handleInventoryClose(event);
        this.totemMenuManager.handleInventoryClose(event);
        this.deliveryMenuManager.handleInventoryClose(event);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.fishMenuManager.handleInventoryDrag(event)) {
            return;
        }
        if (this.sellFishMenuManager.handleInventoryDrag(event)) {
            return;
        }
        if (this.upgradeMenuManager.handleInventoryDrag(event)) {
            return;
        }
        if (this.recipeMenuManager.handleInventoryDrag(event)) {
            return;
        }
        if (this.shopMenuManager.handleInventoryDrag(event)) {
            return;
        }
        if (this.totemMenuManager.handleInventoryDrag(event)) {
            return;
        }
        this.deliveryMenuManager.handleInventoryDrag(event);
    }
}

