/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private String prefix;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.addDefaultMessages();
        this.prefix = this.translateColors(this.messagesConfig.getString("prefix", "&8[&6MrUltimateFishing&8] &r"));
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    public void reloadConfig() {
        this.reloadMessages();
    }

    public String getMessage(String key) {
        String message = this.messagesConfig.getString(key, "&cMessage not found: " + key);
        message = message.replace("{prefix}", this.prefix);
        return this.translateColors(message);
    }

    public String getMessage(String key, String ... placeholders) {
        String message = this.messagesConfig.getString(key, "&cMessage not found: " + key);
        message = message.replace("{prefix}", this.prefix);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            String placeholder = placeholders[i];
            String value = placeholders[i + 1];
            message = message.replace(placeholder, value);
            if (placeholder.startsWith("{") || placeholder.startsWith("[")) continue;
            message = message.replace("{" + placeholder + "}", value);
            message = message.replace("[" + placeholder + "]", value);
        }
        return this.translateColors(message);
    }

    public void sendMessage(CommandSender sender, String key) {
        sender.sendMessage(this.getMessage(key));
    }

    public void sendMessage(CommandSender sender, String key, String ... placeholders) {
        sender.sendMessage(this.getMessage(key, placeholders));
    }

    public void broadcastMessage(String key, String ... placeholders) {
        String message = this.getMessage(key, placeholders);
        this.plugin.getServer().broadcastMessage(message);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public String translateColors(String message) {
        if (message == null) {
            return "";
        }
        Pattern hexPattern = Pattern.compile("\\{#([A-Fa-f0-9]{6})\\}");
        Matcher matcher = hexPattern.matcher(message);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            try {
                String replacement = net.md_5.bungee.api.ChatColor.of((String)("#" + hexColor)).toString();
                message = message.replace("{#" + hexColor + "}", replacement);
            }
            catch (Exception e) {
                message = message.replace("{#" + hexColor + "}", ChatColor.WHITE.toString());
            }
        }
        Pattern gradientPattern = Pattern.compile("\\{#([A-Fa-f0-9]{6})[><]\\}");
        Matcher gradientMatcher = gradientPattern.matcher(message);
        while (gradientMatcher.find()) {
            String hexColor = gradientMatcher.group(1);
            try {
                String replacement = net.md_5.bungee.api.ChatColor.of((String)("#" + hexColor)).toString();
                message = message.replace("{#" + hexColor + ">}", replacement);
                message = message.replace("{#" + hexColor + "<}", replacement);
            }
            catch (Exception e) {
                message = message.replace("{#" + hexColor + ">}", ChatColor.WHITE.toString());
                message = message.replace("{#" + hexColor + "<}", ChatColor.WHITE.toString());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void addDefaultMessages() {
        String currentTypes;
        boolean changed = false;
        if (!this.messagesConfig.contains("boosters.activated")) {
            this.messagesConfig.set("boosters.activated", (Object)"{prefix}&a&lBooster Activated! &7[type] booster ([value]x) for [duration] seconds!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.extended")) {
            this.messagesConfig.set("boosters.extended", (Object)"{prefix}&a&lBooster Extended! &7[type] booster duration extended by [duration] seconds!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.expired")) {
            this.messagesConfig.set("boosters.expired", (Object)"{prefix}&c&lBooster Expired! &7Your [type] booster has ended.");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.conflict")) {
            this.messagesConfig.set("boosters.conflict", (Object)"{prefix}&c&lBooster Conflict! &7You already have a [type] booster with different value active! Wait for it to expire first.");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.not-found")) {
            this.messagesConfig.set("boosters.not-found", (Object)"{prefix}&cBooster not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.not-available")) {
            this.messagesConfig.set("boosters.not-available", (Object)"{prefix}&cThis booster is not available for purchase!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.insufficient-level")) {
            this.messagesConfig.set("boosters.insufficient-level", (Object)"{prefix}&cYou need fishing level [level] to buy this booster!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.insufficient-money")) {
            this.messagesConfig.set("boosters.insufficient-money", (Object)"{prefix}&cYou need [money] money to buy this booster!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.purchase-success")) {
            this.messagesConfig.set("boosters.purchase-success", (Object)"{prefix}&aBooster purchased successfully!");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.purchase-success-dropped")) {
            this.messagesConfig.set("boosters.purchase-success-dropped", (Object)"{prefix}&aBooster purchased successfully! Item dropped at your location.");
            changed = true;
        }
        if (!this.messagesConfig.contains("boosters.creation-failed")) {
            this.messagesConfig.set("boosters.creation-failed", (Object)"{prefix}&cFailed to create booster item!");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.usage")) {
            this.messagesConfig.set("commands.give.booster.usage", (Object)"{prefix}&cUsage: /[command] give booster <boosterID> <amount> <player>");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.types")) {
            this.messagesConfig.set("commands.give.booster.types", (Object)"{prefix}&cBooster IDs: Check your boosters.yml configuration");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.invalid-id")) {
            this.messagesConfig.set("commands.give.booster.invalid-id", (Object)"{prefix}&cBooster ID [id] does not exist in configuration!");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.invalid-amount")) {
            this.messagesConfig.set("commands.give.booster.invalid-amount", (Object)"{prefix}&cInvalid booster ID: [id]");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.success")) {
            this.messagesConfig.set("commands.give.booster.success", (Object)"{prefix}&aGave [amount] booster(s) (ID: [id]) to [player]");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.received")) {
            this.messagesConfig.set("commands.give.booster.received", (Object)"{prefix}&aYou received [amount] booster(s) from [sender]");
            changed = true;
        }
        if (!this.messagesConfig.contains("commands.give.booster.failed-create")) {
            this.messagesConfig.set("commands.give.booster.failed-create", (Object)"{prefix}&cFailed to create booster item ID: [id]");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.menu-not-found")) {
            this.messagesConfig.set("delivery.menu-not-found", (Object)"{prefix}&cDelivery menu configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.config-not-found")) {
            this.messagesConfig.set("delivery.config-not-found", (Object)"{prefix}&cDelivery configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.selected")) {
            this.messagesConfig.set("delivery.selected", (Object)"{prefix}&aYou selected a [index] delivery! Catch [fishes] fishes within [time]!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.completed")) {
            this.messagesConfig.set("delivery.completed", (Object)"{prefix}&aDelivery completed! Return to the delivery menu to claim your reward!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.reward-claimed")) {
            this.messagesConfig.set("delivery.reward-claimed", (Object)"{prefix}&aDelivery reward claimed successfully!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.shipment-time-reduced")) {
            this.messagesConfig.set("delivery.shipment-time-reduced", (Object)"{prefix}&aShipment time reduced by [reduction]%!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.available")) {
            this.messagesConfig.set("delivery.available", (Object)"{prefix}&aA new delivery is available! Check your delivery menu.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.expired")) {
            this.messagesConfig.set("delivery.expired", (Object)"{prefix}&cYour delivery has expired! The delivery slot is now available for a new delivery.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.not-enough-fish")) {
            this.messagesConfig.set("delivery.not-enough-fish", (Object)"{prefix}&cYou need [required]x [fish] but you only have [have]!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.submitted")) {
            this.messagesConfig.set("delivery.submitted", (Object)"{prefix}&aYou successfully submitted your delivery! Received [fishes] fish and [scales] fish scales.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.upgrade-max-level")) {
            this.messagesConfig.set("delivery.upgrade-max-level", (Object)"{prefix}&cThis upgrade is already at maximum level!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.upgrade-insufficient-scales")) {
            this.messagesConfig.set("delivery.upgrade-insufficient-scales", (Object)"{prefix}&cYou need [scales] fish scales for this upgrade!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.upgrade-purchased")) {
            this.messagesConfig.set("delivery.upgrade-purchased", (Object)"{prefix}&aUpgrade purchased successfully!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.not-enough-fishes")) {
            this.messagesConfig.set("delivery.not-enough-fishes", (Object)"{prefix}&cYou don't have enough fishes to get a new delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.accept-success")) {
            this.messagesConfig.set("delivery.accept-success", (Object)"{prefix}&aDelivery accepted successfully!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.cancel-success")) {
            this.messagesConfig.set("delivery.cancel-success", (Object)"{prefix}&aDelivery cancelled successfully!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-available-slots")) {
            this.messagesConfig.set("delivery.no-available-slots", (Object)"{prefix}&cNo available delivery slots!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-active-delivery")) {
            this.messagesConfig.set("delivery.no-active-delivery", (Object)"{prefix}&cYou don't have an active delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.already-completed")) {
            this.messagesConfig.set("delivery.already-completed", (Object)"{prefix}&cThis delivery has already been completed!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-fish-required")) {
            this.messagesConfig.set("delivery.no-fish-required", (Object)"{prefix}&cNo fish requirements found for this delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.submit-success")) {
            this.messagesConfig.set("delivery.submit-success", (Object)"{prefix}&aDelivery submitted successfully! Your shipment will arrive soon.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-completed-delivery")) {
            this.messagesConfig.set("delivery.no-completed-delivery", (Object)"{prefix}&cYou don't have a completed delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.shipment-complete")) {
            this.messagesConfig.set("delivery.shipment-complete", (Object)"{prefix}&aShipment completed! Rewards have been delivered.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-available-delivery")) {
            this.messagesConfig.set("delivery.no-available-delivery", (Object)"{prefix}&cNo available delivery for slot [slot]!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.already-have-active")) {
            this.messagesConfig.set("delivery.already-have-active", (Object)"{prefix}&cYou already have an active delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-rejected")) {
            this.messagesConfig.set("delivery.delivery-rejected", (Object)"{prefix}&cYou rejected the delivery for slot [slot]!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-rejected-info")) {
            this.messagesConfig.set("delivery.delivery-rejected-info", (Object)"{prefix}&7The slot is now waiting for a new delivery.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.shipment-arrived")) {
            this.messagesConfig.set("delivery.shipment-arrived", (Object)"{prefix}&aYour shipment has arrived! Delivery completed.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-config-not-found")) {
            this.messagesConfig.set("delivery.delivery-config-not-found", (Object)"{prefix}&cDelivery configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.active-config-not-found")) {
            this.messagesConfig.set("delivery.active-config-not-found", (Object)"{prefix}&cActive configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.completed-config-not-found")) {
            this.messagesConfig.set("delivery.completed-config-not-found", (Object)"{prefix}&cCompleted configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.available-config-not-found")) {
            this.messagesConfig.set("delivery.available-config-not-found", (Object)"{prefix}&cAvailable configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.available-delivery-data-not-found")) {
            this.messagesConfig.set("delivery.available-delivery-data-not-found", (Object)"{prefix}&cAvailable delivery data not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.waiting-config-not-found")) {
            this.messagesConfig.set("delivery.waiting-config-not-found", (Object)"{prefix}&cWaiting configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.upgradeslot-config-not-found")) {
            this.messagesConfig.set("delivery.upgradeslot-config-not-found", (Object)"{prefix}&cUpgradeSlot configuration not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-active-delivery-to-submit")) {
            this.messagesConfig.set("delivery.no-active-delivery-to-submit", (Object)"{prefix}&cYou don't have an active delivery to submit!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-settings-not-found")) {
            this.messagesConfig.set("delivery.delivery-settings-not-found", (Object)"{prefix}&cDelivery settings for [deliveryType] not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-fish-requirements")) {
            this.messagesConfig.set("delivery.no-fish-requirements", (Object)"{prefix}&cNo fish requirements found for this delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-available-delivery-for-slot")) {
            this.messagesConfig.set("delivery.no-available-delivery-for-slot", (Object)"{prefix}&cNo available delivery for this slot!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-rejected-for-slot")) {
            this.messagesConfig.set("delivery.delivery-rejected-for-slot", (Object)"{prefix}&cYou rejected the delivery for slot [slot]!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-rejected-slot-waiting")) {
            this.messagesConfig.set("delivery.delivery-rejected-slot-waiting", (Object)"{prefix}&7The slot is now waiting for a new delivery.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.already-have-active-delivery")) {
            this.messagesConfig.set("delivery.already-have-active-delivery", (Object)"{prefix}&cYou already have an active delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-settings-not-found-type")) {
            this.messagesConfig.set("delivery.delivery-settings-not-found-type", (Object)"{prefix}&cDelivery settings for [deliveryType] not found!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-fish-requirements-for-delivery")) {
            this.messagesConfig.set("delivery.no-fish-requirements-for-delivery", (Object)"{prefix}&cNo fish requirements found for this delivery!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.shipment-arrived-completed")) {
            this.messagesConfig.set("delivery.shipment-arrived-completed", (Object)"{prefix}&aYour shipment has arrived! Delivery completed.");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.no-active-delivery-to-submit-message")) {
            this.messagesConfig.set("delivery.no-active-delivery-to-submit-message", (Object)"{prefix}&cYou don't have an active delivery to submit!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.not-completed-yet")) {
            this.messagesConfig.set("delivery.not-completed-yet", (Object)"{prefix}&cDelivery time has not completed yet!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.delivery-accepted")) {
            this.messagesConfig.set("delivery.delivery-accepted", (Object)"{prefix}&aDelivery accepted for slot [slot]!");
            changed = true;
        }
        if (!this.messagesConfig.contains("delivery.missing-fish")) {
            this.messagesConfig.set("delivery.missing-fish", (Object)"{prefix}&cYou need [required]x [fish] but you only have [have]!");
            changed = true;
        }
        if (this.messagesConfig.contains("commands.give.types") && !(currentTypes = this.messagesConfig.getString("commands.give.types", "")).contains("booster")) {
            String newTypes = currentTypes.replace("enchant", "enchant, booster");
            this.messagesConfig.set("commands.give.types", (Object)newTypes);
            changed = true;
        }
        if (changed) {
            try {
                File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
                this.messagesConfig.save(messagesFile);
                this.plugin.getLogger().info("Added missing booster and delivery messages to messages.yml");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save messages.yml: " + e.getMessage());
            }
        }
    }
}

