/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultManager {
    private final JavaPlugin plugin;
    private Economy economy;
    private boolean vaultEnabled = false;

    public VaultManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupEconomy();
    }

    private void setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aVault not found! Economy features will be disabled."));
            return;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aNo economy plugin found! Economy features will be disabled."));
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.vaultEnabled = true;
        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aVault economy integration enabled!"));
    }

    public boolean isVaultEnabled() {
        return this.vaultEnabled && this.economy != null;
    }

    public boolean giveMoney(Player player, double amount) {
        if (!this.isVaultEnabled()) {
            return false;
        }
        try {
            return this.economy.depositPlayer((OfflinePlayer)player, amount).transactionSuccess();
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError giving money to player " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean takeMoney(Player player, double amount) {
        if (!this.isVaultEnabled()) {
            return false;
        }
        try {
            return this.economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError taking money from player " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public double getBalance(Player player) {
        if (!this.isVaultEnabled()) {
            return 0.0;
        }
        try {
            return this.economy.getBalance((OfflinePlayer)player);
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError getting balance for player " + player.getName() + ": " + e.getMessage()));
            return 0.0;
        }
    }

    public boolean hasEnough(Player player, double amount) {
        if (!this.isVaultEnabled()) {
            return false;
        }
        try {
            return this.economy.has((OfflinePlayer)player, amount);
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError checking balance for player " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public String formatMoney(double amount) {
        if (!this.isVaultEnabled()) {
            return String.valueOf(amount);
        }
        try {
            return this.economy.format(amount);
        }
        catch (Exception e) {
            return String.valueOf(amount);
        }
    }

    public void executeRewardCommand(Player player, String command) {
        String processedCommand = command.replace("[PlayerName]", player.getName()).replace("[player]", player.getName());
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand);
            }
            catch (Exception e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &cError executing reward command '" + processedCommand + "': " + e.getMessage()));
            }
        });
    }
}

