/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.integrations;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPIIntegration
extends PlaceholderExpansion {
    private final MrUltimateFishing plugin;
    private final PlayerDataManager data;
    private final Map<String, CachedLeaderboard> cache = new ConcurrentHashMap<String, CachedLeaderboard>();
    private final long CACHE_TTL_MS = 30000L;

    public PlaceholderAPIIntegration(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.data = plugin.getPlayerDataManager();
    }

    @NotNull
    public String getIdentifier() {
        return "mrultimatefishing";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer p, @NotNull String params) {
        if (p == null) {
            return "";
        }
        PlayerDataManager.PlayerData pd = this.data.getPlayerData(p.getUniqueId());
        if (pd == null) {
            return "";
        }
        switch (params.toLowerCase(Locale.ROOT)) {
            case "level": {
                return String.valueOf(pd.getFishingLevel());
            }
            case "xp": {
                return String.valueOf(pd.getFishingXP());
            }
            case "normal_fishscales": {
                return String.valueOf(pd.getFishScale());
            }
            case "formatted_fishscales": {
                return NumberFormat.getInstance(Locale.US).format(pd.getFishScale());
            }
            case "catchcount": {
                return String.valueOf(pd.getTotalFishCaught());
            }
            case "upgradepoints": {
                return String.valueOf(pd.getUpgradePoints());
            }
        }
        if (params.startsWith("top_name_") || params.startsWith("top_value_")) {
            int position;
            String[] split = params.split("_");
            if (split.length < 4) {
                return "";
            }
            String mode = split[1];
            String type = split[2];
            String posStr = split[3];
            LeaderboardType lbType = LeaderboardType.fromString(type);
            if (lbType == null) {
                return "";
            }
            List<LBEntry> entries = this.getLeaderboard(lbType);
            if (entries.isEmpty()) {
                return "";
            }
            if ("me".equalsIgnoreCase(posStr)) {
                int idx = this.getPlayerIndex(entries, p.getUniqueId());
                if (idx == -1) {
                    return "";
                }
                LBEntry e = entries.get(idx);
                return "name".equals(mode) ? e.name : String.valueOf(e.value);
            }
            try {
                position = Integer.parseInt(posStr);
            }
            catch (NumberFormatException ex) {
                return "";
            }
            if (position <= 0 || position > entries.size()) {
                return "";
            }
            LBEntry e = entries.get(position - 1);
            return "name".equals(mode) ? e.name : String.valueOf(e.value);
        }
        return null;
    }

    private int getPlayerIndex(List<LBEntry> list, UUID uuid) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).uuid.equals(uuid)) continue;
            return i;
        }
        return -1;
    }

    private List<LBEntry> getLeaderboard(LeaderboardType type) {
        String key = type.name();
        CachedLeaderboard cached = this.cache.get(key);
        long now = System.currentTimeMillis();
        if (cached != null && now - cached.timestamp < 30000L) {
            return cached.entries;
        }
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        File[] files = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            this.cache.put(key, new CachedLeaderboard(now, Collections.emptyList()));
            return Collections.emptyList();
        }
        ArrayList<LBEntry> entries = new ArrayList<LBEntry>(files.length);
        for (File f : files) {
            try {
                long value;
                String uuidStr = f.getName().substring(0, f.getName().length() - 4);
                UUID uuid = UUID.fromString(uuidStr);
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
                switch (type.ordinal()) {
                    case 0: {
                        value = cfg.getLong("total-fish-caught", 0L);
                        break;
                    }
                    case 1: {
                        value = cfg.getLong("fish-scale", 0L);
                        break;
                    }
                    case 2: {
                        value = cfg.getLong("fishing-level", 1L);
                        break;
                    }
                    default: {
                        value = 0L;
                    }
                }
                String name2 = Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)uuid).getName()).orElse(uuid.toString());
                entries.add(new LBEntry(uuid, name2, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entries.sort(Comparator.comparingLong(e -> e.value).reversed());
        this.cache.put(key, new CachedLeaderboard(now, entries));
        return entries;
    }

    private static enum LeaderboardType {
        CATCH("catch"),
        FISHSCALE("fishscale"),
        LEVEL("level");

        final String id;

        private LeaderboardType(String id) {
            this.id = id;
        }

        static LeaderboardType fromString(String s) {
            for (LeaderboardType t : LeaderboardType.values()) {
                if (!t.id.equalsIgnoreCase(s)) continue;
                return t;
            }
            return null;
        }
    }

    private static class LBEntry {
        final UUID uuid;
        final String name;
        final long value;

        LBEntry(UUID uuid, String name, long value) {
            this.uuid = uuid;
            this.name = name;
            this.value = value;
        }
    }

    private static class CachedLeaderboard {
        final long timestamp;
        final List<LBEntry> entries;

        CachedLeaderboard(long timestamp, List<LBEntry> entries) {
            this.timestamp = timestamp;
            this.entries = entries;
        }
    }
}

