/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.listeners;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FishScalesBundleListener
implements Listener {
    private final MrUltimateFishing plugin;

    public FishScalesBundleListener(MrUltimateFishing plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "fish_scales_bundle_item");
        if (!meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
            return;
        }
        if (event.getAction().name().contains("RIGHT_CLICK")) {
            event.setCancelled(true);
            int bundleValue = (Integer)meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
            PlayerDataManager playerData = this.plugin.getPlayerDataManager();
            playerData.addFishScale(player, bundleValue);
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("enchants.fish-scales-bundle-deposited").replace("[amount]", String.valueOf(bundleValue))));
        }
    }
}

