/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BoosterManager
implements Listener {
    private final MrUltimateFishing plugin;
    private final FileConfiguration boostersConfig;
    private final Map<UUID, Map<BoosterType, ActiveBooster>> activeBoosters;

    public BoosterManager(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.boostersConfig = plugin.getConfigManager().getBoostersConfig();
        this.activeBoosters = new ConcurrentHashMap<UUID, Map<BoosterType, ActiveBooster>>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public ItemStack createBoosterItem(int boosterId) {
        ConfigurationSection customModelData;
        Material material;
        ConfigurationSection boosterSection = this.boostersConfig.getConfigurationSection("MrUltimateFishing.Boosters." + boosterId);
        if (boosterSection == null) {
            return null;
        }
        ConfigurationSection itemSection = boosterSection.getConfigurationSection("Item");
        if (itemSection == null) {
            return null;
        }
        String materialName = itemSection.getString("material", "DIAMOND_SWORD");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.DIAMOND_SWORD;
        }
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        String displayName = itemSection.getString("display-name", "&6Booster");
        displayName = ColorSystem.colorize(displayName);
        meta.setDisplayName(displayName);
        List lore = itemSection.getStringList("lore");
        ArrayList<String> coloredLore = new ArrayList<String>();
        for (String line : lore) {
            line = ColorSystem.colorize(line);
            ConfigurationSection booster = boosterSection.getConfigurationSection("Booster");
            if (booster != null) {
                double value = booster.getDouble("value", 1.0);
                int duration = booster.getInt("duration", 60);
                String rarity = booster.getString("rarity", "");
                line = this.replacePlaceholder(line, "value", String.valueOf(value));
                line = this.replacePlaceholder(line, "duration", String.valueOf(duration));
                line = this.replacePlaceholder(line, "rarity", rarity);
                line = this.replacePlaceholder(line, "Value", String.valueOf(value));
                line = this.replacePlaceholder(line, "Duration", String.valueOf(duration));
                line = this.replacePlaceholder(line, "Rarity", rarity);
            }
            coloredLore.add(line);
        }
        meta.setLore(coloredLore);
        if (itemSection.getBoolean("glowing", false)) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if ((customModelData = itemSection.getConfigurationSection("custom-model-data")) != null && customModelData.getBoolean("enabled", false)) {
            meta.setCustomModelData(Integer.valueOf(customModelData.getInt("value", 0)));
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_id");
        dataContainer.set(boosterKey, PersistentDataType.INTEGER, (Object)boosterId);
        item.setItemMeta(meta);
        return item;
    }

    private String replacePlaceholder(String text, String placeholder, String value) {
        if (text == null || placeholder == null || value == null) {
            return text;
        }
        text = text.replace("%" + placeholder + "%", value);
        text = text.replace("[" + placeholder + "]", value);
        text = text.replace("{" + placeholder + "}", value);
        text = text.replace("<" + placeholder + ">", value);
        return text;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        NamespacedKey boosterKey;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (!dataContainer.has(boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_id"), PersistentDataType.INTEGER)) {
            return;
        }
        if (!event.getAction().name().contains("RIGHT_CLICK")) {
            return;
        }
        event.setCancelled(true);
        int boosterId = (Integer)dataContainer.get(boosterKey, PersistentDataType.INTEGER);
        this.activateBooster(player, boosterId);
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
    }

    public boolean activateBooster(final Player player, int boosterId) {
        BoosterType type;
        ConfigurationSection boosterSection = this.boostersConfig.getConfigurationSection("MrUltimateFishing.Boosters." + boosterId);
        if (boosterSection == null) {
            return false;
        }
        ConfigurationSection booster = boosterSection.getConfigurationSection("Booster");
        if (booster == null) {
            return false;
        }
        String typeString = booster.getString("type", "XP").toUpperCase();
        try {
            type = BoosterType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid booster type: " + typeString);
            return false;
        }
        double value = booster.getDouble("value", 1.0);
        String rarity = booster.getString("rarity", "");
        int durationSeconds = booster.getInt("duration", 60);
        long durationMs = (long)durationSeconds * 1000L;
        Map playerBoosters = this.activeBoosters.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        if (playerBoosters.containsKey((Object)type)) {
            ActiveBooster existingBooster = (ActiveBooster)playerBoosters.get((Object)type);
            if (Math.abs(existingBooster.getValue() - value) < 0.001) {
                existingBooster.extendDuration(durationMs);
                String message = this.plugin.getMessageManager().getMessage("boosters.extended");
                message = this.replacePlaceholder(message, "type", type.name());
                message = this.replacePlaceholder(message, "duration", String.valueOf(durationSeconds));
                player.sendMessage(ColorSystem.colorize(message));
                return true;
            }
            String message = this.plugin.getMessageManager().getMessage("boosters.conflict");
            message = this.replacePlaceholder(message, "type", type.name().toLowerCase());
            player.sendMessage(ColorSystem.colorize(message));
            return false;
        }
        ActiveBooster activeBooster = new ActiveBooster(type, value, rarity, durationMs);
        playerBoosters.put(type, activeBooster);
        String message = this.plugin.getMessageManager().getMessage("boosters.activated");
        message = this.replacePlaceholder(message, "type", type.name());
        message = this.replacePlaceholder(message, "value", String.valueOf(value));
        message = this.replacePlaceholder(message, "duration", String.valueOf(durationSeconds));
        player.sendMessage(ColorSystem.colorize(message));
        new BukkitRunnable(this){
            final /* synthetic */ BoosterManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Map boosters = (Map)this.this$0.activeBoosters.get(player.getUniqueId());
                if (boosters != null) {
                    boosters.remove((Object)type);
                    if (boosters.isEmpty()) {
                        this.this$0.activeBoosters.remove(player.getUniqueId());
                    }
                }
                if (player.isOnline()) {
                    String expiredMessage = this.this$0.plugin.getMessageManager().getMessage("boosters.expired");
                    expiredMessage = this.this$0.replacePlaceholder(expiredMessage, "type", type.name().toLowerCase());
                    player.sendMessage(ColorSystem.colorize(expiredMessage));
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)durationSeconds * 20L);
        return true;
    }

    public double getBoosterMultiplier(Player player, BoosterType type) {
        Map<BoosterType, ActiveBooster> playerBoosters = this.activeBoosters.get(player.getUniqueId());
        if (playerBoosters == null) {
            return 1.0;
        }
        ActiveBooster booster = playerBoosters.get((Object)type);
        if (booster == null || booster.isExpired()) {
            if (booster != null) {
                playerBoosters.remove((Object)type);
                if (playerBoosters.isEmpty()) {
                    this.activeBoosters.remove(player.getUniqueId());
                }
            }
            return 1.0;
        }
        return booster.getValue();
    }

    public double getRarityBoostChance(Player player, String rarity) {
        Map<BoosterType, ActiveBooster> playerBoosters = this.activeBoosters.get(player.getUniqueId());
        if (playerBoosters == null) {
            return 0.0;
        }
        ActiveBooster booster = playerBoosters.get((Object)BoosterType.RARITY);
        if (booster == null || booster.isExpired()) {
            return 0.0;
        }
        if (booster.getRarity().equalsIgnoreCase(rarity)) {
            return booster.getValue();
        }
        return 0.0;
    }

    public Map<BoosterType, ActiveBooster> getActiveBoosters(Player player) {
        Map<BoosterType, ActiveBooster> playerBoosters = this.activeBoosters.get(player.getUniqueId());
        if (playerBoosters == null) {
            return new HashMap<BoosterType, ActiveBooster>();
        }
        playerBoosters.entrySet().removeIf(entry -> ((ActiveBooster)entry.getValue()).isExpired());
        if (playerBoosters.isEmpty()) {
            this.activeBoosters.remove(player.getUniqueId());
            return new HashMap<BoosterType, ActiveBooster>();
        }
        return new HashMap<BoosterType, ActiveBooster>(playerBoosters);
    }

    public void cleanupExpiredBoosters() {
        this.activeBoosters.entrySet().removeIf(entry -> {
            Map playerBoosters = (Map)entry.getValue();
            playerBoosters.entrySet().removeIf(boosterEntry -> ((ActiveBooster)boosterEntry.getValue()).isExpired());
            return playerBoosters.isEmpty();
        });
    }

    public void onPlayerQuit(Player player) {
        this.activeBoosters.remove(player.getUniqueId());
    }

    public Set<String> getAvailableBoosterIds() {
        ConfigurationSection boostersSection = this.boostersConfig.getConfigurationSection("MrUltimateFishing.Boosters");
        if (boostersSection != null) {
            return boostersSection.getKeys(false);
        }
        return new HashSet<String>();
    }

    public void shutdown() {
        this.activeBoosters.clear();
    }

    public static enum BoosterType {
        XP,
        FISHSCALES,
        SELLBOOST,
        RARITY,
        GUTBOOST,
        CRABBOOST;

    }

    public static class ActiveBooster {
        private final BoosterType type;
        private final double value;
        private final String rarity;
        private long startTime;
        private long duration;

        public ActiveBooster(BoosterType type, double value, String rarity, long duration) {
            this.type = type;
            this.value = value;
            this.rarity = rarity;
            this.startTime = System.currentTimeMillis();
            this.duration = duration;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + this.duration;
        }

        public long getRemainingTime() {
            long remaining = this.startTime + this.duration - System.currentTimeMillis();
            return Math.max(0L, remaining);
        }

        public void extendDuration(long additionalDuration) {
            this.duration += additionalDuration;
        }

        public BoosterType getType() {
            return this.type;
        }

        public double getValue() {
            return this.value;
        }

        public String getRarity() {
            return this.rarity;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

