/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ShopMenuManager
extends BaseMenuManager {
    private final Set<Inventory> activeShopMenuInventories = new HashSet<Inventory>();

    public void registerShopMenuInventory(Inventory inventory) {
        this.activeShopMenuInventories.add(inventory);
    }

    public void unregisterShopMenuInventory(Inventory inventory) {
        this.activeShopMenuInventories.remove(inventory);
    }

    public boolean isShopMenuRegistered(Inventory inventory) {
        return this.activeShopMenuInventories.contains(inventory);
    }

    public ShopMenuManager(MrUltimateFishing plugin) {
        super(plugin);
    }

    public void openShopMenu(Player player) {
        File shopFile = new File(this.plugin.getDataFolder(), "Menus/shop.yml");
        if (!shopFile.exists()) {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("shop.config-not-found")));
            return;
        }
        ConfigurationSection shopConfig = this.plugin.getMenuConfig("shop");
        if (shopConfig == null) {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("shop.config-load-failed")));
            return;
        }
        String title = ColorSystem.colorize(shopConfig.getString("title", "Shop"));
        int size = shopConfig.getInt("size", 54);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.registerShopMenuInventory(inventory);
        this.addDecorations(inventory, shopConfig.getConfigurationSection("decorations"));
        this.addNavigationKeys(inventory, shopConfig.getConfigurationSection("keys"), player);
        this.addShopItems(inventory, shopConfig, player);
        player.openInventory(inventory);
    }

    private void addShopItems(Inventory inventory, ConfigurationSection shopConfig, Player player) {
        ConfigurationSection totemShopItemConfig;
        ConfigurationSection itemsSection = shopConfig.getConfigurationSection("items.buyitems");
        if (itemsSection == null) {
            return;
        }
        List<Integer> slots = this.parseSlots(itemsSection.getString("slots", ""));
        ConfigurationSection totemConfig = this.plugin.getConfig().getConfigurationSection("Totem");
        if (totemConfig != null && totemConfig.getBoolean("Buy.Enable", false) && (totemShopItemConfig = totemConfig.getConfigurationSection("Buy.Settings.ShopItem")) != null && !slots.isEmpty()) {
            ItemStack totemItem = this.createTotemShopItem(totemShopItemConfig, player);
            inventory.setItem(slots.get(0).intValue(), totemItem);
        }
        int slotIndex = 1;
        for (int boosterId = 1; boosterId <= 10 && slotIndex < slots.size(); ++boosterId) {
            ItemStack boosterShopItem = this.createBoosterShopItem(boosterId, player);
            if (boosterShopItem == null) continue;
            inventory.setItem(slots.get(slotIndex).intValue(), boosterShopItem);
            ++slotIndex;
        }
    }

    private ItemStack createTotemShopItem(ConfigurationSection itemConfig, Player player) {
        Material material = Material.valueOf((String)itemConfig.getString("Material", "BEACON"));
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = itemConfig.getString("Display-Name", "Fish Totem");
            meta.setDisplayName(ColorSystem.colorize(displayName));
            List lore = itemConfig.getStringList("Lore");
            ArrayList<String> processedLore = new ArrayList<String>();
            PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
            for (String line : lore) {
                line = ColorSystem.colorize(line);
                line = line.replace("[CurrentUpgradeSlots]", "1").replace("[CurrentRadius]", "5 blocks").replace("[CurrentEnableTime]", "30 seconds").replace("[CurrentCooldownTime]", "30 minutes");
                processedLore.add(line);
            }
            meta.setLore(processedLore);
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey shopItemKey = new NamespacedKey((Plugin)this.plugin, "shop_item");
            dataContainer.set(shopItemKey, PersistentDataType.STRING, (Object)"totem");
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection keysSection, Player player) {
        if (keysSection == null) {
            return;
        }
        this.addBackButton(inventory, keysSection.getParent());
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        String action;
        NamespacedKey actionKey;
        NamespacedKey shopItemKey;
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isShopMenuRegistered(event.getInventory())) {
            return false;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return true;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return true;
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (dataContainer.has(shopItemKey = new NamespacedKey((Plugin)this.plugin, "shop_item"), PersistentDataType.STRING)) {
            NamespacedKey boosterIdKey;
            String itemType = (String)dataContainer.get(shopItemKey, PersistentDataType.STRING);
            if ("totem".equals(itemType)) {
                this.handleTotemPurchase(player);
                return true;
            }
            if ("booster".equals(itemType) && dataContainer.has(boosterIdKey = new NamespacedKey((Plugin)this.plugin, "booster_shop_id"), PersistentDataType.INTEGER)) {
                int boosterId = (Integer)dataContainer.get(boosterIdKey, PersistentDataType.INTEGER);
                this.handleBoosterPurchase(player, boosterId);
                return true;
            }
        }
        if (dataContainer.has(actionKey = new NamespacedKey((Plugin)this.plugin, "action"), PersistentDataType.STRING) && "back".equals(action = (String)dataContainer.get(actionKey, PersistentDataType.STRING))) {
            player.closeInventory();
            this.plugin.getMenuManager().openHeadMenu(player);
            return true;
        }
        return true;
    }

    private void handleTotemPurchase(Player player) {
        ConfigurationSection totemConfig = this.plugin.getConfig().getConfigurationSection("Totem.Buy");
        if (totemConfig == null) {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("shop.purchase-not-configured")));
            return;
        }
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        int requiredFishScales = totemConfig.getInt("FishScales", 35000);
        int requiredLevel = totemConfig.getInt("FishLevel", 25);
        if (playerData.getFishingLevel() < requiredLevel) {
            String message = this.plugin.getMessageManager().getMessage("shop.insufficient-level").replace("[level]", String.valueOf(requiredLevel));
            player.sendMessage(ColorSystem.colorize(message));
            return;
        }
        if (playerData.getFishScale() < requiredFishScales) {
            String message = this.plugin.getMessageManager().getMessage("shop.insufficient-scales").replace("[scales]", String.valueOf(requiredFishScales));
            player.sendMessage(ColorSystem.colorize(message));
            return;
        }
        List requiredItems = totemConfig.getStringList("Items");
        HashMap<String, Integer> missingItems = new HashMap<String, Integer>();
        for (String itemStr : requiredItems) {
            String[] parts = itemStr.split(":");
            if (parts.length != 2) continue;
            String itemName = parts[0];
            int requiredAmount = Integer.parseInt(parts[1]);
            int playerAmount = this.countCustomItems(player, itemName);
            if (playerAmount >= requiredAmount) continue;
            missingItems.put(itemName, requiredAmount - playerAmount);
        }
        ConfigurationSection fishesSection = totemConfig.getConfigurationSection("Fishes");
        if (fishesSection != null) {
            boolean hasEpic;
            int rareRequired = fishesSection.getInt("Rare", 0);
            int epicRequired = fishesSection.getInt("Epic", 0);
            boolean hasRare = this.countFishByRarity(player, "RARE") >= rareRequired;
            boolean bl = hasEpic = this.countFishByRarity(player, "EPIC") >= epicRequired;
            if (!hasRare && !hasEpic) {
                String message = this.plugin.getMessageManager().getMessage("shop.insufficient-fish").replace("[rare]", String.valueOf(rareRequired)).replace("[epic]", String.valueOf(epicRequired));
                player.sendMessage(ColorSystem.colorize(message));
                return;
            }
        }
        if (!missingItems.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(missingItems.entrySet().stream().map(entry -> entry.getValue() + "x " + (String)entry.getKey()).collect(Collectors.joining(", ")));
            String finalMessage = this.plugin.getMessageManager().getMessage("shop.missing-items").replace("[items]", message.toString());
            player.sendMessage(ColorSystem.colorize(finalMessage));
            return;
        }
        if (!this.plugin.getPlayerDataManager().removeFishScale(player, requiredFishScales)) {
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("shop.scales-removal-failed")));
            return;
        }
        this.removeRequiredItems(player, totemConfig);
        ItemStack totemItem = this.createTotemItem();
        if (player.getInventory().firstEmpty() == -1) {
            player.getWorld().dropItemNaturally(player.getLocation(), totemItem);
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("shop.totem-purchase-success-dropped")));
        } else {
            player.getInventory().addItem(new ItemStack[]{totemItem});
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("shop.totem-purchase-success")));
        }
        player.closeInventory();
    }

    private void handleBoosterPurchase(Player player, int boosterId) {
        ItemStack boosterItem;
        FileConfiguration boostersConfig = this.plugin.getConfigManager().getBoostersConfig();
        ConfigurationSection boosterSection = boostersConfig.getConfigurationSection("MrUltimateFishing.Boosters." + boosterId);
        if (boosterSection == null) {
            String message = this.plugin.getMessageManager().getMessage("boosters.not-found");
            player.sendMessage(ColorSystem.colorize(message));
            return;
        }
        ConfigurationSection shopItemSection = boosterSection.getConfigurationSection("ShopItem");
        if (shopItemSection == null) {
            String message = this.plugin.getMessageManager().getMessage("boosters.not-available");
            player.sendMessage(ColorSystem.colorize(message));
            return;
        }
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        int requiredLevel = shopItemSection.getInt("Required-Level", 1);
        if (playerData.getFishingLevel() < requiredLevel) {
            String message = this.plugin.getMessageManager().getMessage("boosters.insufficient-level");
            message = this.replacePlaceholder(message, "level", String.valueOf(requiredLevel));
            player.sendMessage(ColorSystem.colorize(message));
            return;
        }
        ConfigurationSection priceSection = shopItemSection.getConfigurationSection("Price");
        if (priceSection != null) {
            int requiredFishScales = priceSection.getInt("Fish-Scales", 0);
            int requiredMoney = priceSection.getInt("Money", 0);
            if (requiredFishScales > 0 && playerData.getFishScale() < requiredFishScales) {
                String message = this.plugin.getMessageManager().getMessage("shop.insufficient-scales").replace("[scales]", String.valueOf(requiredFishScales));
                player.sendMessage(ColorSystem.colorize(message));
                return;
            }
            if (requiredMoney > 0 && !this.plugin.getVaultManager().hasEnough(player, requiredMoney)) {
                String message = this.plugin.getMessageManager().getMessage("boosters.insufficient-money");
                message = this.replacePlaceholder(message, "money", String.valueOf(requiredMoney));
                player.sendMessage(ColorSystem.colorize(message));
                return;
            }
            if (requiredFishScales > 0) {
                this.plugin.getPlayerDataManager().removeFishScale(player, requiredFishScales);
            }
            if (requiredMoney > 0) {
                this.plugin.getVaultManager().takeMoney(player, requiredMoney);
            }
        }
        if ((boosterItem = this.plugin.getBoosterManager().createBoosterItem(boosterId)) == null) {
            String message = this.plugin.getMessageManager().getMessage("boosters.creation-failed");
            player.sendMessage(ColorSystem.colorize(message));
            return;
        }
        if (player.getInventory().firstEmpty() == -1) {
            player.getWorld().dropItemNaturally(player.getLocation(), boosterItem);
            String message = this.plugin.getMessageManager().getMessage("boosters.purchase-success-dropped");
            player.sendMessage(ColorSystem.colorize(message));
        } else {
            player.getInventory().addItem(new ItemStack[]{boosterItem});
            String message = this.plugin.getMessageManager().getMessage("boosters.purchase-success");
            player.sendMessage(ColorSystem.colorize(message));
        }
        player.closeInventory();
    }

    private ItemStack createTotemItem() {
        ConfigurationSection totemConfig = this.plugin.getConfig().getConfigurationSection("Totem.Buy.Settings.Item");
        if (totemConfig == null) {
            return new ItemStack(Material.BEACON);
        }
        Material material = Material.valueOf((String)totemConfig.getString("Material", "BEACON"));
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = totemConfig.getString("Display-Name", "Fish Totem");
            meta.setDisplayName(ColorSystem.colorize(displayName));
            List lore = totemConfig.getStringList("Lore");
            ArrayList<String> processedLore = new ArrayList<String>();
            for (String line : lore) {
                line = ColorSystem.colorize(line);
                line = line.replace("[CurrentUpgradeSlots]", "1").replace("[CurrentRadius]", "5").replace("[CurrentEnableTime]", "30").replace("[CurrentCooldownTime]", "1800");
                processedLore.add(line);
            }
            meta.setLore(processedLore);
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey totemKey = new NamespacedKey((Plugin)this.plugin, "totem");
            dataContainer.set(totemKey, PersistentDataType.STRING, (Object)"fish_totem");
            NamespacedKey radiusKey = new NamespacedKey((Plugin)this.plugin, "totem_radius");
            dataContainer.set(radiusKey, PersistentDataType.INTEGER, (Object)5);
            NamespacedKey activeTimeKey = new NamespacedKey((Plugin)this.plugin, "totem_active_time");
            dataContainer.set(activeTimeKey, PersistentDataType.INTEGER, (Object)30);
            NamespacedKey cooldownKey = new NamespacedKey((Plugin)this.plugin, "totem_cooldown");
            dataContainer.set(cooldownKey, PersistentDataType.INTEGER, (Object)1800);
            NamespacedKey upgradeSlotsKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade_slots");
            dataContainer.set(upgradeSlotsKey, PersistentDataType.INTEGER, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createBoosterShopItem(int boosterId, Player player) {
        Material material;
        FileConfiguration boostersConfig = this.plugin.getConfigManager().getBoostersConfig();
        ConfigurationSection boosterSection = boostersConfig.getConfigurationSection("MrUltimateFishing.Boosters." + boosterId);
        if (boosterSection == null) {
            return null;
        }
        ConfigurationSection shopItemSection = boosterSection.getConfigurationSection("ShopItem");
        if (shopItemSection == null) {
            return null;
        }
        ConfigurationSection boosterInfo = boosterSection.getConfigurationSection("Booster");
        ConfigurationSection itemInfo = boosterSection.getConfigurationSection("Item");
        if (boosterInfo == null || itemInfo == null) {
            return null;
        }
        int requiredLevel = shopItemSection.getInt("Required-Level", 1);
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (playerData.getFishingLevel() < requiredLevel) {
            return null;
        }
        String materialName = itemInfo.getString("material", "DIAMOND_SWORD");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.DIAMOND_SWORD;
        }
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        String displayName = shopItemSection.getString("Display-Name", "&6Booster");
        meta.setDisplayName(ColorSystem.colorize(displayName));
        List lore = shopItemSection.getStringList("Lore");
        ArrayList<String> processedLore = new ArrayList<String>();
        for (String line : lore) {
            line = ColorSystem.colorize(line);
            double value = boosterInfo.getDouble("value", 1.0);
            int duration = boosterInfo.getInt("duration", 60);
            String rarity = boosterInfo.getString("rarity", "");
            line = this.replacePlaceholder(line, "value", String.valueOf(value));
            line = this.replacePlaceholder(line, "duration", String.valueOf(duration));
            line = this.replacePlaceholder(line, "rarity", rarity);
            line = this.replacePlaceholder(line, "Value", String.valueOf(value));
            line = this.replacePlaceholder(line, "Duration", String.valueOf(duration));
            line = this.replacePlaceholder(line, "Rarity", rarity);
            processedLore.add(line);
        }
        meta.setLore(processedLore);
        if (itemInfo.getBoolean("glowing", false)) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey shopItemKey = new NamespacedKey((Plugin)this.plugin, "shop_item");
        dataContainer.set(shopItemKey, PersistentDataType.STRING, (Object)"booster");
        NamespacedKey boosterIdKey = new NamespacedKey((Plugin)this.plugin, "booster_shop_id");
        dataContainer.set(boosterIdKey, PersistentDataType.INTEGER, (Object)boosterId);
        item.setItemMeta(meta);
        return item;
    }

    private String replacePlaceholder(String text, String placeholder, String value) {
        if (text == null || placeholder == null || value == null) {
            return text;
        }
        text = text.replace("%" + placeholder + "%", value);
        text = text.replace("[" + placeholder + "]", value);
        text = text.replace("{" + placeholder + "}", value);
        text = text.replace("<" + placeholder + ">", value);
        return text;
    }

    private int countCustomItems(Player player, String itemName) {
        int count = 0;
        String customType = this.getCustomItemType(itemName);
        for (ItemStack item : player.getInventory().getContents()) {
            String customItemType;
            NamespacedKey customItemKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(customItemKey = new NamespacedKey((Plugin)this.plugin, "custom_drop_type"), PersistentDataType.STRING) || !customType.equals(customItemType = (String)dataContainer.get(customItemKey, PersistentDataType.STRING))) continue;
            count += item.getAmount();
        }
        return count;
    }

    private String getCustomItemType(String materialName) {
        switch (materialName) {
            case "DOLPHIN_TAIL": {
                return "dolphin-tail";
            }
            case "CRAB_CLAWS": {
                return "crab-claws";
            }
            case "CRAB_SHELL": {
                return "crab-shell";
            }
            case "SQUID_TENTACLE": {
                return "squid-tentacle";
            }
        }
        return materialName.toLowerCase().replace("_", "-");
    }

    private int countFishByRarity(Player player, String rarity) {
        int count = 0;
        String actualRarity = "RARE".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getRareRarity() : ("EPIC".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getEpicRarity() : rarity.toUpperCase());
        for (ItemStack item : player.getInventory().getContents()) {
            String fishRarity;
            NamespacedKey fishRarityKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(fishRarityKey = new NamespacedKey("mrultimatefishing", "muf_fish_rarity"), PersistentDataType.STRING) || !actualRarity.equalsIgnoreCase(fishRarity = (String)dataContainer.get(fishRarityKey, PersistentDataType.STRING))) continue;
            count += item.getAmount();
        }
        return count;
    }

    private void removeRequiredItems(Player player, ConfigurationSection totemConfig) {
        List requiredItems = totemConfig.getStringList("Items");
        for (String itemStr : requiredItems) {
            String[] parts = itemStr.split(":");
            if (parts.length != 2) continue;
            String itemName = parts[0];
            int requiredAmount = Integer.parseInt(parts[1]);
            this.removeCustomItems(player, itemName, requiredAmount);
        }
        ConfigurationSection fishesSection = totemConfig.getConfigurationSection("Fishes");
        if (fishesSection != null) {
            int rareRequired = fishesSection.getInt("Rare", 0);
            int epicRequired = fishesSection.getInt("Epic", 0);
            if (this.countFishByRarity(player, "RARE") >= rareRequired) {
                this.removeFishByRarity(player, "RARE", rareRequired);
            } else if (this.countFishByRarity(player, "EPIC") >= epicRequired) {
                this.removeFishByRarity(player, "EPIC", epicRequired);
            }
        }
    }

    private void removeCustomItems(Player player, String itemName, int amount) {
        String customType = this.getCustomItemType(itemName);
        for (ItemStack item : player.getInventory().getContents()) {
            String customItemType;
            NamespacedKey customItemKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || amount <= 0 || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(customItemKey = new NamespacedKey((Plugin)this.plugin, "custom_drop_type"), PersistentDataType.STRING) || !customType.equals(customItemType = (String)dataContainer.get(customItemKey, PersistentDataType.STRING))) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= amount) {
                amount -= itemAmount;
                item.setAmount(0);
                continue;
            }
            item.setAmount(itemAmount - amount);
            amount = 0;
        }
    }

    private void removeFishByRarity(Player player, String rarity, int amount) {
        String actualRarity = "RARE".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getRareRarity() : ("EPIC".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getEpicRarity() : rarity.toUpperCase());
        for (ItemStack item : player.getInventory().getContents()) {
            String fishRarity;
            NamespacedKey fishRarityKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || amount <= 0 || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(fishRarityKey = new NamespacedKey("mrultimatefishing", "muf_fish_rarity"), PersistentDataType.STRING) || !actualRarity.equalsIgnoreCase(fishRarity = (String)dataContainer.get(fishRarityKey, PersistentDataType.STRING))) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= amount) {
                amount -= itemAmount;
                item.setAmount(0);
                continue;
            }
            item.setAmount(itemAmount - amount);
            amount = 0;
        }
    }

    public boolean handleInventoryClose(InventoryCloseEvent event) {
        if (this.isShopMenuRegistered(event.getInventory())) {
            this.unregisterShopMenuInventory(event.getInventory());
            return true;
        }
        return false;
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        if (this.isShopMenuRegistered(event.getInventory())) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    public void cleanupPlayerData(Player player) {
    }
}

