/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Squid;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomDropsManager
implements Listener {
    private final MrUltimateFishing plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final Random random;

    public CustomDropsManager(MrUltimateFishing plugin, ConfigManager configManager, MessageManager messageManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messageManager = messageManager;
        this.random = new Random();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Squid) {
            this.handleSquidDrop(event);
        }
        if (event.getEntity() instanceof Dolphin) {
            this.handleDolphinDrop(event);
        }
        if (event.getEntity() instanceof Silverfish) {
            this.handleCrabDrop(event);
        }
    }

    private void handleDolphinDrop(EntityDeathEvent event) {
        ItemStack dolphinTail;
        Dolphin dolphin = (Dolphin)event.getEntity();
        if (!(dolphin.getKiller() instanceof Player)) {
            return;
        }
        Player killer = dolphin.getKiller();
        double dropChance = this.configManager.getMainConfig().getDouble("CustomDrops.Dolphin.chance", 15.0) / 100.0;
        if (this.random.nextDouble() < dropChance && (dolphinTail = this.createDolphinTail()) != null) {
            Location dropLocation = event.getEntity().getLocation();
            dropLocation.getWorld().dropItemNaturally(dropLocation, dolphinTail);
            if (this.plugin.getConfig().getBoolean("debug.drops", false)) {
                // empty if block
            }
        }
    }

    private void handleSquidDrop(EntityDeathEvent event) {
        ItemStack tentacle;
        Squid squid = (Squid)event.getEntity();
        if (!(squid.getKiller() instanceof Player)) {
            return;
        }
        Player killer = squid.getKiller();
        double dropChance = this.configManager.getMainConfig().getDouble("CustomDrops.Squids.chance", 10.0);
        if (this.random.nextDouble() < dropChance && (tentacle = this.createSquidTentacle()) != null) {
            Location dropLocation = event.getEntity().getLocation();
            dropLocation.getWorld().dropItemNaturally(dropLocation, tentacle);
            if (this.plugin.getConfig().getBoolean("debug.drops", false)) {
                // empty if block
            }
        }
    }

    public ItemStack createDolphinTail() {
        try {
            String materialName = this.messageManager.getMessagesConfig().getString("Items.dolphin-tail.material", "PHANTOM_MEMBRANE");
            String displayName = this.messageManager.getMessagesConfig().getString("Items.dolphin-tail.display-name", "&bDolphin Tail");
            List lore = this.messageManager.getMessagesConfig().getStringList("Items.dolphin-tail.lore");
            boolean glowing = this.messageManager.getMessagesConfig().getBoolean("Items.dolphin-tail.glowing", false);
            Material material = Material.valueOf((String)materialName.toUpperCase());
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ColorSystem.colorize(displayName));
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(ColorSystem.colorize(line));
                }
                meta.setLore(coloredLore);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"dolphin-tail");
                if (glowing) {
                    meta.addEnchant(Enchantment.LURE, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack createSquidTentacle() {
        try {
            String materialName = this.messageManager.getMessagesConfig().getString("Items.squid-tentacle.material", "KELP");
            String displayName = this.messageManager.getMessagesConfig().getString("Items.squid-tentacle.display-name", "&bSquid Tentacle");
            List lore = this.messageManager.getMessagesConfig().getStringList("Items.squid-tentacle.lore");
            boolean glowing = this.messageManager.getMessagesConfig().getBoolean("Items.squid-tentacle.glowing", false);
            Material material = Material.valueOf((String)materialName.toUpperCase());
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ColorSystem.colorize(displayName));
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(ColorSystem.colorize(line));
                }
                meta.setLore(coloredLore);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"squid-tentacle");
                if (glowing) {
                    meta.addEnchant(Enchantment.LURE, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack createCrabClaws() {
        try {
            String materialName = this.messageManager.getMessagesConfig().getString("Items.crab-claws.material", "SHEARS");
            String displayName = this.messageManager.getMessagesConfig().getString("Items.crab-claws.display-name", "&cCrab Claws");
            List lore = this.messageManager.getMessagesConfig().getStringList("Items.crab-claws.lore");
            boolean glowing = this.messageManager.getMessagesConfig().getBoolean("Items.crab-claws.glowing", false);
            Material material = Material.valueOf((String)materialName.toUpperCase());
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ColorSystem.colorize(displayName));
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(ColorSystem.colorize(line));
                }
                meta.setLore(coloredLore);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"crab-claws");
                if (glowing) {
                    meta.addEnchant(Enchantment.LURE, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack createCrabShell() {
        try {
            String materialName = this.messageManager.getMessagesConfig().getString("Items.crab-shell.material", "SCUTE");
            String displayName = this.messageManager.getMessagesConfig().getString("Items.crab-shell.display-name", "&eCrab Shell");
            List lore = this.messageManager.getMessagesConfig().getStringList("Items.crab-shell.lore");
            boolean glowing = this.messageManager.getMessagesConfig().getBoolean("Items.crab-shell.glowing", false);
            Material material = Material.valueOf((String)materialName.toUpperCase());
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ColorSystem.colorize(displayName));
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(ColorSystem.colorize(line));
                }
                meta.setLore(coloredLore);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"crab-shell");
                if (glowing) {
                    meta.addEnchant(Enchantment.LURE, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void handleCrabDrop(EntityDeathEvent event) {
        Silverfish silverfish = (Silverfish)event.getEntity();
        if (silverfish.getCustomName() == null) {
            return;
        }
        String crabName = this.plugin.getConfig().getString("CustomDrops.Crab.mob-name", "&cCrab");
        crabName = crabName.replace("&", "\u00a7");
        if (!silverfish.getCustomName().equals(crabName)) {
            return;
        }
        double dropChance = this.plugin.getConfig().getDouble("CustomDrops.Crab.drop-chance", 0.15);
        if (this.random.nextDouble() < dropChance) {
            ItemStack crabClaws = this.createCrabClaws();
            ItemStack crabShell = this.createCrabShell();
            if (crabClaws != null && crabShell != null) {
                Location dropLocation = event.getEntity().getLocation();
                dropLocation.getWorld().dropItemNaturally(dropLocation, crabClaws);
                dropLocation.getWorld().dropItemNaturally(dropLocation, crabShell);
                if (this.plugin.getConfig().getBoolean("debug.drops", false)) {
                    // empty if block
                }
            }
        }
    }
}

