/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.CustomDropsManager;
import eu.mrneznamy.mrultimatefishing.FishingManager;
import eu.mrneznamy.mrultimatefishing.FishingRodListener;
import eu.mrneznamy.mrultimatefishing.HologramManager;
import eu.mrneznamy.mrultimatefishing.MenuManager;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.PlayerListener;
import eu.mrneznamy.mrultimatefishing.VaultManager;
import eu.mrneznamy.mrultimatefishing.commands.FishCommand;
import eu.mrneznamy.mrultimatefishing.commands.MufCommand;
import eu.mrneznamy.mrultimatefishing.integrations.MrCommunityQuestIntegration;
import eu.mrneznamy.mrultimatefishing.integrations.PlaceholderAPIIntegration;
import eu.mrneznamy.mrultimatefishing.listeners.EnchantApplyListener;
import eu.mrneznamy.mrultimatefishing.listeners.FishScalesBundleListener;
import eu.mrneznamy.mrultimatefishing.managers.BoosterManager;
import eu.mrneznamy.mrultimatefishing.managers.EnchantManager;
import eu.mrneznamy.mrultimatefishing.managers.EventManager;
import eu.mrneznamy.mrultimatefishing.managers.RarityMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.RecipeMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.ShopMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.TotemManager;
import eu.mrneznamy.mrultimatefishing.managers.TournamentManager;
import eu.mrneznamy.mrultimatefishing.managers.UpgradeMenuManager;
import eu.mrneznamy.mrultimatefishing.utils.CheckUpdates;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import eu.mrneznamy.mrultimatefishing.utils.VersionChecker;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MrUltimateFishing
extends JavaPlugin {
    private MessageManager messageManager;
    private ConfigManager configManager;
    private FishingManager fishingManager;
    private PlayerDataManager playerDataManager;
    private VaultManager vaultManager;
    private MenuManager menuManager;
    private UpgradeMenuManager upgradeMenuManager;
    private CustomDropsManager customDropsManager;
    private EnchantManager enchantManager;
    private RecipeMenuManager recipeMenuManager;
    private RarityMenuManager rarityMenuManager;
    private HologramManager hologramManager;
    private TotemManager totemManager;
    private ShopMenuManager shopMenuManager;
    private TournamentManager tournamentManager;
    private EventManager eventManager;
    private BoosterManager boosterManager;
    private MrCommunityQuestIntegration communityQuestIntegration;

    public void onEnable() {
        VersionChecker versionChecker = new VersionChecker(this);
        if (!versionChecker.checkVersion()) {
            return;
        }
        CheckUpdates updater = new CheckUpdates(this);
        updater.EnableMessage();
        updater.checkForUpdates();
        this.getServer().getPluginManager().registerEvents((Listener)updater, (Plugin)this);
        this.createMenuFiles();
        this.messageManager = new MessageManager(this);
        this.configManager = new ConfigManager(this, this.messageManager);
        this.vaultManager = new VaultManager(this);
        this.hologramManager = new HologramManager(this, this.configManager);
        this.playerDataManager = new PlayerDataManager(this, this.configManager, this.messageManager, this.vaultManager);
        this.fishingManager = new FishingManager(this, this.configManager, this.messageManager);
        this.upgradeMenuManager = new UpgradeMenuManager(this);
        this.customDropsManager = new CustomDropsManager(this, this.configManager, this.messageManager);
        this.enchantManager = new EnchantManager(this);
        this.recipeMenuManager = new RecipeMenuManager(this);
        this.rarityMenuManager = new RarityMenuManager(this);
        this.totemManager = new TotemManager(this);
        this.shopMenuManager = new ShopMenuManager(this);
        this.tournamentManager = new TournamentManager(this);
        this.eventManager = new EventManager(this);
        this.boosterManager = new BoosterManager(this);
        this.menuManager = new MenuManager(this, this.messageManager, this.vaultManager);
        this.communityQuestIntegration = new MrCommunityQuestIntegration(this);
        MufCommand mufCommand = new MufCommand(this, this.messageManager, this.configManager, this.customDropsManager);
        this.getCommand("muf").setExecutor((CommandExecutor)mufCommand);
        this.getCommand("muf").setTabCompleter((TabCompleter)mufCommand);
        FishCommand fishCommand = new FishCommand(this, this.messageManager, this.configManager, this.customDropsManager);
        this.getCommand("fish").setExecutor((CommandExecutor)fishCommand);
        this.getCommand("fish").setTabCompleter((TabCompleter)fishCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.playerDataManager, this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.fishingManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.menuManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.rarityMenuManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FishingRodListener(this, this.menuManager, this.messageManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.customDropsManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantApplyListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FishScalesBundleListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.totemManager, (Plugin)this);
        this.loadOnlinePlayersData();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new PlaceholderAPIIntegration(this).register();
                Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aPlaceholderAPI integration enabled!"));
            }
            catch (Exception e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&cMrUltimateFishing&8] &cFailed to enable PlaceholderAPI integration: " + e.getMessage()));
            }
        } else {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&cMrUltimateFishing&8] &cPlaceholderAPI not found. Skipping PlaceholderAPI integration."));
        }
    }

    public void onDisable() {
        if (this.fishingManager != null) {
            this.fishingManager.disable();
        }
        if (this.playerDataManager != null) {
            this.playerDataManager.disable();
        }
        if (this.totemManager != null) {
            this.totemManager.shutdown();
        }
        if (this.tournamentManager != null) {
            this.tournamentManager.shutdown();
        }
        if (this.eventManager != null) {
            this.eventManager.shutdown();
        }
        if (this.boosterManager != null) {
            this.boosterManager.shutdown();
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public VaultManager getVaultManager() {
        return this.vaultManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public UpgradeMenuManager getUpgradeMenuManager() {
        return this.upgradeMenuManager;
    }

    public VaultManager getEconomy() {
        return this.vaultManager;
    }

    public EnchantManager getEnchantManager() {
        return this.enchantManager;
    }

    public RecipeMenuManager getRecipeMenuManager() {
        return this.recipeMenuManager;
    }

    public RarityMenuManager getRarityMenuManager() {
        return this.rarityMenuManager;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public TotemManager getTotemManager() {
        return this.totemManager;
    }

    public ShopMenuManager getShopMenuManager() {
        return this.shopMenuManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public TournamentManager getTournamentManager() {
        return this.tournamentManager;
    }

    public FishingManager getFishingManager() {
        return this.fishingManager;
    }

    public BoosterManager getBoosterManager() {
        return this.boosterManager;
    }

    public ConfigurationSection getMenuConfig(String menuName) {
        File menuFile = new File(this.getDataFolder(), "Menus/" + menuName + ".yml");
        if (!menuFile.exists()) {
            return null;
        }
        YamlConfiguration menuConfig = YamlConfiguration.loadConfiguration((File)menuFile);
        return menuConfig.getConfigurationSection("MrUltimateFishing." + this.capitalize(menuName));
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void createMenuFiles() {
        File shopFile;
        File totemFile;
        File recipesFile;
        File rarityCategoryFile;
        File rarityFile;
        File sellFishFile;
        File menusFolder = new File(this.getDataFolder(), "Menus");
        if (!menusFolder.exists() && !menusFolder.mkdirs()) {
            return;
        }
        File headMenuFile = new File(menusFolder, "headmenu.yml");
        if (!headMenuFile.exists()) {
            try {
                this.saveResource("Menus/headmenu.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(sellFishFile = new File(menusFolder, "sellfish.yml")).exists()) {
            try {
                this.saveResource("Menus/sellfish.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(rarityFile = new File(menusFolder, "rarity.yml")).exists()) {
            try {
                this.saveResource("Menus/rarity.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(rarityCategoryFile = new File(menusFolder, "raritycategory.yml")).exists()) {
            try {
                this.saveResource("Menus/raritycategory.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(recipesFile = new File(menusFolder, "recipes.yml")).exists()) {
            try {
                this.saveResource("Menus/recipes.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(totemFile = new File(menusFolder, "totem.yml")).exists()) {
            try {
                this.saveResource("Menus/totem.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(shopFile = new File(menusFolder, "shop.yml")).exists()) {
            try {
                this.saveResource("Menus/shop.yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadOnlinePlayersData() {
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            for (Player player : this.getServer().getOnlinePlayers()) {
                try {
                    this.playerDataManager.onPlayerJoin(player);
                    this.upgradeMenuManager.onPlayerJoin(player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 20L);
    }

    public MrCommunityQuestIntegration getCommunityQuestIntegration() {
        return this.communityQuestIntegration;
    }
}

