/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.effects;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TsunamiEffect {
    private final MrUltimateFishing plugin;
    private final Map<UUID, ActiveTsunami> activeTsunamis;
    private static final double SPAWN_RADIUS = 5.0;

    public TsunamiEffect(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.activeTsunamis = new HashMap<UUID, ActiveTsunami>();
    }

    public boolean spawnTsunami(Player player, Location location, int duration) {
        if (!this.isAboveWater(location)) {
            return false;
        }
        for (ActiveTsunami tsunami : this.activeTsunamis.values()) {
            if (!tsunami.isActive() || !tsunami.getLocation().getWorld().equals((Object)location.getWorld()) || !(tsunami.getLocation().distance(location) < 5.0)) continue;
            return false;
        }
        this.stopPlayerTsunami(player.getUniqueId());
        ActiveTsunami tsunami = new ActiveTsunami(player.getUniqueId(), location, duration);
        this.activeTsunamis.put(player.getUniqueId(), tsunami);
        tsunami.startParticleEffect();
        location.getWorld().strikeLightning(location);
        return true;
    }

    public boolean isPlayerInTsunami(Player player, Location fishingLocation) {
        ActiveTsunami tsunami = this.activeTsunamis.get(player.getUniqueId());
        if (tsunami == null || !tsunami.isActive()) {
            return false;
        }
        return tsunami.getLocation().distance(fishingLocation) <= 5.0;
    }

    private boolean isAboveWater(Location location) {
        Location below = location.clone().subtract(0.0, 1.0, 0.0);
        Material blockType = below.getBlock().getType();
        return blockType == Material.WATER;
    }

    public void cleanup() {
        this.activeTsunamis.entrySet().removeIf(entry -> {
            ActiveTsunami tsunami = (ActiveTsunami)entry.getValue();
            if (!tsunami.isActive()) {
                tsunami.stop();
                return true;
            }
            return false;
        });
    }

    public void stopPlayerTsunami(UUID playerId) {
        ActiveTsunami tsunami = this.activeTsunamis.remove(playerId);
        if (tsunami != null) {
            tsunami.stop();
        }
    }

    public void stopAllTsunamis() {
        for (ActiveTsunami tsunami : this.activeTsunamis.values()) {
            tsunami.stop();
        }
        this.activeTsunamis.clear();
    }

    public boolean hasActiveTsunamiNear(Location location, double radius) {
        for (ActiveTsunami tsunami : this.activeTsunamis.values()) {
            if (!tsunami.isActive() || !tsunami.getLocation().getWorld().equals((Object)location.getWorld()) || !(tsunami.getLocation().distance(location) < radius)) continue;
            return true;
        }
        return false;
    }

    private class ActiveTsunami {
        private final UUID playerId;
        private final Location location;
        private final long endTime;
        private BukkitTask particleTask;

        public ActiveTsunami(UUID playerId, Location location, int durationSeconds) {
            this.playerId = playerId;
            this.location = location;
            this.endTime = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        }

        public void startParticleEffect() {
            this.particleTask = new BukkitRunnable(){
                private long startTime = System.currentTimeMillis();

                public void run() {
                    long totalDuration;
                    if (!ActiveTsunami.this.isActive()) {
                        this.cancel();
                        return;
                    }
                    long elapsed = System.currentTimeMillis() - this.startTime;
                    double progress = (double)elapsed / (double)(totalDuration = ActiveTsunami.this.endTime - this.startTime);
                    double waveHeight = progress <= 0.5 ? progress * 8.0 : (1.0 - progress) * 8.0;
                    for (int ring = 0; ring < 4; ++ring) {
                        double ringRadius = 2.0 + (double)ring * 1.0;
                        int pointsInRing = 12 + ring * 4;
                        for (int i = 0; i < pointsInRing; ++i) {
                            double angle = Math.PI * 2 * (double)i / (double)pointsInRing;
                            double x = ActiveTsunami.this.location.getX() + ringRadius * Math.cos(angle);
                            double z = ActiveTsunami.this.location.getZ() + ringRadius * Math.sin(angle);
                            Location checkLocation = new Location(ActiveTsunami.this.location.getWorld(), x, ActiveTsunami.this.location.getY() - 1.0, z);
                            if (checkLocation.getBlock().getType() != Material.WATER) continue;
                            double ringHeight = waveHeight + (double)(3 - ring) * 0.3;
                            double y = ActiveTsunami.this.location.getY() + Math.max(0.1, ringHeight);
                            Location particleLocation = new Location(ActiveTsunami.this.location.getWorld(), x, y, z);
                            ActiveTsunami.this.location.getWorld().spawnParticle(Particle.DRIPPING_DRIPSTONE_WATER, particleLocation, 4, 0.1, 0.1, 0.1, 0.0);
                            ActiveTsunami.this.location.getWorld().spawnParticle(Particle.SPLASH, particleLocation, 3, 0.2, 0.2, 0.2, 0.1);
                            if (!(ringHeight < 2.0)) continue;
                            ActiveTsunami.this.location.getWorld().spawnParticle(Particle.BUBBLE_POP, particleLocation, 2, 0.1, 0.1, 0.1, 0.0);
                        }
                    }
                    Location centerLoc = new Location(ActiveTsunami.this.location.getWorld(), ActiveTsunami.this.location.getX(), ActiveTsunami.this.location.getY() + Math.max(0.1, waveHeight + 1.0), ActiveTsunami.this.location.getZ());
                    ActiveTsunami.this.location.getWorld().spawnParticle(Particle.SPLASH, centerLoc, 6, 0.5, 0.5, 0.5, 0.3);
                    ActiveTsunami.this.location.getWorld().spawnParticle(Particle.DRIPPING_DRIPSTONE_WATER, centerLoc, 8, 0.3, 0.3, 0.3, 0.0);
                }
            }.runTaskTimer((Plugin)TsunamiEffect.this.plugin, 0L, 2L);
        }

        public boolean isActive() {
            return System.currentTimeMillis() < this.endTime;
        }

        public Location getLocation() {
            return this.location;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public void stop() {
            if (this.particleTask != null && !this.particleTask.isCancelled()) {
                this.particleTask.cancel();
            }
        }
    }
}

