/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrultimatefishing.FishItem;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DeliveryMenuManager
extends BaseMenuManager {
    private final Map<UUID, Integer> currentPages = new HashMap<UUID, Integer>();
    private final Map<UUID, Inventory> openDeliveryMenus = new HashMap<UUID, Inventory>();
    private BukkitRunnable deliveryMenuRefreshTask;

    private int getBaseDeliveryTime() {
        FileConfiguration deliveryMenuConfig = this.plugin.getConfigManager().getDeliveryMenuConfig();
        return deliveryMenuConfig != null ? deliveryMenuConfig.getInt("MrUltimateFishing.Delivery.items.Upgrades.MoreTimeToDelivery.FirstLevel", 450) : 450;
    }

    private String formatTimeWithSuffixes(long seconds) {
        int length;
        if (seconds <= 0L) {
            return "0sec";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("min ");
        }
        if (secs > 0L || sb.length() == 0) {
            sb.append(secs).append("sec");
        }
        if ((length = sb.length()) > 0 && sb.charAt(length - 1) == ' ') {
            sb.setLength(length - 1);
        }
        return sb.toString();
    }

    private String formatTimeMMSS(long seconds) {
        if (seconds <= 0L) {
            return "00:00";
        }
        long minutes = seconds / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d", minutes, secs);
    }

    public DeliveryMenuManager(MrUltimateFishing plugin) {
        super(plugin);
        this.startDeliveryMenuRefreshTask();
    }

    private void startDeliveryMenuRefreshTask() {
        this.deliveryMenuRefreshTask = new BukkitRunnable(){

            public void run() {
                DeliveryMenuManager.this.refreshOpenDeliveryMenus();
            }
        };
        this.deliveryMenuRefreshTask.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private void refreshOpenDeliveryMenus() {
        HashSet<UUID> playerIds = new HashSet<UUID>(this.openDeliveryMenus.keySet());
        for (UUID playerId : playerIds) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null && player.isOnline()) {
                Integer currentPage;
                PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
                if (playerData.hasCompletedDelivery()) {
                    if (System.currentTimeMillis() >= playerData.getShipmentCompleteTime()) {
                        this.completeShipment(player);
                        continue;
                    }
                    currentPage = this.currentPages.get(playerId);
                    this.openDeliveryMenu(player, currentPage != null ? currentPage : 0, false);
                    continue;
                }
                if (!playerData.hasActiveDelivery() || playerData.isDeliveryCompleted()) continue;
                currentPage = this.currentPages.get(playerId);
                this.openDeliveryMenu(player, currentPage != null ? currentPage : 0, false);
                continue;
            }
            this.openDeliveryMenus.remove(playerId);
            this.currentPages.remove(playerId);
        }
    }

    public void refreshDeliveryMenuForPlayer(Player player) {
        if (this.openDeliveryMenus.containsKey(player.getUniqueId())) {
            Integer currentPage = this.currentPages.get(player.getUniqueId());
            this.openDeliveryMenu(player, currentPage != null ? currentPage : 0, false);
        }
    }

    public void openDeliveryMenu(Player player) {
        this.openDeliveryMenu(player, 0);
    }

    public void openDeliveryMenu(Player player, int page) {
        this.openDeliveryMenu(player, page, true);
    }

    public void openDeliveryMenu(Player player, int page, boolean addToTracking) {
        FileConfiguration config = this.plugin.getConfigManager().getDeliveryMenuConfig();
        if (config == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.menu-not-found"));
        } else {
            ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.Delivery");
            if (menuSection == null) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.menu-not-found"));
            } else {
                ConfigurationSection itemsSection;
                ConfigurationSection keysSection;
                ConfigurationSection decorationsSection;
                this.currentPages.put(player.getUniqueId(), page);
                String baseTitle = menuSection.getString("title", "{#ffde59>}&lFISHING{#ffbd59<} &8| &fDeliveries");
                String title = ColorSystem.colorize(baseTitle);
                int size = menuSection.getInt("size", 54);
                Inventory inventory = Bukkit.createInventory((InventoryHolder)null, (int)size, (String)title);
                if (addToTracking) {
                    this.openDeliveryMenus.put(player.getUniqueId(), inventory);
                }
                if ((decorationsSection = menuSection.getConfigurationSection("decorations")) != null) {
                    this.addDecorations(inventory, decorationsSection);
                }
                if ((keysSection = menuSection.getConfigurationSection("keys")) != null) {
                    this.addNavigationKeys(inventory, keysSection, player);
                }
                if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
                    this.addDeliveryItems(inventory, itemsSection, player, page);
                    this.addUpgradeItems(inventory, itemsSection.getConfigurationSection("Upgrades"), player);
                }
                player.openInventory(inventory);
            }
        }
    }

    private boolean isDeliveryMenu(String inventoryTitle) {
        if (inventoryTitle == null) {
            return false;
        }
        FileConfiguration config = this.plugin.getConfigManager().getDeliveryMenuConfig();
        if (config == null) {
            return false;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.Delivery");
        if (menuSection == null) {
            return false;
        }
        String configuredTitle = menuSection.getString("title", "{#ffde59>}&lFISHING{#ffbd59<} &8| &fDeliveries");
        String coloredConfiguredTitle = ColorSystem.colorize(configuredTitle);
        return inventoryTitle.equals(coloredConfiguredTitle);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void addDecorations(Inventory inventory, ConfigurationSection decorationsSection) {
        var3 = decorationsSection.getKeys(false).iterator();
        block0: while (true) {
            if (!var3.hasNext()) {
                return;
            }
            decorationKey = (String)var3.next();
            decoration = decorationsSection.getConfigurationSection(decorationKey);
            if (decoration == null) continue;
            materialName = decoration.getString("material", "BLACK_STAINED_GLASS_PANE");
            displayName = decoration.getString("display-name", " ");
            lore = decoration.getStringList("lore");
            glowing = decoration.getBoolean("glowing", false);
            slots = this.parseSlots(decoration.getString("slots", ""));
            item = this.createMenuItem(materialName, displayName, lore, glowing);
            var12 = slots.iterator();
            while (true) {
                if (var12.hasNext()) ** break;
                continue block0;
                slot = var12.next();
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, item);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addNavigationKeys(Inventory inventory, ConfigurationSection keysSection, Player player) {
        var4 = keysSection.getKeys(false).iterator();
        block6: while (true) {
            if (!var4.hasNext()) {
                return;
            }
            key = (String)var4.next();
            keySection = keysSection.getConfigurationSection(key);
            if (keySection == null) continue;
            type = keySection.getString("type", "");
            slots = this.parseSlots(keySection.getString("slots", ""));
            item = null;
            displayName = "";
            lore /* !! */  = new ArrayList<E>();
            var12 = type.toLowerCase();
            var13 = -1;
            switch (var12.hashCode()) {
                case 3015911: {
                    if (!var12.equals("back")) break;
                    var13 = 0;
                }
            }
            switch (var13) {
                case 0: {
                    item = new ItemStack(Material.BARRIER);
                    displayName = this.plugin.getMessageManager().getMessage("menu-keys.back.display-name", new String[]{"[prefix]", this.plugin.getMessageManager().getMessage("prefix")});
                    lore /* !! */  = this.plugin.getMessageManager().getMessagesConfig().getStringList("menu-keys.back.lore");
                }
            }
            if (item == null) continue;
            meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ColorSystem.colorize(displayName));
                coloredLore = new ArrayList<String>();
                for (String line : (List)lore /* !! */ ) {
                    coloredLore.add(ColorSystem.colorize(line));
                }
                meta.setLore(coloredLore);
                dataContainer = meta.getPersistentDataContainer();
                navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
                dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
                item.setItemMeta(meta);
            }
            var18 = slots.iterator();
            while (true) {
                if (var18.hasNext()) ** break;
                continue block6;
                slot = var18.next();
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, item);
            }
            break;
        }
    }

    private void addDeliveryItems(Inventory inventory, ConfigurationSection itemsSection, Player player, int page) {
        block10: {
            List<Integer> slots;
            ConfigurationSection deliverySection = itemsSection.getConfigurationSection("delivery");
            if (deliverySection == null || (slots = this.parseSlots(deliverySection.getString("slots", ""))).isEmpty()) break block10;
            PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
            int playerDeliverySlots = this.plugin.getPlayerDataManager().getCurrentDeliverySlots(playerData);
            FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
            if (deliveryConfig == null) {
                for (int slot : slots) {
                    if (slot < 0 || slot >= inventory.getSize()) continue;
                    ItemStack errorItem = new ItemStack(Material.BARRIER);
                    ItemMeta meta = errorItem.getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.delivery-config-not-found"));
                        errorItem.setItemMeta(meta);
                    }
                    inventory.setItem(slot, errorItem);
                }
            } else {
                boolean hasActiveDelivery = playerData.hasActiveDelivery();
                boolean hasCompletedDelivery = playerData.hasCompletedDelivery();
                int activeDeliverySlot = playerData.getActiveDeliverySlot();
                boolean firstWaitingSlotFound = false;
                for (int i = 0; i < slots.size(); ++i) {
                    ItemStack deliveryItem;
                    int slot = slots.get(i);
                    if (slot < 0 || slot >= inventory.getSize()) continue;
                    if (i >= playerDeliverySlots) {
                        deliveryItem = this.createUpgradeSlotItem(deliverySection);
                        inventory.setItem(slot, deliveryItem);
                        continue;
                    }
                    if ((hasActiveDelivery || hasCompletedDelivery) && i == activeDeliverySlot) {
                        if (hasActiveDelivery) {
                            deliveryItem = this.createActiveDeliveryItem(deliverySection, playerData);
                            inventory.setItem(slot, deliveryItem);
                            continue;
                        }
                        if (!hasCompletedDelivery) continue;
                        deliveryItem = this.createCompletedDeliveryItem(deliverySection, playerData);
                        inventory.setItem(slot, deliveryItem);
                        continue;
                    }
                    if (playerData.hasAvailableDelivery(i)) {
                        deliveryItem = this.createAvailableDeliveryItem(deliverySection, playerData, i);
                        inventory.setItem(slot, deliveryItem);
                        continue;
                    }
                    if (!firstWaitingSlotFound) {
                        deliveryItem = this.createWaitingItem(deliverySection, player, true, i);
                        inventory.setItem(slot, deliveryItem);
                        firstWaitingSlotFound = true;
                        continue;
                    }
                    deliveryItem = this.createWaitingItem(deliverySection, player, false, i);
                    inventory.setItem(slot, deliveryItem);
                }
            }
        }
    }

    private boolean hasPlayerCaughtEnoughFishes(Player player) {
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
        if (deliveryConfig == null) {
            return false;
        }
        int requiredFishes = deliveryConfig.getInt("MrUltimateFishing.Delivery.Required-Fishes-To-Get-Delivery", 0);
        int lessFishesBonus = playerData.getLessFishesToGetBonus();
        requiredFishes = Math.max(0, requiredFishes - lessFishesBonus);
        return playerData.getTotalFishCaught() >= requiredFishes;
    }

    private ItemStack createActiveDeliveryItem(ConfigurationSection deliverySection, PlayerDataManager.PlayerData playerData) {
        String processedLine;
        ConfigurationSection rewardsSection;
        String fishScales;
        List deliveryNames;
        ConfigurationSection activeSection = deliverySection.getConfigurationSection("Active");
        if (activeSection == null) {
            ItemStack errorItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = errorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.active-config-not-found"));
                errorItem.setItemMeta(meta);
            }
            return errorItem;
        }
        String materialName = activeSection.getString("material", "CHEST_MINECART");
        String displayName = activeSection.getString("display-name", "&aActive Delivery");
        List lore = activeSection.getStringList("lore");
        boolean glowing = activeSection.getBoolean("glowing", false);
        FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
        String deliveryType = playerData.getActiveDeliveryType() != null ? playerData.getActiveDeliveryType() : "COMMON";
        ConfigurationSection deliverySettings = null;
        if (deliveryConfig != null) {
            deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
        }
        int caughtFishes = playerData.getCaughtFishes();
        int requiredFishes = playerData.getRequiredFishes();
        long timeLeft = (playerData.getDeliveryCompleteTime() - System.currentTimeMillis()) / 1000L;
        this.formatTimeWithSuffixes(Math.max(0L, timeLeft));
        String deliveryName = "Unknown";
        if (deliveryConfig != null && !(deliveryNames = deliveryConfig.getStringList("MrUltimateFishing.Delivery.Delivery-Names")).isEmpty()) {
            deliveryName = (String)deliveryNames.get(0);
        }
        String shipmentTime = "Unknown";
        int shipmentTimeMinutes = playerData.getShipmentTimeMinutes();
        if (shipmentTimeMinutes > 0) {
            int lessShipmentTimeBonus = this.plugin.getPlayerDataManager().getLessShipmentTimeBonus(playerData);
            if (lessShipmentTimeBonus > 0) {
                double reductionFactor = (100.0 - (double)lessShipmentTimeBonus) / 100.0;
                shipmentTimeMinutes = (int)Math.max(1.0, (double)shipmentTimeMinutes * reductionFactor);
            }
            shipmentTime = this.formatTimeMMSS(shipmentTimeMinutes * 60);
        }
        StringBuilder fishRequirements = new StringBuilder();
        Map<String, Integer> deliveryFishRequirements = playerData.getDeliveryFishRequirements();
        if (deliveryFishRequirements != null && !deliveryFishRequirements.isEmpty()) {
            fishScales = " {#ffde59}\u27a3 &f[FishRequired]x [FishName]";
            if (deliveryConfig != null) {
                fishScales = deliveryConfig.getString("MrUltimateFishing.Delivery.FishLore", fishScales);
            }
            for (Map.Entry<String, Integer> entry : deliveryFishRequirements.entrySet()) {
                String fishLore = fishScales.replace("[FishRequired]", String.valueOf(entry.getValue())).replace("[FishName]", entry.getKey());
                fishRequirements.append(fishLore).append("\n");
            }
        }
        if (fishRequirements.length() == 0) {
            fishRequirements.append(" Unknown Requirements");
        }
        fishScales = String.valueOf(playerData.getDeliveryFishScalesReward());
        StringBuilder rewardsBuilder = new StringBuilder();
        if (deliverySettings != null && (rewardsSection = deliverySettings.getConfigurationSection("Rewards.Command-Rewards.Rewards")) != null) {
            int minRewards = deliverySettings.getInt("Rewards.Command-Rewards.Minimum", 1);
            int maxRewards = deliverySettings.getInt("Rewards.Command-Rewards.Maximum", 1);
            int rewardCount = minRewards + new Random().nextInt(maxRewards - minRewards + 1);
            int addedRewards = 0;
            for (String rewardKey : rewardsSection.getKeys(false)) {
                if (addedRewards >= rewardCount) break;
                ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardKey);
                if (rewardSection == null || (processedLine = rewardSection.getString("Text", "")).isEmpty()) continue;
                rewardsBuilder.append("").append(processedLine).append("\n");
                ++addedRewards;
            }
        }
        if (rewardsBuilder.length() == 0) {
            rewardsBuilder.append(" Unknown Rewards");
        }
        displayName = displayName.replace("[DeliveryName]", deliveryName);
        displayName = displayName.replace("[CatchFishes]", String.valueOf(caughtFishes));
        displayName = displayName.replace("[RequiredFishes]", String.valueOf(requiredFishes));
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            String rewardLine;
            line = line.replace("[DeliveryName]", deliveryName);
            line = line.replace("[CatchFishes]", String.valueOf(caughtFishes));
            line = line.replace("[RequiredFishes]", String.valueOf(requiredFishes));
            line = line.replace("[Time]", this.formatTimeMMSS(Math.max(0L, timeLeft)));
            line = line.replace("[Shipment-Time]", shipmentTime);
            if ((line = line.replace("[Fish-Scales]", fishScales)).contains("[Fish-Requiments]")) {
                String[] rewardLines;
                String[] var46 = rewardLines = fishRequirements.toString().split("\n");
                int var49 = rewardLines.length;
                for (int var50 = 0; var50 < var49; ++var50) {
                    rewardLine = var46[var50];
                    processedLine = line.replace("[Fish-Requiments]", rewardLine);
                    finalLore.add(processedLine);
                }
                continue;
            }
            if (line.contains("[Rewards]")) {
                String[] rewardLines;
                String[] var46 = rewardLines = rewardsBuilder.toString().split("\n");
                int var49 = rewardLines.length;
                for (int var50 = 0; var50 < var49; ++var50) {
                    rewardLine = var46[var50];
                    processedLine = line.replace("[Rewards]", rewardLine);
                    finalLore.add(processedLine);
                }
                continue;
            }
            line = line.replace("[Fish-Requiments]", "");
            line = line.replace("[Rewards]", "");
            finalLore.add(line);
        }
        ItemStack item = this.createMenuItem(materialName, displayName, finalLore, glowing);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey deliverySubmitKey = new NamespacedKey((Plugin)this.plugin, "delivery_submit");
            dataContainer.set(deliverySubmitKey, PersistentDataType.STRING, (Object)"active_delivery");
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createCompletedDeliveryItem(ConfigurationSection deliverySection, PlayerDataManager.PlayerData playerData) {
        String processedLine;
        ConfigurationSection rewardsSection;
        String fishScales;
        List deliveryNames;
        ConfigurationSection completedSection = deliverySection.getConfigurationSection("Shipment");
        if (completedSection == null) {
            ItemStack errorItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = errorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.completed-config-not-found"));
                errorItem.setItemMeta(meta);
            }
            return errorItem;
        }
        String materialName = completedSection.getString("material", "ENDER_CHEST");
        String displayName = completedSection.getString("display-name", "&aCompleted Delivery");
        List lore = completedSection.getStringList("lore");
        boolean glowing = completedSection.getBoolean("glowing", false);
        FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
        String deliveryType = playerData.getActiveDeliveryType() != null ? playerData.getActiveDeliveryType() : "COMMON";
        ConfigurationSection deliverySettings = null;
        if (deliveryConfig != null) {
            deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
        }
        int requiredFishes = playerData.getRequiredFishes();
        String deliveryName = "Unknown";
        if (deliveryConfig != null && !(deliveryNames = deliveryConfig.getStringList("MrUltimateFishing.Delivery.Delivery-Names")).isEmpty()) {
            deliveryName = (String)deliveryNames.get(new Random().nextInt(deliveryNames.size()));
        }
        String shipmentTime = "Unknown";
        int shipmentTimeMinutes = playerData.getShipmentTimeMinutes();
        if (shipmentTimeMinutes > 0) {
            int lessShipmentTimeBonus = this.plugin.getPlayerDataManager().getLessShipmentTimeBonus(playerData);
            if (lessShipmentTimeBonus > 0) {
                double reductionFactor = (100.0 - (double)lessShipmentTimeBonus) / 100.0;
                shipmentTimeMinutes = (int)Math.max(1.0, (double)shipmentTimeMinutes * reductionFactor);
            }
            this.formatTimeMMSS(shipmentTimeMinutes * 60);
        }
        long shipmentTimeLeft = Math.max(0L, (playerData.getShipmentCompleteTime() - System.currentTimeMillis()) / 1000L);
        String shipmentTimeRemaining = this.formatTimeMMSS(shipmentTimeLeft);
        StringBuilder fishRequirements = new StringBuilder();
        Map<String, Integer> deliveryFishRequirements = playerData.getDeliveryFishRequirements();
        if (deliveryFishRequirements != null && !deliveryFishRequirements.isEmpty()) {
            fishScales = " {#ffde59}\u27a3 &f[FishRequired]x [FishName]";
            if (deliveryConfig != null) {
                fishScales = deliveryConfig.getString("MrUltimateFishing.Delivery.FishLore", fishScales);
            }
            for (Map.Entry<String, Integer> entry : deliveryFishRequirements.entrySet()) {
                String fishLore = fishScales.replace("[FishRequired]", String.valueOf(entry.getValue())).replace("[FishName]", entry.getKey());
                fishRequirements.append(fishLore).append("\n");
            }
        }
        if (fishRequirements.length() == 0) {
            fishRequirements.append(" Unknown Requirements");
        }
        fishScales = String.valueOf(playerData.getDeliveryFishScalesReward());
        StringBuilder rewards = new StringBuilder();
        if (deliverySettings != null && (rewardsSection = deliverySettings.getConfigurationSection("Rewards.Command-Rewards.Rewards")) != null) {
            int minRewards = deliverySettings.getInt("Rewards.Command-Rewards.Minimum", 1);
            int maxRewards = deliverySettings.getInt("Rewards.Command-Rewards.Maximum", 1);
            int rewardCount = minRewards + new Random().nextInt(maxRewards - minRewards + 1);
            int addedRewards = 0;
            for (String rewardKey : rewardsSection.getKeys(false)) {
                if (addedRewards >= rewardCount) break;
                ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardKey);
                if (rewardSection == null || (processedLine = rewardSection.getString("Text", "")).isEmpty()) continue;
                rewards.append("").append(processedLine).append("\n");
                ++addedRewards;
            }
        }
        if (rewards.length() == 0) {
            rewards.append(" Unknown Rewards");
        }
        displayName = displayName.replace("[DeliveryName]", deliveryName);
        displayName = displayName.replace("[RequiredFishes]", String.valueOf(requiredFishes));
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            String rewardLine;
            line = line.replace("[DeliveryName]", deliveryName);
            line = line.replace("[RequiredFishes]", String.valueOf(requiredFishes));
            line = line.replace("[Shipment-Time]", shipmentTimeRemaining);
            if ((line = line.replace("[Fish-Scales]", fishScales)).contains("[Fish-Requiments]")) {
                String[] rewardLines;
                String[] var42 = rewardLines = fishRequirements.toString().split("\n");
                int var43 = rewardLines.length;
                for (int var44 = 0; var44 < var43; ++var44) {
                    rewardLine = var42[var44];
                    processedLine = line.replace("[Fish-Requiments]", rewardLine);
                    finalLore.add(processedLine);
                }
                continue;
            }
            if (line.contains("[Rewards]")) {
                String[] rewardLines;
                String[] var42 = rewardLines = rewards.toString().split("\n");
                int var43 = rewardLines.length;
                for (int var44 = 0; var44 < var43; ++var44) {
                    rewardLine = var42[var44];
                    processedLine = line.replace("[Rewards]", rewardLine);
                    finalLore.add(processedLine);
                }
                continue;
            }
            line = line.replace("[Fish-Requiments]", "");
            line = line.replace("[Rewards]", "");
            finalLore.add(line);
        }
        return this.createMenuItem(materialName, displayName, finalLore, glowing);
    }

    private ItemStack createAvailableDeliveryItem(ConfigurationSection deliverySection, PlayerDataManager.PlayerData playerData, int slotIndex) {
        String fishScales;
        List deliveryNames;
        ConfigurationSection availableSection = deliverySection.getConfigurationSection("Avaible");
        if (availableSection == null) {
            ItemStack errorItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = errorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.available-config-not-found"));
                errorItem.setItemMeta(meta);
            }
            return errorItem;
        }
        String materialName = availableSection.getString("material", "MINECART");
        String displayName = availableSection.getString("display-name", "&aNew Delivery Avaible!");
        List lore = availableSection.getStringList("lore");
        boolean glowing = availableSection.getBoolean("glowing", false);
        PlayerDataManager.AvailableDelivery availableDelivery = playerData.getAvailableDelivery(slotIndex);
        if (availableDelivery == null) {
            ItemStack errorItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = errorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.available-delivery-data-not-found"));
                errorItem.setItemMeta(meta);
            }
            return errorItem;
        }
        FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
        String deliveryType = availableDelivery.getDeliveryType();
        Object deliverySettings = null;
        if (deliveryConfig != null) {
            deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
        }
        String deliveryName = "Unknown";
        if (deliveryConfig != null && !(deliveryNames = deliveryConfig.getStringList("MrUltimateFishing.Delivery.Delivery-Names")).isEmpty()) {
            deliveryName = (String)deliveryNames.get(new Random().nextInt(deliveryNames.size()));
        }
        String shipmentTime = "Unknown";
        String timeString = "Unknown";
        int shipmentTimeMinutes = availableDelivery.getShipmentTimeMinutes();
        if (shipmentTimeMinutes > 0) {
            int lessShipmentTimeBonus = this.plugin.getPlayerDataManager().getLessShipmentTimeBonus(playerData);
            if (lessShipmentTimeBonus > 0) {
                double reductionFactor = (100.0 - (double)lessShipmentTimeBonus) / 100.0;
                shipmentTimeMinutes = (int)Math.max(1.0, (double)shipmentTimeMinutes * reductionFactor);
            }
            shipmentTime = this.formatTimeMMSS(shipmentTimeMinutes * 60);
            int baseDeliveryTimeSeconds = 450;
            FileConfiguration deliveryMenuConfig = this.plugin.getConfigManager().getDeliveryMenuConfig();
            if (deliveryMenuConfig != null) {
                baseDeliveryTimeSeconds = deliveryMenuConfig.getInt("MrUltimateFishing.Delivery.items.Upgrades.MoreTimeToDelivery.FirstLevel", 450);
            }
            int moreTimeBonus = this.plugin.getPlayerDataManager().getMoreTimeToDeliveryBonus(playerData);
            int totalDeliveryTimeSeconds = baseDeliveryTimeSeconds + moreTimeBonus;
            timeString = this.formatTimeMMSS(totalDeliveryTimeSeconds);
        }
        StringBuilder fishRequirements = new StringBuilder();
        Map<String, Integer> deliveryFishRequirements = availableDelivery.getFishRequirements();
        if (deliveryFishRequirements != null && !deliveryFishRequirements.isEmpty()) {
            fishScales = " {#ffde59}\u27a3 &f[FishRequired]x [FishName]";
            if (deliveryConfig != null) {
                fishScales = deliveryConfig.getString("MrUltimateFishing.Delivery.FishLore", fishScales);
            }
            for (Map.Entry<String, Integer> entry : deliveryFishRequirements.entrySet()) {
                String fishLore = fishScales.replace("[FishRequired]", String.valueOf(entry.getValue())).replace("[FishName]", entry.getKey());
                fishRequirements.append(fishLore).append("\n");
            }
        }
        if (fishRequirements.length() == 0) {
            fishRequirements.append(" Unknown Requirements");
        }
        fishScales = String.valueOf(availableDelivery.getFishScalesReward());
        StringBuilder rewardsBuilder = new StringBuilder();
        List<String> commandRewards = availableDelivery.getCommandRewards();
        if (commandRewards != null && !commandRewards.isEmpty()) {
            for (String rewardText : commandRewards) {
                rewardsBuilder.append("").append(rewardText).append("\n");
            }
        }
        if (rewardsBuilder.length() == 0) {
            rewardsBuilder.append(" Unknown Rewards");
        }
        displayName = displayName.replace("[DeliveryName]", deliveryName);
        displayName = displayName.replace("[DeliveryType]", deliveryType);
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            String processedLine;
            String rewardLine;
            int var28;
            int var27;
            String[] var26;
            String[] rewardLines;
            line = line.replace("[DeliveryName]", deliveryName);
            line = line.replace("[DeliveryType]", deliveryType);
            line = line.replace("[Time]", timeString);
            line = line.replace("[Shipment-Time]", shipmentTime);
            if ((line = line.replace("[Fish-Scales]", fishScales)).contains("[Fish-Requiments]")) {
                var26 = rewardLines = fishRequirements.toString().split("\n");
                var27 = rewardLines.length;
                for (var28 = 0; var28 < var27; ++var28) {
                    rewardLine = var26[var28];
                    processedLine = line.replace("[Fish-Requiments]", rewardLine);
                    finalLore.add(processedLine);
                }
                continue;
            }
            if (line.contains("[Rewards]")) {
                var26 = rewardLines = rewardsBuilder.toString().split("\n");
                var27 = rewardLines.length;
                for (var28 = 0; var28 < var27; ++var28) {
                    rewardLine = var26[var28];
                    processedLine = line.replace("[Rewards]", rewardLine);
                    finalLore.add(processedLine);
                }
                continue;
            }
            line = line.replace("[Fish-Requiments]", "");
            line = line.replace("[Rewards]", "");
            finalLore.add(line);
        }
        ItemStack item = this.createMenuItem(materialName, displayName, finalLore, glowing);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey deliveryTypeKey = new NamespacedKey((Plugin)this.plugin, "delivery_type");
            dataContainer.set(deliveryTypeKey, PersistentDataType.STRING, (Object)"available_delivery");
            NamespacedKey deliverySlotKey = new NamespacedKey((Plugin)this.plugin, "delivery_slot");
            dataContainer.set(deliverySlotKey, PersistentDataType.INTEGER, (Object)slotIndex);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createWaitingItem(ConfigurationSection deliverySection, Player player, boolean isActiveFilling) {
        return this.createWaitingItem(deliverySection, player, isActiveFilling, 0);
    }

    private ItemStack createWaitingItem(ConfigurationSection deliverySection, Player player, boolean isActiveFilling, int slotIndex) {
        List deliveryNames;
        ConfigurationSection waitingSection = deliverySection.getConfigurationSection("Waiting");
        if (waitingSection == null) {
            ItemStack errorItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = errorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.waiting-config-not-found"));
                errorItem.setItemMeta(meta);
            }
            return errorItem;
        }
        String materialName = waitingSection.getString("material", "HOPPER_MINECART");
        String displayName = waitingSection.getString("display-name", "&cDelivery will arrive after fulfillment");
        List lore = waitingSection.getStringList("lore");
        boolean glowing = waitingSection.getBoolean("glowing", false);
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
        String deliveryType = "COMMON";
        Object deliverySettings = null;
        if (deliveryConfig != null) {
            deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
        }
        int requiredFishesToGetDelivery = 80;
        if (deliveryConfig != null) {
            requiredFishesToGetDelivery = deliveryConfig.getInt("MrUltimateFishing.Delivery.Required-Fishes-To-Get-Delivery", 80);
        }
        int lessFishesBonus = playerData.getLessFishesToGetBonus();
        requiredFishesToGetDelivery = Math.max(0, requiredFishesToGetDelivery - lessFishesBonus);
        int currentProgress = playerData.getWaitingDeliveryProgress(slotIndex);
        int fishNeeded = Math.max(0, requiredFishesToGetDelivery - currentProgress);
        String deliveryName = "Unknown";
        if (deliveryConfig != null && !(deliveryNames = deliveryConfig.getStringList("MrUltimateFishing.Delivery.Delivery-Names")).isEmpty()) {
            deliveryName = (String)deliveryNames.get(0);
        }
        displayName = displayName.replace("[DeliveryName]", deliveryName);
        displayName = displayName.replace("[RequiredFishes]", String.valueOf(requiredFishesToGetDelivery));
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            line = line.replace("[DeliveryName]", deliveryName);
            line = line.replace("[RequiredFishes]", String.valueOf(requiredFishesToGetDelivery));
            line = line.replace("[FishNeeded]", String.valueOf(fishNeeded));
            finalLore.add(line);
        }
        ItemStack item = this.createMenuItem(materialName, displayName, finalLore, glowing);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey deliveryTypeKey = new NamespacedKey((Plugin)this.plugin, "delivery_type");
            dataContainer.set(deliveryTypeKey, PersistentDataType.STRING, (Object)"waiting_delivery");
            NamespacedKey deliverySlotKey = new NamespacedKey((Plugin)this.plugin, "delivery_slot");
            dataContainer.set(deliverySlotKey, PersistentDataType.INTEGER, (Object)slotIndex);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createUpgradeSlotItem(ConfigurationSection deliverySection) {
        ConfigurationSection upgradeSlotSection = deliverySection.getConfigurationSection("UpgradeSlot");
        if (upgradeSlotSection == null) {
            ItemStack errorItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = errorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getMessageManager().getMessage("delivery.upgradeslot-config-not-found"));
                errorItem.setItemMeta(meta);
            }
            return errorItem;
        }
        String materialName = upgradeSlotSection.getString("material", "IRON_BARS");
        String displayName = upgradeSlotSection.getString("display-name", "&cNot Avaible (Please Upgrade Slots)");
        List lore = upgradeSlotSection.getStringList("lore");
        boolean glowing = upgradeSlotSection.getBoolean("glowing", false);
        return this.createMenuItem(materialName, displayName, lore, glowing);
    }

    private String selectRandomDeliveryType(Player player) {
        Map.Entry entry;
        FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
        if (deliveryConfig == null) {
            return "COMMON";
        }
        ConfigurationSection deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings");
        if (deliverySettings == null) {
            return "COMMON";
        }
        double totalChance = 0.0;
        HashMap<String, Double> deliveryChances = new HashMap<String, Double>();
        for (String deliveryType : deliverySettings.getKeys(false)) {
            double chance;
            ConfigurationSection typeSection = deliverySettings.getConfigurationSection(deliveryType);
            if (typeSection == null || !((chance = typeSection.getDouble("Chance-To-This-Delivery", 0.0)) > 0.0)) continue;
            deliveryChances.put(deliveryType, chance);
            totalChance += chance;
        }
        if (totalChance <= 0.0) {
            return "COMMON";
        }
        double randomValue = new Random().nextDouble() * totalChance;
        double currentChance = 0.0;
        Iterator var11 = deliveryChances.entrySet().iterator();
        do {
            if (var11.hasNext()) continue;
            return (String)deliveryChances.keySet().iterator().next();
        } while (randomValue > (currentChance += ((Double)(entry = var11.next()).getValue()).doubleValue()));
        return (String)entry.getKey();
    }

    /*
     * Unable to fully structure code
     */
    private void addUpgradeItems(Inventory inventory, ConfigurationSection upgradesSection, Player player) {
        if (upgradesSection != null) {
            playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
            var5 = upgradesSection.getKeys(false).iterator();
            block0: while (true) {
                if (!var5.hasNext()) {
                    return;
                }
                upgradeKey = (String)var5.next();
                upgradeSection = upgradesSection.getConfigurationSection(upgradeKey);
                if (upgradeSection == null || (itemSection = upgradeSection.getConfigurationSection("Item")) == null || (slots = this.parseSlots(itemSection.getString("slots", ""))).isEmpty()) continue;
                materialName = itemSection.getString("material", "PAPER");
                displayName = itemSection.getString("display-name", "&fUpgrade");
                lore = itemSection.getStringList("lore");
                glowing = itemSection.getBoolean("glowing", false);
                currentLevel = this.getCurrentUpgradeLevel(playerData, upgradeKey);
                displayName = displayName.replace("[Price]", String.valueOf(upgradeSection.getLong("PriceforUpgrade", 0L)));
                displayName = displayName.replace("[CurrentLevel]", String.valueOf(currentLevel));
                displayName = displayName.replace("[MaxLevels]", String.valueOf(upgradeSection.getInt("MaxUpgradeLevel", 0)));
                displayName = displayName.replace("[CurrentBonus]", this.getUpgradeBonus(upgradeKey, currentLevel));
                finalLore = new ArrayList<String>();
                for (String line : lore) {
                    line = line.replace("[Price]", String.valueOf(upgradeSection.getLong("PriceforUpgrade", 0L)));
                    line = line.replace("[CurrentLevel]", String.valueOf(currentLevel));
                    line = line.replace("[MaxLevels]", String.valueOf(upgradeSection.getInt("MaxUpgradeLevel", 0)));
                    line = line.replace("[CurrentBonus]", this.getUpgradeBonus(upgradeKey, currentLevel));
                    finalLore.add(line);
                }
                item = this.createMenuItem(materialName, displayName, finalLore, glowing);
                meta = item.getItemMeta();
                if (meta != null) {
                    dataContainer = meta.getPersistentDataContainer();
                    upgradeTypeKey = new NamespacedKey((Plugin)this.plugin, "delivery_upgrade");
                    dataContainer.set(upgradeTypeKey, PersistentDataType.STRING, (Object)upgradeKey);
                    item.setItemMeta(meta);
                }
                var21 = slots.iterator();
                while (true) {
                    if (var21.hasNext()) ** break;
                    continue block0;
                    slot = var21.next();
                    if (slot < 0 || slot >= inventory.getSize()) continue;
                    inventory.setItem(slot, item);
                }
                break;
            }
        }
    }

    private int getCurrentUpgradeLevel(PlayerDataManager.PlayerData playerData, String upgradeKey) {
        int var4 = -1;
        switch (upgradeKey.hashCode()) {
            case -1675329263: {
                if (!upgradeKey.equals("MoreTimeToDelivery")) break;
                var4 = 3;
                break;
            }
            case -303925280: {
                if (!upgradeKey.equals("LessShipmentTime")) break;
                var4 = 4;
                break;
            }
            case 174728196: {
                if (!upgradeKey.equals("LessFishesC")) break;
                var4 = 1;
                break;
            }
            case 174728197: {
                if (!upgradeKey.equals("LessFishesD")) break;
                var4 = 2;
                break;
            }
            case 1022049511: {
                if (!upgradeKey.equals("MoreDeliveries")) break;
                var4 = 0;
            }
        }
        switch (var4) {
            case 0: {
                return playerData.getDeliverySlotsLevel();
            }
            case 1: {
                return playerData.getLessFishesToCompleteLevel();
            }
            case 2: {
                return playerData.getLessFishesToGetLevel();
            }
            case 3: {
                return playerData.getMoreTimeToDeliveryLevel();
            }
            case 4: {
                return playerData.getLessShipmentTimeLevel();
            }
        }
        return 0;
    }

    private String getUpgradeBonus(String upgradeKey, int currentLevel) {
        FileConfiguration deliveryMenuConfig = this.plugin.getConfigManager().getDeliveryMenuConfig();
        if (deliveryMenuConfig == null) {
            return this.getHardcodedUpgradeBonus(upgradeKey, currentLevel);
        }
        ConfigurationSection upgradesSection = deliveryMenuConfig.getConfigurationSection("MrUltimateFishing.Delivery.items.Upgrades");
        if (upgradesSection == null) {
            return this.getHardcodedUpgradeBonus(upgradeKey, currentLevel);
        }
        ConfigurationSection upgradeSection = upgradesSection.getConfigurationSection(upgradeKey);
        if (upgradeSection == null) {
            return this.getHardcodedUpgradeBonus(upgradeKey, currentLevel);
        }
        int var7 = -1;
        switch (upgradeKey.hashCode()) {
            case -1675329263: {
                if (!upgradeKey.equals("MoreTimeToDelivery")) break;
                var7 = 3;
                break;
            }
            case -303925280: {
                if (!upgradeKey.equals("LessShipmentTime")) break;
                var7 = 4;
                break;
            }
            case 174728196: {
                if (!upgradeKey.equals("LessFishesC")) break;
                var7 = 1;
                break;
            }
            case 174728197: {
                if (!upgradeKey.equals("LessFishesD")) break;
                var7 = 2;
                break;
            }
            case 1022049511: {
                if (!upgradeKey.equals("MoreDeliveries")) break;
                var7 = 0;
            }
        }
        switch (var7) {
            case 0: {
                int firstLevel = upgradeSection.getInt("FirstLevel", 1);
                int forUpgradeGet = upgradeSection.getInt("ForUpgradeGet", 1);
                return String.valueOf(firstLevel + currentLevel * forUpgradeGet);
            }
            case 1: 
            case 2: {
                int fishReduction = upgradeSection.getInt("ForUpgradeGet", 1);
                return String.valueOf(currentLevel * fishReduction);
            }
            case 3: {
                int timeBonus = upgradeSection.getInt("ForUpgradeGet", 80);
                return String.valueOf(currentLevel * timeBonus);
            }
            case 4: {
                int timeReduction = upgradeSection.getInt("ForUpgradeGet", 2);
                return String.valueOf(currentLevel * timeReduction);
            }
        }
        return "0";
    }

    private String getHardcodedUpgradeBonus(String upgradeKey, int currentLevel) {
        int var4 = -1;
        switch (upgradeKey.hashCode()) {
            case -1675329263: {
                if (!upgradeKey.equals("MoreTimeToDelivery")) break;
                var4 = 3;
                break;
            }
            case -303925280: {
                if (!upgradeKey.equals("LessShipmentTime")) break;
                var4 = 4;
                break;
            }
            case 174728196: {
                if (!upgradeKey.equals("LessFishesC")) break;
                var4 = 1;
                break;
            }
            case 174728197: {
                if (!upgradeKey.equals("LessFishesD")) break;
                var4 = 2;
                break;
            }
            case 1022049511: {
                if (!upgradeKey.equals("MoreDeliveries")) break;
                var4 = 0;
            }
        }
        switch (var4) {
            case 0: {
                return String.valueOf(1 + currentLevel);
            }
            case 1: 
            case 2: {
                return String.valueOf(currentLevel);
            }
            case 3: {
                return String.valueOf(currentLevel * 80);
            }
            case 4: {
                return String.valueOf(currentLevel * 2);
            }
        }
        return "0";
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        String inventoryTitle = event.getView().getTitle();
        if (!this.isDeliveryMenu(inventoryTitle)) {
            return false;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && clickedItem.hasItemMeta()) {
            String deliverySubmit;
            NamespacedKey navigationKey;
            ItemMeta meta = clickedItem.getItemMeta();
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            if (dataContainer.has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
                String navigation = (String)dataContainer.get(navigationKey, PersistentDataType.STRING);
                this.handleNavigation(player, navigation);
                return true;
            }
            NamespacedKey upgradeKey = new NamespacedKey((Plugin)this.plugin, "delivery_upgrade");
            if (dataContainer.has(upgradeKey, PersistentDataType.STRING)) {
                String upgradeType = (String)dataContainer.get(upgradeKey, PersistentDataType.STRING);
                this.handleUpgradeClick(player, upgradeType, event.getClick());
                return true;
            }
            NamespacedKey deliveryTypeKey = new NamespacedKey((Plugin)this.plugin, "delivery_type");
            if (dataContainer.has(deliveryTypeKey, PersistentDataType.STRING)) {
                String deliveryType = (String)dataContainer.get(deliveryTypeKey, PersistentDataType.STRING);
                NamespacedKey deliverySlotKey = new NamespacedKey((Plugin)this.plugin, "delivery_slot");
                int slotIndex = 0;
                if (dataContainer.has(deliverySlotKey, PersistentDataType.INTEGER)) {
                    slotIndex = (Integer)dataContainer.get(deliverySlotKey, PersistentDataType.INTEGER);
                }
                this.handleDeliveryAcceptance(player, slotIndex, event.getClick());
                return true;
            }
            NamespacedKey deliverySubmitKey = new NamespacedKey((Plugin)this.plugin, "delivery_submit");
            if (dataContainer.has(deliverySubmitKey, PersistentDataType.STRING) && "active_delivery".equals(deliverySubmit = (String)dataContainer.get(deliverySubmitKey, PersistentDataType.STRING)) && event.getClick().isLeftClick()) {
                this.handleDeliverySubmission(player);
                return true;
            }
            return true;
        }
        return true;
    }

    private void handleUpgradeClick(Player player, String upgradeType, ClickType clickType) {
        FileConfiguration deliveryMenuConfig = this.plugin.getConfigManager().getDeliveryMenuConfig();
        if (deliveryMenuConfig == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.menu-not-found"));
        } else {
            ConfigurationSection upgradesSection = deliveryMenuConfig.getConfigurationSection("MrUltimateFishing.Delivery.items.Upgrades");
            if (upgradesSection == null) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.menu-not-found"));
            } else {
                ConfigurationSection upgradeSection = upgradesSection.getConfigurationSection(upgradeType);
                if (upgradeSection == null) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.menu-not-found"));
                } else {
                    int maxLevel;
                    PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
                    int currentLevel = this.getCurrentUpgradeLevel(playerData, upgradeType);
                    if (currentLevel >= (maxLevel = upgradeSection.getInt("MaxUpgradeLevel", 0))) {
                        player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.upgrade-max-level"));
                    } else {
                        int price = upgradeSection.getInt("PriceforUpgrade", 10000);
                        if (playerData.getFishScale() < price) {
                            String message = this.plugin.getMessageManager().getMessage("delivery.upgrade-insufficient-scales").replace("[scales]", String.valueOf(price));
                            player.sendMessage(ColorSystem.colorize(message));
                        } else {
                            playerData.setFishScale(playerData.getFishScale() - price);
                            this.applyUpgrade(playerData, upgradeType);
                            this.plugin.getPlayerDataManager().savePlayerData(player);
                            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.upgrade-purchased"));
                            if ("LessShipmentTime".equals(upgradeType)) {
                                int lessShipmentTimeBonus = this.plugin.getPlayerDataManager().getLessShipmentTimeBonus(playerData);
                                String message = this.plugin.getMessageManager().getMessage("delivery.shipment-time-reduced").replace("[reduction]", String.valueOf(lessShipmentTimeBonus));
                                player.sendMessage(ColorSystem.colorize(message));
                            }
                            player.closeInventory();
                            this.openDeliveryMenu(player);
                        }
                    }
                }
            }
        }
    }

    private void applyUpgrade(PlayerDataManager.PlayerData playerData, String upgradeType) {
        int var4 = -1;
        switch (upgradeType.hashCode()) {
            case -1675329263: {
                if (!upgradeType.equals("MoreTimeToDelivery")) break;
                var4 = 3;
                break;
            }
            case -303925280: {
                if (!upgradeType.equals("LessShipmentTime")) break;
                var4 = 4;
                break;
            }
            case 174728196: {
                if (!upgradeType.equals("LessFishesC")) break;
                var4 = 1;
                break;
            }
            case 174728197: {
                if (!upgradeType.equals("LessFishesD")) break;
                var4 = 2;
                break;
            }
            case 1022049511: {
                if (!upgradeType.equals("MoreDeliveries")) break;
                var4 = 0;
            }
        }
        switch (var4) {
            case 0: {
                playerData.setDeliverySlotsLevel(playerData.getDeliverySlotsLevel() + 1);
                break;
            }
            case 1: {
                playerData.setLessFishesToCompleteLevel(playerData.getLessFishesToCompleteLevel() + 1);
                break;
            }
            case 2: {
                playerData.setLessFishesToGetLevel(playerData.getLessFishesToGetLevel() + 1);
                break;
            }
            case 3: {
                playerData.setMoreTimeToDeliveryLevel(playerData.getMoreTimeToDeliveryLevel() + 1);
                break;
            }
            case 4: {
                playerData.setLessShipmentTimeLevel(playerData.getLessShipmentTimeLevel() + 1);
                int n = this.plugin.getPlayerDataManager().getLessShipmentTimeBonus(playerData);
            }
        }
    }

    private void handleNavigation(Player player, String navigation) {
        switch (navigation.toLowerCase()) {
            case "back": {
                player.closeInventory();
                this.plugin.getMenuManager().openHeadMenu(player);
            }
        }
    }

    public void handleInventoryClose(InventoryCloseEvent event) {
        String inventoryTitle;
        if (event.getPlayer() instanceof Player && this.isDeliveryMenu(inventoryTitle = event.getView().getTitle())) {
            Player player = (Player)event.getPlayer();
            this.openDeliveryMenus.remove(player.getUniqueId());
            this.cleanupPlayerData(player);
        }
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        String inventoryTitle = event.getView().getTitle();
        if (!this.isDeliveryMenu(inventoryTitle)) {
            return false;
        }
        event.setCancelled(true);
        return true;
    }

    public void cleanupPlayerData(Player player) {
        this.currentPages.remove(player.getUniqueId());
    }

    private void handleDeliveryAcceptance(Player player, int slotIndex, ClickType clickType) {
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (!playerData.hasAvailableDelivery(slotIndex)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.no-available-delivery-for-slot"));
        } else {
            if (clickType.isLeftClick()) {
                this.createDeliveryForPlayer(player, slotIndex);
            } else if (clickType.isRightClick()) {
                playerData.setAvailableDelivery(slotIndex, null);
                playerData.setWaitingDeliveryProgress(slotIndex, 0);
                this.plugin.getPlayerDataManager().savePlayerData(player);
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.delivery-rejected-for-slot", "[slot]", String.valueOf(slotIndex + 1)));
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.delivery-rejected-slot-waiting"));
            }
            Integer currentPage = this.currentPages.get(player.getUniqueId());
            this.openDeliveryMenu(player, currentPage != null ? currentPage : 0);
        }
    }

    private void createDeliveryForPlayer(Player player, String deliveryType) {
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (playerData.hasActiveDelivery()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.already-have-active-delivery"));
        } else {
            FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
            if (deliveryConfig == null) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.config-not-found"));
            } else {
                ConfigurationSection deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
                if (deliverySettings == null) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.delivery-settings-not-found-type", "[deliveryType]", deliveryType));
                } else {
                    String randomFishId;
                    List<String> fishIds;
                    int minFishes = deliverySettings.getInt("Required-Fishes.Required-Fishes.Minimum", 10);
                    int maxFishes = deliverySettings.getInt("Required-Fishes.Required-Fishes.Maximum", 25);
                    int requiredFishes = minFishes + new Random().nextInt(maxFishes - minFishes + 1);
                    int lessFishesBonus = playerData.getLessFishesToCompleteBonus();
                    requiredFishes = Math.max(1, requiredFishes - lessFishesBonus);
                    int baseDeliveryTimeSeconds = this.getBaseDeliveryTime();
                    int moreTimeBonus = this.plugin.getPlayerDataManager().getMoreTimeToDeliveryBonus(playerData);
                    int totalDeliveryTimeSeconds = baseDeliveryTimeSeconds + moreTimeBonus;
                    int minFishScales = deliverySettings.getInt("Rewards.FishScales.Minimum", 1000);
                    int maxFishScales = deliverySettings.getInt("Rewards.FishScales.Maximum", 5000);
                    int fishScalesReward = minFishScales + new Random().nextInt(maxFishScales - minFishScales + 1);
                    HashMap<String, Integer> fishRequirements = new HashMap<String, Integer>();
                    ConfigurationSection raritySection = deliverySettings.getConfigurationSection("Required-Fishes.CanPickFishesFromRarity");
                    if (raritySection != null) {
                        for (String rarity : raritySection.getKeys(false)) {
                            ConfigurationSection raritySettings = raritySection.getConfigurationSection(rarity);
                            if (raritySettings == null || !raritySettings.getBoolean("Enabled", false) || (fishIds = this.plugin.getConfigManager().getFishIdsByRarity(rarity)).isEmpty()) continue;
                            randomFishId = fishIds.get(new Random().nextInt(fishIds.size()));
                            String fishName = this.plugin.getConfigManager().getFishDisplayName(randomFishId);
                            if (fishName == null || fishName.isEmpty()) {
                                fishName = "Unknown Fish";
                            }
                            int percentage = raritySettings.getInt("Percentage", 0);
                            int fishCount = Math.max(1, requiredFishes * percentage / 100);
                            fishRequirements.put(fishName, fishCount);
                        }
                    }
                    ArrayList<String> commandRewards = new ArrayList<String>();
                    ConfigurationSection rewardsSection = deliverySettings.getConfigurationSection("Rewards.Command-Rewards.Rewards");
                    if (rewardsSection != null) {
                        int shipmentTimeMinutes = deliverySettings.getInt("Rewards.Command-Rewards.Minimum", 1);
                        int maxRewards = deliverySettings.getInt("Rewards.Command-Rewards.Maximum", 1);
                        int rewardCount = shipmentTimeMinutes + new Random().nextInt(maxRewards - shipmentTimeMinutes + 1);
                        int addedRewards = 0;
                        ArrayList rewardKeys = new ArrayList(rewardsSection.getKeys(false));
                        Collections.shuffle(rewardKeys);
                        for (String rewardKey : rewardKeys) {
                            String rewardText;
                            if (addedRewards >= rewardCount) break;
                            ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardKey);
                            if (rewardSection == null || (rewardText = rewardSection.getString("Text", "")).isEmpty()) continue;
                            commandRewards.add(rewardText);
                            ++addedRewards;
                        }
                    }
                    int shipmentTimeMinutes = 30;
                    fishIds = deliverySettings.getStringList("Shipment-Times");
                    if (!fishIds.isEmpty()) {
                        shipmentTimeMinutes = Integer.parseInt((String)fishIds.get(new Random().nextInt(fishIds.size())));
                    }
                    playerData.setActiveDeliveryType(deliveryType);
                    playerData.setRequiredFishes(requiredFishes);
                    playerData.setCaughtFishes(0);
                    playerData.setDeliveryStartTime(System.currentTimeMillis());
                    playerData.setDeliveryCompleteTime(System.currentTimeMillis() + (long)totalDeliveryTimeSeconds * 1000L);
                    playerData.setDeliveryCompleted(false);
                    playerData.setDeliveryFishScalesReward(fishScalesReward);
                    playerData.setDeliveryFishRequirements(fishRequirements);
                    playerData.setShipmentTimeMinutes(shipmentTimeMinutes);
                    playerData.setActiveDeliverySlot(0);
                    this.plugin.getPlayerDataManager().savePlayerData(player);
                    randomFishId = this.plugin.getMessageManager().getMessage("delivery.selected").replace("[index]", deliveryType).replace("[fishes]", String.valueOf(requiredFishes)).replace("[time]", this.formatTimeWithSuffixes(totalDeliveryTimeSeconds));
                    player.sendMessage(ColorSystem.colorize(randomFishId));
                }
            }
        }
    }

    private void createDeliveryForPlayer(Player player, int slotIndex) {
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (playerData.hasActiveDelivery()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.already-have-active-delivery"));
        } else {
            PlayerDataManager.AvailableDelivery availableDelivery = playerData.getAvailableDelivery(slotIndex);
            if (availableDelivery == null) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.no-available-delivery-for-slot", "[slot]", String.valueOf(slotIndex + 1)));
            } else {
                playerData.setActiveDeliveryType(availableDelivery.getDeliveryType());
                playerData.setRequiredFishes(availableDelivery.getRequiredFishes());
                playerData.setCaughtFishes(0);
                int baseDeliveryTimeSeconds = this.getBaseDeliveryTime();
                int moreTimeBonus = this.plugin.getPlayerDataManager().getMoreTimeToDeliveryBonus(playerData);
                int totalDeliveryTimeSeconds = baseDeliveryTimeSeconds + moreTimeBonus;
                playerData.setDeliveryStartTime(System.currentTimeMillis());
                playerData.setDeliveryCompleteTime(System.currentTimeMillis() + (long)totalDeliveryTimeSeconds * 1000L);
                playerData.setDeliveryCompleted(false);
                playerData.setDeliveryFishScalesReward(availableDelivery.getFishScalesReward());
                playerData.setDeliveryFishRequirements(availableDelivery.getFishRequirements());
                playerData.setShipmentTimeMinutes(availableDelivery.getShipmentTimeMinutes());
                playerData.setActiveDeliverySlot(slotIndex);
                playerData.setAvailableDelivery(slotIndex, null);
                playerData.setWaitingDeliveryProgress(slotIndex, 0);
                this.plugin.getPlayerDataManager().savePlayerData(player);
                String message = this.plugin.getMessageManager().getMessage("delivery.selected").replace("[index]", availableDelivery.getDeliveryType()).replace("[fishes]", String.valueOf(availableDelivery.getRequiredFishes())).replace("[time]", this.formatTimeWithSuffixes(totalDeliveryTimeSeconds));
                player.sendMessage(ColorSystem.colorize(message));
            }
        }
    }

    private void completeShipment(Player player) {
        ConfigurationSection rewardsSection;
        ConfigurationSection deliverySettings;
        FileConfiguration deliveryConfig;
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        int fishScalesReward = playerData.getDeliveryFishScalesReward();
        playerData.setFishScale(playerData.getFishScale() + fishScalesReward);
        ArrayList<String> commandRewards = new ArrayList<String>();
        String deliveryType = playerData.getActiveDeliveryType();
        if (deliveryType != null && (deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig()) != null && (deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType)) != null && (rewardsSection = deliverySettings.getConfigurationSection("Rewards.Command-Rewards.Rewards")) != null) {
            int minRewards = deliverySettings.getInt("Rewards.Command-Rewards.Minimum", 1);
            int maxRewards = deliverySettings.getInt("Rewards.Command-Rewards.Maximum", 1);
            int rewardCount = minRewards + new Random().nextInt(maxRewards - minRewards + 1);
            int addedRewards = 0;
            ArrayList rewardKeys = new ArrayList(rewardsSection.getKeys(false));
            Collections.shuffle(rewardKeys);
            for (String rewardKey : rewardKeys) {
                String rewardCommand;
                if (addedRewards >= rewardCount) break;
                ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardKey);
                if (rewardSection == null || (rewardCommand = rewardSection.getString("Command", "")).isEmpty()) continue;
                commandRewards.add(rewardCommand);
                ++addedRewards;
            }
        }
        for (String command : commandRewards) {
            command = command.replace("[player]", player.getName());
            command = command.replace("[PlayerName]", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        playerData.setActiveDeliveryType(null);
        playerData.setRequiredFishes(0);
        playerData.setCaughtFishes(0);
        playerData.setDeliveryStartTime(0L);
        playerData.setDeliveryCompleteTime(0L);
        playerData.setDeliveryCompleted(false);
        playerData.setShipmentCompleteTime(0L);
        playerData.setDeliveryFishScalesReward(0);
        playerData.setDeliveryFishRequirements(new HashMap<String, Integer>());
        playerData.setShipmentTimeMinutes(0);
        playerData.setActiveDeliverySlot(-1);
        this.plugin.getPlayerDataManager().savePlayerData(player);
        player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.shipment-arrived-completed"));
        Integer currentPage = this.currentPages.get(player.getUniqueId());
        this.openDeliveryMenu(player, currentPage != null ? currentPage : 0);
    }

    private void handleDeliverySubmission(Player player) {
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (!playerData.hasActiveDelivery()) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.no-active-delivery-to-submit-message"));
        } else {
            FileConfiguration deliveryConfig = this.plugin.getConfigManager().getDeliveryConfig();
            if (deliveryConfig == null) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.config-not-found"));
            } else {
                String deliveryType = playerData.getActiveDeliveryType();
                ConfigurationSection deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
                if (deliverySettings == null) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.delivery-settings-not-found-type", "[deliveryType]", deliveryType));
                } else {
                    Map<String, Integer> deliveryFishRequirements = playerData.getDeliveryFishRequirements();
                    if (deliveryFishRequirements != null && !deliveryFishRequirements.isEmpty()) {
                        int lessShipmentTimeBonus;
                        HashMap<String, String> fishNameToIdMap = new HashMap<String, String>();
                        Set<String> allFishIds = this.plugin.getConfigManager().getAllFishIds();
                        if (allFishIds != null) {
                            for (String fishId : allFishIds) {
                                String fishName = this.plugin.getConfigManager().getFishDisplayName(fishId);
                                if (fishName == null || fishName.isEmpty()) continue;
                                fishNameToIdMap.put(fishName, fishId);
                            }
                        }
                        HashMap<String, Integer> playerFishCounts = new HashMap<String, Integer>();
                        for (ItemStack item : player.getInventory().getContents()) {
                            String fishDisplayName;
                            String fishId2;
                            if (item == null || !FishItem.isCustomFish(item) || (fishId2 = FishItem.getFishId(item)) == null || (fishDisplayName = this.plugin.getConfigManager().getFishDisplayName(fishId2)) == null) continue;
                            playerFishCounts.put(fishDisplayName, playerFishCounts.getOrDefault(fishDisplayName, 0) + item.getAmount());
                        }
                        for (Map.Entry<String, Integer> requirement : deliveryFishRequirements.entrySet()) {
                            String requiredFishName = requirement.getKey();
                            int requiredCount = requirement.getValue();
                            int shipmentTimeMinutes = playerFishCounts.getOrDefault(requiredFishName, 0);
                            if (shipmentTimeMinutes >= requiredCount) continue;
                            String fishId = this.plugin.getMessageManager().getMessage("delivery.not-enough-fish").replace("[fish]", requiredFishName).replace("[required]", String.valueOf(requiredCount)).replace("[have]", String.valueOf(shipmentTimeMinutes));
                            player.sendMessage(ColorSystem.colorize(fishId));
                            return;
                        }
                        HashMap<String, Integer> fishToRemove = new HashMap<String, Integer>(deliveryFishRequirements);
                        for (ItemStack item : player.getInventory().getContents()) {
                            String fishName;
                            String fishId;
                            if (item == null || !FishItem.isCustomFish(item) || (fishId = FishItem.getFishId(item)) == null || (fishName = this.plugin.getConfigManager().getFishDisplayName(fishId)) == null || !fishToRemove.containsKey(fishName)) continue;
                            int requiredCount = (Integer)fishToRemove.get(fishName);
                            int itemCount = item.getAmount();
                            if (itemCount <= requiredCount) {
                                item.setAmount(0);
                                fishToRemove.put(fishName, requiredCount - itemCount);
                            } else {
                                item.setAmount(itemCount - requiredCount);
                                fishToRemove.put(fishName, 0);
                            }
                            if ((Integer)fishToRemove.get(fishName) <= 0) {
                                fishToRemove.remove(fishName);
                            }
                            if (fishToRemove.isEmpty()) break;
                        }
                        int fishScalesReward = playerData.getDeliveryFishScalesReward();
                        StringBuilder rewards = new StringBuilder();
                        ConfigurationSection rewardsSection = deliverySettings.getConfigurationSection("Rewards.Command-Rewards.Rewards");
                        if (rewardsSection != null) {
                            int shipmentTimeMinutes = deliverySettings.getInt("Rewards.Command-Rewards.Minimum", 1);
                            lessShipmentTimeBonus = deliverySettings.getInt("Rewards.Command-Rewards.Maximum", 1);
                            int rewardCount = shipmentTimeMinutes + new Random().nextInt(lessShipmentTimeBonus - shipmentTimeMinutes + 1);
                            int requiredCount = 0;
                            for (String rewardKey : rewardsSection.getKeys(false)) {
                                String rewardText;
                                if (requiredCount >= rewardCount) break;
                                ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardKey);
                                if (rewardSection == null || (rewardText = rewardSection.getString("Text", "")).isEmpty()) continue;
                                rewards.append(" ").append(rewardText).append("\n");
                                ++requiredCount;
                            }
                        }
                        playerData.setDeliveryCompleted(true);
                        int shipmentTimeMinutes = playerData.getShipmentTimeMinutes();
                        lessShipmentTimeBonus = this.plugin.getPlayerDataManager().getLessShipmentTimeBonus(playerData);
                        if (lessShipmentTimeBonus > 0) {
                            double reductionFactor = (100.0 - (double)lessShipmentTimeBonus) / 100.0;
                            shipmentTimeMinutes = (int)Math.max(1.0, (double)shipmentTimeMinutes * reductionFactor);
                        }
                        long shipmentCompleteTime = System.currentTimeMillis() + (long)(shipmentTimeMinutes * 60) * 1000L;
                        playerData.setShipmentCompleteTime(shipmentCompleteTime);
                        this.plugin.getPlayerDataManager().savePlayerData(player);
                        String message = this.plugin.getMessageManager().getMessage("delivery.submitted").replace("[fishes]", String.valueOf(playerData.getRequiredFishes()));
                        player.sendMessage(ColorSystem.colorize(message));
                        Integer currentPage = this.currentPages.get(player.getUniqueId());
                        this.openDeliveryMenu(player, currentPage != null ? currentPage : 0);
                    } else {
                        player.sendMessage(this.plugin.getMessageManager().getMessage("delivery.no-fish-requirements-for-delivery"));
                    }
                }
            }
        }
    }

    public void disable() {
        if (this.deliveryMenuRefreshTask != null) {
            this.deliveryMenuRefreshTask.cancel();
        }
        this.openDeliveryMenus.clear();
        this.currentPages.clear();
    }
}

