/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EventManager {
    private final MrUltimateFishing plugin;
    private FileConfiguration eventConfig;
    private File eventFile;
    private ActiveEvent activeEvent;
    private BukkitTask eventTask;
    private BukkitTask autoStartTask;
    private BossBar eventBossBar;

    public EventManager(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.startAutoEventScheduler();
    }

    private void loadConfig() {
        this.eventFile = new File(this.plugin.getDataFolder(), "events.yml");
        if (!this.eventFile.exists()) {
            this.plugin.saveResource("events.yml", false);
        }
        this.eventConfig = YamlConfiguration.loadConfiguration((File)this.eventFile);
    }

    public void reloadConfig() {
        this.eventConfig = YamlConfiguration.loadConfiguration((File)this.eventFile);
        if (this.autoStartTask != null) {
            this.autoStartTask.cancel();
        }
        this.startAutoEventScheduler();
    }

    private void startAutoEventScheduler() {
        if (!this.eventConfig.getBoolean("MrUltimateFishing.Enabled", true)) {
            return;
        }
        String timesString = this.eventConfig.getString("MrUltimateFishing.Tournaments-Starting", "");
        if (timesString.isEmpty()) {
            return;
        }
        final String[] times = timesString.split(",");
        this.autoStartTask = new BukkitRunnable(this){
            final /* synthetic */ EventManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Calendar now = Calendar.getInstance();
                int currentHour = now.get(11);
                int currentMinute = now.get(12);
                for (String timeStr : times) {
                    try {
                        int minute;
                        String[] timeParts = timeStr.trim().split(":");
                        int hour = Integer.parseInt(timeParts[0]);
                        int n = minute = timeParts.length > 1 ? Integer.parseInt(timeParts[1]) : 0;
                        if (currentHour != hour || currentMinute != minute || this.this$0.activeEvent != null) continue;
                        this.this$0.startRandomEvent();
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.this$0.plugin.getLogger().warning("Invalid event time format: " + timeStr);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1200L);
    }

    public void startEvent(int eventId) {
        if (this.activeEvent != null) {
            this.plugin.getLogger().info("Event already active!");
            return;
        }
        ConfigurationSection eventSection = this.eventConfig.getConfigurationSection("MrUltimateFishing.Events." + eventId);
        if (eventSection == null) {
            this.plugin.getLogger().warning("Event with ID " + eventId + " not found!");
            return;
        }
        this.activeEvent = new ActiveEvent(eventId, eventSection);
        this.createBossBar();
        this.sendEventMessages("Start");
        this.startEventTimer();
        this.plugin.getLogger().info("Event " + eventId + " started!");
    }

    public void startRandomEvent() {
        ConfigurationSection eventsSection = this.eventConfig.getConfigurationSection("MrUltimateFishing.Events");
        if (eventsSection == null) {
            return;
        }
        Set eventKeys = eventsSection.getKeys(false);
        if (eventKeys.isEmpty()) {
            return;
        }
        String[] eventArray = eventKeys.toArray(new String[0]);
        int randomIndex = new Random().nextInt(eventArray.length);
        int eventId = Integer.parseInt(eventArray[randomIndex]);
        this.startEvent(eventId);
    }

    public void endEvent() {
        if (this.activeEvent == null) {
            return;
        }
        if (this.eventTask != null) {
            this.eventTask.cancel();
            this.eventTask = null;
        }
        if (this.eventBossBar != null) {
            this.eventBossBar.removeAll();
            this.eventBossBar = null;
        }
        this.sendEventMessages("End");
        this.activeEvent = null;
        this.plugin.getLogger().info("Event ended!");
    }

    private void createBossBar() {
        BarStyle style;
        BarColor color;
        if (!this.activeEvent.bossbarEnabled) {
            return;
        }
        try {
            color = BarColor.valueOf((String)this.activeEvent.bossbarColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            color = BarColor.PINK;
        }
        try {
            style = BarStyle.valueOf((String)this.activeEvent.bossbarType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            style = BarStyle.SOLID;
        }
        String message = this.activeEvent.bossbarMessage.replace("[EndEvent]", String.valueOf(this.activeEvent.timeToEnd));
        this.eventBossBar = Bukkit.createBossBar((String)ColorSystem.colorize(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        this.eventBossBar.setProgress(1.0);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.eventBossBar.addPlayer(player);
        }
    }

    private void startEventTimer() {
        this.eventTask = new BukkitRunnable(){
            private int timeLeft;
            {
                this.timeLeft = ((EventManager)EventManager.this).activeEvent.timeToEnd * 60;
            }

            public void run() {
                --this.timeLeft;
                if (EventManager.this.eventBossBar != null) {
                    double progress = (double)this.timeLeft / (double)(((EventManager)EventManager.this).activeEvent.timeToEnd * 60);
                    EventManager.this.eventBossBar.setProgress(Math.max(0.0, progress));
                    String message = ((EventManager)EventManager.this).activeEvent.bossbarMessage.replace("[EndEvent]", String.valueOf((this.timeLeft + 59) / 60));
                    EventManager.this.eventBossBar.setTitle(ColorSystem.colorize(message));
                }
                if (this.timeLeft <= 0) {
                    EventManager.this.endEvent();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void sendEventMessages(String messageType) {
        List<String> messages = this.activeEvent.getMessages(messageType);
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (String message : messages) {
                String processedMessage = message.replace("[EndEvent]", String.valueOf(this.activeEvent.timeToEnd));
                player.sendMessage(ColorSystem.colorize(processedMessage));
            }
        }
    }

    public boolean isEventActive() {
        return this.activeEvent != null;
    }

    public List<String> getAvailableEventIds() {
        ArrayList<String> ids = new ArrayList<String>();
        ConfigurationSection eventsSection = this.eventConfig.getConfigurationSection("MrUltimateFishing.Events");
        if (eventsSection != null) {
            Set eventKeys = eventsSection.getKeys(false);
            ids.addAll(eventKeys);
        }
        return ids;
    }

    public ActiveEvent getActiveEvent() {
        return this.activeEvent;
    }

    public void shutdown() {
        if (this.eventTask != null) {
            this.eventTask.cancel();
        }
        if (this.autoStartTask != null) {
            this.autoStartTask.cancel();
        }
        if (this.eventBossBar != null) {
            this.eventBossBar.removeAll();
            this.eventBossBar = null;
        }
    }

    public static class ActiveEvent {
        public final int id;
        public final EventType type;
        public final double value;
        public final int timeToEnd;
        public final boolean bossbarEnabled;
        public final String bossbarType;
        public final String bossbarColor;
        public final String bossbarMessage;
        private final ConfigurationSection config;

        public ActiveEvent(int id, ConfigurationSection config) {
            this.id = id;
            this.config = config;
            this.type = EventType.valueOf(config.getString("Type", "SELLBOOST").toUpperCase());
            this.value = Double.parseDouble(config.getString("Value", "1.0"));
            this.timeToEnd = config.getInt("Time-to-End", 15);
            ConfigurationSection bossbarConfig = config.getConfigurationSection("Bossbar");
            this.bossbarEnabled = bossbarConfig != null && bossbarConfig.getBoolean("Enabled", true);
            this.bossbarType = bossbarConfig != null ? bossbarConfig.getString("Type", "PROGRESS") : "PROGRESS";
            this.bossbarColor = bossbarConfig != null ? bossbarConfig.getString("Color", "PINK") : "PINK";
            this.bossbarMessage = bossbarConfig != null ? bossbarConfig.getString("Message", "") : "";
        }

        public List<String> getMessages(String messageType) {
            return this.config.getStringList("Messages." + messageType);
        }

        public double getMultiplier() {
            return this.value;
        }
    }

    public static enum EventType {
        SELLBOOST,
        GUTBOOST,
        FISHSCALEBOOST,
        BOOSTXPLEVEL;

    }
}

