/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrultimatefishing.FishItem;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.BoosterManager;
import eu.mrneznamy.mrultimatefishing.managers.TournamentManager;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellFishMenuManager
extends BaseMenuManager {
    private final Set<Inventory> activeSellFishInventories = new HashSet<Inventory>();

    public SellFishMenuManager(MrUltimateFishing plugin) {
        super(plugin);
    }

    public void registerSellFishInventory(Inventory inventory) {
        this.activeSellFishInventories.add(inventory);
    }

    public void unregisterSellFishInventory(Inventory inventory) {
        this.activeSellFishInventories.remove(inventory);
    }

    public boolean isSellFishMenu(Inventory inventory) {
        return this.activeSellFishInventories.contains(inventory);
    }

    public void openSellFishMenu(Player player) {
        ConfigurationSection itemsSection;
        FileConfiguration config = this.plugin.getConfigManager().getSellFishConfig();
        if (config == null) {
            return;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.SellFish");
        if (menuSection == null) {
            return;
        }
        String baseTitle = menuSection.getString("title", "Sell Fish");
        String colorSuffix = this.menuTitleSuffixes.getOrDefault("SellFish", "");
        String title = ColorSystem.colorize(baseTitle + colorSuffix);
        int size = menuSection.getInt("size", 54);
        Inventory inventory = this.createInventory(title, "SellFish", size);
        this.registerSellFishInventory(inventory);
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            this.addDecorations(inventory, decorationsSection);
        }
        if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
            this.addItems(inventory, itemsSection);
        }
        this.addNavigationKeys(inventory, menuSection, player, 0);
        player.openInventory(inventory);
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection menuSection, Player player, int page) {
        ConfigurationSection keysSection = menuSection.getConfigurationSection("keys");
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            ConfigurationSection keySection = keysSection.getConfigurationSection(key);
            if (keySection == null) continue;
            ItemStack keyItem = this.createNavigationKeyItem(keySection, key, player, page);
            String slotsStr = keySection.getString("slots", "");
            List<Integer> slots = this.parseSlots(slotsStr);
            for (int slot : slots) {
                ItemStack existingItem;
                if (slot < 0 || slot >= inventory.getSize() || (existingItem = inventory.getItem(slot)) != null && existingItem.getType() != Material.AIR && this.isFish(existingItem)) continue;
                inventory.setItem(slot, keyItem);
            }
        }
    }

    private ItemStack createNavigationKeyItem(ConfigurationSection keySection, String keyType, Player player, int page) {
        ArrayList<String> lore;
        String displayName;
        String type = keySection.getString("type", keyType);
        FileConfiguration messagesConfig = this.plugin.getMessageManager().getMessagesConfig();
        if (messagesConfig == null) {
            ConfigurationSection fallbackSection;
            FileConfiguration config = this.plugin.getConfigManager().getSellFishConfig();
            if (config != null && (fallbackSection = config.getConfigurationSection("MrUltimateFishing.SellFish.fallback-navigation")) != null) {
                String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                String fallbackName = fallbackSection.getString("display-name", "Navigation");
                List fallbackLore = fallbackSection.getStringList("lore");
                return this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
            }
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        ConfigurationSection menuKeysSection = messagesConfig.getConfigurationSection("menu-keys");
        if (menuKeysSection == null) {
            ConfigurationSection fallbackSection;
            FileConfiguration config = this.plugin.getConfigManager().getSellFishConfig();
            if (config != null && (fallbackSection = config.getConfigurationSection("MrUltimateFishing.SellFish.fallback-navigation")) != null) {
                String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                String fallbackName = fallbackSection.getString("display-name", "Navigation");
                List fallbackLore = fallbackSection.getStringList("lore");
                return this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
            }
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        ConfigurationSection itemSection = menuKeysSection.getConfigurationSection(type);
        if (itemSection == null) {
            ConfigurationSection fallbackSection;
            FileConfiguration config = this.plugin.getConfigManager().getSellFishConfig();
            if (config != null && (fallbackSection = config.getConfigurationSection("MrUltimateFishing.SellFish.fallback-navigation")) != null) {
                String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                String fallbackName = fallbackSection.getString("display-name", "Navigation");
                List fallbackLore = fallbackSection.getStringList("lore");
                return this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
            }
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        String material = itemSection.getString("material", "ARROW").toUpperCase();
        ItemStack finalItem = this.createMenuItem(material, displayName = itemSection.getString("display-name", ""), lore = new ArrayList<String>(itemSection.getStringList("lore")), false);
        ItemMeta meta = finalItem.getItemMeta();
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
            dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
            finalItem.setItemMeta(meta);
        }
        return finalItem;
    }

    private boolean isFish(ItemStack item) {
        if (FishItem.isCustomFish(item)) {
            String fishId = FishItem.getFishId(item);
            String fishRarity = FishItem.getFishRarity(item);
            return true;
        }
        return this.isVanillaFish(item);
    }

    private boolean isVanillaFish(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type == Material.COD || type == Material.SALMON || type == Material.TROPICAL_FISH || type == Material.PUFFERFISH;
    }

    public double getFishValue(ItemStack item) {
        String fishId;
        if (!this.isFish(item)) {
            return 0.0;
        }
        Double nbtPrice = FishItem.getFishPrice(item);
        if (nbtPrice != null) {
            return nbtPrice;
        }
        if (this.isVanillaFish(item)) {
            double vanillaPrice = this.getVanillaFishValue(item);
            return vanillaPrice;
        }
        if (FishItem.isCustomFish(item) && (fishId = FishItem.getFishId(item)) != null) {
            boolean hasOverrideRarity = this.plugin.getConfigManager().getFishOverrideRarity(fishId);
            if (hasOverrideRarity) {
                double price = this.plugin.getConfigManager().getFishSellPrice(fishId);
                return price;
            }
            String rarityId = FishItem.getFishRarity(item);
            if (rarityId != null) {
                double price = this.plugin.getConfigManager().getRaritySellPrice(rarityId);
                return price;
            }
        }
        return 0.0;
    }

    private double getVanillaFishValue(ItemStack item) {
        Material type = item.getType();
        double vanillaPrice = this.plugin.getConfigManager().getVanillaFishSellPrice();
        switch (type) {
            case COD: 
            case SALMON: 
            case TROPICAL_FISH: 
            case PUFFERFISH: {
                return vanillaPrice;
            }
        }
        return 0.0;
    }

    private boolean isReservedSlot(int slot) {
        ConfigurationSection itemsSection;
        ConfigurationSection keysSection;
        FileConfiguration config = this.plugin.getConfigManager().getSellFishConfig();
        if (config == null) {
            return false;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.SellFish");
        if (menuSection == null) {
            return false;
        }
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            for (Object decorationKey : decorationsSection.getKeys(false)) {
                List<Integer> decorationSlots;
                String slotsStr;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection((String)decorationKey);
                if (decorationSection == null || (slotsStr = decorationSection.getString("slots")) == null || !(decorationSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        if ((keysSection = menuSection.getConfigurationSection("keys")) != null) {
            for (String keyKey : keysSection.getKeys(false)) {
                List<Integer> keySlots;
                String slotsStr;
                ConfigurationSection keySection = keysSection.getConfigurationSection(keyKey);
                if (keySection == null || (slotsStr = keySection.getString("slots")) == null || !(keySlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                List<Integer> itemSlots;
                String slotsStr;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null || (slotsStr = itemSection.getString("slots")) == null || !(itemSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDecorationSlot(int slot) {
        ConfigurationSection itemsSection;
        FileConfiguration config = this.plugin.getConfigManager().getSellFishConfig();
        if (config == null) {
            return false;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.SellFish");
        if (menuSection == null) {
            return false;
        }
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            for (String decorationKey : decorationsSection.getKeys(false)) {
                List<Integer> decorationSlots;
                String slotsStr;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection(decorationKey);
                if (decorationSection == null || (slotsStr = decorationSection.getString("slots")) == null || !(decorationSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                List<Integer> itemSlots;
                String slotsStr;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null || (slotsStr = itemSection.getString("slots")) == null || !(itemSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        return false;
    }

    public void sellAllFish(Player player, Inventory sellInventory) {
        double totalValue = 0.0;
        int fishCount = 0;
        ArrayList<ItemStack> nonFishItems = new ArrayList<ItemStack>();
        for (int i = 0; i < sellInventory.getSize(); ++i) {
            NamespacedKey navigationKey;
            ItemMeta meta;
            PersistentDataContainer dataContainer;
            boolean isDecoration;
            ItemStack item = sellInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR || (isDecoration = this.isDecorationSlot(i))) continue;
            boolean isFishItem = this.isFish(item);
            if (isFishItem) {
                double value = this.getFishValue(item);
                double slotValue = value * (double)item.getAmount();
                totalValue += slotValue;
                fishCount += item.getAmount();
                sellInventory.setItem(i, null);
                continue;
            }
            boolean isNavigationItem = false;
            if (item.hasItemMeta() && (dataContainer = (meta = item.getItemMeta()).getPersistentDataContainer()).has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
                isNavigationItem = true;
            }
            if (isNavigationItem) {
                sellInventory.setItem(i, null);
                continue;
            }
            nonFishItems.add(item.clone());
            sellInventory.setItem(i, null);
        }
        if (totalValue > 0.0) {
            MrUltimateFishing mrPlugin = this.plugin;
            double sellBoostMultiplier = mrPlugin.getFishingManager().getSellBoostMultiplier();
            double boosterSellMultiplier = mrPlugin.getBoosterManager().getBoosterMultiplier(player, BoosterManager.BoosterType.SELLBOOST);
            double finalValue = totalValue * sellBoostMultiplier * boosterSellMultiplier;
            this.plugin.getEconomy().giveMoney(player, finalValue);
            mrPlugin.getTournamentManager().onPlayerAction(player, TournamentManager.TournamentType.MOSTSELLEDFISHES, "", fishCount);
            mrPlugin.getCommunityQuestIntegration().processFishSelling(player, fishCount, finalValue);
            String message = this.plugin.getMessageManager().getMessage("fishing.fish-sold").replace("[amount]", String.valueOf(fishCount)).replace("[money]", String.valueOf((int)finalValue));
            player.sendMessage(message);
            if (sellBoostMultiplier > 1.0) {
                String bonusMessage = this.plugin.getMessageManager().getMessage("prefix") + "&aYou received a &6" + String.format("%.1f", sellBoostMultiplier) + "x&a sell bonus from the active event!";
                player.sendMessage(ColorSystem.colorize(bonusMessage));
            }
            if (boosterSellMultiplier > 1.0) {
                String boosterMessage = this.plugin.getMessageManager().getMessage("prefix") + "&aYou received a &6" + String.format("%.1f", boosterSellMultiplier) + "x&a sell bonus from your booster!";
                player.sendMessage(ColorSystem.colorize(boosterMessage));
            }
        }
        for (ItemStack nonFishItem : nonFishItems) {
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{nonFishItem});
            for (ItemStack drop : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), drop);
            }
        }
        if (!nonFishItems.isEmpty()) {
            String message = this.plugin.getMessageManager().getMessage("prefix") + "&7Returned " + nonFishItems.size() + " non-fish items to your inventory.";
            player.sendMessage(ColorSystem.colorize(message));
        }
    }

    public void handleSellButtonClick(Player player, Inventory inventory) {
        this.sellAllFish(player, inventory);
    }

    public boolean canPlaceItem(ItemStack item, int slot) {
        boolean isFishItem;
        if (this.isReservedSlot(slot)) {
            return false;
        }
        boolean canPlace = isFishItem = this.isFish(item);
        return canPlace;
    }

    public double getTotalValue(Inventory sellInventory, Player player) {
        double totalValue = 0.0;
        for (int i = 0; i < sellInventory.getSize(); ++i) {
            ItemStack item = sellInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            boolean isDecoration = this.isDecorationSlot(i);
            boolean isFishItem = this.isFish(item);
            if (isDecoration || !isFishItem) continue;
            double value = this.getFishValue(item);
            double slotValue = value * (double)item.getAmount();
            totalValue += slotValue;
        }
        MrUltimateFishing mrPlugin = this.plugin;
        double sellBoostMultiplier = mrPlugin.getFishingManager().getSellBoostMultiplier();
        double boosterSellMultiplier = 1.0;
        if (player != null) {
            boosterSellMultiplier = mrPlugin.getBoosterManager().getBoosterMultiplier(player, BoosterManager.BoosterType.SELLBOOST);
        }
        return totalValue * sellBoostMultiplier * boosterSellMultiplier;
    }

    public double getTotalValue(Inventory sellInventory) {
        return this.getTotalValue(sellInventory, null);
    }

    public int getFishCount(Inventory sellInventory) {
        int count = 0;
        for (int i = 0; i < sellInventory.getSize(); ++i) {
            ItemStack item = sellInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            boolean isDecoration = this.isDecorationSlot(i);
            boolean isFishItem = this.isFish(item);
            if (isDecoration || !isFishItem) continue;
            count += item.getAmount();
        }
        return count;
    }

    public void openRarityCategoryMenu(Player player, String rarity, int page) {
        this.plugin.getMenuManager().openRarityMenu(player, rarity, page);
    }

    public void cleanupPlayerData(Player player) {
    }

    private boolean isSellFishMenu(String inventoryTitle) {
        return false;
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        if (!this.isSellFishMenu(event.getInventory())) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        int slot = event.getSlot();
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory != null && clickedInventory.equals((Object)event.getView().getTopInventory())) {
            ItemMeta meta;
            if (clickedItem != null && clickedItem.getType() != Material.AIR && this.isReservedSlot(slot)) {
                if (clickedItem.hasItemMeta()) {
                    NamespacedKey navigationKey;
                    ItemMeta meta2 = clickedItem.getItemMeta();
                    PersistentDataContainer dataContainer = meta2.getPersistentDataContainer();
                    if (dataContainer.has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
                        String navigationType = (String)dataContainer.get(navigationKey, PersistentDataType.STRING);
                        switch (navigationType) {
                            case "back": {
                                this.plugin.getMenuManager().openHeadMenu(player);
                                event.setCancelled(true);
                                return true;
                            }
                            case "previous-page": 
                            case "prev": {
                                event.setCancelled(true);
                                return true;
                            }
                            case "next-page": 
                            case "next": {
                                event.setCancelled(true);
                                return true;
                            }
                        }
                    }
                    if (meta2.hasLore()) {
                        List lore = meta2.getLore();
                        for (String line : lore) {
                            String cleanLine = ChatColor.stripColor((String)line).toLowerCase();
                            if (!cleanLine.contains("sell") || !cleanLine.contains("all") && !cleanLine.contains("everything")) continue;
                            this.handleSellButtonClick(player, event.getInventory());
                            event.setCancelled(true);
                            return true;
                        }
                    }
                }
                event.setCancelled(true);
                return true;
            }
            if (clickedItem != null && clickedItem.hasItemMeta() && !this.isReservedSlot(slot) && (meta = clickedItem.getItemMeta()).hasLore()) {
                List lore = meta.getLore();
                for (String line : lore) {
                    String cleanLine = ChatColor.stripColor((String)line).toLowerCase();
                    if (!cleanLine.contains("sell") || !cleanLine.contains("all") && !cleanLine.contains("everything")) continue;
                    this.handleSellButtonClick(player, event.getInventory());
                    event.setCancelled(true);
                    return true;
                }
            }
            if (cursorItem != null && cursorItem.getType() != Material.AIR) {
                if (this.isReservedSlot(slot)) {
                    event.setCancelled(true);
                    return true;
                }
                if (!this.isFish(cursorItem)) {
                    event.setCancelled(true);
                    this.plugin.getMessageManager().sendMessage((CommandSender)player, "sell.only-fish");
                    return true;
                }
            }
        }
        if (event.getClick().isShiftClick() && clickedInventory != null && clickedInventory.equals((Object)player.getInventory()) && clickedItem != null && clickedItem.getType() != Material.AIR) {
            if (!this.isFish(clickedItem)) {
                event.setCancelled(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public void handleInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (this.isSellFishMenu(event.getInventory())) {
            Inventory closedInventory = event.getInventory();
            int fishCount = this.getFishCount(closedInventory);
            double totalValue = this.getTotalValue(closedInventory);
            if (fishCount > 0) {
                this.sellAllFish(player, closedInventory);
            }
            this.unregisterSellFishInventory(closedInventory);
        }
        this.cleanupPlayerData(player);
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        int rawSlot;
        if (!this.isSellFishMenu(event.getInventory())) {
            return false;
        }
        int topSize = event.getView().getTopInventory().getSize();
        boolean touchesTop = false;
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            rawSlot = (Integer)iterator.next();
            if (rawSlot >= topSize) continue;
            touchesTop = true;
            break;
        }
        if (!touchesTop) {
            return false;
        }
        iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            rawSlot = (Integer)iterator.next();
            if (rawSlot >= topSize || !this.isDecorationSlot(rawSlot)) continue;
            event.setCancelled(true);
            return true;
        }
        if (event.getOldCursor() != null && !this.isFish(event.getOldCursor())) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }
}

