/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class UpgradeMenuManager
extends BaseMenuManager {
    private final MrUltimateFishing plugin;
    private final PlayerDataManager playerDataManager;
    private final Map<UUID, Map<String, Integer>> playerUpgrades;
    private final Map<UUID, Integer> playerUpgradePoints;
    private File upgradeDataFolder;

    public UpgradeMenuManager(MrUltimateFishing plugin) {
        super(plugin);
        this.plugin = plugin;
        this.playerDataManager = plugin.getPlayerDataManager();
        this.playerUpgrades = new HashMap<UUID, Map<String, Integer>>();
        this.playerUpgradePoints = new HashMap<UUID, Integer>();
        this.upgradeDataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.upgradeDataFolder.exists()) {
            this.upgradeDataFolder.mkdirs();
        }
    }

    public void openUpgradeMenu(Player player) {
        ConfigurationSection navigationSection;
        this.loadPlayerUpgradeData(player);
        FileConfiguration config = this.plugin.getConfigManager().getUpgradesConfig();
        if (config == null) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.config-not-found");
            return;
        }
        String title = config.getString("MrUltimateFishing.Upgrades.title", "Upgrades");
        title = ColorSystem.colorize(title);
        int size = config.getInt("MrUltimateFishing.Upgrades.size", 54);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection decorationsSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.decorations");
        if (decorationsSection != null) {
            this.addDecorations(inventory, decorationsSection);
        }
        if ((navigationSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.keys")) != null) {
            this.addNavigationKeys(inventory, navigationSection);
        }
        this.addUpgradeItems(inventory, config, player);
        player.openInventory(inventory);
    }

    private void addUpgradeItems(Inventory inventory, FileConfiguration config, Player player) {
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int upgradePoints = this.playerDataManager.getUpgradePoints(player);
        if (this.plugin.getConfig().getBoolean("Upgrades.XPUpgrade.enabled", true)) {
            this.addXPUpgradeItem(inventory, config, player, upgrades, upgradePoints);
        }
        if (this.plugin.getConfig().getBoolean("Upgrades.FSUpgrade.enabled", true)) {
            this.addFSUpgradeItem(inventory, config, player, upgrades, upgradePoints);
        }
        if (this.plugin.getConfig().getBoolean("Upgrades.FSGUpgrade.enabled", true)) {
            this.addFSGUpgradeItem(inventory, config, player, upgrades, upgradePoints);
        }
        if (this.plugin.getConfig().getBoolean("Upgrades.Tornado.enabled", true)) {
            this.addTornadoUpgradeItem(inventory, config, player, upgrades, upgradePoints);
        }
        if (this.plugin.getConfig().getBoolean("Upgrades.Tsunami.enabled", true)) {
            this.addTsunamiUpgradeItem(inventory, config, player, upgrades, upgradePoints);
        }
        if (this.plugin.getConfig().getBoolean("Upgrades.ResetUpgrades.enabled", true)) {
            this.addResetUpgradeItem(inventory, config, player, upgrades);
        }
        this.addInformationItem(inventory, config, player, upgradePoints);
    }

    private void addXPUpgradeItem(Inventory inventory, FileConfiguration config, Player player, Map<String, Integer> upgrades, int upgradePoints) {
        int currentLevel = upgrades.getOrDefault("XPUpgrade", 0);
        int maxLevel = this.plugin.getConfig().getInt("Upgrades.XPUpgrade.max-level", 100);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.XPUpgrade.XPUpgradePercent", 0.3);
        int cost = this.plugin.getConfig().getInt("Upgrades.XPUpgrade.cost", 1);
        ConfigurationSection itemSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.items.more-xp-per-catch");
        ItemStack item = this.createMenuItem(itemSection);
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore();
                if (lore != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String line : lore) {
                        line = line.replace("[XPUpgradePercent]", String.format("%.1f", upgradePercent));
                        line = line.replace("[XPUpgradeTimes]", String.valueOf(currentLevel));
                        line = line.replace("[XPMaxUpgrades]", maxLevel == 0 ? "\u221e" : String.valueOf(maxLevel));
                        line = line.replace("[XPUpgradeTotal]", String.format("%.1f%%", (double)currentLevel * upgradePercent));
                        newLore.add(ColorSystem.colorize(line));
                    }
                    meta.setLore(newLore);
                }
                meta = this.addNBTString(meta, "upgrade_action", "xp_upgrade");
                meta = this.addNBTString(meta, "upgrade_cost", String.valueOf(cost));
                meta = this.addNBTString(meta, "can_upgrade", String.valueOf(this.canUpgrade(currentLevel, maxLevel, upgradePoints, cost)));
                item.setItemMeta(meta);
            }
            int slot = config.getInt("MrUltimateFishing.Upgrades.items.more-xp-per-catch.slot", 20);
            inventory.setItem(slot, item);
        }
    }

    private void addFSUpgradeItem(Inventory inventory, FileConfiguration config, Player player, Map<String, Integer> upgrades, int upgradePoints) {
        int currentLevel = upgrades.getOrDefault("FSUpgrade", 0);
        int maxLevel = this.plugin.getConfig().getInt("Upgrades.FSUpgrade.max-level", 125);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.FSUpgrade.FSUpgradePercent", 0.5);
        int cost = this.plugin.getConfig().getInt("Upgrades.FSUpgrade.cost", 1);
        ConfigurationSection itemSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.items.more-fish-scales-per-catch");
        ItemStack item = this.createMenuItem(itemSection);
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore();
                if (lore != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String line : lore) {
                        line = line.replace("[FSUpgradePercent]", String.format("%.1f", upgradePercent));
                        line = line.replace("[FSUpgradeTimes]", String.valueOf(currentLevel));
                        line = line.replace("[FSMaxUpgrades]", maxLevel == 0 ? "\u221e" : String.valueOf(maxLevel));
                        line = line.replace("[FSUpgradeTotal]", String.format("%.1f%%", (double)currentLevel * upgradePercent));
                        newLore.add(ColorSystem.colorize(line));
                    }
                    meta.setLore(newLore);
                }
                meta = this.addNBTString(meta, "upgrade_action", "fs_upgrade");
                meta = this.addNBTString(meta, "upgrade_cost", String.valueOf(cost));
                meta = this.addNBTString(meta, "can_upgrade", String.valueOf(this.canUpgrade(currentLevel, maxLevel, upgradePoints, cost)));
                item.setItemMeta(meta);
            }
            int slot = config.getInt("MrUltimateFishing.Upgrades.items.more-fish-scales-per-catch.slot", 21);
            inventory.setItem(slot, item);
        }
    }

    private void addFSGUpgradeItem(Inventory inventory, FileConfiguration config, Player player, Map<String, Integer> upgrades, int upgradePoints) {
        int currentLevel = upgrades.getOrDefault("FSGUpgrade", 0);
        int maxLevel = this.plugin.getConfig().getInt("Upgrades.FSGUpgrade.max-level", 50);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.FSGUpgrade.FSGUpgradePercent", 0.8);
        int cost = this.plugin.getConfig().getInt("Upgrades.FSGUpgrade.cost", 2);
        ConfigurationSection itemSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.items.more-fish-scales-per-gutting");
        ItemStack item = this.createMenuItem(itemSection);
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore();
                if (lore != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String line : lore) {
                        line = line.replace("[FSGUpgradePercent]", String.format("%.1f", upgradePercent));
                        line = line.replace("[FSGUpgradeTimes]", String.valueOf(currentLevel));
                        line = line.replace("[FSGMaxUpgrades]", maxLevel == 0 ? "\u221e" : String.valueOf(maxLevel));
                        line = line.replace("[FSGUpgradeTotal]", String.format("%.1f%%", (double)currentLevel * upgradePercent));
                        newLore.add(ColorSystem.colorize(line));
                    }
                    meta.setLore(newLore);
                }
                meta = this.addNBTString(meta, "upgrade_action", "fsg_upgrade");
                meta = this.addNBTString(meta, "upgrade_cost", String.valueOf(cost));
                meta = this.addNBTString(meta, "can_upgrade", String.valueOf(this.canUpgrade(currentLevel, maxLevel, upgradePoints, cost)));
                item.setItemMeta(meta);
            }
            int slot = config.getInt("MrUltimateFishing.Upgrades.items.more-fish-scales-per-gutting.slot", 22);
            inventory.setItem(slot, item);
        }
    }

    private void addTornadoUpgradeItem(Inventory inventory, FileConfiguration config, Player player, Map<String, Integer> upgrades, int upgradePoints) {
        int currentLevel = upgrades.getOrDefault("Tornado", 0);
        int maxLevel = this.plugin.getConfig().getInt("Upgrades.Tornado.max-level", 10);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.Tornado.TUpgradePercent", 0.3);
        int cost = this.plugin.getConfig().getInt("Upgrades.Tornado.cost", 25);
        int tornadoTime = this.plugin.getConfig().getInt("Upgrades.Tornado.TornadoTime", 10);
        ConfigurationSection itemSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.items.tornado");
        ItemStack item = this.createMenuItem(itemSection);
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore();
                if (lore != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String line : lore) {
                        line = line.replace("[TUpgradePercent]", String.format("%.1f", upgradePercent));
                        line = line.replace("[TUpgradeTimes]", String.valueOf(currentLevel));
                        line = line.replace("[TMaxUpgrades]", maxLevel == 0 ? "\u221e" : String.valueOf(maxLevel));
                        line = line.replace("[TUpgradeTotal]", String.format("%.1f%%", (double)currentLevel * upgradePercent));
                        line = line.replace("[TActive]", String.valueOf(tornadoTime));
                        newLore.add(ColorSystem.colorize(line));
                    }
                    meta.setLore(newLore);
                }
                meta = this.addNBTString(meta, "upgrade_action", "tornado_upgrade");
                meta = this.addNBTString(meta, "upgrade_cost", String.valueOf(cost));
                meta = this.addNBTString(meta, "can_upgrade", String.valueOf(this.canUpgrade(currentLevel, maxLevel, upgradePoints, cost)));
                item.setItemMeta(meta);
            }
            int slot = config.getInt("MrUltimateFishing.Upgrades.items.tornado.slot", 23);
            inventory.setItem(slot, item);
        }
    }

    private void addTsunamiUpgradeItem(Inventory inventory, FileConfiguration config, Player player, Map<String, Integer> upgrades, int upgradePoints) {
        int currentLevel = upgrades.getOrDefault("Tsunami", 0);
        int maxLevel = this.plugin.getConfig().getInt("Upgrades.Tsunami.max-level", 15);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.Tsunami.TUpgradePercent", 0.5);
        int cost = this.plugin.getConfig().getInt("Upgrades.Tsunami.cost", 15);
        int tsunamiTime = this.plugin.getConfig().getInt("Upgrades.Tsunami.TsunamiTime", 10);
        ConfigurationSection itemSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.items.tsunami");
        ItemStack item = this.createMenuItem(itemSection);
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore();
                if (lore != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String line : lore) {
                        line = line.replace("[TsUpgradePercent]", String.format("%.1f", upgradePercent));
                        line = line.replace("[TsUpgradeTimes]", String.valueOf(currentLevel));
                        line = line.replace("[TsMaxUpgrades]", maxLevel == 0 ? "\u221e" : String.valueOf(maxLevel));
                        line = line.replace("[TsUpgradeTotal]", String.format("%.1f%%", (double)currentLevel * upgradePercent));
                        line = line.replace("[TsActive]", String.valueOf(tsunamiTime));
                        newLore.add(ColorSystem.colorize(line));
                    }
                    meta.setLore(newLore);
                }
                meta = this.addNBTString(meta, "upgrade_action", "tsunami_upgrade");
                meta = this.addNBTString(meta, "upgrade_cost", String.valueOf(cost));
                meta = this.addNBTString(meta, "can_upgrade", String.valueOf(this.canUpgrade(currentLevel, maxLevel, upgradePoints, cost)));
                item.setItemMeta(meta);
            }
            int slot = config.getInt("MrUltimateFishing.Upgrades.items.tsunami.slot", 24);
            inventory.setItem(slot, item);
        }
    }

    private void addResetUpgradeItem(Inventory inventory, FileConfiguration config, Player player, Map<String, Integer> upgrades) {
        int resetCost = this.plugin.getConfig().getInt("Upgrades.ResetUpgrades.cost", 15000);
        PlayerDataManager.PlayerData playerData = this.playerDataManager.getPlayerData(player);
        int fishScales = playerData.getFishScale();
        ConfigurationSection itemSection = config.getConfigurationSection("MrUltimateFishing.Upgrades.items.reset-upgrades");
        ItemStack item = this.createMenuItem(itemSection);
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore();
                if (lore != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String line : lore) {
                        line = line.replace("[Price]", String.valueOf(resetCost));
                        line = line.replace("[TotalFishScales]", String.valueOf(fishScales));
                        newLore.add(ColorSystem.colorize(line));
                    }
                    meta.setLore(newLore);
                }
                meta = this.addNBTString(meta, "upgrade_action", "reset_upgrades");
                meta = this.addNBTString(meta, "reset_cost", String.valueOf(resetCost));
                meta = this.addNBTString(meta, "can_reset", String.valueOf(fishScales >= resetCost));
                item.setItemMeta(meta);
            }
            int slot = config.getInt("MrUltimateFishing.Upgrades.items.reset-upgrades.slot", 5);
            inventory.setItem(slot, item);
        }
    }

    private void addInformationItem(Inventory inventory, FileConfiguration config, Player player, int upgradePoints) {
        List lore;
        ItemMeta meta;
        ItemStack infoItem = inventory.getItem(4);
        if (infoItem != null && (meta = infoItem.getItemMeta()) != null && (lore = meta.getLore()) != null) {
            ArrayList<String> newLore = new ArrayList<String>();
            int availablePoints = this.playerDataManager.getUpgradePoints(player);
            for (String line : lore) {
                line = line.replace("[UpgradePoints]", String.valueOf(availablePoints));
                newLore.add(ColorSystem.colorize(line));
            }
            meta.setLore(newLore);
            infoItem.setItemMeta(meta);
        }
    }

    private ItemMeta addNBTString(ItemMeta meta, String key, String value) {
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, key);
            dataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)value);
        }
        return meta;
    }

    private boolean canUpgrade(int currentLevel, int maxLevel, int upgradePoints, int cost) {
        if (maxLevel > 0 && currentLevel >= maxLevel) {
            return false;
        }
        return upgradePoints >= cost;
    }

    public int getUpgradePoints(Player player) {
        PlayerDataManager.PlayerData playerData = this.playerDataManager.getPlayerData(player);
        return playerData.getFishingLevel();
    }

    public double getXPUpgradeMultiplier(Player player) {
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int level = upgrades.getOrDefault("XPUpgrade", 0);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.XPUpgrade.XPUpgradePercent", 0.3);
        return 1.0 + (double)level * upgradePercent / 100.0;
    }

    public double getFSUpgradeMultiplier(Player player) {
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int level = upgrades.getOrDefault("FSUpgrade", 0);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.FSUpgrade.FSUpgradePercent", 0.5);
        return 1.0 + (double)level * upgradePercent / 100.0;
    }

    public double getFSGUpgradeMultiplier(Player player) {
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int level = upgrades.getOrDefault("FSGUpgrade", 0);
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.FSGUpgrade.FSGUpgradePercent", 0.8);
        return 1.0 + (double)level * upgradePercent / 100.0;
    }

    public void loadPlayerUpgradeData(Player player) {
        if (this.playerUpgrades.containsKey(player.getUniqueId())) {
            return;
        }
        File playerFile = new File(this.upgradeDataFolder, "upgrades_" + player.getUniqueId() + ".yml");
        HashMap<String, Integer> upgrades = new HashMap<String, Integer>();
        if (!playerFile.exists()) {
            upgrades.put("XPUpgrade", 0);
            upgrades.put("FSUpgrade", 0);
            upgrades.put("FSGUpgrade", 0);
            upgrades.put("Tornado", 0);
            upgrades.put("Tsunami", 0);
        } else {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
            upgrades.put("XPUpgrade", config.getInt("XPUpgrade", 0));
            upgrades.put("FSUpgrade", config.getInt("FSUpgrade", 0));
            upgrades.put("FSGUpgrade", config.getInt("FSGUpgrade", 0));
            upgrades.put("Tornado", config.getInt("Tornado", 0));
            upgrades.put("Tsunami", config.getInt("Tsunami", 0));
        }
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
    }

    private void savePlayerUpgradeData(Player player) {
        UUID playerId = player.getUniqueId();
        Map<String, Integer> upgrades = this.playerUpgrades.get(playerId);
        if (upgrades == null) {
            return;
        }
        Map<String, Integer> cacheUpgrades = this.playerUpgrades.get(playerId);
        File playerFile = new File(this.upgradeDataFolder, "upgrades_" + playerId.toString() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        config.set("XPUpgrade", (Object)upgrades.getOrDefault("XPUpgrade", 0));
        config.set("FSUpgrade", (Object)upgrades.getOrDefault("FSUpgrade", 0));
        config.set("FSGUpgrade", (Object)upgrades.getOrDefault("FSGUpgrade", 0));
        config.set("Tornado", (Object)upgrades.getOrDefault("Tornado", 0));
        config.set("Tsunami", (Object)upgrades.getOrDefault("Tsunami", 0));
        try {
            config.save(playerFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        NamespacedKey upgradeActionKey;
        PersistentDataContainer dataContainer;
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        FileConfiguration config = this.plugin.getConfigManager().getUpgradesConfig();
        if (config == null) {
            return false;
        }
        String menuTitle = ColorSystem.colorize(config.getString("MrUltimateFishing.Upgrades.title", "Upgrades"));
        if (!title.equals(menuTitle)) {
            return false;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return true;
        }
        if (this.isNavigationItem(clickedItem)) {
            String navigationId = this.getNavigationIdentifier(clickedItem);
            if ("back".equals(navigationId)) {
                this.plugin.getMenuManager().openHeadMenu(player);
            }
            return true;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta != null && (dataContainer = meta.getPersistentDataContainer()).has(upgradeActionKey = new NamespacedKey((Plugin)this.plugin, "upgrade_action"), PersistentDataType.STRING)) {
            String upgradeAction = (String)dataContainer.get(upgradeActionKey, PersistentDataType.STRING);
            this.handleUpgradeAction(player, upgradeAction, meta);
        }
        return true;
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection keysSection) {
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            ConfigurationSection keySection = keysSection.getConfigurationSection(key);
            if (keySection == null) continue;
            ItemStack keyItem = this.createNavigationKeyItem(keySection, key);
            String slotsStr = keySection.getString("slots", "");
            List<Integer> slots = this.parseSlots(slotsStr);
            for (int slot : slots) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, keyItem);
            }
        }
    }

    private ItemStack createNavigationKeyItem(ConfigurationSection keySection, String keyType) {
        List lore;
        String displayName;
        ConfigurationSection itemSection;
        ConfigurationSection menuKeysSection;
        String type = keySection.getString("type", keyType);
        FileConfiguration messagesConfig = this.plugin.getMessageManager().getMessagesConfig();
        if (messagesConfig != null && (menuKeysSection = messagesConfig.getConfigurationSection("menu-keys")) != null && (itemSection = menuKeysSection.getConfigurationSection(type)) != null) {
            List lore2;
            String displayName2;
            String material = itemSection.getString("material", "ARROW");
            ItemStack item = this.createMenuItem(material, displayName2 = itemSection.getString("display-name", ""), lore2 = itemSection.getStringList("lore"), false);
            if (item != null && item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
                dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
                item.setItemMeta(meta);
            }
            return item;
        }
        String material = keySection.getString("material", "ARROW");
        ItemStack item = this.createMenuItem(material, displayName = keySection.getString("display-name", ""), lore = keySection.getStringList("lore"), false);
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
            dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void handleUpgradeAction(Player player, String action, ItemMeta meta) {
        switch (action) {
            case "xp_upgrade": {
                this.handleXPUpgrade(player, meta);
                break;
            }
            case "fs_upgrade": {
                this.handleFSUpgrade(player, meta);
                break;
            }
            case "fsg_upgrade": {
                this.handleFSGUpgrade(player, meta);
                break;
            }
            case "tornado_upgrade": {
                this.handleTornadoUpgrade(player, meta);
                break;
            }
            case "tsunami_upgrade": {
                this.handleTsunamiUpgrade(player, meta);
                break;
            }
            case "reset_upgrades": {
                this.handleResetUpgrades(player, meta);
            }
        }
    }

    private void handleXPUpgrade(Player player, ItemMeta meta) {
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey canUpgradeKey = new NamespacedKey((Plugin)this.plugin, "can_upgrade");
        NamespacedKey upgradeCostKey = new NamespacedKey((Plugin)this.plugin, "upgrade_cost");
        if (!dataContainer.has(canUpgradeKey, PersistentDataType.STRING) || !"true".equals(dataContainer.get(canUpgradeKey, PersistentDataType.STRING))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.cannot-upgrade");
            return;
        }
        String costStr = (String)dataContainer.get(upgradeCostKey, PersistentDataType.STRING);
        int cost = Integer.parseInt(costStr);
        int upgradePoints = this.playerDataManager.getUpgradePoints(player);
        if (upgradePoints < cost) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-points", "[cost]", String.valueOf(cost), "[points]", String.valueOf(upgradePoints));
            return;
        }
        if (!this.playerDataManager.removeUpgradePoints(player, cost)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.points-removal-failed");
            return;
        }
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int currentLevel = upgrades.getOrDefault("XPUpgrade", 0);
        upgrades.put("XPUpgrade", currentLevel + 1);
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
        this.savePlayerUpgradeData(player);
        this.plugin.getCommunityQuestIntegration().processProcessUpgrade(player, "XPUpgrade");
        double bonusPercent = this.plugin.getConfig().getDouble("Upgrades.XPUpgrade.XPUpgradePercent", 0.3);
        double totalBonus = (double)(currentLevel + 1) * bonusPercent;
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.xp-upgrade-purchased", "[level]", String.valueOf(currentLevel + 1), "[bonus]", String.format("%.1f", totalBonus));
        this.openUpgradeMenu(player);
    }

    private void handleFSUpgrade(Player player, ItemMeta meta) {
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey canUpgradeKey = new NamespacedKey((Plugin)this.plugin, "can_upgrade");
        NamespacedKey upgradeCostKey = new NamespacedKey((Plugin)this.plugin, "upgrade_cost");
        if (!dataContainer.has(canUpgradeKey, PersistentDataType.STRING) || !"true".equals(dataContainer.get(canUpgradeKey, PersistentDataType.STRING))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.cannot-upgrade");
            return;
        }
        String costStr = (String)dataContainer.get(upgradeCostKey, PersistentDataType.STRING);
        int cost = Integer.parseInt(costStr);
        int upgradePoints = this.playerDataManager.getUpgradePoints(player);
        if (upgradePoints < cost) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-points", "[cost]", String.valueOf(cost), "[points]", String.valueOf(upgradePoints));
            return;
        }
        if (!this.playerDataManager.removeUpgradePoints(player, cost)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.points-removal-failed");
            return;
        }
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int currentLevel = upgrades.getOrDefault("FSUpgrade", 0);
        upgrades.put("FSUpgrade", currentLevel + 1);
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
        this.savePlayerUpgradeData(player);
        this.plugin.getCommunityQuestIntegration().processProcessUpgrade(player, "FSUpgrade");
        double bonusPercent = this.plugin.getConfig().getDouble("Upgrades.FSUpgrade.FSUpgradePercent", 0.5);
        double totalBonus = (double)(currentLevel + 1) * bonusPercent;
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.fs-upgrade-purchased", "[level]", String.valueOf(currentLevel + 1), "[bonus]", String.format("%.1f", totalBonus));
        this.openUpgradeMenu(player);
    }

    private void handleFSGUpgrade(Player player, ItemMeta meta) {
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey canUpgradeKey = new NamespacedKey((Plugin)this.plugin, "can_upgrade");
        NamespacedKey upgradeCostKey = new NamespacedKey((Plugin)this.plugin, "upgrade_cost");
        if (!dataContainer.has(canUpgradeKey, PersistentDataType.STRING) || !"true".equals(dataContainer.get(canUpgradeKey, PersistentDataType.STRING))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.cannot-upgrade");
            return;
        }
        String costStr = (String)dataContainer.get(upgradeCostKey, PersistentDataType.STRING);
        int cost = Integer.parseInt(costStr);
        int upgradePoints = this.playerDataManager.getUpgradePoints(player);
        if (upgradePoints < cost) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-points", "[cost]", String.valueOf(cost), "[points]", String.valueOf(upgradePoints));
            return;
        }
        if (!this.playerDataManager.removeUpgradePoints(player, cost)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.points-removal-failed");
            return;
        }
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int currentLevel = upgrades.getOrDefault("FSGUpgrade", 0);
        upgrades.put("FSGUpgrade", currentLevel + 1);
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
        this.savePlayerUpgradeData(player);
        this.plugin.getCommunityQuestIntegration().processProcessUpgrade(player, "FSGUpgrade");
        double bonusPercent = this.plugin.getConfig().getDouble("Upgrades.FSGUpgrade.FSGUpgradePercent", 0.8);
        double totalBonus = (double)(currentLevel + 1) * bonusPercent;
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.fsg-upgrade-purchased", "[level]", String.valueOf(currentLevel + 1), "[bonus]", String.format("%.1f", totalBonus));
        this.openUpgradeMenu(player);
    }

    private void handleResetUpgrades(Player player, ItemMeta meta) {
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey canResetKey = new NamespacedKey((Plugin)this.plugin, "can_reset");
        NamespacedKey resetCostKey = new NamespacedKey((Plugin)this.plugin, "reset_cost");
        if (!dataContainer.has(canResetKey, PersistentDataType.STRING) || !"true".equals(dataContainer.get(canResetKey, PersistentDataType.STRING))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-fish-scales-reset");
            return;
        }
        String resetCostStr = (String)dataContainer.get(resetCostKey, PersistentDataType.STRING);
        int resetCost = Integer.parseInt(resetCostStr);
        if (!this.playerDataManager.removeFishScale(player, resetCost)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-fish-scales");
            return;
        }
        Map currentUpgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int xpUpgrades = currentUpgrades.getOrDefault("XPUpgrade", 0);
        int fsUpgrades = currentUpgrades.getOrDefault("FSUpgrade", 0);
        int fsgUpgrades = currentUpgrades.getOrDefault("FSGUpgrade", 0);
        int tornadoUpgrades = currentUpgrades.getOrDefault("Tornado", 0);
        int tsunamiUpgrades = currentUpgrades.getOrDefault("Tsunami", 0);
        int xpCost = this.plugin.getConfig().getInt("Upgrades.XPUpgrade.cost", 1);
        int fsCost = this.plugin.getConfig().getInt("Upgrades.FSUpgrade.cost", 1);
        int fsgCost = this.plugin.getConfig().getInt("Upgrades.FSGUpgrade.cost", 2);
        int tornadoCost = this.plugin.getConfig().getInt("Upgrades.Tornado.cost", 25);
        int tsunamiCost = this.plugin.getConfig().getInt("Upgrades.Tsunami.cost", 15);
        int totalPointsToReturn = xpUpgrades * xpCost + fsUpgrades * fsCost + fsgUpgrades * fsgCost + tornadoUpgrades * tornadoCost + tsunamiUpgrades * tsunamiCost;
        HashMap<String, Integer> upgrades = new HashMap<String, Integer>();
        upgrades.put("XPUpgrade", 0);
        upgrades.put("FSUpgrade", 0);
        upgrades.put("FSGUpgrade", 0);
        upgrades.put("Tornado", 0);
        upgrades.put("Tsunami", 0);
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
        this.savePlayerUpgradeData(player);
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.reset-success", "{points}", String.valueOf(totalPointsToReturn));
        this.openUpgradeMenu(player);
    }

    private void handleTornadoUpgrade(Player player, ItemMeta meta) {
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey canUpgradeKey = new NamespacedKey((Plugin)this.plugin, "can_upgrade");
        NamespacedKey upgradeCostKey = new NamespacedKey((Plugin)this.plugin, "upgrade_cost");
        if (!dataContainer.has(canUpgradeKey, PersistentDataType.STRING) || !"true".equals(dataContainer.get(canUpgradeKey, PersistentDataType.STRING))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.cannot-upgrade");
            return;
        }
        String costStr = (String)dataContainer.get(upgradeCostKey, PersistentDataType.STRING);
        int cost = Integer.parseInt(costStr);
        int upgradePoints = this.playerDataManager.getUpgradePoints(player);
        if (upgradePoints < cost) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-points", "[cost]", String.valueOf(cost), "[points]", String.valueOf(upgradePoints));
            return;
        }
        if (!this.playerDataManager.removeUpgradePoints(player, cost)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.points-removal-failed");
            return;
        }
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int currentLevel = upgrades.getOrDefault("Tornado", 0);
        upgrades.put("Tornado", currentLevel + 1);
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
        this.savePlayerUpgradeData(player);
        this.plugin.getCommunityQuestIntegration().processProcessUpgrade(player, "Tornado");
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.Tornado.TUpgradePercent", 0.3);
        double chancePercent = (double)(currentLevel + 1) * upgradePercent;
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.tornado-upgrade-purchased", "[level]", String.valueOf(currentLevel + 1), "[chance]", String.format("%.1f", chancePercent));
        this.openUpgradeMenu(player);
    }

    private void handleTsunamiUpgrade(Player player, ItemMeta meta) {
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey canUpgradeKey = new NamespacedKey((Plugin)this.plugin, "can_upgrade");
        NamespacedKey upgradeCostKey = new NamespacedKey((Plugin)this.plugin, "upgrade_cost");
        if (!dataContainer.has(canUpgradeKey, PersistentDataType.STRING) || !"true".equals(dataContainer.get(canUpgradeKey, PersistentDataType.STRING))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.cannot-upgrade");
            return;
        }
        String costStr = (String)dataContainer.get(upgradeCostKey, PersistentDataType.STRING);
        int cost = Integer.parseInt(costStr);
        int upgradePoints = this.playerDataManager.getUpgradePoints(player);
        if (upgradePoints < cost) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.insufficient-points", "[cost]", String.valueOf(cost), "[points]", String.valueOf(upgradePoints));
            return;
        }
        if (!this.playerDataManager.removeUpgradePoints(player, cost)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.points-removal-failed");
            return;
        }
        Map upgrades = this.playerUpgrades.getOrDefault(player.getUniqueId(), new HashMap());
        int currentLevel = upgrades.getOrDefault("Tsunami", 0);
        upgrades.put("Tsunami", currentLevel + 1);
        this.playerUpgrades.put(player.getUniqueId(), upgrades);
        this.savePlayerUpgradeData(player);
        this.plugin.getCommunityQuestIntegration().processProcessUpgrade(player, "Tsunami");
        double upgradePercent = this.plugin.getConfig().getDouble("Upgrades.Tsunami.TUpgradePercent", 0.5);
        double chancePercent = (double)(currentLevel + 1) * upgradePercent;
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "upgrades.tsunami-upgrade-purchased", "[level]", String.valueOf(currentLevel + 1), "[chance]", String.format("%.1f", chancePercent));
        this.openUpgradeMenu(player);
    }

    public void handleInventoryClose(InventoryCloseEvent event) {
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        FileConfiguration config = this.plugin.getConfigManager().getUpgradesConfig();
        if (config == null) {
            return false;
        }
        String menuTitle = ColorSystem.colorize(config.getString("MrUltimateFishing.Upgrades.title", "Upgrades"));
        if (title.equals(menuTitle)) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    public void cleanupPlayerData(Player player) {
        this.playerUpgrades.remove(player.getUniqueId());
    }

    public void onPlayerJoin(Player player) {
        this.loadPlayerUpgradeData(player);
    }

    public void onPlayerQuit(Player player) {
    }

    public int getPlayerUpgradeLevel(Player player, String upgradeType) {
        Map<String, Integer> upgrades = this.playerUpgrades.get(player.getUniqueId());
        if (upgrades == null) {
            this.loadPlayerUpgradeData(player);
            upgrades = this.playerUpgrades.get(player.getUniqueId());
            if (upgrades == null) {
                return 0;
            }
        }
        int level = upgrades.getOrDefault(upgradeType, 0);
        if (!upgradeType.equals("Tornado") && !upgradeType.equals("Tsunami") || level > 0) {
            // empty if block
        }
        return level;
    }

    public double getXPMultiplier(Player player) {
        Map<String, Integer> upgrades = this.playerUpgrades.get(player.getUniqueId());
        if (upgrades == null) {
            return 1.0;
        }
        int level = upgrades.getOrDefault("XPUpgrade", 0);
        double multiplier = 1.0 + (double)level * 0.1;
        return multiplier;
    }

    public double getFSMultiplier(Player player) {
        Map<String, Integer> upgrades = this.playerUpgrades.get(player.getUniqueId());
        if (upgrades == null) {
            return 1.0;
        }
        int level = upgrades.getOrDefault("FSUpgrade", 0);
        double multiplier = 1.0 + (double)level * 0.1;
        return multiplier;
    }

    public double getFSGMultiplier(Player player) {
        Map<String, Integer> upgrades = this.playerUpgrades.get(player.getUniqueId());
        if (upgrades == null) {
            return 1.0;
        }
        int level = upgrades.getOrDefault("FSGUpgrade", 0);
        double multiplier = 1.0 + (double)level * 0.1;
        return multiplier;
    }
}

