/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.utils;

import eu.mrneznamy.mrultimatefishing.utils.ColorSystem;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionChecker {
    private final JavaPlugin plugin;

    public VersionChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean checkVersion() {
        String version = Bukkit.getVersion();
        String bukkitVersion = Bukkit.getBukkitVersion();
        String versionNumber = this.extractVersionNumber(bukkitVersion);
        if (versionNumber == null || versionNumber.isEmpty()) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&cMrUltimateFishing&8] &cCould not determine server version!"));
            return false;
        }
        if (this.isSupportedVersion(versionNumber)) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aRunning on supported version: " + versionNumber));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrUltimateFishing&8] &aSupported versions: 1.21 - 1.21.8"));
            return true;
        }
        if (this.isOldVersionWithBugs(versionNumber)) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&eMrUltimateFishing&8] &eWarning: Running on older version " + versionNumber));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&eMrUltimateFishing&8] &eThere may be many bugs on this version and no time will be spent on them as they are old and not supported by me."));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&eMrUltimateFishing&8] &eSupported versions: 1.20.x, 1.21 - 1.21.8"));
            return true;
        }
        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&cMrUltimateFishing&8] &cUnsupported server version: " + versionNumber));
        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&cMrUltimateFishing&8] &cSupported versions: 1.20.x, 1.21 - 1.21.8"));
        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&cMrUltimateFishing&8] &cPlugin will be disabled."));
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin));
        return false;
    }

    private String extractVersionNumber(String bukkitVersion) {
        if (bukkitVersion.contains("-")) {
            return bukkitVersion.substring(0, bukkitVersion.indexOf("-"));
        }
        return bukkitVersion;
    }

    private boolean isSupportedVersion(String version) {
        if (version.startsWith("1.21")) {
            if (version.equals("1.21") || version.matches("1\\.21\\.[1-8]")) {
                return true;
            }
            return !version.matches("1\\.21\\.([9-9]|[1-9][0-9]+)");
        }
        return false;
    }

    private boolean isOldVersionWithBugs(String version) {
        return version.startsWith("1.18") || version.startsWith("1.19");
    }
}

