/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.database;

import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import eu.mrneznamy.mrlibcore.database.MrLibDatabaseManager;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FishingDatabaseManager {
    private final MrUltimateFishing plugin;
    private final String storageType;
    private final MrLibDatabase database;

    public FishingDatabaseManager(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.storageType = plugin.getConfig().getString("MrUltimateFishing.Database.Type", "yml").toLowerCase();
        if ("mysql".equals(this.storageType) || "sqlite".equals(this.storageType)) {
            this.database = this.initializeDatabase();
            if (this.database != null) {
                this.createTables();
            }
        } else {
            this.database = null;
        }
    }

    private MrLibDatabase initializeDatabase() {
        FileConfiguration config = this.plugin.getConfig();
        if ("mysql".equals(this.storageType)) {
            String host = config.getString("Database.MySQL.Host", "localhost");
            int port = config.getInt("Database.MySQL.Port", 3306);
            String dbName = config.getString("Database.MySQL.Database", "ultimatefishing");
            String username = config.getString("Database.MySQL.Username", "root");
            String password = config.getString("Database.MySQL.Password", "");
            MrLibDatabase db = MrLibDatabaseManager.registerMySQL((String)this.plugin.getName(), (String)host, (int)port, (String)dbName, (String)username, (String)password);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrUltimateFishing connected to MySQL database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to MySQL! Using YAML instead.");
            return null;
        }
        if ("sqlite".equals(this.storageType)) {
            String fileName = config.getString("Database.SQLite.FileName", "ultimatefishing.db");
            MrLibDatabase db = MrLibDatabaseManager.registerSQLite((JavaPlugin)this.plugin, (String)fileName);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrUltimateFishing connected to SQLite database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to SQLite! Using YAML instead.");
            return null;
        }
        return null;
    }

    private void createTables() {
        if (this.database == null) {
            return;
        }
        this.database.createTable("player_data", "uuid VARCHAR(36) PRIMARY KEY, level INTEGER DEFAULT 1, exp DOUBLE DEFAULT 0.0, fish_scale INTEGER DEFAULT 0, total_fish_caught INTEGER DEFAULT 0");
        this.database.createTable("first_catches", "uuid VARCHAR(36) NOT NULL, fish_name VARCHAR(100) NOT NULL, caught_at BIGINT NOT NULL, PRIMARY KEY (uuid, fish_name)");
        this.database.createTable("fish_stats", "fish_name VARCHAR(100) PRIMARY KEY, total_caught INTEGER DEFAULT 0");
        this.database.createTable("tournament_data", "uuid VARCHAR(36) NOT NULL, tournament_id VARCHAR(100) NOT NULL, score DOUBLE DEFAULT 0.0, PRIMARY KEY (uuid, tournament_id)");
        MrLibConsoleSayer.MrSay_Success((String)"MrUltimateFishing database tables created/verified!");
    }

    public boolean isUsingDatabase() {
        return this.database != null && this.database.isConnected();
    }

    public void close() {
        if (this.database != null) {
            MrLibDatabaseManager.unregister((String)this.plugin.getName());
        }
    }
}

