/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.effects;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TornadoEffect {
    private final MrUltimateFishing plugin;
    private final Map<UUID, ActiveTornado> activeTornados;
    private static final double SPAWN_RADIUS = 5.0;

    public TornadoEffect(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.activeTornados = new HashMap<UUID, ActiveTornado>();
    }

    public boolean spawnTornado(Player player, Location location, int duration) {
        if (!this.isAboveWater(location)) {
            return false;
        }
        for (ActiveTornado tornado : this.activeTornados.values()) {
            if (!tornado.isActive() || !tornado.getLocation().getWorld().equals((Object)location.getWorld()) || !(tornado.getLocation().distance(location) < 5.0)) continue;
            return false;
        }
        this.stopPlayerTornado(player.getUniqueId());
        ActiveTornado tornado = new ActiveTornado(player.getUniqueId(), location, duration);
        this.activeTornados.put(player.getUniqueId(), tornado);
        tornado.startParticleEffect();
        location.getWorld().strikeLightning(location);
        return true;
    }

    public boolean isPlayerInTornado(Player player, Location fishingLocation) {
        ActiveTornado tornado = this.activeTornados.get(player.getUniqueId());
        if (tornado == null || !tornado.isActive()) {
            return false;
        }
        return tornado.getLocation().distance(fishingLocation) <= 5.0;
    }

    public void cleanup() {
        this.activeTornados.entrySet().removeIf(entry -> {
            ActiveTornado tornado = (ActiveTornado)entry.getValue();
            if (!tornado.isActive()) {
                tornado.stop();
                return true;
            }
            return false;
        });
    }

    public void stopPlayerTornado(UUID playerId) {
        ActiveTornado tornado = this.activeTornados.remove(playerId);
        if (tornado != null) {
            tornado.stop();
        }
    }

    public void stopAllTornados() {
        for (ActiveTornado tornado : this.activeTornados.values()) {
            tornado.stop();
        }
        this.activeTornados.clear();
    }

    public boolean hasActiveTornadoNear(Location location, double radius) {
        for (ActiveTornado tornado : this.activeTornados.values()) {
            if (!tornado.isActive() || !tornado.getLocation().getWorld().equals((Object)location.getWorld()) || !(tornado.getLocation().distance(location) < radius)) continue;
            return true;
        }
        return false;
    }

    private boolean isAboveWater(Location location) {
        Location below = location.clone().subtract(0.0, 1.0, 0.0);
        Material blockType = below.getBlock().getType();
        return blockType == Material.WATER;
    }

    private class ActiveTornado {
        private final UUID playerId;
        private final Location location;
        private final long endTime;
        private BukkitTask particleTask;

        public ActiveTornado(UUID playerId, Location location, int durationSeconds) {
            this.playerId = playerId;
            this.location = location;
            this.endTime = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        }

        public void startParticleEffect() {
            this.particleTask = new BukkitRunnable(){
                private int tickCount = 0;
                private final int totalDuration;
                {
                    this.totalDuration = (int)((ActiveTornado.this.endTime - System.currentTimeMillis()) / 50L);
                }

                public void run() {
                    if (!ActiveTornado.this.isActive()) {
                        this.cancel();
                        return;
                    }
                    double progress = Math.min(1.0, (double)this.tickCount / (double)this.totalDuration);
                    double heightProgress = progress <= 0.5 ? progress * 2.0 : 2.0 - progress * 2.0;
                    double maxHeight = 12.0;
                    double currentMaxHeight = heightProgress * maxHeight;
                    double spiralTurns = 3.0;
                    int particlesPerLevel = 8;
                    for (double y = 0.0; y <= currentMaxHeight; y += 0.3) {
                        double spiralProgress = y / maxHeight;
                        double spiralAngle = spiralProgress * spiralTurns * 2.0 * Math.PI + (double)this.tickCount * 0.2;
                        double radius = 2.5 - spiralProgress * 1.8;
                        if (radius < 0.4) {
                            radius = 0.4;
                        }
                        for (int i = 0; i < particlesPerLevel; ++i) {
                            double particleAngle = spiralAngle + (double)i * Math.PI * 2.0 / (double)particlesPerLevel;
                            double x = ActiveTornado.this.location.getX() + radius * Math.cos(particleAngle);
                            double z = ActiveTornado.this.location.getZ() + radius * Math.sin(particleAngle);
                            Location particleLocation = new Location(ActiveTornado.this.location.getWorld(), x, ActiveTornado.this.location.getY() + y, z);
                            ActiveTornado.this.location.getWorld().spawnParticle(Particle.DRIPPING_DRIPSTONE_WATER, particleLocation, 1, 0.1, 0.1, 0.1, 0.0);
                            if (i % 2 != 0) continue;
                            ActiveTornado.this.location.getWorld().spawnParticle(Particle.SPLASH, particleLocation, 1, 0.05, 0.05, 0.05, 0.01);
                        }
                    }
                    double circleRadius = 5.0;
                    int circlePoints = 32;
                    for (int i = 0; i < circlePoints; ++i) {
                        double circleAngle = (double)i * Math.PI * 2.0 / (double)circlePoints + (double)this.tickCount * 0.1;
                        double x = ActiveTornado.this.location.getX() + circleRadius * Math.cos(circleAngle);
                        double z = ActiveTornado.this.location.getZ() + circleRadius * Math.sin(circleAngle);
                        Location circleLocation = new Location(ActiveTornado.this.location.getWorld(), x, ActiveTornado.this.location.getY() + 0.2, z);
                        if (!TornadoEffect.this.isAboveWater(circleLocation)) continue;
                        ActiveTornado.this.location.getWorld().spawnParticle(Particle.DRIPPING_DRIPSTONE_WATER, circleLocation, 2, 0.2, 0.1, 0.2, 0.0);
                        ActiveTornado.this.location.getWorld().spawnParticle(Particle.SPLASH, circleLocation, 1, 0.15, 0.05, 0.15, 0.02);
                    }
                    for (double r = 1.5; r <= 4.5; r += 1.0) {
                        for (double a = 0.0; a < Math.PI * 2; a += 0.19634954084936207) {
                            double x = ActiveTornado.this.location.getX() + r * Math.cos(a + (double)this.tickCount * 0.05);
                            double z = ActiveTornado.this.location.getZ() + r * Math.sin(a + (double)this.tickCount * 0.05);
                            Location ringLocation = new Location(ActiveTornado.this.location.getWorld(), x, ActiveTornado.this.location.getY() + 0.1, z);
                            if (!TornadoEffect.this.isAboveWater(ringLocation)) continue;
                            ActiveTornado.this.location.getWorld().spawnParticle(Particle.SPLASH, ringLocation, 1, 0.1, 0.05, 0.1, 0.01);
                            if (!(r <= 3.0)) continue;
                            ActiveTornado.this.location.getWorld().spawnParticle(Particle.BUBBLE_POP, ringLocation, 1, 0.08, 0.05, 0.08, 0.01);
                        }
                    }
                    ++this.tickCount;
                }
            }.runTaskTimer((Plugin)TornadoEffect.this.plugin, 0L, 1L);
        }

        public boolean isActive() {
            return System.currentTimeMillis() < this.endTime;
        }

        public Location getLocation() {
            return this.location;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public void stop() {
            if (this.particleTask != null && !this.particleTask.isCancelled()) {
                this.particleTask.cancel();
            }
        }
    }
}

