/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.integrations;

import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MrCommunityQuestIntegration {
    private final MrUltimateFishing plugin;
    private boolean isEnabled;

    public MrCommunityQuestIntegration(MrUltimateFishing plugin) {
        this.plugin = plugin;
        boolean bl = this.isEnabled = Bukkit.getPluginManager().getPlugin("MrCommunityQuest") != null;
        if (this.isEnabled) {
            plugin.getLogger().info("MrCommunityQuest integration enabled!");
        }
    }

    public void processFishCatch(Player player, String fishId, String rarity) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processFishCatch", Player.class, String.class, String.class).invoke(listener, player, fishId, rarity);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process fish catch for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processFishGutting(Player player, int fishCount, int fishScales) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processFishGutting", Player.class, Integer.TYPE, Integer.TYPE).invoke(listener, player, fishCount, fishScales);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process fish gutting for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processFishSelling(Player player, int fishCount, double moneyEarned) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processFishSelling", Player.class, Integer.TYPE, Double.TYPE).invoke(listener, player, fishCount, moneyEarned);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process fish selling for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processTotemActivation(Player player) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processTotemActivation", Player.class).invoke(listener, player);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process totem activation for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processEnchantCrafting(Player player, String enchantName) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processEnchantCrafting", Player.class, String.class).invoke(listener, player, enchantName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process enchant crafting for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processEnchantApplication(Player player, String enchantName) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processEnchantApplication", Player.class, String.class).invoke(listener, player, enchantName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process enchant application for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processProcessUpgrade(Player player, String upgradeType) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processProcessUpgrade", Player.class, String.class).invoke(listener, player, upgradeType);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process process upgrade for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processFishScalesEarning(Player player, int amount) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processFishScalesEarning", Player.class, Integer.TYPE).invoke(listener, player, amount);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process fish scales earning for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processFishLevelEarning(Player player, int levels) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processFishLevelEarning", Player.class, Integer.TYPE).invoke(listener, player, levels);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process fish level earning for MrCommunityQuest: " + e.getMessage());
        }
    }

    public void processSpecificFishCatch(Player player, String fishId) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateFishingListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                return;
            }
            listener.getClass().getMethod("processSpecificFishCatch", Player.class, String.class).invoke(listener, player, fishId);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process specific fish catch for MrCommunityQuest: " + e.getMessage());
        }
    }
}

