/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.FishItem;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.BoosterManager;
import eu.mrneznamy.mrultimatefishing.managers.TournamentManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GuttingMenuManager
extends BaseMenuManager {
    private final MrUltimateFishing plugin;
    private final MessageManager messageManager;
    private final MrLibVaultManager vaultManager;
    private final PlayerDataManager playerDataManager;
    private final Map<Player, Inventory> guttingInventories;

    public GuttingMenuManager(MrUltimateFishing plugin, MessageManager messageManager, MrLibVaultManager vaultManager) {
        super(plugin);
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.vaultManager = vaultManager;
        this.playerDataManager = plugin.getPlayerDataManager();
        this.guttingInventories = new HashMap<Player, Inventory>();
    }

    public void openGuttingMenu(Player player) {
        FileConfiguration config = this.plugin.getConfigManager().getGuttingConfig();
        if (config == null) {
            this.messageManager.sendMessage((CommandSender)player, "menu-not-found");
            return;
        }
        ConfigurationSection guttingSection = config.getConfigurationSection("MrUltimateFishing.Gutting");
        if (guttingSection == null) {
            this.messageManager.sendMessage((CommandSender)player, "menu-not-found");
            return;
        }
        String title = MrLibColors.colorize((String)guttingSection.getString("title", "Gutting"));
        int size = guttingSection.getInt("size", 54);
        Inventory inventory = this.createInventory(title, "gutting", size);
        ConfigurationSection decorationsSection = guttingSection.getConfigurationSection("decorations");
        this.addDecorations(inventory, decorationsSection);
        this.addItems(inventory, guttingSection);
        this.addNavigationKeys(inventory, guttingSection, player, 0);
        this.guttingInventories.put(player, inventory);
        player.openInventory(inventory);
    }

    public void handleInventoryClick(InventoryClickEvent event) {
        ItemStack item;
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        if (!this.guttingInventories.containsKey(player)) {
            return;
        }
        if (clickedInventory == null) {
            return;
        }
        if (clickedInventory.equals((Object)this.guttingInventories.get(player))) {
            int slot = event.getSlot();
            if (this.isReservedSlot(slot)) {
                String identifier;
                event.setCancelled(true);
                if (this.isNavigationItem(event.getCurrentItem()) && "back".equals(identifier = this.getNavigationIdentifier(event.getCurrentItem()))) {
                    player.closeInventory();
                    this.plugin.getMenuManager().openHeadMenu(player);
                }
                return;
            }
            ItemStack cursorItem = event.getCursor();
            if (cursorItem != null && cursorItem.getType() != Material.AIR && !this.isFish(cursorItem)) {
                event.setCancelled(true);
                this.messageManager.sendMessage((CommandSender)player, "gutting.only-fish");
                return;
            }
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem != null && clickedItem.getType() != Material.AIR && !this.isFish(clickedItem)) {
                event.setCancelled(true);
                return;
            }
        } else if (clickedInventory.equals((Object)player.getInventory()) && event.isShiftClick() && (item = event.getCurrentItem()) != null && item.getType() != Material.AIR && !this.isFish(item)) {
            event.setCancelled(true);
            return;
        }
    }

    public void handleInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Inventory inventory = event.getInventory();
        if (!this.guttingInventories.containsKey(player)) {
            return;
        }
        if (inventory.equals((Object)this.guttingInventories.get(player))) {
            this.gutAllFish(player, inventory);
            this.guttingInventories.remove(player);
        }
    }

    private boolean isFish(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        if (this.isFishWithNBT(item)) {
            return true;
        }
        boolean isVanilla = this.isVanillaFish(item);
        return isVanilla;
    }

    private boolean isFishWithNBT(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return FishItem.isCustomFish(item);
    }

    private boolean isVanillaFish(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        Material type = item.getType();
        boolean result = type == Material.COD || type == Material.SALMON || type == Material.TROPICAL_FISH || type == Material.PUFFERFISH;
        return result;
    }

    private int getFishGuttingValue(ItemStack item) {
        if (!this.isFish(item)) {
            return 0;
        }
        if (FishItem.isCustomFish(item)) {
            String fishId = FishItem.getFishId(item);
            String fishRarity = FishItem.getFishRarity(item);
            if (fishRarity != null) {
                return this.plugin.getConfigManager().getRarityGuttingValue(fishRarity);
            }
        }
        if (this.isVanillaFish(item)) {
            return this.plugin.getConfigManager().getVanillaFishGuttingValue();
        }
        return 0;
    }

    public void gutAllFish(Player player, Inventory guttingInventory) {
        int totalScales = 0;
        int fishCount = 0;
        ArrayList<ItemStack> nonFishItems = new ArrayList<ItemStack>();
        for (int i = 0; i < guttingInventory.getSize(); ++i) {
            ItemStack item = guttingInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            boolean isDecoration = this.isDecorationSlot(i);
            boolean isNavigation = this.isNavigationItem(item);
            if (!isDecoration && !isNavigation) {
                if (this.isFish(item)) {
                    int scalesPerFish = this.getFishGuttingValue(item);
                    int itemAmount = item.getAmount();
                    totalScales += scalesPerFish * itemAmount;
                    fishCount += itemAmount;
                    guttingInventory.setItem(i, null);
                    continue;
                }
                nonFishItems.add(item.clone());
                guttingInventory.setItem(i, null);
                continue;
            }
            if (!isNavigation) continue;
            guttingInventory.setItem(i, null);
        }
        int finalScales = totalScales;
        int bonusScales = 0;
        if (totalScales > 0) {
            double guttingMultiplier = this.plugin.getMenuManager().getUpgradeMenuManager().getFSGUpgradeMultiplier(player);
            MrUltimateFishing mrPlugin = this.plugin;
            double eventMultiplier = mrPlugin.getFishingManager().getGutBoostMultiplier();
            double boosterGutMultiplier = mrPlugin.getBoosterManager().getBoosterMultiplier(player, BoosterManager.BoosterType.GUTBOOST);
            finalScales = (int)((double)totalScales * guttingMultiplier * eventMultiplier * boosterGutMultiplier);
            bonusScales = finalScales - totalScales;
        }
        if (finalScales > 0) {
            this.playerDataManager.addFishScale(player, finalScales);
        }
        for (ItemStack item : nonFishItems) {
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
            for (ItemStack leftoverItem : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), leftoverItem);
            }
        }
        if (fishCount > 0) {
            double boosterGutMultiplier;
            double eventMultiplier;
            MrUltimateFishing mrPlugin = this.plugin;
            mrPlugin.getTournamentManager().onPlayerAction(player, TournamentManager.TournamentType.MOSTGUTTEDFISHES, "", fishCount);
            mrPlugin.getCommunityQuestIntegration().processFishGutting(player, fishCount, finalScales);
            mrPlugin.getCommunityQuestIntegration().processFishScalesEarning(player, finalScales);
            this.messageManager.sendMessage((CommandSender)player, "gutting.success", "{fish_count}", String.valueOf(fishCount), "{scales_count}", String.valueOf(totalScales));
            if (bonusScales > 0) {
                this.messageManager.sendMessage((CommandSender)player, "gutting.bonus-scales", "{bonus_scales}", String.valueOf(bonusScales));
            }
            if ((eventMultiplier = mrPlugin.getFishingManager().getGutBoostMultiplier()) > 1.0) {
                String bonusMessage = this.plugin.getMessageManager().getMessage("gutting.event-bonus").replace("{multiplier}", String.format("%.1f", eventMultiplier));
                this.plugin.sendMessage(player, bonusMessage);
            }
            if ((boosterGutMultiplier = mrPlugin.getBoosterManager().getBoosterMultiplier(player, BoosterManager.BoosterType.GUTBOOST)) > 1.0) {
                String boosterMessage = this.plugin.getMessageManager().getMessage("gutting.booster-bonus").replace("{multiplier}", String.format("%.1f", boosterGutMultiplier));
                this.plugin.sendMessage(player, boosterMessage);
            }
        } else {
            this.messageManager.sendMessage((CommandSender)player, "gutting.no-fish");
        }
    }

    public void cleanupPlayerData(Player player) {
        if (this.guttingInventories.containsKey(player)) {
            Inventory inventory = this.guttingInventories.get(player);
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType() == Material.AIR || this.isDecorationSlot(i)) continue;
                HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                for (ItemStack leftoverItem : leftover.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), leftoverItem);
                }
            }
            this.guttingInventories.remove(player);
        }
    }

    private boolean isReservedSlot(int slot) {
        ConfigurationSection itemsSection;
        ConfigurationSection keysSection;
        FileConfiguration config = this.plugin.getConfigManager().getGuttingConfig();
        if (config == null) {
            return false;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.Gutting");
        if (menuSection == null) {
            return false;
        }
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            for (Object decorationKey : decorationsSection.getKeys(false)) {
                List<Integer> decorationSlots;
                String slotsStr;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection((String)decorationKey);
                if (decorationSection == null || (slotsStr = decorationSection.getString("slots")) == null || !(decorationSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        if ((keysSection = menuSection.getConfigurationSection("keys")) != null) {
            for (String keyKey : keysSection.getKeys(false)) {
                List<Integer> keySlots;
                String slotsStr;
                ConfigurationSection keySection = keysSection.getConfigurationSection(keyKey);
                if (keySection == null || (slotsStr = keySection.getString("slots")) == null || !(keySlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                List<Integer> itemSlots;
                String slotsStr;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null || (slotsStr = itemSection.getString("slots")) == null || !(itemSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDecorationSlot(int slot) {
        ConfigurationSection itemsSection;
        FileConfiguration config = this.plugin.getConfigManager().getGuttingConfig();
        if (config == null) {
            return false;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.Gutting");
        if (menuSection == null) {
            return false;
        }
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            for (String decorationKey : decorationsSection.getKeys(false)) {
                List<Integer> decorationSlots;
                String slotsStr;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection(decorationKey);
                if (decorationSection == null || (slotsStr = decorationSection.getString("slots")) == null || !(decorationSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                List<Integer> itemSlots;
                String slotsStr;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null || (slotsStr = itemSection.getString("slots")) == null || !(itemSlots = this.parseSlots(slotsStr)).contains(slot)) continue;
                return true;
            }
        }
        return false;
    }

    public void handleGutButtonClick(Player player, Inventory inventory) {
        this.gutAllFish(player, inventory);
    }

    public boolean canPlaceItem(ItemStack item, int slot) {
        if (this.isReservedSlot(slot)) {
            return false;
        }
        boolean canPlace = this.isFish(item);
        return canPlace;
    }

    public int getFishCount(Inventory inventory) {
        int count = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR || this.isDecorationSlot(i) || !this.isFish(item)) continue;
            count += item.getAmount();
        }
        return count;
    }

    public int getTotalScalesValue(Inventory inventory) {
        int totalScales = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR || this.isDecorationSlot(i) || !this.isFish(item)) continue;
            int scalesPerFish = this.getFishGuttingValue(item);
            totalScales += scalesPerFish * item.getAmount();
        }
        return totalScales;
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection menuSection, Player player, int page) {
        ConfigurationSection keysSection = menuSection.getConfigurationSection("keys");
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            String type;
            ConfigurationSection keySection = keysSection.getConfigurationSection(key);
            if (keySection == null || (type = keySection.getString("type")) == null) continue;
            String slotsStr = keySection.getString("slots", "");
            List<Integer> slots = this.parseSlots(slotsStr);
            for (int slot : slots) {
                ItemStack keyItem;
                if (slot < 0 || slot >= inventory.getSize() || (keyItem = this.createNavigationKeyItem(keySection, type, player, page)) == null) continue;
                inventory.setItem(slot, keyItem);
            }
        }
    }

    private ItemStack createNavigationKeyItem(ConfigurationSection keySection, String keyType, Player player, int page) {
        ArrayList<String> lore;
        String displayName;
        String type = keySection.getString("type", keyType);
        FileConfiguration messagesConfig = this.plugin.getMessageManager().getMessagesConfig();
        if (messagesConfig == null) {
            ItemStack fallbackItem;
            FileConfiguration config = this.plugin.getConfigManager().getGuttingConfig();
            if (config != null) {
                ConfigurationSection fallbackSection = config.getConfigurationSection("MrUltimateFishing.Gutting.fallback-navigation");
                if (fallbackSection != null) {
                    String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                    String fallbackName = fallbackSection.getString("display-name", "Navigation");
                    List fallbackLore = fallbackSection.getStringList("lore");
                    fallbackItem = this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
                } else {
                    fallbackItem = this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
                }
            } else {
                fallbackItem = this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
            }
            ItemMeta meta = fallbackItem.getItemMeta();
            if (meta != null) {
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey actionKey = new NamespacedKey((Plugin)this.plugin, "action");
                dataContainer.set(actionKey, PersistentDataType.STRING, (Object)type);
                fallbackItem.setItemMeta(meta);
            }
            return fallbackItem;
        }
        ConfigurationSection menuKeysSection = messagesConfig.getConfigurationSection("MrUltimateFishing.menu-keys");
        if (menuKeysSection == null) {
            ItemStack fallbackItem;
            FileConfiguration config = this.plugin.getConfigManager().getGuttingConfig();
            if (config != null) {
                ConfigurationSection fallbackSection = config.getConfigurationSection("MrUltimateFishing.Gutting.fallback-navigation");
                if (fallbackSection != null) {
                    String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                    String fallbackName = fallbackSection.getString("display-name", "Navigation");
                    List fallbackLore = fallbackSection.getStringList("lore");
                    fallbackItem = this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
                } else {
                    fallbackItem = this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
                }
            } else {
                fallbackItem = this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
            }
            ItemMeta meta = fallbackItem.getItemMeta();
            if (meta != null) {
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey actionKey = new NamespacedKey((Plugin)this.plugin, "action");
                dataContainer.set(actionKey, PersistentDataType.STRING, (Object)type);
                fallbackItem.setItemMeta(meta);
            }
            return fallbackItem;
        }
        ConfigurationSection itemSection = menuKeysSection.getConfigurationSection(type);
        if (itemSection == null) {
            ItemStack fallbackItem;
            FileConfiguration config = this.plugin.getConfigManager().getGuttingConfig();
            if (config != null) {
                ConfigurationSection fallbackSection = config.getConfigurationSection("MrUltimateFishing.Gutting.fallback-navigation");
                if (fallbackSection != null) {
                    String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                    String fallbackName = fallbackSection.getString("display-name", "Navigation");
                    List fallbackLore = fallbackSection.getStringList("lore");
                    fallbackItem = this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
                } else {
                    fallbackItem = this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
                }
            } else {
                fallbackItem = this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
            }
            ItemMeta meta = fallbackItem.getItemMeta();
            if (meta != null) {
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey actionKey = new NamespacedKey((Plugin)this.plugin, "action");
                dataContainer.set(actionKey, PersistentDataType.STRING, (Object)type);
                fallbackItem.setItemMeta(meta);
            }
            return fallbackItem;
        }
        String material = itemSection.getString("material", "ARROW").toUpperCase();
        ItemStack finalItem = this.createMenuItem(material, displayName = itemSection.getString("display-name", ""), lore = new ArrayList<String>(itemSection.getStringList("lore")), false);
        ItemMeta meta = finalItem.getItemMeta();
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
            dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
            finalItem.setItemMeta(meta);
        }
        return finalItem;
    }
}

