/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrlibcore.MrLibRegisterPlugin;
import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrlibcore.holograms.MrLibHologramManager;
import eu.mrneznamy.mrlibcore.messages.MrLibMessage;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.CustomDropsManager;
import eu.mrneznamy.mrultimatefishing.FishingManager;
import eu.mrneznamy.mrultimatefishing.FishingRodListener;
import eu.mrneznamy.mrultimatefishing.MenuManager;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.PlayerListener;
import eu.mrneznamy.mrultimatefishing.commands.FishCommand;
import eu.mrneznamy.mrultimatefishing.commands.MufCommand;
import eu.mrneznamy.mrultimatefishing.database.FishingDatabaseManager;
import eu.mrneznamy.mrultimatefishing.integrations.MrCommunityQuestIntegration;
import eu.mrneznamy.mrultimatefishing.integrations.PlaceholderAPIIntegration;
import eu.mrneznamy.mrultimatefishing.listeners.EnchantApplyListener;
import eu.mrneznamy.mrultimatefishing.listeners.FishScalesBundleListener;
import eu.mrneznamy.mrultimatefishing.managers.BoosterManager;
import eu.mrneznamy.mrultimatefishing.managers.EnchantManager;
import eu.mrneznamy.mrultimatefishing.managers.EventManager;
import eu.mrneznamy.mrultimatefishing.managers.RarityMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.RecipeMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.ShopMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.TotemManager;
import eu.mrneznamy.mrultimatefishing.managers.TournamentManager;
import eu.mrneznamy.mrultimatefishing.managers.UpgradeMenuManager;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MrUltimateFishing
extends JavaPlugin {
    private MessageManager messageManager;
    private MrLibMessage messageSystem;
    private ConfigManager configManager;
    private FishingManager fishingManager;
    private PlayerDataManager playerDataManager;
    private FishingDatabaseManager databaseManager;
    private MenuManager menuManager;
    private UpgradeMenuManager upgradeMenuManager;
    private CustomDropsManager customDropsManager;
    private EnchantManager enchantManager;
    private RecipeMenuManager recipeMenuManager;
    private RarityMenuManager rarityMenuManager;
    private MrLibHologramManager hologramManager;
    private TotemManager totemManager;
    private ShopMenuManager shopMenuManager;
    private TournamentManager tournamentManager;
    private EventManager eventManager;
    private BoosterManager boosterManager;
    private MrCommunityQuestIntegration communityQuestIntegration;

    public void onEnable() {
        if (this.getServer().getPluginManager().getPlugin("MrLibCore") == null) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("MrUltimateFishing requires MrLibCore to run!");
            this.getLogger().severe("Please download MrLibCore from:");
            this.getLogger().severe("https://modrinth.com/plugin/mrlibcore");
            this.getLogger().severe("========================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.createMenuFiles();
        this.messageManager = new MessageManager(this);
        this.messageSystem = new MrLibMessage((JavaPlugin)this);
        this.configManager = new ConfigManager(this, this.messageManager);
        this.databaseManager = new FishingDatabaseManager(this);
        this.hologramManager = MrLibHologramManager.getInstance();
        String provider = this.getConfig().getString("MrUltimateFishing.HologramProvider", "MrLibCore");
        if (("MrLibCore".equals(provider) || "DecentHolograms".equals(provider) || "CMI".equals(provider) || "CMIHolograms".equals(provider)) && !this.hologramManager.setProvider(provider)) {
            this.getLogger().warning("Failed to set hologram provider: " + provider + ". Using default provider.");
        }
        this.playerDataManager = new PlayerDataManager(this, this.configManager, this.messageManager, MrLibVaultManager.getInstance());
        this.fishingManager = new FishingManager(this, this.configManager, this.messageManager);
        this.upgradeMenuManager = new UpgradeMenuManager(this);
        this.customDropsManager = new CustomDropsManager(this, this.configManager, this.messageManager);
        this.enchantManager = new EnchantManager(this);
        this.recipeMenuManager = new RecipeMenuManager(this);
        this.rarityMenuManager = new RarityMenuManager(this);
        this.totemManager = new TotemManager(this);
        this.shopMenuManager = new ShopMenuManager(this);
        this.tournamentManager = new TournamentManager(this);
        this.eventManager = new EventManager(this);
        this.boosterManager = new BoosterManager(this);
        this.menuManager = new MenuManager(this, this.messageManager, MrLibVaultManager.getInstance());
        this.communityQuestIntegration = new MrCommunityQuestIntegration(this);
        MufCommand mufCommand = new MufCommand(this, this.messageManager, this.configManager, this.customDropsManager);
        this.getCommand("muf").setExecutor((CommandExecutor)mufCommand);
        this.getCommand("muf").setTabCompleter((TabCompleter)mufCommand);
        FishCommand fishCommand = new FishCommand(this, this.messageManager, this.configManager, this.customDropsManager);
        this.getCommand("fish").setExecutor((CommandExecutor)fishCommand);
        this.getCommand("fish").setTabCompleter((TabCompleter)fishCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.playerDataManager, this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.fishingManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.menuManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.rarityMenuManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FishingRodListener(this, this.menuManager, this.messageManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.customDropsManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantApplyListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FishScalesBundleListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.totemManager, (Plugin)this);
        this.loadOnlinePlayersData();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new PlaceholderAPIIntegration(this).register();
                MrLibConsoleSayer.MrSay_Success((String)"PlaceholderAPI integration enabled!");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to enable PlaceholderAPI integration: " + e.getMessage());
            }
        }
        MrLibRegisterPlugin.register((JavaPlugin)this, (String)"mrultimatefishing");
        String hologramProvider = this.getConfig().getString("MrUltimateFishing.HologramProvider", "DecentHolograms");
        MrLibConsoleSayer.MrSay_Success((String)("Hologram Provider: " + hologramProvider));
        this.registerHelpCommands();
        MrLibConsoleSayer.MrSay_Success((String)"MrUltimateFishing enabled!");
    }

    private void registerHelpCommands() {
        ArrayList<MrLibHelper.CommandInfo> commands = new ArrayList<MrLibHelper.CommandInfo>();
        commands.add(new MrLibHelper.CommandInfo("/fish", "Open the fishing menu", "/fish"));
        commands.add(new MrLibHelper.CommandInfo("/muf reload", "Reload plugin configuration", "/muf reload"));
        commands.add(new MrLibHelper.CommandInfo("/muf give <type> <item> <player> [amount]", "Give fishing items to players", "/muf give fish salmon Player123 5"));
        commands.add(new MrLibHelper.CommandInfo("/muf tournament <start|end|status> [id]", "Manage fishing tournaments", "/muf tournament start weekly_1"));
        commands.add(new MrLibHelper.CommandInfo("/muf event <start|end|status> [id]", "Manage fishing events", "/muf event start daily_bonus"));
        commands.add(new MrLibHelper.CommandInfo("/muf help [plugin] [page]", "Show help for registered plugins", "/muf help MrUltimateFishing 1"));
        MrLibHelper.registerPluginCommands((JavaPlugin)this, (String)"MrUltimateFishing", commands);
    }

    public void onDisable() {
        if (this.fishingManager != null) {
            this.fishingManager.disable();
        }
        if (this.playerDataManager != null) {
            this.playerDataManager.disable();
        }
        if (this.totemManager != null) {
            this.totemManager.shutdown();
        }
        if (this.tournamentManager != null) {
            this.tournamentManager.shutdown();
        }
        if (this.eventManager != null) {
            this.eventManager.shutdown();
        }
        if (this.boosterManager != null) {
            this.boosterManager.shutdown();
        }
        if (this.hologramManager != null) {
            this.hologramManager.cleanupAllHolograms();
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public MrLibMessage getMessageSystem() {
        return this.messageSystem;
    }

    public void sendMessage(Player player, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (message.contains("(!message!)")) {
            return;
        }
        if (message.contains("(!NOPREFIX!)")) {
            message = message.replace("(!NOPREFIX!)", "");
            String prefix = this.getPrefix();
            if (prefix != null && !prefix.isEmpty()) {
                message = message.replace(prefix, "").trim();
            }
        }
        this.messageSystem.send(player, message);
    }

    public String getPrefix() {
        String prefix = this.messageManager.getMessage("Prefix");
        if (prefix != null && !prefix.isEmpty() && !prefix.contains("Message not found")) {
            return MrLibColors.colorize((String)prefix);
        }
        return MrLibColors.colorize((String)"{#ffde59>}&lMrUltimateFishing{#ffbd59<} &8|");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public MrLibVaultManager getVaultManager() {
        return MrLibVaultManager.getInstance();
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public UpgradeMenuManager getUpgradeMenuManager() {
        return this.upgradeMenuManager;
    }

    public MrLibVaultManager getEconomy() {
        return MrLibVaultManager.getInstance();
    }

    public EnchantManager getEnchantManager() {
        return this.enchantManager;
    }

    public RecipeMenuManager getRecipeMenuManager() {
        return this.recipeMenuManager;
    }

    public RarityMenuManager getRarityMenuManager() {
        return this.rarityMenuManager;
    }

    public MrLibHologramManager getHologramManager() {
        return this.hologramManager;
    }

    public TotemManager getTotemManager() {
        return this.totemManager;
    }

    public ShopMenuManager getShopMenuManager() {
        return this.shopMenuManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public TournamentManager getTournamentManager() {
        return this.tournamentManager;
    }

    public FishingManager getFishingManager() {
        return this.fishingManager;
    }

    public BoosterManager getBoosterManager() {
        return this.boosterManager;
    }

    public ConfigurationSection getMenuConfig(String menuName) {
        File menuFile = new File(this.getDataFolder(), "Menus/" + menuName + ".yml");
        if (!menuFile.exists()) {
            return null;
        }
        YamlConfiguration menuConfig = YamlConfiguration.loadConfiguration((File)menuFile);
        return menuConfig.getConfigurationSection("MrUltimateFishing." + this.capitalize(menuName));
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void createMenuFiles() {
        File menusFolder = new File(this.getDataFolder(), "Menus");
        if (!menusFolder.exists() && !menusFolder.mkdirs()) {
            return;
        }
    }

    private void loadOnlinePlayersData() {
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            for (Player player : this.getServer().getOnlinePlayers()) {
                try {
                    this.playerDataManager.onPlayerJoin(player);
                    this.upgradeMenuManager.onPlayerJoin(player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 20L);
    }

    public MrCommunityQuestIntegration getCommunityQuestIntegration() {
        return this.communityQuestIntegration;
    }

    public void executeRewardCommand(Player player, String command) {
        String processedCommand = command.replace("[PlayerName]", player.getName()).replace("[player]", player.getName());
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            try {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand);
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error((String)("Error executing reward command '" + processedCommand + "': " + e.getMessage()));
            }
        });
    }
}

