/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class BaseMenuManager {
    protected final MrUltimateFishing plugin;
    protected final Map<String, String> menuTitleSuffixes = new HashMap<String, String>();

    public BaseMenuManager(MrUltimateFishing plugin) {
        this.plugin = plugin;
    }

    protected ItemStack createMenuItem(ConfigurationSection section) {
        Material material;
        if (section == null) {
            return new ItemStack(Material.STONE);
        }
        String materialName = section.getString("material", "STONE");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            FileConfiguration config;
            String fallbackMaterial = "STONE";
            if (this.plugin != null && this.plugin.getConfigManager() != null && (config = this.plugin.getConfigManager().getMainConfig()) != null) {
                fallbackMaterial = config.getString("fallback.material", "STONE");
            }
            try {
                material = Material.valueOf((String)fallbackMaterial.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                material = Material.STONE;
            }
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            boolean glowing;
            ConfigurationSection customModelData;
            String displayName = section.getString("display-name");
            if (displayName != null) {
                meta.setDisplayName(MrLibColors.colorize((String)displayName));
            }
            List lore = section.getStringList("lore");
            ArrayList<String> coloredLore = new ArrayList<String>();
            if (!lore.isEmpty()) {
                for (String line : lore) {
                    coloredLore.add(MrLibColors.colorize((String)line));
                }
            }
            String action = section.getString("action");
            String actionClick = section.getString("actionclick");
            if (!coloredLore.isEmpty()) {
                meta.setLore(coloredLore);
            }
            if (action != null || actionClick != null) {
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                if (action != null) {
                    NamespacedKey actionKey = new NamespacedKey((Plugin)this.plugin, "action");
                    dataContainer.set(actionKey, PersistentDataType.STRING, (Object)action);
                }
                if (actionClick != null) {
                    NamespacedKey actionClickKey = new NamespacedKey((Plugin)this.plugin, "actionclick");
                    dataContainer.set(actionClickKey, PersistentDataType.STRING, (Object)actionClick);
                }
            }
            if ((customModelData = section.getConfigurationSection("custom-model-data")) != null && customModelData.getBoolean("enabled", false)) {
                meta.setCustomModelData(Integer.valueOf(customModelData.getInt("value", 0)));
            }
            if (glowing = section.getBoolean("glowing", false)) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    protected ItemStack createMenuItem(String materialName, String displayName, List<String> lore, boolean hasGlow) {
        Material material;
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(MrLibColors.colorize((String)displayName));
            }
            if (lore != null && !lore.isEmpty()) {
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(MrLibColors.colorize((String)line));
                }
                meta.setLore(coloredLore);
            }
            if (hasGlow) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    protected List<Integer> parseSlots(String slotsStr) {
        String[] parts;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (slotsStr == null || slotsStr.trim().isEmpty()) {
            return slots;
        }
        for (String part : parts = slotsStr.split(",")) {
            if ((part = part.trim()).contains("-")) {
                String[] range = part.split("-");
                try {
                    int start = Integer.parseInt(range[0].trim());
                    int end = Integer.parseInt(range[1].trim());
                    for (int i = start; i <= end; ++i) {
                        slots.add(i);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            try {
                slots.add(Integer.parseInt(part));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    protected void addDecorations(Inventory inventory, ConfigurationSection decorationsSection) {
        if (decorationsSection == null) {
            return;
        }
        HashSet<Integer> occupiedSlots = new HashSet<Integer>();
        for (String key : decorationsSection.getKeys(false)) {
            int slot;
            ConfigurationSection decoration = decorationsSection.getConfigurationSection(key);
            if (decoration == null) continue;
            String material = decoration.getString("material", "STONE");
            String displayName = decoration.getString("display-name", "");
            String slots = decoration.getString("slots", "");
            List lore = decoration.getStringList("lore");
            boolean hasGlow = false;
            List<Object> glowingSlots = new ArrayList<Integer>();
            Object glowingSetting = decoration.get("glowing");
            if (glowingSetting != null) {
                if (glowingSetting instanceof Boolean) {
                    hasGlow = (Boolean)glowingSetting;
                } else if (glowingSetting instanceof String) {
                    String glowingStr = (String)glowingSetting;
                    if ("true".equalsIgnoreCase(glowingStr)) {
                        hasGlow = true;
                    } else if ("false".equalsIgnoreCase(glowingStr)) {
                        hasGlow = false;
                    } else {
                        glowingSlots = this.parseSlots(glowingStr);
                    }
                } else if (glowingSetting instanceof Number) {
                    glowingSlots.add(((Number)glowingSetting).intValue());
                }
            }
            ItemStack regularItem = this.createMenuItem(material, displayName, lore, false);
            ItemStack glowingItem = this.createMenuItem(material, displayName, lore, true);
            List<Integer> regularSlots = this.parseSlots(slots);
            Iterator<Object> iterator = regularSlots.iterator();
            while (iterator.hasNext()) {
                slot = iterator.next();
                if (slot < 0 || slot >= inventory.getSize() || occupiedSlots.contains(slot)) continue;
                boolean shouldGlow = hasGlow || glowingSlots.contains(slot);
                ItemStack itemToPlace = shouldGlow ? glowingItem : regularItem;
                inventory.setItem(slot, itemToPlace);
                occupiedSlots.add(slot);
            }
            iterator = glowingSlots.iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                if (slot < 0 || slot >= inventory.getSize() || regularSlots.contains(slot) || occupiedSlots.contains(slot)) continue;
                inventory.setItem(slot, glowingItem);
                occupiedSlots.add(slot);
            }
        }
    }

    protected void addItems(Inventory inventory, ConfigurationSection menuSection) {
        ConfigurationSection items = menuSection.getConfigurationSection("items");
        if (items == null) {
            return;
        }
        for (String key : items.getKeys(false)) {
            ConfigurationSection item = items.getConfigurationSection(key);
            if (item == null) continue;
            ItemStack menuItem = this.createMenuItem(item);
            List<Object> slots = new ArrayList<Integer>();
            Object slotsObj = item.get("slots");
            if (slotsObj != null) {
                if (slotsObj instanceof String) {
                    slots = this.parseSlots((String)slotsObj);
                } else if (slotsObj instanceof Number) {
                    slots.add(((Number)slotsObj).intValue());
                } else if (slotsObj instanceof List) {
                    List slotsList = (List)slotsObj;
                    for (Object slotObj : slotsList) {
                        if (!(slotObj instanceof Number)) continue;
                        slots.add(((Number)slotObj).intValue());
                    }
                }
            } else {
                int slot = item.getInt("slot", -1);
                if (slot >= 0) {
                    slots.add(slot);
                }
            }
            Iterator<Object> iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= inventory.getSize()) continue;
                ItemStack existingItem = inventory.getItem(slot);
                if (existingItem != null && existingItem.getType() != Material.AIR && existingItem.hasItemMeta() && existingItem.getItemMeta().hasDisplayName()) {
                    String string = existingItem.getItemMeta().getDisplayName();
                }
                inventory.setItem(slot, menuItem);
            }
        }
    }

    protected String generateRandomColorSuffix() {
        String[] colors = new String[]{"&a", "&b", "&c", "&d", "&e", "&f", "&1", "&2", "&3", "&4", "&5", "&6", "&9"};
        String randomColor = colors[ThreadLocalRandom.current().nextInt(colors.length)];
        return randomColor;
    }

    protected Inventory createInventory(String baseTitle, String menuType, int size) {
        String colorSuffix = this.menuTitleSuffixes.getOrDefault(menuType, "");
        String title = MrLibColors.colorize((String)(baseTitle + colorSuffix));
        return Bukkit.createInventory(null, (int)size, (String)title);
    }

    protected boolean isNavigationItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
        return dataContainer.has(navigationKey, PersistentDataType.STRING);
    }

    protected String getNavigationIdentifier(ItemStack item) {
        NamespacedKey navigationKey;
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (dataContainer.has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
            return (String)dataContainer.get(navigationKey, PersistentDataType.STRING);
        }
        return null;
    }

    protected void addBackButton(Inventory inventory, ConfigurationSection menuSection) {
        ConfigurationSection keysSection = menuSection.getConfigurationSection("keys");
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            String type;
            ConfigurationSection keyConfig = keysSection.getConfigurationSection(key);
            if (keyConfig == null || !"back".equalsIgnoreCase(type = keyConfig.getString("type", ""))) continue;
            String slots = keyConfig.getString("slots", "");
            ConfigurationSection backConfig = this.plugin.getMessageManager().getMessagesConfig().getConfigurationSection("menu-keys.back");
            if (backConfig != null) {
                NamespacedKey actionKey;
                ItemStack backItem = this.createMenuItem(backConfig);
                ItemMeta meta = backItem.getItemMeta();
                if (meta != null) {
                    PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                    actionKey = new NamespacedKey((Plugin)this.plugin, "action");
                    dataContainer.set(actionKey, PersistentDataType.STRING, (Object)"back");
                    backItem.setItemMeta(meta);
                }
                List<Integer> backSlots = this.parseSlots(slots);
                actionKey = backSlots.iterator();
                while (actionKey.hasNext()) {
                    int slot = (Integer)actionKey.next();
                    if (slot < 0 || slot >= inventory.getSize()) continue;
                    inventory.setItem(slot, backItem);
                }
            } else {
                List lore;
                String displayName;
                String material = keyConfig.getString("material", "ARROW");
                ItemStack backItem = this.createMenuItem(material, displayName = keyConfig.getString("display-name", "&cBack"), lore = keyConfig.getStringList("lore"), false);
                ItemMeta meta = backItem.getItemMeta();
                if (meta != null) {
                    PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                    NamespacedKey actionKey = new NamespacedKey((Plugin)this.plugin, "action");
                    dataContainer.set(actionKey, PersistentDataType.STRING, (Object)"back");
                    backItem.setItemMeta(meta);
                }
                List<Integer> backSlots = this.parseSlots(slots);
                for (int slot : backSlots) {
                    if (slot < 0 || slot >= inventory.getSize()) continue;
                    inventory.setItem(slot, backItem);
                }
            }
            break;
        }
    }
}

