/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FishMenuManager
extends BaseMenuManager {
    private final Map<UUID, Integer> currentPages = new HashMap<UUID, Integer>();
    private final Set<Inventory> activeHeadMenuInventories = new HashSet<Inventory>();

    public void registerHeadMenuInventory(Inventory inventory) {
        this.activeHeadMenuInventories.add(inventory);
    }

    public void unregisterHeadMenuInventory(Inventory inventory) {
        this.activeHeadMenuInventories.remove(inventory);
    }

    public boolean isHeadMenu(Inventory inventory) {
        return this.activeHeadMenuInventories.contains(inventory);
    }

    public FishMenuManager(MrUltimateFishing plugin) {
        super(plugin);
    }

    public void openHeadMenu(Player player) {
        this.openHeadMenu(player, 0);
    }

    public void openHeadMenu(Player player, int page) {
        ConfigurationSection itemsSection;
        FileConfiguration config = this.plugin.getConfigManager().getHeadMenuConfig();
        if (config == null) {
            return;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.HeadMenu");
        if (menuSection == null) {
            return;
        }
        this.currentPages.put(player.getUniqueId(), page);
        String baseTitle = menuSection.getString("title", "&6&lMrUltimateFishing &8| Fish Menu");
        String colorSuffix = this.menuTitleSuffixes.getOrDefault("HeadMenu", "");
        String title = MrLibColors.colorize((String)(baseTitle + colorSuffix));
        int size = menuSection.getInt("size", 54);
        Inventory inventory = this.createInventory(baseTitle, "HeadMenu", size);
        this.registerHeadMenuInventory(inventory);
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            this.addDecorations(inventory, decorationsSection);
        }
        if ((itemsSection = menuSection.getConfigurationSection("items")) != null) {
            this.addItems(inventory, menuSection);
        }
        this.addRarityCategoryItems(inventory, menuSection, page);
        this.addNavigationKeys(inventory, menuSection, player, page);
        this.applyPlayerPlaceholdersToInventory(inventory, player);
        player.openInventory(inventory);
    }

    private void applyPlayerPlaceholdersToInventory(Inventory inventory, Player player) {
        try {
            int fishScales = this.plugin.getPlayerDataManager().getFishScale(player);
            int catchedFishes = Optional.ofNullable(this.plugin.getPlayerDataManager().getPlayerData(player)).map(PlayerDataManager.PlayerData::getTotalFishCaught).orElse(0);
            int level = this.plugin.getPlayerDataManager().getLevel(player);
            int xp = this.plugin.getPlayerDataManager().getXP(player);
            int xpNeed = this.plugin.getPlayerDataManager().getXPRequiredForNextLevel(player);
            int upgradePoints = this.plugin.getPlayerDataManager().getUpgradePoints(player);
            for (int i = 0; i < inventory.getSize(); ++i) {
                List lore;
                String newName;
                String name;
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) continue;
                ItemMeta meta = item.getItemMeta();
                boolean changed = false;
                if (meta.hasDisplayName() && !Objects.equals(name = meta.getDisplayName(), newName = this.replaceHeadMenuPlaceholders(name, fishScales, catchedFishes, level, xp, xpNeed, upgradePoints))) {
                    meta.setDisplayName(MrLibColors.colorize((String)newName));
                    changed = true;
                }
                if (meta.hasLore() && (lore = meta.getLore()) != null && !lore.isEmpty()) {
                    ArrayList<String> newLore = new ArrayList<String>(lore.size());
                    boolean loreChanged = false;
                    for (String line : lore) {
                        String replaced;
                        if (!Objects.equals(line, replaced = this.replaceHeadMenuPlaceholders(line, fishScales, catchedFishes, level, xp, xpNeed, upgradePoints))) {
                            loreChanged = true;
                        }
                        newLore.add(MrLibColors.colorize((String)replaced));
                    }
                    if (loreChanged) {
                        meta.setLore(newLore);
                        changed = true;
                    }
                }
                if (!changed) continue;
                item.setItemMeta(meta);
                inventory.setItem(i, item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String replaceHeadMenuPlaceholders(String input, int fishScales, int catchedFishes, int level, int xp, int xpNeed, int upgradePoints) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String out = input;
        out = out.replace("[FishScales]", String.valueOf(fishScales));
        out = out.replace("[CatchedFishes]", String.valueOf(catchedFishes));
        out = out.replace("[FishLevel]", String.valueOf(level));
        out = out.replace("[FishXP]", String.valueOf(xp));
        out = out.replace("[FishXPNeed]", String.valueOf(xpNeed));
        out = out.replace("[FishUpgradePoints]", String.valueOf(upgradePoints));
        return out;
    }

    private void addRarityCategoryItems(Inventory inventory, ConfigurationSection menuSection, int page) {
        ConfigurationSection rarityCategorySection = menuSection.getConfigurationSection("rarity-category");
        if (rarityCategorySection == null) {
            return;
        }
        String slotsStr = rarityCategorySection.getString("slots");
        if (slotsStr == null) {
            return;
        }
        List<Integer> availableSlots = this.parseSlots(slotsStr);
        ArrayList<String> rarities = new ArrayList<String>(this.plugin.getConfigManager().getAllRarities());
        if (rarities.isEmpty()) {
            return;
        }
        int itemsPerPage = availableSlots.size();
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, rarities.size());
        for (int i = startIndex; i < endIndex; ++i) {
            String rarity = (String)rarities.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= availableSlots.size()) continue;
            int slot = availableSlots.get(slotIndex);
            ItemStack rarityItem = this.createRarityCategoryItem(rarity, rarityCategorySection);
            if (rarityItem == null || slot < 0 || slot >= inventory.getSize()) continue;
            inventory.setItem(slot, rarityItem);
        }
    }

    private ItemStack createRarityCategoryItem(String rarity, ConfigurationSection template) {
        String material = template.getString("material", "BOOK");
        String name = template.getString("display-name", "[Rarity]");
        List lore = template.getStringList("lore");
        String rarityName = this.plugin.getConfigManager().getRarityName(rarity);
        if (rarityName == null) {
            rarityName = rarity;
        }
        int fishCount = this.plugin.getConfigManager().getFishCountByRarity(rarity);
        name = name.replace("[Rarity]", rarityName);
        name = name.replace("[FishCount]", String.valueOf(fishCount));
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            line = line.replace("[Rarity]", rarityName);
            line = line.replace("[FishCount]", String.valueOf(fishCount));
            line = this.replaceFishCountPlaceholder(line, rarity);
            lore.set(i, line);
        }
        ItemStack item = this.createMenuItem(material, name, lore, false);
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey rarityKeyNBT = new NamespacedKey((Plugin)this.plugin, "rarity_category");
            dataContainer.set(rarityKeyNBT, PersistentDataType.STRING, (Object)rarity);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String replaceFishCountPlaceholder(String text, String rarity) {
        int count;
        if (text == null) {
            return "";
        }
        if (text.contains("[FishCount-" + rarity + "]")) {
            count = this.plugin.getConfigManager().getFishCountByRarity(rarity);
            text = text.replace("[FishCount-" + rarity + "]", String.valueOf(count));
        }
        if (text.contains("[FishCount]")) {
            count = this.plugin.getConfigManager().getFishCountByRarity(rarity);
            text = text.replace("[FishCount]", String.valueOf(count));
        }
        return text;
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection menuSection, Player player, int page) {
        ConfigurationSection keysSection = menuSection.getConfigurationSection("keys");
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            ConfigurationSection keySection = keysSection.getConfigurationSection(key);
            if (keySection == null) continue;
            ItemStack keyItem = this.createNavigationKeyItem(keySection, key, player, page);
            List<Integer> slots = this.parseSlots(keySection.getString("slots", ""));
            for (int slot : slots) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, keyItem);
            }
        }
    }

    private ItemStack createNavigationKeyItem(ConfigurationSection keySection, String keyType, Player player, int page) {
        List lore;
        String displayName;
        String material = keySection.getString("material", "ARROW");
        ItemStack item = this.createMenuItem(material, displayName = keySection.getString("display-name", ""), lore = keySection.getStringList("lore"), false);
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey navigationKeyNBT = new NamespacedKey((Plugin)this.plugin, "navigation");
            dataContainer.set(navigationKeyNBT, PersistentDataType.STRING, (Object)keyType);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void handleMenuItemClick(Player player, ItemStack clickedItem) {
        NamespacedKey navigationKey;
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (dataContainer.has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
            String navigationValue = (String)dataContainer.get(navigationKey, PersistentDataType.STRING);
            this.handleNavigation(player, navigationValue);
            return;
        }
        NamespacedKey rarityKey = new NamespacedKey((Plugin)this.plugin, "rarity_category");
        if (dataContainer.has(rarityKey, PersistentDataType.STRING)) {
            String rarityValue = (String)dataContainer.get(rarityKey, PersistentDataType.STRING);
            this.openRarityCategoryMenu(player, rarityValue);
            return;
        }
        NamespacedKey actionKey = new NamespacedKey((Plugin)this.plugin, "action");
        if (dataContainer.has(actionKey, PersistentDataType.STRING)) {
            NamespacedKey actionClickKey;
            String actionValue = (String)dataContainer.get(actionKey, PersistentDataType.STRING);
            if ("OPENMENU".equals(actionValue) && dataContainer.has(actionClickKey = new NamespacedKey((Plugin)this.plugin, "actionclick"), PersistentDataType.STRING)) {
                String actionClickValue = (String)dataContainer.get(actionClickKey, PersistentDataType.STRING);
                if ("SellFish".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openSellFishMenu(player);
                    return;
                }
                if ("RarityCategory".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openRarityCategoryMenu(player);
                    return;
                }
                if ("Gutting".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openGuttingMenu(player);
                    return;
                }
                if ("Upgrades".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openUpgradeMenu(player);
                    return;
                }
                if ("Recipes".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openRecipeMenu(player);
                    return;
                }
                if ("Shop".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openShopMenu(player);
                    return;
                }
                if ("Delivery".equals(actionClickValue)) {
                    this.plugin.getMenuManager().openDeliveryMenu(player);
                    return;
                }
            }
            return;
        }
    }

    private void handleNavigation(Player player, String navigation) {
        switch (navigation) {
            case "previous-page": {
                this.handlePreviousPage(player);
                break;
            }
            case "next-page": {
                this.handleNextPage(player);
                break;
            }
            case "back": {
                player.closeInventory();
            }
        }
    }

    public void handlePreviousPage(Player player) {
        Integer currentPage = this.currentPages.get(player.getUniqueId());
        if (currentPage != null && currentPage > 0) {
            int newPage = currentPage - 1;
            this.openHeadMenu(player, newPage);
        }
    }

    public void handleNextPage(Player player) {
        Integer currentPage = this.currentPages.get(player.getUniqueId());
        if (currentPage != null && this.hasNextPage(currentPage)) {
            int newPage = currentPage + 1;
            this.openHeadMenu(player, newPage);
        }
    }

    private boolean hasNextPage(int currentPage) {
        ArrayList<String> rarities = new ArrayList<String>(this.plugin.getConfigManager().getAllRarities());
        FileConfiguration config = this.plugin.getConfigManager().getHeadMenuConfig();
        if (config == null) {
            return false;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.HeadMenu");
        if (menuSection == null) {
            return false;
        }
        ConfigurationSection rarityCategorySection = menuSection.getConfigurationSection("rarity-category");
        if (rarityCategorySection == null) {
            return false;
        }
        String slotsStr = rarityCategorySection.getString("slots");
        if (slotsStr == null) {
            return false;
        }
        List<Integer> availableSlots = this.parseSlots(slotsStr);
        int itemsPerPage = availableSlots.size();
        int totalPages = (int)Math.ceil((double)rarities.size() / (double)itemsPerPage);
        return currentPage < totalPages - 1;
    }

    public void cleanupPlayer(UUID playerId) {
        this.currentPages.remove(playerId);
    }

    public Integer getCurrentPage(UUID playerId) {
        return this.currentPages.get(playerId);
    }

    public void openRarityCategoryMenu(Player player, String rarity, int page) {
        this.plugin.getMenuManager().openRarityMenu(player, rarity, page);
    }

    public void openRarityCategoryMenu(Player player, String rarity) {
        this.openRarityCategoryMenu(player, rarity, 0);
    }

    public void cleanupPlayerData(Player player) {
        this.cleanupPlayer(player.getUniqueId());
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        if (!this.isHeadMenu(event.getInventory())) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null) {
            this.handleMenuItemClick(player, clickedItem);
        }
        event.setCancelled(true);
        return true;
    }

    private boolean isFishMenu(String inventoryTitle) {
        return false;
    }

    public void handleInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (this.isHeadMenu(event.getInventory())) {
            Player player = (Player)event.getPlayer();
            this.cleanupPlayerData(player);
            this.unregisterHeadMenuInventory(event.getInventory());
        }
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        if (!this.isHeadMenu(event.getInventory())) {
            return false;
        }
        event.setCancelled(true);
        return true;
    }
}

