/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.integrations;

import eu.mrneznamy.mrlibcore.placeholders.MrLibRegisterPlaceholders;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlaceholderAPIIntegration {
    private final MrUltimateFishing plugin;
    private final PlayerDataManager data;
    private final Map<String, CachedLeaderboard> cache = new ConcurrentHashMap<String, CachedLeaderboard>();
    private final long CACHE_TTL_MS = 30000L;

    public PlaceholderAPIIntegration(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.data = plugin.getPlayerDataManager();
    }

    public void register() {
        MrLibRegisterPlaceholders.register((String)"muf", (String)"level", (player, params) -> {
            if (player == null) {
                return "";
            }
            PlayerDataManager.PlayerData pd = this.data.getPlayerData(player.getUniqueId());
            return pd != null ? String.valueOf(pd.getFishingLevel()) : "";
        });
        MrLibRegisterPlaceholders.register((String)"muf", (String)"xp", (player, params) -> {
            if (player == null) {
                return "";
            }
            PlayerDataManager.PlayerData pd = this.data.getPlayerData(player.getUniqueId());
            return pd != null ? String.valueOf(pd.getFishingXP()) : "";
        });
        MrLibRegisterPlaceholders.register((String)"muf", (String)"normal_fishscales", (player, params) -> {
            if (player == null) {
                return "";
            }
            PlayerDataManager.PlayerData pd = this.data.getPlayerData(player.getUniqueId());
            return pd != null ? String.valueOf(pd.getFishScale()) : "";
        });
        MrLibRegisterPlaceholders.register((String)"muf", (String)"formatted_fishscales", (player, params) -> {
            if (player == null) {
                return "";
            }
            PlayerDataManager.PlayerData pd = this.data.getPlayerData(player.getUniqueId());
            return pd != null ? NumberFormat.getInstance(Locale.US).format(pd.getFishScale()) : "";
        });
        MrLibRegisterPlaceholders.register((String)"muf", (String)"catchcount", (player, params) -> {
            if (player == null) {
                return "";
            }
            PlayerDataManager.PlayerData pd = this.data.getPlayerData(player.getUniqueId());
            return pd != null ? String.valueOf(pd.getTotalFishCaught()) : "";
        });
        MrLibRegisterPlaceholders.register((String)"muf", (String)"upgradepoints", (player, params) -> {
            if (player == null) {
                return "";
            }
            PlayerDataManager.PlayerData pd = this.data.getPlayerData(player.getUniqueId());
            return pd != null ? String.valueOf(pd.getUpgradePoints()) : "";
        });
        MrLibRegisterPlaceholders.register((String)"muf", (String)"top", (player, params) -> {
            int position;
            if (params == null || params.isEmpty()) {
                return "";
            }
            String[] split = params.split("_");
            if (split.length < 3) {
                return "";
            }
            String mode = split[0];
            String type = split[1];
            String posStr = split[2];
            LeaderboardType lbType = LeaderboardType.fromString(type);
            if (lbType == null) {
                return "";
            }
            List<LBEntry> entries = this.getLeaderboard(lbType);
            if (entries.isEmpty()) {
                return "";
            }
            if ("me".equalsIgnoreCase(posStr)) {
                if (player == null) {
                    return "";
                }
                int idx = this.getPlayerIndex(entries, player.getUniqueId());
                if (idx == -1) {
                    return "";
                }
                LBEntry e = entries.get(idx);
                return "name".equals(mode) ? e.name : String.valueOf(e.value);
            }
            try {
                position = Integer.parseInt(posStr);
            }
            catch (NumberFormatException ex) {
                return "";
            }
            if (position <= 0 || position > entries.size()) {
                return "";
            }
            LBEntry e = entries.get(position - 1);
            return "name".equals(mode) ? e.name : String.valueOf(e.value);
        });
    }

    private int getPlayerIndex(List<LBEntry> list, UUID uuid) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).uuid.equals(uuid)) continue;
            return i;
        }
        return -1;
    }

    private List<LBEntry> getLeaderboard(LeaderboardType type) {
        String key = type.name();
        CachedLeaderboard cached = this.cache.get(key);
        long now = System.currentTimeMillis();
        if (cached != null && now - cached.timestamp < 30000L) {
            return cached.entries;
        }
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        File[] files = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            this.cache.put(key, new CachedLeaderboard(now, Collections.emptyList()));
            return Collections.emptyList();
        }
        ArrayList<LBEntry> entries = new ArrayList<LBEntry>(files.length);
        for (File f : files) {
            try {
                String uuidStr = f.getName().substring(0, f.getName().length() - 4);
                UUID uuid = UUID.fromString(uuidStr);
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
                long value = switch (type.ordinal()) {
                    case 0 -> cfg.getLong("total-fish-caught", 0L);
                    case 1 -> cfg.getLong("fish-scale", 0L);
                    case 2 -> cfg.getLong("fishing-level", 1L);
                    default -> 0L;
                };
                String name2 = Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)uuid).getName()).orElse(uuid.toString());
                entries.add(new LBEntry(uuid, name2, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entries.sort(Comparator.comparingLong(e -> e.value).reversed());
        this.cache.put(key, new CachedLeaderboard(now, entries));
        return entries;
    }

    private static class LBEntry {
        final UUID uuid;
        final String name;
        final long value;

        LBEntry(UUID uuid, String name, long value) {
            this.uuid = uuid;
            this.name = name;
            this.value = value;
        }
    }

    private static enum LeaderboardType {
        CATCH("catch"),
        FISHSCALE("fishscale"),
        LEVEL("level");

        final String id;

        private LeaderboardType(String id) {
            this.id = id;
        }

        static LeaderboardType fromString(String s) {
            for (LeaderboardType t : LeaderboardType.values()) {
                if (!t.id.equalsIgnoreCase(s)) continue;
                return t;
            }
            return null;
        }
    }

    private static class CachedLeaderboard {
        final long timestamp;
        final List<LBEntry> entries;

        CachedLeaderboard(long timestamp, List<LBEntry> entries) {
            this.timestamp = timestamp;
            this.entries = entries;
        }
    }
}

