/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.listeners;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.managers.EnchantManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EnchantApplyListener
implements Listener {
    private final MrUltimateFishing plugin;
    private final EnchantManager enchantManager;

    public EnchantApplyListener(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.enchantManager = plugin.getEnchantManager();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == null || event.getClickedInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        ItemStack cursor = event.getCursor();
        ItemStack current = event.getCurrentItem();
        if (cursor != null && current != null && this.isEnchantItem(cursor) && this.isFishingRod(current)) {
            event.setCancelled(true);
            String enchantName = this.getEnchantFromItem(cursor);
            if (enchantName == null) {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.invalid-enchant")));
                return;
            }
            this.applyEnchantLogic(player, current, enchantName, cursor);
            return;
        }
        if (current != null && event.isShiftClick() && this.isEnchantItem(current)) {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            ItemStack offHand = player.getInventory().getItemInOffHand();
            ItemStack fishingRod = null;
            if (this.isFishingRod(mainHand)) {
                fishingRod = mainHand;
            } else if (this.isFishingRod(offHand)) {
                fishingRod = offHand;
            }
            if (fishingRod != null) {
                event.setCancelled(true);
                String enchantName = this.getEnchantFromItem(current);
                if (enchantName == null) {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.invalid-enchant")));
                    return;
                }
                this.applyEnchantLogic(player, fishingRod, enchantName, current);
                if (current.getAmount() > 1) {
                    current.setAmount(current.getAmount() - 1);
                } else {
                    event.setCurrentItem(null);
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryDrag(InventoryDragEvent event) {
        int slot;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack draggedItem = event.getOldCursor();
        if (draggedItem == null || !this.isEnchantItem(draggedItem)) {
            return;
        }
        int topSize = event.getView().getTopInventory().getSize();
        boolean onlyBottomSlots = true;
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            if (slot >= topSize) continue;
            onlyBottomSlots = false;
            break;
        }
        if (!onlyBottomSlots) {
            return;
        }
        iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            ItemStack targetItem;
            block11: {
                slot = (Integer)iterator.next();
                targetItem = null;
                try {
                    if (slot < event.getInventory().getSize()) {
                        targetItem = event.getInventory().getItem(slot);
                    } else {
                        int playerSlot = slot - event.getInventory().getSize();
                        if (playerSlot >= 0 && playerSlot < player.getInventory().getSize()) {
                            targetItem = player.getInventory().getItem(playerSlot);
                        }
                    }
                }
                catch (Exception e) {
                    if (slot < 0 || slot >= player.getInventory().getSize()) break block11;
                    targetItem = player.getInventory().getItem(slot);
                }
            }
            if (targetItem == null || !this.isFishingRod(targetItem)) continue;
            event.setCancelled(true);
            String enchantName = this.getEnchantFromItem(draggedItem);
            if (enchantName == null) {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.invalid-enchant")));
                return;
            }
            this.applyEnchantLogic(player, targetItem, enchantName, draggedItem);
            return;
        }
    }

    private void applyEnchantLogic(Player player, ItemStack fishingRod, String enchantName, ItemStack enchantItem) {
        if (this.hasEnchant(fishingRod, enchantName)) {
            int currentLevel = this.getEnchantLevel(fishingRod, enchantName);
            EnchantManager.EnchantData enchantData = this.enchantManager.getEnchant(enchantName);
            if (enchantData != null && currentLevel < enchantData.maxLevel) {
                if (this.upgradeEnchant(fishingRod, enchantName, currentLevel + 1)) {
                    this.consumeEnchantItem(player, enchantItem);
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.enchant-upgraded").replace("[enchant]", enchantName).replace("[level]", String.valueOf(currentLevel + 1))));
                } else {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.enchant-upgrade-failed").replace("[enchant]", enchantName)));
                }
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.enchant-max-level").replace("[enchant]", enchantName).replace("[max_level]", String.valueOf(enchantData != null ? enchantData.maxLevel : 1))));
            }
            return;
        }
        if (this.applyEnchantToRod(fishingRod, enchantName, 1)) {
            this.consumeEnchantItem(player, enchantItem);
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.enchant-applied").replace("[enchant]", enchantName)));
            this.plugin.getCommunityQuestIntegration().processEnchantApplication(player, enchantName);
        } else {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.enchant-craft-failed").replace("[enchant]", enchantName)));
        }
    }

    private boolean isEnchantItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_enchant");
        return meta.getPersistentDataContainer().has(key, PersistentDataType.STRING);
    }

    private boolean isFishingRod(ItemStack item) {
        return item != null && item.getType() == Material.FISHING_ROD;
    }

    private String getEnchantFromItem(ItemStack item) {
        return this.enchantManager.getEnchantFromItem(item);
    }

    private boolean hasEnchant(ItemStack fishingRod, String enchantName) {
        if (!fishingRod.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = fishingRod.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
        return meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER);
    }

    private int getEnchantLevel(ItemStack fishingRod, String enchantName) {
        if (!fishingRod.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = fishingRod.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
        return (Integer)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    private int getEnchantCount(ItemStack fishingRod) {
        if (!fishingRod.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = fishingRod.getItemMeta();
        int count = 0;
        for (String enchantName : this.enchantManager.getEnchantNames()) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
            if (!meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) continue;
            ++count;
        }
        return count;
    }

    private void consumeEnchantItem(Player player, ItemStack cursor) {
        if (cursor.getAmount() > 1) {
            cursor.setAmount(cursor.getAmount() - 1);
            player.setItemOnCursor(cursor);
        } else {
            player.setItemOnCursor(null);
        }
    }

    private boolean applyEnchantToRod(ItemStack fishingRod, String enchantName, int level) {
        ItemMeta meta;
        if (!fishingRod.hasItemMeta()) {
            fishingRod.setItemMeta(this.plugin.getServer().getItemFactory().getItemMeta(fishingRod.getType()));
        }
        if ((meta = fishingRod.getItemMeta()) == null) {
            return false;
        }
        EnchantManager.EnchantData enchantData = this.enchantManager.getEnchant(enchantName);
        if (enchantData == null) {
            return false;
        }
        NamespacedKey enchantKey = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
        meta.getPersistentDataContainer().set(enchantKey, PersistentDataType.INTEGER, (Object)level);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        String enchantLore = MrLibColors.colorize((String)enchantData.onItemLore.replace("[Level]", String.valueOf(level)).replace(".LVL", ""));
        boolean foundAndUpdated = false;
        String enchantDisplayPattern = this.extractEnchantDisplayName(enchantData.onItemLore);
        for (int i = 0; i < lore.size(); ++i) {
            String loreLine = (String)lore.get(i);
            String strippedLine = ChatColor.stripColor((String)loreLine).toLowerCase();
            if (enchantDisplayPattern.isEmpty() || !strippedLine.contains(enchantDisplayPattern.toLowerCase()) || !strippedLine.contains("lvl") && !strippedLine.matches(".*\\d+.*")) continue;
            lore.set(i, enchantLore);
            foundAndUpdated = true;
            break;
        }
        if (!foundAndUpdated) {
            lore.add(enchantLore);
        }
        meta.setLore(lore);
        fishingRod.setItemMeta(meta);
        return true;
    }

    private String extractEnchantDisplayName(String onItemLore) {
        int end;
        int start;
        if (onItemLore == null || onItemLore.isEmpty()) {
            return "";
        }
        String cleaned = ChatColor.stripColor((String)MrLibColors.colorize((String)onItemLore));
        if ((cleaned = cleaned.replaceAll("\\[Level\\]", "").replaceAll("\\.LVL", "").replaceAll("\\d+", "").replaceAll("lvl", "").replaceAll("\u2192", "").replaceAll("\u27a3", "").trim()).contains(">&l") && cleaned.contains("<") && (start = cleaned.indexOf(">&l") + 3) < (end = cleaned.indexOf("<", start)) && end > 0) {
            cleaned = cleaned.substring(start, end).trim();
        }
        return cleaned.trim();
    }

    private boolean upgradeEnchant(ItemStack fishingRod, String enchantName, int newLevel) {
        if (!fishingRod.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = fishingRod.getItemMeta();
        if (meta == null) {
            return false;
        }
        EnchantManager.EnchantData enchantData = this.enchantManager.getEnchant(enchantName);
        if (enchantData == null) {
            return false;
        }
        NamespacedKey enchantKey = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
        meta.getPersistentDataContainer().set(enchantKey, PersistentDataType.INTEGER, (Object)newLevel);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        String newEnchantLore = MrLibColors.colorize((String)enchantData.onItemLore.replace("[Level]", String.valueOf(newLevel)).replace(".LVL", ""));
        boolean foundAndUpdated = false;
        String enchantDisplayPattern = this.extractEnchantDisplayName(enchantData.onItemLore);
        for (int i = 0; i < lore.size(); ++i) {
            String loreLine = (String)lore.get(i);
            String strippedLine = ChatColor.stripColor((String)loreLine).toLowerCase();
            if (enchantDisplayPattern.isEmpty() || !strippedLine.contains(enchantDisplayPattern.toLowerCase()) || !strippedLine.contains("lvl") && !strippedLine.matches(".*\\d+.*")) continue;
            lore.set(i, newEnchantLore);
            foundAndUpdated = true;
            break;
        }
        if (!foundAndUpdated) {
            lore.add(newEnchantLore);
        }
        meta.setLore(lore);
        fishingRod.setItemMeta(meta);
        return true;
    }
}

