/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EnchantManager {
    private final MrUltimateFishing plugin;
    private final Map<String, EnchantData> enchants = new HashMap<String, EnchantData>();

    public EnchantManager(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.loadEnchants();
    }

    public void loadEnchants() {
        this.enchants.clear();
        ConfigurationSection enchantsSection = this.plugin.getConfig().getConfigurationSection("MrUltimateFishing.CustomEnchants");
        if (enchantsSection == null) {
            return;
        }
        for (String enchantName : enchantsSection.getKeys(false)) {
            ConfigurationSection recipeSection;
            ConfigurationSection itemSection;
            ConfigurationSection craftingSection;
            ConfigurationSection enchantSection = enchantsSection.getConfigurationSection(enchantName);
            if (enchantSection == null) continue;
            EnchantData enchantData = new EnchantData();
            enchantData.name = enchantName;
            ConfigurationSection enchantProps = enchantSection.getConfigurationSection("Enchant");
            if (enchantProps != null) {
                enchantData.maxLevel = enchantProps.getInt("MaxLevel", 1);
                enchantData.bonus = enchantProps.getDouble("Bonus", 0.0);
                enchantData.onItemLore = enchantProps.getString("OnItem-Lore", "");
            }
            if ((craftingSection = enchantSection.getConfigurationSection("Crafting.Required")) != null) {
                enchantData.requiredFishScales = craftingSection.getInt("Fish-Scales", 0);
                enchantData.requiredFishLevel = craftingSection.getInt("Fish-Level", 0);
                List items = craftingSection.getStringList("Items");
                for (String item : items) {
                    String[] parts = item.split(":");
                    if (parts.length != 2) continue;
                    try {
                        String materialName = parts[0];
                        int amount = Integer.parseInt(parts[1]);
                        enchantData.requiredItems.put(materialName, amount);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if ((itemSection = enchantSection.getConfigurationSection("Item")) != null && itemSection.getBoolean("enabled", false)) {
                enchantData.material = itemSection.getString("material", "FIREWORK_STAR");
                enchantData.displayName = itemSection.getString("display-name", enchantName);
                enchantData.lore = itemSection.getStringList("lore");
            }
            if ((recipeSection = enchantSection.getConfigurationSection("InRecipeMenu")) != null) {
                enchantData.recipeMaterial = recipeSection.getString("material", "FIREWORK_STAR");
                enchantData.recipeDisplayName = recipeSection.getString("display-name", enchantName);
                enchantData.recipeLore = recipeSection.getStringList("lore");
            }
            this.enchants.put(enchantName, enchantData);
        }
    }

    public EnchantData getEnchant(String name) {
        return this.enchants.get(name);
    }

    public Set<String> getEnchantNames() {
        return this.enchants.keySet();
    }

    public ItemStack createEnchantItem(String enchantName) {
        EnchantData enchant = this.enchants.get(enchantName);
        if (enchant == null || enchant.material == null) {
            return null;
        }
        String[] materialParts = enchant.material.split(":");
        Material material = Material.valueOf((String)materialParts[0]);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MrLibColors.colorize((String)enchant.displayName));
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : enchant.lore) {
                coloredLore.add(MrLibColors.colorize((String)line));
            }
            meta.setLore(coloredLore);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_enchant");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)enchantName);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack createRecipeMenuItem(String enchantName) {
        EnchantData enchant = this.enchants.get(enchantName);
        if (enchant == null || enchant.recipeMaterial == null) {
            return null;
        }
        String[] materialParts = enchant.recipeMaterial.split(":");
        Material material = Material.valueOf((String)materialParts[0]);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MrLibColors.colorize((String)enchant.recipeDisplayName));
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : enchant.recipeLore) {
                coloredLore.add(MrLibColors.colorize((String)line));
            }
            meta.setLore(coloredLore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public boolean canCraftEnchant(Player player, String enchantName) {
        EnchantData enchant = this.enchants.get(enchantName);
        if (enchant == null) {
            return false;
        }
        PlayerDataManager playerData = this.plugin.getPlayerDataManager();
        if (playerData.getFishScale(player) < enchant.requiredFishScales) {
            return false;
        }
        if (playerData.getLevel(player) < enchant.requiredFishLevel) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : enchant.requiredItems.entrySet()) {
            String materialName = entry.getKey();
            int requiredAmount = entry.getValue();
            if (this.isCustomItem(materialName)) {
                String customType = this.getCustomItemType(materialName);
                if (this.hasCustomItem(player, customType, requiredAmount)) continue;
                return false;
            }
            try {
                Material material = Material.valueOf((String)materialName);
                if (this.hasItem(player, material, requiredAmount)) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        this.plugin.getCommunityQuestIntegration().processEnchantCrafting(player, enchantName);
        return true;
    }

    private boolean hasItem(Player player, Material material, int amount) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.isVanillaItem(item) || (count += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    private boolean isVanillaItem(ItemStack item) {
        if (!item.hasItemMeta()) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            return false;
        }
        if (meta.hasLore()) {
            return false;
        }
        if (!meta.getPersistentDataContainer().isEmpty()) {
            return false;
        }
        return !meta.hasEnchants();
    }

    private boolean hasCustomItem(Player player, String customType, int amount) {
        int count = 0;
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
        for (ItemStack item : player.getInventory().getContents()) {
            String type;
            ItemMeta meta;
            if (item == null || !item.hasItemMeta() || !(meta = item.getItemMeta()).getPersistentDataContainer().has(key, PersistentDataType.STRING) || !customType.equals(type = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING)) || (count += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    private boolean isCustomItem(String materialName) {
        return materialName.equals("DOLPHIN_TAIL") || materialName.equals("CRAB_CLAWS") || materialName.equals("CRAB_SHELL") || materialName.equals("SQUID_TENTACLE");
    }

    private String getCustomItemType(String materialName) {
        switch (materialName) {
            case "DOLPHIN_TAIL": {
                return "dolphin-tail";
            }
            case "CRAB_CLAWS": {
                return "crab-claws";
            }
            case "CRAB_SHELL": {
                return "crab-shell";
            }
            case "SQUID_TENTACLE": {
                return "squid-tentacle";
            }
        }
        return materialName.toLowerCase().replace("_", "-");
    }

    public String getEnchantFromItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_enchant");
        if (meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            return (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        }
        return null;
    }

    public boolean hasEnchantOnRod(ItemStack fishingRod, String enchantName) {
        if (fishingRod == null || !fishingRod.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = fishingRod.getItemMeta();
        NamespacedKey enchantKey = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
        boolean hasEnchant = meta.getPersistentDataContainer().has(enchantKey, PersistentDataType.INTEGER);
        return hasEnchant;
    }

    public int getEnchantLevelOnRod(ItemStack fishingRod, String enchantName) {
        if (fishingRod == null || !fishingRod.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = fishingRod.getItemMeta();
        NamespacedKey enchantKey = new NamespacedKey((Plugin)this.plugin, "custom_enchant_" + enchantName.toLowerCase());
        if (meta.getPersistentDataContainer().has(enchantKey, PersistentDataType.INTEGER)) {
            int level = (Integer)meta.getPersistentDataContainer().get(enchantKey, PersistentDataType.INTEGER);
            return level;
        }
        return 0;
    }

    public static class EnchantData {
        public String name;
        public int maxLevel = 1;
        public double bonus = 0.0;
        public String onItemLore = "";
        public int requiredFishScales = 0;
        public int requiredFishLevel = 0;
        public Map<String, Integer> requiredItems = new HashMap<String, Integer>();
        public String material;
        public String displayName;
        public List<String> lore = new ArrayList<String>();
        public String recipeMaterial;
        public String recipeDisplayName;
        public List<String> recipeLore = new ArrayList<String>();
    }
}

