/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RarityMenuManager
extends BaseMenuManager
implements Listener {
    private final Map<UUID, String> currentRarity = new HashMap<UUID, String>();
    private final Map<UUID, Integer> currentPages = new HashMap<UUID, Integer>();
    private final Set<Inventory> activeRarityMenuInventories = new HashSet<Inventory>();
    private final Set<Inventory> activeRarityCategoryMenuInventories = new HashSet<Inventory>();
    private final Set<UUID> navigatingPlayers = new HashSet<UUID>();
    private final Map<Inventory, String> inventoryRarity = new HashMap<Inventory, String>();
    private final Map<Inventory, Integer> inventoryPages = new HashMap<Inventory, Integer>();

    public void registerRarityMenuInventory(Inventory inventory) {
        this.activeRarityMenuInventories.add(inventory);
    }

    public void unregisterRarityMenuInventory(Inventory inventory) {
        this.activeRarityMenuInventories.remove(inventory);
    }

    public boolean isRarityMenuRegistered(Inventory inventory) {
        return this.activeRarityMenuInventories.contains(inventory);
    }

    public void registerRarityCategoryMenuInventory(Inventory inventory) {
        this.activeRarityCategoryMenuInventories.add(inventory);
    }

    public void unregisterRarityCategoryMenuInventory(Inventory inventory) {
        this.activeRarityCategoryMenuInventories.remove(inventory);
    }

    public boolean isRarityCategoryMenuRegistered(Inventory inventory) {
        return this.activeRarityCategoryMenuInventories.contains(inventory);
    }

    public RarityMenuManager(MrUltimateFishing plugin) {
        super(plugin);
    }

    public void openRarityMenu(Player player, String rarity, int page) {
        List<Integer> availableSlots;
        int itemsPerPage;
        String slotsStr;
        FileConfiguration menuConfig;
        String currentPlayerRarity = this.getCurrentRarity(player.getUniqueId());
        if (currentPlayerRarity != null && !currentPlayerRarity.equals(rarity)) {
            this.clearNavigatingFlag(player);
        }
        if ((menuConfig = this.plugin.getConfigManager().getRarityMenuConfig()) == null) {
            this.plugin.sendMessage(player, "\u00a7cError: Rarity menu configuration not found!");
            return;
        }
        ConfigurationSection menuSection = menuConfig.getConfigurationSection("MrUltimateFishing.Rarity");
        if (menuSection == null) {
            this.plugin.sendMessage(player, "\u00a7cError: Rarity menu configuration not found!");
            return;
        }
        UUID playerId = player.getUniqueId();
        this.currentRarity.put(playerId, rarity);
        this.currentPages.put(playerId, page);
        String baseTitle = menuSection.getString("title", "&6&lMrUltimateFishing &8| Rarity");
        List<String> fishIds = this.plugin.getConfigManager().getFishIdsByRarity(rarity);
        ConfigurationSection fishItemSection = menuSection.getConfigurationSection("items.fish");
        int totalPages = 1;
        if (fishItemSection != null && (slotsStr = fishItemSection.getString("slots")) != null && (itemsPerPage = (availableSlots = this.parseSlots(slotsStr)).size()) > 0) {
            totalPages = (int)Math.ceil((double)fishIds.size() / (double)itemsPerPage);
        }
        baseTitle = baseTitle.replace("[Rarity]", rarity);
        baseTitle = baseTitle.replace("[CurrentPage]", String.valueOf(page + 1));
        baseTitle = baseTitle.replace("[TotalPages]", String.valueOf(totalPages));
        String colorSuffix = this.menuTitleSuffixes.getOrDefault("Rarity", "");
        String title = MrLibColors.colorize((String)(baseTitle + colorSuffix));
        int size = menuSection.getInt("size", 54);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.inventoryRarity.put(inventory, rarity);
        this.inventoryPages.put(inventory, page);
        this.registerRarityMenuInventory(inventory);
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            this.addDecorations(inventory, decorationsSection);
        }
        this.addFishItems(inventory, menuSection, rarity, page);
        this.addNavigationKeys(inventory, menuSection, player, page);
        player.openInventory(inventory);
    }

    private void addFishItems(Inventory inventory, ConfigurationSection menuSection, String rarity, int page) {
        List<String> fishIds = this.plugin.getConfigManager().getFishIdsByRarity(rarity);
        if (fishIds.isEmpty()) {
            return;
        }
        ConfigurationSection fishItemSection = menuSection.getConfigurationSection("items.fish");
        if (fishItemSection == null) {
            if (menuSection.getConfigurationSection("items") != null) {
                // empty if block
            }
            return;
        }
        String slotsStr = fishItemSection.getString("slots");
        if (slotsStr == null) {
            return;
        }
        List<Integer> availableSlots = this.parseSlots(slotsStr);
        int itemsPerPage = availableSlots.size();
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, fishIds.size());
        for (int i = startIndex; i < endIndex; ++i) {
            String fishId = fishIds.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= availableSlots.size()) continue;
            int slot = availableSlots.get(slotIndex);
            ItemStack fishItem = this.createFishDisplayItem(fishId, fishItemSection);
            if (fishItem == null || slot < 0 || slot >= inventory.getSize()) continue;
            inventory.setItem(slot, fishItem);
        }
    }

    private ItemStack createFishDisplayItem(String fishId, ConfigurationSection template) {
        FileConfiguration fishConfig = this.plugin.getConfigManager().getFishConfig();
        if (fishConfig == null) {
            return null;
        }
        ConfigurationSection fishSection = fishConfig.getConfigurationSection("MrUltimateFishing." + fishId);
        if (fishSection == null) {
            return null;
        }
        String material = fishSection.getString("Item.material", "COD");
        String name = template.getString("display-name", "[FishName]");
        List lore = template.getStringList("lore");
        try {
            Material mat = Material.valueOf((String)material.toUpperCase());
            ItemStack item = new ItemStack(mat);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                String fishName = fishSection.getString("Item.display-name", fishId);
                name = name.replace("[FishName]", fishName);
                meta.setDisplayName(this.plugin.getMessageManager().translateColors(name));
                ArrayList<String> translatedLore = new ArrayList<String>();
                for (String line : lore) {
                    line = this.replaceFishPlaceholders(line, fishId, fishSection);
                    translatedLore.add(this.plugin.getMessageManager().translateColors(line));
                }
                meta.setLore(translatedLore);
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String replaceFishPlaceholders(String text, String fishId, ConfigurationSection fishSection) {
        String biomesStr;
        if (text == null) {
            return "";
        }
        String fishName = fishSection.getString("Item.display-name", fishId);
        String rarityId = fishSection.getString("Fish.rarity", "COMMON");
        String rarityName = this.plugin.getConfigManager().getRarityName(rarityId);
        if (rarityName == null) {
            rarityName = rarityId;
        }
        double price = 0.0;
        boolean hasOverrideRarity = this.plugin.getConfigManager().getFishOverrideRarity(fishId);
        if (hasOverrideRarity) {
            price = this.plugin.getConfigManager().getFishSellPrice(fishId);
        } else {
            price = this.plugin.getConfigManager().getRaritySellPrice(rarityId);
            if (this.plugin.getConfigManager().getRarityConfig() != null) {
                double d = this.plugin.getConfigManager().getRarityConfig().getDouble("MrUltimateFishing.Rarity." + rarityId + ".sell-price", -1.0);
            }
        }
        String firstCatcher = this.plugin.getConfigManager().getFishFirstCatcher(fishId);
        int catchCount = this.plugin.getConfigManager().getFishCatchCount(fishId);
        String biomesString = fishSection.getString("Fish.catchable-biome", "ALL");
        if ("ALL".equals(biomesString)) {
            biomesStr = "Any";
        } else {
            String[] biomeArray = biomesString.split(",");
            ArrayList<String> biomes = new ArrayList<String>();
            block20: for (String biome : biomeArray) {
                String cleanBiome = biome.trim();
                switch (cleanBiome.toUpperCase()) {
                    case "OCEAN": {
                        biomes.add("Ocean");
                        continue block20;
                    }
                    case "REEF": {
                        biomes.add("Reef");
                        continue block20;
                    }
                    case "COASTAL": {
                        biomes.add("Coastal");
                        continue block20;
                    }
                    case "FRESHWATER": {
                        biomes.add("Freshwater");
                        continue block20;
                    }
                    case "RIVER": {
                        biomes.add("River");
                        continue block20;
                    }
                    case "RIVERBANK": {
                        biomes.add("Riverbank");
                        continue block20;
                    }
                    case "LAKE": {
                        biomes.add("Lake");
                        continue block20;
                    }
                    case "BOTTOM": {
                        biomes.add("Deep Water");
                        continue block20;
                    }
                    default: {
                        biomes.add(cleanBiome);
                    }
                }
            }
            biomesStr = String.join((CharSequence)", ", biomes);
        }
        String fishDescription = fishSection.getString("Item.description", "");
        String fishWeight = fishSection.getString("Fish.weight", "1.0");
        String priceStr = price == (double)((long)price) ? String.valueOf((long)price) : String.valueOf(price);
        text = text.replace("[FishName]", fishName);
        text = text.replace("{fish_name}", fishName);
        text = text.replace("[FishDescription]", fishDescription);
        text = text.replace("{fish_description}", fishDescription);
        text = text.replace("[Rarity]", rarityName);
        text = text.replace("{fish_rarity}", rarityName);
        text = text.replace("[Price]", priceStr);
        text = text.replace("[SellPrice]", priceStr);
        text = text.replace("{fish_price}", priceStr);
        text = text.replace("[Weight]", fishWeight);
        text = text.replace("{fish_weight}", fishWeight);
        text = text.replace("[Biome]", biomesStr);
        text = text.replace("[FishBiomes]", biomesStr);
        text = text.replace("{fish_biomes}", biomesStr);
        String unknownPlaceholder = "Unknown";
        FileConfiguration config = this.plugin.getConfigManager().getMainConfig();
        if (config != null) {
            unknownPlaceholder = config.getString("unknown-placeholder", "Unknown");
        }
        text = text.replace("[FirstCatcher]", firstCatcher != null ? firstCatcher : unknownPlaceholder);
        text = text.replace("[Catched]", String.valueOf(catchCount));
        text = text.replace("{first_catcher}", firstCatcher != null ? firstCatcher : unknownPlaceholder);
        text = text.replace("{catch_count}", String.valueOf(catchCount));
        return text;
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection menuSection, Player player, int page) {
        ConfigurationSection keysSection = menuSection.getConfigurationSection("keys");
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            ConfigurationSection keySection = keysSection.getConfigurationSection(key);
            if (keySection == null) continue;
            String type = keySection.getString("type", key);
            ItemStack keyItem = this.createNavigationKeyItem(keySection, key, player, page);
            String slotsStr = keySection.getString("slots", "");
            List<Integer> slots = this.parseSlots(slotsStr);
            for (int slot : slots) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, keyItem);
            }
        }
    }

    private ItemStack createNavigationKeyItem(ConfigurationSection keySection, String keyType, Player player, int page) {
        ItemStack finalItem;
        ItemMeta meta;
        String type = keySection.getString("type", keyType);
        FileConfiguration messagesConfig = this.plugin.getMessageManager().getMessagesConfig();
        if (messagesConfig == null) {
            ConfigurationSection fallbackSection;
            FileConfiguration config = this.plugin.getConfigManager().getRarityMenuConfig();
            if (config != null && (fallbackSection = config.getConfigurationSection("MrUltimateFishing.Rarity.fallback-navigation")) != null) {
                String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                String fallbackName = fallbackSection.getString("display-name", "Navigation");
                List fallbackLore = fallbackSection.getStringList("lore");
                return this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
            }
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        ConfigurationSection menuKeysSection = messagesConfig.getConfigurationSection("menu-keys");
        if (menuKeysSection == null) {
            ConfigurationSection fallbackSection;
            FileConfiguration config = this.plugin.getConfigManager().getRarityMenuConfig();
            if (config != null && (fallbackSection = config.getConfigurationSection("MrUltimateFishing.Rarity.fallback-navigation")) != null) {
                String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                String fallbackName = fallbackSection.getString("display-name", "Navigation");
                List fallbackLore = fallbackSection.getStringList("lore");
                return this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
            }
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        ConfigurationSection itemSection = menuKeysSection.getConfigurationSection(type);
        if (itemSection == null) {
            ConfigurationSection fallbackSection;
            FileConfiguration config = this.plugin.getConfigManager().getRarityMenuConfig();
            if (config != null && (fallbackSection = config.getConfigurationSection("MrUltimateFishing.Rarity.fallback-navigation")) != null) {
                String fallbackMaterial = fallbackSection.getString("material", "ARROW");
                String fallbackName = fallbackSection.getString("display-name", "Navigation");
                List fallbackLore = fallbackSection.getStringList("lore");
                return this.createMenuItem(fallbackMaterial, fallbackName, fallbackLore, false);
            }
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        String material = itemSection.getString("material", "ARROW").toUpperCase();
        String displayName = itemSection.getString("display-name", "");
        ArrayList<String> lore = new ArrayList<String>(itemSection.getStringList("lore"));
        String currentRarity = this.getCurrentRarity(player.getUniqueId());
        Integer currentPage = this.getCurrentPage(player.getUniqueId());
        if (currentRarity != null) {
            String rarityName = this.plugin.getConfigManager().getRarityName(currentRarity);
            if (rarityName == null) {
                rarityName = currentRarity;
            }
            displayName = displayName.replace("[Rarity]", rarityName);
            displayName = displayName.replace("[CurrentPage]", String.valueOf((currentPage != null ? currentPage : page) + 1));
            displayName = displayName.replace("[Page]", String.valueOf((currentPage != null ? currentPage : page) + 1));
            for (int i = 0; i < lore.size(); ++i) {
                String loreLine = (String)lore.get(i);
                loreLine = loreLine.replace("[Rarity]", rarityName);
                loreLine = loreLine.replace("[CurrentPage]", String.valueOf((currentPage != null ? currentPage : page) + 1));
                loreLine = loreLine.replace("[Page]", String.valueOf((currentPage != null ? currentPage : page) + 1));
                lore.set(i, loreLine);
            }
        }
        if ((meta = (finalItem = this.createMenuItem(material, displayName, lore, false)).getItemMeta()) != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
            dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
            finalItem.setItemMeta(meta);
        }
        return finalItem;
    }

    public void handlePreviousPage(Player player, Inventory inventory) {
        String rarity = this.inventoryRarity.get(inventory);
        Integer currentPage = this.inventoryPages.get(inventory);
        if (rarity == null) {
            this.navigatingPlayers.remove(player.getUniqueId());
            return;
        }
        if (currentPage == null) {
            this.navigatingPlayers.remove(player.getUniqueId());
            return;
        }
        if (currentPage > 0) {
            int newPage = currentPage - 1;
            this.currentPages.put(player.getUniqueId(), newPage);
            this.openRarityMenu(player, rarity, newPage);
        } else {
            this.navigatingPlayers.remove(player.getUniqueId());
        }
    }

    private Integer extractCurrentPageFromTitle(String title) {
        if (title == null) {
            return null;
        }
        String cleanTitle = ChatColor.stripColor((String)title);
        Pattern pattern = Pattern.compile("\\((\\d+)/(\\d+)\\)");
        Matcher matcher = pattern.matcher(cleanTitle);
        if (matcher.find()) {
            try {
                int currentPage = Integer.parseInt(matcher.group(1)) - 1;
                return currentPage;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractRarityFromTitle(String title) {
        if (title == null) {
            return null;
        }
        String cleanTitle = ChatColor.stripColor((String)title);
        String[] rarityNames = this.getRarityNamesFromConfig();
        Arrays.sort(rarityNames, (a, b) -> Integer.compare(b.length(), a.length()));
        for (String rarity : rarityNames) {
            if (!cleanTitle.contains(rarity.toUpperCase()) && !cleanTitle.contains(rarity)) continue;
            return rarity;
        }
        return null;
    }

    public void handleNextPage(Player player, Inventory inventory) {
        String rarity = this.inventoryRarity.get(inventory);
        Integer currentPage = this.inventoryPages.get(inventory);
        if (rarity == null) {
            this.navigatingPlayers.remove(player.getUniqueId());
            return;
        }
        if (currentPage == null) {
            this.navigatingPlayers.remove(player.getUniqueId());
            return;
        }
        boolean hasNext = this.hasNextPage(rarity, currentPage);
        if (hasNext) {
            int newPage = currentPage + 1;
            this.currentPages.put(player.getUniqueId(), newPage);
            this.openRarityMenu(player, rarity, newPage);
        } else {
            this.navigatingPlayers.remove(player.getUniqueId());
        }
    }

    private boolean hasNextPage(String rarity, int currentPage) {
        List<String> fishIds = this.plugin.getConfigManager().getFishIdsByRarity(rarity);
        FileConfiguration menuConfig = this.plugin.getConfigManager().getRarityMenuConfig();
        if (menuConfig == null) {
            return false;
        }
        ConfigurationSection menuSection = menuConfig.getConfigurationSection("MrUltimateFishing.Rarity");
        if (menuSection == null) {
            return false;
        }
        ConfigurationSection fishItemSection = menuSection.getConfigurationSection("items.fish");
        if (fishItemSection == null) {
            return false;
        }
        String slotsStr = fishItemSection.getString("slots");
        if (slotsStr == null) {
            return false;
        }
        List<Integer> availableSlots = this.parseSlots(slotsStr);
        if (availableSlots.isEmpty()) {
            return false;
        }
        int itemsPerPage = availableSlots.size();
        int totalPages = (int)Math.ceil((double)fishIds.size() / (double)itemsPerPage);
        boolean hasNext = currentPage < totalPages - 1;
        return hasNext;
    }

    public void cleanupPlayer(UUID playerId) {
        this.currentRarity.remove(playerId);
        this.currentPages.remove(playerId);
    }

    public String getCurrentRarity(UUID playerId) {
        return this.currentRarity.get(playerId);
    }

    public Integer getCurrentPage(UUID playerId) {
        return this.currentPages.get(playerId);
    }

    public void openRarityCategoryMenu(Player player) {
        this.clearNavigatingFlag(player);
        FileConfiguration config = this.plugin.getConfigManager().getRarityCategoryConfig();
        if (config == null) {
            return;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.RarityCategory");
        if (menuSection == null) {
            return;
        }
        String title = menuSection.getString("title", "Rarity Categories");
        title = title.replace("[CurrentPage]", "1");
        title = title.replace("[TotalPages]", "1");
        title = MrLibColors.colorize((String)title);
        int size = menuSection.getInt("size", 54);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.registerRarityCategoryMenuInventory(inventory);
        ConfigurationSection decorationsSection = menuSection.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            this.addDecorations(inventory, decorationsSection);
        }
        this.addRarityCategoryItems(inventory, menuSection);
        this.addNavigationKeys(inventory, menuSection, player, 0);
        player.openInventory(inventory);
    }

    private void addRarityCategoryItems(Inventory inventory, ConfigurationSection menuSection) {
        ConfigurationSection items = menuSection.getConfigurationSection("items");
        if (items == null) {
            return;
        }
        for (String rarityKey : items.getKeys(false)) {
            ConfigurationSection item = items.getConfigurationSection(rarityKey);
            if (item == null) continue;
            List<String> fishIds = this.plugin.getConfigManager().getFishIdsByRarity(rarityKey);
            int fishCount = fishIds.size();
            ItemStack menuItem = this.createRarityCategoryItem(item, rarityKey, fishCount);
            List<Object> slots = new ArrayList<Integer>();
            Object slotsObj = item.get("slots");
            if (slotsObj != null) {
                if (slotsObj instanceof String) {
                    slots = this.parseSlots((String)slotsObj);
                } else if (slotsObj instanceof Number) {
                    slots.add(((Number)slotsObj).intValue());
                } else if (slotsObj instanceof List) {
                    List slotsList = (List)slotsObj;
                    for (Object slotObj : slotsList) {
                        if (!(slotObj instanceof Number)) continue;
                        slots.add(((Number)slotObj).intValue());
                    }
                }
            }
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, menuItem);
            }
            if (!slots.isEmpty()) continue;
        }
    }

    private ItemStack createRarityCategoryItem(ConfigurationSection itemSection, String rarityKey, int fishCount) {
        String material = itemSection.getString("material", "BOOK");
        String displayName = itemSection.getString("display-name", rarityKey);
        ArrayList<String> lore = new ArrayList<String>(itemSection.getStringList("lore"));
        boolean glowing = itemSection.getBoolean("glowing", false);
        displayName = displayName.replace("[NumberofFish]", String.valueOf(fishCount));
        for (int i = 0; i < lore.size(); ++i) {
            String loreLine = (String)lore.get(i);
            loreLine = loreLine.replace("[NumberofFish]", String.valueOf(fishCount));
            lore.set(i, loreLine);
        }
        return this.createMenuItem(material, displayName, lore, glowing);
    }

    public void cleanupPlayerData(Player player) {
        if (this.navigatingPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.cleanupPlayer(player.getUniqueId());
    }

    @EventHandler
    public void handleInventoryClick(InventoryClickEvent event) {
        NamespacedKey navigationKey;
        Inventory inventory = event.getInventory();
        if (!this.isAnyRarityMenu(inventory)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (dataContainer.has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
            String navigationType = (String)dataContainer.get(navigationKey, PersistentDataType.STRING);
            if ("previous-page".equals(navigationType) || "prev".equals(navigationType)) {
                this.navigatingPlayers.add(player.getUniqueId());
                this.handlePreviousPage(player, inventory);
                return;
            }
            if ("next-page".equals(navigationType) || "next".equals(navigationType)) {
                this.navigatingPlayers.add(player.getUniqueId());
                this.handleNextPage(player, inventory);
                return;
            }
            if ("back".equals(navigationType)) {
                boolean isRarityMenuCheck = this.isRarityMenu(inventory);
                boolean isRarityCategoryMenuCheck = this.isRarityCategoryMenu(inventory);
                if (isRarityMenuCheck) {
                    this.navigatingPlayers.add(player.getUniqueId());
                    this.openRarityCategoryMenu(player);
                } else if (isRarityCategoryMenuCheck) {
                    this.clearNavigatingFlag(player);
                    this.plugin.getMenuManager().openHeadMenu(player);
                }
                return;
            }
        }
        if (this.isRarityCategoryMenu(inventory)) {
            String rarity;
            displayName = meta.getDisplayName();
            if (displayName != null && !displayName.isEmpty() && (rarity = this.getRarityFromClick(event.getSlot(), displayName)) != null) {
                this.openRarityMenu(player, rarity, 0);
                return;
            }
        } else if (this.isRarityMenu(inventory)) {
            displayName = meta.getDisplayName();
            if (this.isFishItem(clickedItem, event.getSlot())) {
                this.handleFishClick(player, clickedItem, event.getSlot());
                return;
            }
        }
    }

    @EventHandler
    public void handleInventoryClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        if (this.isRarityMenuRegistered(inventory)) {
            Player player = (Player)event.getPlayer();
            if (this.navigatingPlayers.contains(player.getUniqueId())) {
                this.navigatingPlayers.remove(player.getUniqueId());
            } else {
                this.cleanupPlayerData(player);
            }
            this.unregisterRarityMenuInventory(inventory);
            this.inventoryRarity.remove(inventory);
            this.inventoryPages.remove(inventory);
        } else if (this.isRarityCategoryMenuRegistered(inventory)) {
            Player player = (Player)event.getPlayer();
            if (this.navigatingPlayers.contains(player.getUniqueId())) {
                this.navigatingPlayers.remove(player.getUniqueId());
            } else {
                this.cleanupPlayerData(player);
            }
            this.unregisterRarityCategoryMenuInventory(inventory);
        }
    }

    @EventHandler
    public void handleInventoryDrag(InventoryDragEvent event) {
        Inventory inventory = event.getInventory();
        if (this.isAnyRarityMenu(inventory)) {
            event.setCancelled(true);
        }
    }

    private boolean isRarityMenu(Inventory inventory) {
        return this.isRarityMenuRegistered(inventory);
    }

    private boolean isRarityCategoryMenu(Inventory inventory) {
        return this.isRarityCategoryMenuRegistered(inventory);
    }

    private boolean isRarityMenuByTitle(Inventory inventory) {
        return false;
    }

    private boolean isAnyRarityMenu(Inventory inventory) {
        boolean isCategoryMenu = this.isRarityCategoryMenu(inventory);
        boolean isSpecificRarityMenu = this.isRarityMenu(inventory);
        return isCategoryMenu || isSpecificRarityMenu;
    }

    private String getRarityFromClick(int slot, String displayName) {
        ConfigurationSection raritySection;
        FileConfiguration config = this.plugin.getConfigManager().getRarityCategoryConfig();
        if (config == null) {
            return null;
        }
        ConfigurationSection menuSection = config.getConfigurationSection("MrUltimateFishing.RarityCategory");
        if (menuSection == null) {
            return null;
        }
        ConfigurationSection itemsSection = menuSection.getConfigurationSection("items");
        if (itemsSection == null) {
            return null;
        }
        for (String rarityKey : itemsSection.getKeys(false)) {
            raritySection = itemsSection.getConfigurationSection(rarityKey);
            if (raritySection == null) continue;
            Object slotsObj = raritySection.get("slots");
            List<Object> slots = new ArrayList();
            if (slotsObj != null) {
                if (slotsObj instanceof String) {
                    slots = this.parseSlots((String)slotsObj);
                } else if (slotsObj instanceof Number) {
                    int slotValue = ((Number)slotsObj).intValue();
                    slots.add(slotValue);
                } else if (slotsObj instanceof List) {
                    List slotsList = (List)slotsObj;
                    for (Object slotObj : slotsList) {
                        if (slotObj instanceof Number) {
                            slots.add(((Number)slotObj).intValue());
                            continue;
                        }
                        if (!(slotObj instanceof String)) continue;
                        try {
                            slots.add(Integer.parseInt((String)slotObj));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    try {
                        String slotsStr = slotsObj.toString();
                        if (slotsStr.matches("\\d+")) {
                            slots.add(Integer.parseInt(slotsStr));
                        }
                        slots = this.parseSlots(slotsStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!slots.contains(slot)) continue;
            return rarityKey;
        }
        for (String rarityKey : itemsSection.getKeys(false)) {
            raritySection = itemsSection.getConfigurationSection(rarityKey);
            if (raritySection == null) continue;
            Object object = raritySection.get("slots");
        }
        return null;
    }

    private boolean isFishItem(ItemStack item, int slot) {
        NamespacedKey navigationKey;
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (dataContainer.has(navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation"), PersistentDataType.STRING)) {
            return false;
        }
        String displayName = meta.getDisplayName();
        return displayName != null && !displayName.trim().isEmpty() && item.getType() != Material.AIR;
    }

    private void handleFishClick(Player player, ItemStack fishItem, int slot) {
        if (fishItem == null || !fishItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = fishItem.getItemMeta();
        String fishName = meta.getDisplayName();
        if (fishName != null && !fishName.trim().isEmpty()) {
            String message = MrLibColors.colorize((String)("&aYou clicked on fish: &e" + fishName));
            this.plugin.sendMessage(player, message);
        } else {
            String message = MrLibColors.colorize((String)"&aYou clicked on a fish item!");
            this.plugin.sendMessage(player, message);
        }
        try {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearNavigatingFlag(UUID playerId) {
        this.navigatingPlayers.remove(playerId);
    }

    public void clearNavigatingFlag(Player player) {
        this.clearNavigatingFlag(player.getUniqueId());
    }

    private String[] getRarityNamesFromConfig() {
        ConfigurationSection raritySection;
        FileConfiguration config = this.plugin.getConfigManager().getMainConfig();
        if (config != null && config.contains("MrUltimateFishing.Rarity.rarities")) {
            List rarities = config.getStringList("MrUltimateFishing.Rarity.rarities");
            return rarities.toArray(new String[0]);
        }
        if (config != null && config.contains("MrUltimateFishing.Rarity.default-rarities")) {
            List rarities = config.getStringList("MrUltimateFishing.Rarity.default-rarities");
            return rarities.toArray(new String[0]);
        }
        FileConfiguration rarityConfig = this.plugin.getConfigManager().getRarityConfig();
        if (rarityConfig != null && (raritySection = rarityConfig.getConfigurationSection("MrUltimateFishing.Rarity")) != null) {
            Set rarityKeys = raritySection.getKeys(false);
            return rarityKeys.toArray(new String[0]);
        }
        return new String[]{"COMMON", "UNCOMMON", "RARE", "EPIC", "LEGENDARY", "MYTHIC", "ULTIMATE"};
    }
}

