/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private final MessageManager messageManager;
    private FileConfiguration fishConfig;
    private FileConfiguration rarityConfig;
    private FileConfiguration rarityMenuConfig;
    private FileConfiguration mainConfig;
    private FileConfiguration headMenuConfig;
    private FileConfiguration sellFishConfig;
    private FileConfiguration rarityCategoryConfig;
    private FileConfiguration guttingConfig;
    private File fishFile;
    private File rarityFile;
    private File rarityMenuFile;
    private File headMenuFile;
    private File sellFishFile;
    private File rarityCategoryFile;
    private File guttingFile;
    private File upgradesFile;
    private File recipesFile;
    private FileConfiguration upgradesConfig;
    private FileConfiguration recipesConfig;
    private FileConfiguration boostersConfig;
    private FileConfiguration deliveryConfig;
    private FileConfiguration deliveryMenuConfig;
    private File boostersFile;
    private File deliveryFile;
    private File deliveryMenuFile;

    public ConfigManager(JavaPlugin plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.loadConfigs();
    }

    public void loadConfigs() {
        this.loadMainConfig();
        this.loadFishConfig();
        this.loadRarityConfig();
        this.loadRarityMenuConfig();
        this.loadHeadMenuConfig();
        this.loadSellFishConfig();
        this.loadRarityCategoryConfig();
        this.loadGuttingConfig();
        this.loadUpgradesConfig();
        this.loadRecipesConfig();
        this.loadBoostersConfig();
        this.loadTotemConfig();
        this.loadShopConfig();
        this.loadDeliveryConfig();
        this.loadDeliveryMenuConfig();
    }

    private void loadMainConfig() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            File configFile = new File(this.plugin.getDataFolder(), "config.yml");
            this.mainConfig = YamlConfiguration.loadConfiguration((File)configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading main configuration file: " + e.getMessage());
        }
    }

    private void loadFishConfig() {
        try {
            this.fishFile = new File(this.plugin.getDataFolder(), "fish.yml");
            this.fishConfig = YamlConfiguration.loadConfiguration((File)this.fishFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading fish configuration file: " + e.getMessage());
        }
    }

    private void loadRarityConfig() {
        try {
            this.rarityFile = new File(this.plugin.getDataFolder(), "rarity.yml");
            this.rarityConfig = YamlConfiguration.loadConfiguration((File)this.rarityFile);
            if (this.rarityConfig != null) {
                double d = this.rarityConfig.getDouble("MrUltimateFishing.Rarity.COMMON.sell-price", 0.0);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading rarity configuration file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadRarityMenuConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.rarityMenuFile = new File(menusDir, "rarity.yml");
            this.rarityMenuConfig = YamlConfiguration.loadConfiguration((File)this.rarityMenuFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading rarity menu configuration file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadHeadMenuConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.headMenuFile = new File(menusDir, "headmenu.yml");
            if (!this.headMenuFile.exists()) {
                // empty if block
            }
            this.headMenuConfig = YamlConfiguration.loadConfiguration((File)this.headMenuFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading head menu configuration file: " + e.getMessage());
        }
    }

    private void loadSellFishConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.sellFishFile = new File(menusDir, "sellfish.yml");
            if (!this.sellFishFile.exists()) {
                // empty if block
            }
            this.sellFishConfig = YamlConfiguration.loadConfiguration((File)this.sellFishFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading sell fish configuration file: " + e.getMessage());
        }
    }

    private void loadRarityCategoryConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.rarityCategoryFile = new File(menusDir, "raritycategory.yml");
            if (!this.rarityCategoryFile.exists()) {
                // empty if block
            }
            this.rarityCategoryConfig = YamlConfiguration.loadConfiguration((File)this.rarityCategoryFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading rarity category configuration file: " + e.getMessage());
        }
    }

    private void loadGuttingConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.guttingFile = new File(menusDir, "gutting.yml");
            if (!this.guttingFile.exists()) {
                // empty if block
            }
            this.guttingConfig = YamlConfiguration.loadConfiguration((File)this.guttingFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading gutting configuration file: " + e.getMessage());
        }
    }

    private void loadUpgradesConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.upgradesFile = new File(menusDir, "upgrades.yml");
            if (!this.upgradesFile.exists()) {
                // empty if block
            }
            this.upgradesConfig = YamlConfiguration.loadConfiguration((File)this.upgradesFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading upgrades configuration file: " + e.getMessage());
        }
    }

    private void loadRecipesConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.recipesFile = new File(menusDir, "recipes.yml");
            if (!this.recipesFile.exists()) {
                // empty if block
            }
            this.recipesConfig = YamlConfiguration.loadConfiguration((File)this.recipesFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading recipes configuration file: " + e.getMessage());
        }
    }

    private void loadBoostersConfig() {
        try {
            this.boostersFile = new File(this.plugin.getDataFolder(), "boosters.yml");
            if (!this.boostersFile.exists()) {
                // empty if block
            }
            this.boostersConfig = YamlConfiguration.loadConfiguration((File)this.boostersFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading boosters configuration file: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadTotemConfig() {
        try {
            File totemFile;
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            if ((totemFile = new File(menusDir, "totem.yml")).exists()) return;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading totem configuration file: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadShopConfig() {
        try {
            File shopFile;
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            if ((shopFile = new File(menusDir, "shop.yml")).exists()) return;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading shop configuration file: " + e.getMessage());
        }
    }

    private void loadDeliveryConfig() {
        try {
            this.deliveryFile = new File(this.plugin.getDataFolder(), "delivery.yml");
            if (!this.deliveryFile.exists()) {
                // empty if block
            }
            this.deliveryConfig = YamlConfiguration.loadConfiguration((File)this.deliveryFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading delivery configuration file: " + e.getMessage());
        }
    }

    private void loadDeliveryMenuConfig() {
        try {
            File menusDir = new File(this.plugin.getDataFolder(), "Menus");
            if (!menusDir.exists()) {
                menusDir.mkdirs();
            }
            this.deliveryMenuFile = new File(menusDir, "delivery.yml");
            if (!this.deliveryMenuFile.exists()) {
                // empty if block
            }
            this.deliveryMenuConfig = YamlConfiguration.loadConfiguration((File)this.deliveryMenuFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading delivery menu configuration file: " + e.getMessage());
        }
    }

    public void reloadConfigs() {
        try {
            if (this.fishFile != null && this.fishFile.exists()) {
                this.fishConfig = YamlConfiguration.loadConfiguration((File)this.fishFile);
            }
            if (this.rarityFile != null && this.rarityFile.exists()) {
                this.rarityConfig = YamlConfiguration.loadConfiguration((File)this.rarityFile);
            }
            if (this.rarityMenuFile != null && this.rarityMenuFile.exists()) {
                this.rarityMenuConfig = YamlConfiguration.loadConfiguration((File)this.rarityMenuFile);
            }
            if (this.headMenuFile != null && this.headMenuFile.exists()) {
                this.headMenuConfig = YamlConfiguration.loadConfiguration((File)this.headMenuFile);
            }
            if (this.sellFishFile != null && this.sellFishFile.exists()) {
                this.sellFishConfig = YamlConfiguration.loadConfiguration((File)this.sellFishFile);
            }
            if (this.rarityCategoryFile != null && this.rarityCategoryFile.exists()) {
                this.rarityCategoryConfig = YamlConfiguration.loadConfiguration((File)this.rarityCategoryFile);
            }
            if (this.guttingFile != null && this.guttingFile.exists()) {
                this.guttingConfig = YamlConfiguration.loadConfiguration((File)this.guttingFile);
            }
            if (this.upgradesFile != null && this.upgradesFile.exists()) {
                this.upgradesConfig = YamlConfiguration.loadConfiguration((File)this.upgradesFile);
            }
            if (this.recipesFile != null && this.recipesFile.exists()) {
                this.recipesConfig = YamlConfiguration.loadConfiguration((File)this.recipesFile);
            }
            if (this.boostersFile != null && this.boostersFile.exists()) {
                this.boostersConfig = YamlConfiguration.loadConfiguration((File)this.boostersFile);
            }
            if (this.deliveryFile != null && this.deliveryFile.exists()) {
                this.deliveryConfig = YamlConfiguration.loadConfiguration((File)this.deliveryFile);
            }
            if (this.deliveryMenuFile != null && this.deliveryMenuFile.exists()) {
                this.deliveryMenuConfig = YamlConfiguration.loadConfiguration((File)this.deliveryMenuFile);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error reloading configuration files: " + e.getMessage());
        }
    }

    public FileConfiguration getFishConfig() {
        return this.fishConfig;
    }

    public Set<String> getAllFishIds() {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getConfigurationSection("MrUltimateFishing").getKeys(false);
    }

    public String getFishRarity(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Fish.rarity");
    }

    public String getFishDisplayName(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Item.display-name");
    }

    public String getFishDescription(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Item.description");
    }

    public String getFishMaterial(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Item.material");
    }

    public boolean getFishGlowing(String fishId) {
        if (this.fishConfig == null) {
            return false;
        }
        return this.fishConfig.getBoolean("MrUltimateFishing." + fishId + ".Item.glowing", false);
    }

    public String getFishBiome(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Fish.catchable-biome");
    }

    public String getFishTime(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Fish.catchable-time");
    }

    public String getFishWeather(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getString("MrUltimateFishing." + fishId + ".Fish.catchable-weather");
    }

    public boolean getFishOverrideRarity(String fishId) {
        if (this.fishConfig == null) {
            return false;
        }
        return this.fishConfig.getBoolean("MrUltimateFishing." + fishId + ".Fish.Overide-Rarity", false);
    }

    public double getFishSellPrice(String fishId) {
        if (this.fishConfig == null) {
            return 0.0;
        }
        return this.fishConfig.getDouble("MrUltimateFishing." + fishId + ".Fish.sell-price", 0.0);
    }

    public double getFishCatchChance(String fishId) {
        if (this.fishConfig == null) {
            return 0.0;
        }
        return this.fishConfig.getDouble("MrUltimateFishing." + fishId + ".Fish.chance-to-catch", 0.0);
    }

    public List<String> getFishLore(String fishId) {
        if (this.fishConfig == null) {
            return null;
        }
        return this.fishConfig.getStringList("MrUltimateFishing." + fishId + ".Item.lore");
    }

    public double getRarityXPReward(String rarityId) {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        String xpPerCatch = this.rarityConfig.getString("MrUltimateFishing.Rarity." + rarityId + ".xp-per-catch", "10");
        if (xpPerCatch.contains("-")) {
            String[] parts = xpPerCatch.split("-");
            if (parts.length == 2) {
                try {
                    int min = Integer.parseInt(parts[0].trim());
                    int max = Integer.parseInt(parts[1].trim());
                    int result = min + (int)(Math.random() * (double)(max - min + 1));
                    return result;
                }
                catch (NumberFormatException e) {
                    return 10.0;
                }
            }
        } else {
            try {
                int result = Integer.parseInt(xpPerCatch.trim());
                return result;
            }
            catch (NumberFormatException e) {
                return 10.0;
            }
        }
        return 10.0;
    }

    public double getFishXPReward(String fishId) {
        if (this.fishConfig == null) {
            return 0.0;
        }
        return this.fishConfig.getDouble("MrUltimateFishing." + fishId + ".Fish.xp-reward", 0.0);
    }

    public double getFishFishScale(String fishId) {
        if (this.fishConfig == null) {
            return 0.0;
        }
        return this.fishConfig.getDouble("MrUltimateFishing." + fishId + ".Fish.fish-scales", 0.0);
    }

    public double getFishChanceToCatch(String fishId) {
        if (this.fishConfig == null) {
            return 0.0;
        }
        return this.fishConfig.getDouble("MrUltimateFishing." + fishId + ".Fish.chance-to-catch", 0.0);
    }

    public double getRarityChanceToCatch(String rarityId) {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        return this.rarityConfig.getDouble("MrUltimateFishing.Rarity." + rarityId + ".chance-to-catch", 0.0);
    }

    public FileConfiguration getRarityConfig() {
        return this.rarityConfig;
    }

    public Set<String> getAllRarities() {
        if (this.rarityConfig == null) {
            return null;
        }
        return this.rarityConfig.getConfigurationSection("MrUltimateFishing.Rarity").getKeys(false);
    }

    public String getRarityDisplayName(String rarity) {
        if (this.rarityConfig == null) {
            return null;
        }
        return this.rarityConfig.getString("MrUltimateFishing.Rarity." + rarity + ".display-name");
    }

    public String getRarityName(String rarity) {
        if (this.rarityConfig == null) {
            return null;
        }
        String rarityName = this.rarityConfig.getString("MrUltimateFishing.Rarity." + rarity + ".rarity-name");
        return rarityName != null ? rarityName : rarity;
    }

    public double getRarityCatchChance(String rarity) {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        return this.rarityConfig.getDouble("MrUltimateFishing.Rarity." + rarity + ".chance-to-catch", 0.0);
    }

    public double getRaritySellPrice(String rarity) {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        return this.rarityConfig.getDouble("MrUltimateFishing.Rarity." + rarity + ".sell-price", 0.0);
    }

    public double getRarityFishScale(String rarity) {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        String fishScales = this.rarityConfig.getString("MrUltimateFishing.Rarity." + rarity + ".fish-scales", "0");
        if (fishScales.contains("-")) {
            String[] parts = fishScales.split("-");
            if (parts.length == 2) {
                try {
                    int min = Integer.parseInt(parts[0].trim());
                    int max = Integer.parseInt(parts[1].trim());
                    int result = min + (int)(Math.random() * (double)(max - min + 1));
                    return result;
                }
                catch (NumberFormatException e) {
                    return 0.0;
                }
            }
        } else {
            try {
                int result = Integer.parseInt(fishScales.trim());
                return result;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public String getRarityXpToLevel(String rarity) {
        if (this.rarityConfig == null) {
            return null;
        }
        String xpPerCatch = this.rarityConfig.getString("MrUltimateFishing.Rarity." + rarity + ".xp-per-catch");
        return xpPerCatch;
    }

    public List<String> getRarityFishLore(String rarityId) {
        if (this.rarityConfig == null) {
            return new ArrayList<String>();
        }
        return this.rarityConfig.getStringList("MrUltimateFishing.Rarity." + rarityId + ".fish-lore");
    }

    public List<String> getFishBiomes(String fishId) {
        if (this.fishConfig == null) {
            return new ArrayList<String>();
        }
        String biomesString = this.fishConfig.getString("MrUltimateFishing." + fishId + ".Fish.catchable-biome", "ALL");
        if (biomesString == null || biomesString.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> biomes = new ArrayList<String>();
        for (String biome : biomesString.split(",")) {
            biomes.add(biome.trim().toUpperCase());
        }
        return biomes;
    }

    public double getFishWeight(String fishId) {
        return (double)Math.round((0.1 + Math.random() * 9.9) * 100.0) / 100.0;
    }

    public double getVanillaFishSellPrice() {
        if (this.rarityConfig == null) {
            return 50.0;
        }
        return this.rarityConfig.getDouble("MrUltimateFishing.VanillaFish.sell-price", 50.0);
    }

    public double getVanillaFishXPReward() {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        String xpPerCatch = this.rarityConfig.getString("MrUltimateFishing.VanillaFish.xp-per-catch", "10");
        if (xpPerCatch.contains("-")) {
            String[] parts = xpPerCatch.split("-");
            if (parts.length == 2) {
                try {
                    int min = Integer.parseInt(parts[0].trim());
                    int max = Integer.parseInt(parts[1].trim());
                    int result = min + (int)(Math.random() * (double)(max - min + 1));
                    return result;
                }
                catch (NumberFormatException e) {
                    return 10.0;
                }
            }
        } else {
            try {
                int result = Integer.parseInt(xpPerCatch.trim());
                return result;
            }
            catch (NumberFormatException e) {
                return 10.0;
            }
        }
        return 10.0;
    }

    public double getVanillaFishScale() {
        if (this.rarityConfig == null) {
            return 0.0;
        }
        String fishScales = this.rarityConfig.getString("MrUltimateFishing.VanillaFish.fish-scales", "0");
        if (fishScales.contains("-")) {
            String[] parts = fishScales.split("-");
            if (parts.length == 2) {
                try {
                    int min = Integer.parseInt(parts[0].trim());
                    int max = Integer.parseInt(parts[1].trim());
                    int result = min + (int)(Math.random() * (double)(max - min + 1));
                    return result;
                }
                catch (NumberFormatException e) {
                    return 0.0;
                }
            }
        } else {
            try {
                int result = Integer.parseInt(fishScales.trim());
                return result;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public List<String> getFishNames() {
        Set<String> fishIds;
        ArrayList<String> fishNames = new ArrayList<String>();
        if (this.fishConfig != null && (fishIds = this.getAllFishIds()) != null) {
            for (String fishId : fishIds) {
                fishNames.add(this.getCleanFishName(fishId));
            }
        }
        return fishNames;
    }

    public List<String> getFishCommandSuggestions() {
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        Set<String> fishIds = this.getAllFishIds();
        if (fishIds != null) {
            suggestions.addAll(fishIds);
            for (String fishId : fishIds) {
                String cleanName = this.getCleanFishName(fishId);
                if (cleanName == null || cleanName.isEmpty()) continue;
                suggestions.add(cleanName.replace(' ', '_'));
            }
        }
        return new ArrayList<String>(suggestions);
    }

    public boolean fishExists(String fishName) {
        if (this.fishConfig == null) {
            return false;
        }
        Set<String> fishIds = this.getAllFishIds();
        if (fishIds == null) {
            return false;
        }
        if (fishIds.contains(fishName)) {
            return true;
        }
        String normalized = fishName.replace('_', ' ');
        for (String fishId : fishIds) {
            String cleanName = this.getCleanFishName(fishId);
            if (!cleanName.equalsIgnoreCase(normalized)) continue;
            return true;
        }
        return false;
    }

    public String getFishIdByName(String fishName) {
        if (this.fishConfig == null) {
            return null;
        }
        Set<String> fishIds = this.getAllFishIds();
        if (fishIds == null) {
            return null;
        }
        String normalized = fishName.replace('_', ' ');
        if (fishIds.contains(fishName)) {
            return fishName;
        }
        for (String fishId : fishIds) {
            String cleanName = this.getCleanFishName(fishId);
            if (!cleanName.equalsIgnoreCase(normalized)) continue;
            return fishId;
        }
        return null;
    }

    public String getCleanFishName(String fishId) {
        if (fishId == null) {
            return null;
        }
        String displayName = this.getFishDisplayName(fishId);
        String cleaned = this.cleanFishName(displayName);
        if (cleaned == null || cleaned.isEmpty()) {
            return fishId;
        }
        return cleaned;
    }

    private String cleanFishName(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[&\u00a7][0-9a-fk-or]", "").replaceAll("\\{[^}]*\\}", "").trim();
    }

    public boolean isFishingEnabled() {
        if (this.mainConfig == null) {
            return true;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Fishing.Enabled")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Fishing.Enabled", true);
        }
        return this.mainConfig.getBoolean("fishing.enabled", true);
    }

    public boolean isReplaceVanilla() {
        if (this.mainConfig == null) {
            return true;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Fishing.Replace-Vanilla")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Fishing.Replace-Vanilla", true);
        }
        return this.mainConfig.getBoolean("fishing.replace-vanilla", true);
    }

    public boolean isDebugEnabled() {
        if (this.mainConfig == null) {
            return false;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Debug.Enabled")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Debug.Enabled", false);
        }
        return this.mainConfig.getBoolean("debug.enabled", false);
    }

    public String getPrefix() {
        if (this.mainConfig == null) {
            return "&8[&6MrUltimateFishing&8]&r ";
        }
        if (this.mainConfig.contains("MrUltimateFishing.General.Prefix")) {
            return this.mainConfig.getString("MrUltimateFishing.General.Prefix", "&8[&6MrUltimateFishing&8]&r ");
        }
        return this.mainConfig.getString("MrUltimateFishing.general.prefix", this.mainConfig.getString("general.prefix", "&8[&6MrUltimateFishing&8]&r "));
    }

    public boolean isLevelingEnabled() {
        if (this.mainConfig == null) {
            return true;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Leveling.Enabled")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Leveling.Enabled", true);
        }
        return this.mainConfig.getBoolean("leveling.enabled", true);
    }

    public int getMaxLevel() {
        if (this.mainConfig == null) {
            return 100;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Leveling.Max-Level")) {
            return this.mainConfig.getInt("MrUltimateFishing.Leveling.Max-Level", 100);
        }
        return this.mainConfig.getInt("leveling.max-level", 100);
    }

    public int getBaseXP() {
        if (this.mainConfig == null) {
            return 100;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Leveling.Base-XP")) {
            return this.mainConfig.getInt("MrUltimateFishing.Leveling.Base-XP", 100);
        }
        return this.mainConfig.getInt("leveling.base-xp", 100);
    }

    public double getXPMultiplier() {
        if (this.mainConfig == null) {
            return 1.5;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Leveling.XP-Multiplier")) {
            return this.mainConfig.getDouble("MrUltimateFishing.Leveling.XP-Multiplier", 1.5);
        }
        return this.mainConfig.getDouble("leveling.xp-multiplier", 1.5);
    }

    public boolean isFishScaleEnabled() {
        if (this.mainConfig == null) {
            return true;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Economy.Fish-Scale.Enabled")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Economy.Fish-Scale.Enabled", true);
        }
        return this.mainConfig.getBoolean("economy.fish-scale.enabled", true);
    }

    public int getStartingFishScale() {
        if (this.mainConfig == null) {
            return 0;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Economy.Fish-Scale.Starting-Amount")) {
            return this.mainConfig.getInt("MrUltimateFishing.Economy.Fish-Scale.Starting-Amount", 0);
        }
        return this.mainConfig.getInt("economy.fish-scale.starting-amount", 0);
    }

    public int getMaxFishScale() {
        if (this.mainConfig == null) {
            return 999999;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Economy.Fish-Scale.Max-Amount")) {
            return this.mainConfig.getInt("MrUltimateFishing.Economy.Fish-Scale.Max-Amount", 999999);
        }
        return this.mainConfig.getInt("economy.fish-scale.max-amount", 999999);
    }

    public boolean isTrackFirstCatch() {
        if (this.mainConfig == null) {
            return true;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Player-Data.Track-First-Catch")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Player-Data.Track-First-Catch", true);
        }
        return this.mainConfig.getBoolean("player-data.track-first-catch", true);
    }

    public boolean isAutoSaveEnabled() {
        if (this.mainConfig == null) {
            return true;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Player-Data.Auto-Save")) {
            return this.mainConfig.getBoolean("MrUltimateFishing.Player-Data.Auto-Save", true);
        }
        return this.mainConfig.getBoolean("player-data.auto-save", true);
    }

    public int getSaveInterval() {
        if (this.mainConfig == null) {
            return 5;
        }
        if (this.mainConfig.contains("MrUltimateFishing.Player-Data.Save-Interval")) {
            return this.mainConfig.getInt("MrUltimateFishing.Player-Data.Save-Interval", 5);
        }
        return this.mainConfig.getInt("player-data.save-interval", 5);
    }

    public String getFishFirstCatcher(String fishId) {
        MrUltimateFishing mrPlugin = (MrUltimateFishing)this.plugin;
        return mrPlugin.getPlayerDataManager().getFirstCatchPlayer(fishId);
    }

    public int getFishCatchCount(String fishId) {
        MrUltimateFishing mrPlugin = (MrUltimateFishing)this.plugin;
        PlayerDataManager playerDataManager = mrPlugin.getPlayerDataManager();
        return playerDataManager.getFishCatchCount(fishId);
    }

    public List<String> getFishIdsByRarity(String rarity) {
        ArrayList<String> fishIds = new ArrayList<String>();
        if (this.fishConfig == null) {
            return fishIds;
        }
        Set<String> allFishIds = this.getAllFishIds();
        if (allFishIds != null) {
            for (String fishId : allFishIds) {
                String fishRarity = this.getFishRarity(fishId);
                if (fishRarity == null || !fishRarity.equalsIgnoreCase(rarity)) continue;
                fishIds.add(fishId);
            }
        }
        return fishIds;
    }

    public int getFishCountByRarity(String rarity) {
        return this.getFishIdsByRarity(rarity).size();
    }

    public FileConfiguration getHeadMenuConfig() {
        return this.headMenuConfig;
    }

    public FileConfiguration getMainConfig() {
        return this.mainConfig;
    }

    public FileConfiguration getSellFishConfig() {
        return this.sellFishConfig;
    }

    public FileConfiguration getRarityCategoryConfig() {
        return this.rarityCategoryConfig;
    }

    public FileConfiguration getRarityMenuConfig() {
        return this.rarityMenuConfig;
    }

    public FileConfiguration getGuttingConfig() {
        return this.guttingConfig;
    }

    public FileConfiguration getUpgradesConfig() {
        return this.upgradesConfig;
    }

    public FileConfiguration getRecipesConfig() {
        return this.recipesConfig;
    }

    public FileConfiguration getBoostersConfig() {
        return this.boostersConfig;
    }

    public int getRarityGuttingValue(String rarity) {
        if (this.rarityConfig == null) {
            return 0;
        }
        return this.rarityConfig.getInt("MrUltimateFishing.Rarity." + rarity + ".gutting", 0);
    }

    public int getVanillaFishGuttingValue() {
        if (this.rarityConfig == null) {
            return 0;
        }
        return this.rarityConfig.getInt("MrUltimateFishing.VanillaFish.gutting", 0);
    }

    public Object getEconomy() {
        MrUltimateFishing mrPlugin = (MrUltimateFishing)this.plugin;
        return mrPlugin.getVaultManager();
    }

    public String getConfigString(String path, String defaultValue) {
        if (this.mainConfig == null) {
            return defaultValue;
        }
        String newPath = "MrUltimateFishing." + path;
        if (this.mainConfig.contains(newPath)) {
            return this.mainConfig.getString(newPath, defaultValue);
        }
        return this.mainConfig.getString(path, defaultValue);
    }

    public int getConfigInt(String path, int defaultValue) {
        if (this.mainConfig == null) {
            return defaultValue;
        }
        String newPath = "MrUltimateFishing." + path;
        if (this.mainConfig.contains(newPath)) {
            return this.mainConfig.getInt(newPath, defaultValue);
        }
        return this.mainConfig.getInt(path, defaultValue);
    }

    public double getConfigDouble(String path, double defaultValue) {
        if (this.mainConfig == null) {
            return defaultValue;
        }
        String newPath = "MrUltimateFishing." + path;
        if (this.mainConfig.contains(newPath)) {
            return this.mainConfig.getDouble(newPath, defaultValue);
        }
        return this.mainConfig.getDouble(path, defaultValue);
    }

    public boolean getConfigBoolean(String path, boolean defaultValue) {
        if (this.mainConfig == null) {
            return defaultValue;
        }
        String newPath = "MrUltimateFishing." + path;
        if (this.mainConfig.contains(newPath)) {
            return this.mainConfig.getBoolean(newPath, defaultValue);
        }
        return this.mainConfig.getBoolean(path, defaultValue);
    }

    public String getRareRarity() {
        if (this.rarityConfig == null) {
            return null;
        }
        for (String rarity : this.getAllRarities()) {
            if (!this.rarityConfig.getBoolean("MrUltimateFishing.Rarity." + rarity + ".RareRarity", false)) continue;
            return rarity;
        }
        return null;
    }

    public String getEpicRarity() {
        if (this.rarityConfig == null) {
            return null;
        }
        for (String rarity : this.getAllRarities()) {
            if (!this.rarityConfig.getBoolean("MrUltimateFishing.Rarity." + rarity + ".EpicRarity", false)) continue;
            return rarity;
        }
        return null;
    }

    public FileConfiguration getDeliveryConfig() {
        return this.deliveryConfig;
    }

    public FileConfiguration getDeliveryMenuConfig() {
        return this.deliveryMenuConfig;
    }
}

