/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.FishItem;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.effects.TornadoEffect;
import eu.mrneznamy.mrultimatefishing.effects.TsunamiEffect;
import eu.mrneznamy.mrultimatefishing.managers.BoosterManager;
import eu.mrneznamy.mrultimatefishing.managers.EventManager;
import eu.mrneznamy.mrultimatefishing.managers.TotemManager;
import eu.mrneznamy.mrultimatefishing.managers.UpgradeMenuManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FishingManager
implements Listener {
    private final MrUltimateFishing plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final Random random;
    private final Set<UUID> processingPlayers;
    private final Map<UUID, Long> activeFishers;
    private final Map<UUID, Long> lastFishingActivity;
    private final TornadoEffect tornadoEffect;
    private final TsunamiEffect tsunamiEffect;

    public FishingManager(MrUltimateFishing plugin, ConfigManager configManager, MessageManager messageManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messageManager = messageManager;
        this.random = new Random();
        this.processingPlayers = new HashSet<UUID>();
        this.activeFishers = new HashMap<UUID, Long>();
        this.lastFishingActivity = new HashMap<UUID, Long>();
        this.tornadoEffect = new TornadoEffect(plugin);
        this.tsunamiEffect = new TsunamiEffect(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerFish(PlayerFishEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (event.getState() == PlayerFishEvent.State.FISHING) {
            this.activeFishers.put(playerId, System.currentTimeMillis());
            this.lastFishingActivity.put(playerId, System.currentTimeMillis());
        } else if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH || event.getState() == PlayerFishEvent.State.FAILED_ATTEMPT || event.getState() == PlayerFishEvent.State.IN_GROUND || event.getState() == PlayerFishEvent.State.REEL_IN) {
            this.activeFishers.remove(playerId);
            this.lastFishingActivity.put(playerId, System.currentTimeMillis());
        }
        if (!this.configManager.isFishingEnabled()) {
            return;
        }
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        if (this.processingPlayers.contains(playerId)) {
            return;
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        Location hookLocation = null;
        if (event.getHook() != null) {
            hookLocation = event.getHook().getLocation();
        }
        this.processingPlayers.add(playerId);
        try {
            if (this.configManager.isReplaceVanilla()) {
                String caughtFishId;
                MrUltimateFishing mrPlugin;
                ItemStack biomeCheckRod = player.getInventory().getItemInMainHand();
                if (biomeCheckRod.getType() != Material.FISHING_ROD) {
                    biomeCheckRod = player.getInventory().getItemInOffHand();
                }
                boolean hasBiomeTeleportationCheck = false;
                int biomeTeleportationLevelCheck = 0;
                if (biomeCheckRod.getType() == Material.FISHING_ROD && (hasBiomeTeleportationCheck = (mrPlugin = this.plugin).getEnchantManager().hasEnchantOnRod(biomeCheckRod, "BiomeTeleportation"))) {
                    biomeTeleportationLevelCheck = mrPlugin.getEnchantManager().getEnchantLevelOnRod(biomeCheckRod, "BiomeTeleportation");
                }
                if ((caughtFishId = this.handleCustomFishing(player, hasBiomeTeleportationCheck, biomeTeleportationLevelCheck)) != null) {
                    FishItem fishItem = new FishItem(this.configManager);
                    String finalFishId = this.checkMythicWaterBonus(player, caughtFishId, hookLocation);
                    ItemStack customFish = fishItem.createFishItem(finalFishId, player);
                    if (customFish != null) {
                        ItemStack enchantBonusFish;
                        ItemStack secondFish;
                        Item caughtItem = (Item)event.getCaught();
                        caughtItem.setItemStack(customFish);
                        boolean isFishingInTornado = this.tornadoEffect.isPlayerInTornado(player, hookLocation != null ? hookLocation : player.getLocation());
                        ItemStack fishingRod = player.getInventory().getItemInMainHand();
                        if (fishingRod.getType() != Material.FISHING_ROD) {
                            fishingRod = player.getInventory().getItemInOffHand();
                        }
                        boolean hasGoldenPlace = false;
                        boolean hasMagicStorm = false;
                        boolean hasFeeding = false;
                        boolean hasBiomeTeleportation = false;
                        boolean hasCrabBait = false;
                        boolean hasProfessionalFisher = false;
                        boolean hasSharpBait = false;
                        int goldenPlaceLevel = 0;
                        int magicStormLevel = 0;
                        int feedingLevel = 0;
                        int biomeTeleportationLevel = 0;
                        int crabBaitLevel = 0;
                        int professionalFisherLevel = 0;
                        int sharpBaitLevel = 0;
                        if (fishingRod.getType() == Material.FISHING_ROD) {
                            MrUltimateFishing mrPlugin2 = this.plugin;
                            hasGoldenPlace = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "GoldenPlace");
                            hasMagicStorm = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "MagicStorm");
                            hasFeeding = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "Feeding");
                            hasBiomeTeleportation = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "BiomeTeleportation");
                            hasCrabBait = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "CrabBait");
                            hasProfessionalFisher = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "ProfessionalFisher");
                            hasSharpBait = mrPlugin2.getEnchantManager().hasEnchantOnRod(fishingRod, "SharpBait");
                            if (hasGoldenPlace) {
                                goldenPlaceLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "GoldenPlace");
                            }
                            if (hasMagicStorm) {
                                magicStormLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "MagicStorm");
                            }
                            if (hasFeeding) {
                                feedingLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "Feeding");
                            }
                            if (hasBiomeTeleportation) {
                                biomeTeleportationLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "BiomeTeleportation");
                            }
                            if (hasCrabBait) {
                                crabBaitLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "CrabBait");
                            }
                            if (hasProfessionalFisher) {
                                professionalFisherLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "ProfessionalFisher");
                            }
                            if (hasSharpBait) {
                                sharpBaitLevel = mrPlugin2.getEnchantManager().getEnchantLevelOnRod(fishingRod, "SharpBait");
                            }
                        }
                        boolean isStorm = player.getWorld().hasStorm() || player.getWorld().isThundering();
                        boolean shouldGiveEnchantBonus = false;
                        String enchantMessage = null;
                        if (hasGoldenPlace) {
                            double goldenPlaceChance = (double)goldenPlaceLevel * this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.GoldenPlace.Enchant.Bonus", 10.0);
                            double randomValue = this.random.nextDouble() * 100.0;
                            if (randomValue < goldenPlaceChance) {
                                shouldGiveEnchantBonus = true;
                                enchantMessage = "enchants.double-catch-golden-place";
                            }
                        }
                        if (hasMagicStorm && isStorm && !shouldGiveEnchantBonus) {
                            double magicStormChance = (double)magicStormLevel * this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.MagicStorm.Enchant.Bonus", 10.0);
                            if (this.random.nextDouble() * 100.0 < magicStormChance) {
                                shouldGiveEnchantBonus = true;
                                enchantMessage = "enchants.double-catch-magic-storm";
                            }
                        }
                        if (isFishingInTornado && (secondFish = fishItem.createFishItem(finalFishId, player)) != null) {
                            player.getInventory().addItem(new ItemStack[]{secondFish});
                            if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
                                // empty if block
                            }
                        }
                        if (shouldGiveEnchantBonus && (enchantBonusFish = fishItem.createFishItem(finalFishId, player)) != null) {
                            String message;
                            MrUltimateFishing mrPlugin3;
                            MessageManager messageManager;
                            player.getInventory().addItem(new ItemStack[]{enchantBonusFish});
                            if (enchantMessage != null && (messageManager = (mrPlugin3 = this.plugin).getMessageManager()) != null && (message = messageManager.getMessage(enchantMessage)) != null && !message.isEmpty()) {
                                mrPlugin3.sendMessage(player, message);
                            }
                            if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
                                // empty if block
                            }
                        }
                        if (hasFeeding) {
                            int maxFood;
                            int currentFood;
                            double bonusPerLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.Feeding.Enchant.Bonus", 5.0);
                            double feedingChance = (double)feedingLevel * bonusPerLevel;
                            if (this.random.nextDouble() * 100.0 < feedingChance && (currentFood = player.getFoodLevel()) < (maxFood = 20)) {
                                player.setFoodLevel(Math.min(maxFood, currentFood + 2));
                                player.setSaturation(Math.min(20.0f, player.getSaturation() + 1.0f));
                                String message = this.plugin.getMessageManager().getMessage("enchants.feeding-restored-hunger");
                                if (message != null && !message.isEmpty()) {
                                    this.plugin.sendMessage(player, message);
                                }
                            }
                        }
                        this.sendFishCaughtMessage(player, finalFishId);
                        String rarity = this.configManager.getFishRarity(finalFishId);
                        this.plugin.getTournamentManager().onFishCatch(player, finalFishId, rarity);
                        this.handleFishCatch(player, finalFishId, hookLocation, hasProfessionalFisher, professionalFisherLevel, hasSharpBait, sharpBaitLevel);
                        this.handleCrabCatch(player, hookLocation, hasCrabBait, crabBaitLevel);
                    }
                } else {
                    event.setCancelled(true);
                    this.sendBiomeRestrictionMessage(player);
                }
            } else if (this.shouldCatchCustomFish()) {
                String finalFishId;
                FishItem fishItem;
                ItemStack customFish;
                String caughtFishId;
                MrUltimateFishing mrPlugin;
                ItemStack biomeCheckRod2 = player.getInventory().getItemInMainHand();
                if (biomeCheckRod2.getType() != Material.FISHING_ROD) {
                    biomeCheckRod2 = player.getInventory().getItemInOffHand();
                }
                boolean hasBiomeTeleportationCheck2 = false;
                int biomeTeleportationLevelCheck2 = 0;
                if (biomeCheckRod2.getType() == Material.FISHING_ROD && (hasBiomeTeleportationCheck2 = (mrPlugin = this.plugin).getEnchantManager().hasEnchantOnRod(biomeCheckRod2, "BiomeTeleportation"))) {
                    biomeTeleportationLevelCheck2 = mrPlugin.getEnchantManager().getEnchantLevelOnRod(biomeCheckRod2, "BiomeTeleportation");
                }
                if ((caughtFishId = this.handleCustomFishing(player, hasBiomeTeleportationCheck2, biomeTeleportationLevelCheck2)) != null && (customFish = (fishItem = new FishItem(this.configManager)).createFishItem(finalFishId = this.checkMythicWaterBonus(player, caughtFishId, hookLocation), player)) != null) {
                    ItemStack enchantBonusFish;
                    ItemStack secondFish;
                    boolean isFishingInTornado = this.tornadoEffect.isPlayerInTornado(player, hookLocation != null ? hookLocation : player.getLocation());
                    ItemStack fishingRod = player.getInventory().getItemInMainHand();
                    if (fishingRod.getType() != Material.FISHING_ROD) {
                        fishingRod = player.getInventory().getItemInOffHand();
                    }
                    boolean hasGoldenPlace = false;
                    boolean hasMagicStorm = false;
                    boolean hasFeeding = false;
                    boolean hasBiomeTeleportation = false;
                    boolean hasCrabBait = false;
                    boolean hasProfessionalFisher = false;
                    boolean hasSharpBait = false;
                    int goldenPlaceLevel = 0;
                    int magicStormLevel = 0;
                    int feedingLevel = 0;
                    int biomeTeleportationLevel = 0;
                    int crabBaitLevel = 0;
                    int professionalFisherLevel = 0;
                    int sharpBaitLevel = 0;
                    if (fishingRod.getType() == Material.FISHING_ROD) {
                        MrUltimateFishing mrPlugin4 = this.plugin;
                        hasGoldenPlace = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "GoldenPlace");
                        hasMagicStorm = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "MagicStorm");
                        hasFeeding = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "Feeding");
                        hasBiomeTeleportation = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "BiomeTeleportation");
                        hasCrabBait = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "CrabBait");
                        hasProfessionalFisher = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "ProfessionalFisher");
                        hasSharpBait = mrPlugin4.getEnchantManager().hasEnchantOnRod(fishingRod, "SharpBait");
                        if (hasGoldenPlace) {
                            goldenPlaceLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "GoldenPlace");
                        }
                        if (hasMagicStorm) {
                            magicStormLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "MagicStorm");
                        }
                        if (hasFeeding) {
                            feedingLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "Feeding");
                        }
                        if (hasBiomeTeleportation) {
                            biomeTeleportationLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "BiomeTeleportation");
                        }
                        if (hasCrabBait) {
                            crabBaitLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "CrabBait");
                        }
                        if (hasProfessionalFisher) {
                            professionalFisherLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "ProfessionalFisher");
                        }
                        if (hasSharpBait) {
                            sharpBaitLevel = mrPlugin4.getEnchantManager().getEnchantLevelOnRod(fishingRod, "SharpBait");
                        }
                    }
                    boolean isStorm = player.getWorld().hasStorm() || player.getWorld().isThundering();
                    boolean shouldGiveEnchantBonus = false;
                    String enchantMessage = null;
                    if (hasGoldenPlace) {
                        double goldenPlaceChance = (double)goldenPlaceLevel * this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.GoldenPlace.Enchant.Bonus", 10.0);
                        double randomValue = this.random.nextDouble() * 100.0;
                        if (randomValue < goldenPlaceChance) {
                            shouldGiveEnchantBonus = true;
                            enchantMessage = "enchants.double-catch-golden-place";
                        }
                    }
                    if (hasMagicStorm && isStorm && !shouldGiveEnchantBonus) {
                        double magicStormChance = (double)magicStormLevel * this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.MagicStorm.Enchant.Bonus", 10.0);
                        if (this.random.nextDouble() * 100.0 < magicStormChance) {
                            shouldGiveEnchantBonus = true;
                            enchantMessage = "enchants.double-catch-magic-storm";
                        }
                    }
                    player.getInventory().addItem(new ItemStack[]{customFish});
                    if (isFishingInTornado && (secondFish = fishItem.createFishItem(finalFishId, player)) != null) {
                        player.getInventory().addItem(new ItemStack[]{secondFish});
                        if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
                            this.plugin.sendMessage(player, MrLibColors.colorize((String)"&e[DEBUG] Tornado bonus: +1 extra fish!"));
                        }
                    }
                    if (shouldGiveEnchantBonus && (enchantBonusFish = fishItem.createFishItem(finalFishId, player)) != null) {
                        String message;
                        MrUltimateFishing mrPlugin5;
                        MessageManager messageManager;
                        player.getInventory().addItem(new ItemStack[]{enchantBonusFish});
                        if (enchantMessage != null && (messageManager = (mrPlugin5 = this.plugin).getMessageManager()) != null && (message = messageManager.getMessage(enchantMessage)) != null && !message.isEmpty()) {
                            this.plugin.sendMessage(player, message);
                        }
                        if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
                            String enchantSource = hasGoldenPlace && enchantMessage.contains("golden") ? "GoldenPlace" : "MagicStorm";
                            this.plugin.sendMessage(player, MrLibColors.colorize((String)("&a[DEBUG] Enchant bonus: +1 extra fish from " + enchantSource + "!")));
                        }
                    }
                    if (hasFeeding) {
                        int maxFood;
                        int currentFood;
                        double bonusPerLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.Feeding.Enchant.Bonus", 5.0);
                        double feedingChance = (double)feedingLevel * bonusPerLevel;
                        if (this.random.nextDouble() * 100.0 < feedingChance && (currentFood = player.getFoodLevel()) < (maxFood = 20)) {
                            player.setFoodLevel(Math.min(maxFood, currentFood + 2));
                            player.setSaturation(Math.min(20.0f, player.getSaturation() + 1.0f));
                            String message = this.plugin.getMessageManager().getMessage("enchants.feeding-restored-hunger");
                            if (message != null && !message.isEmpty()) {
                                this.plugin.sendMessage(player, message);
                            }
                        }
                    }
                    this.sendFishCaughtMessage(player, finalFishId);
                    String rarity = this.configManager.getFishRarity(finalFishId);
                    this.plugin.getTournamentManager().onFishCatch(player, finalFishId, rarity);
                    this.handleFishCatch(player, finalFishId, hookLocation, hasProfessionalFisher, professionalFisherLevel, hasSharpBait, sharpBaitLevel);
                    this.handleCrabCatch(player, hookLocation, hasCrabBait, crabBaitLevel);
                }
            }
        }
        finally {
            this.processingPlayers.remove(playerId);
        }
    }

    private String handleCustomFishing(Player player) {
        return this.handleCustomFishing(player, false, 0);
    }

    private String handleCustomFishing(Player player, boolean hasBiomeTeleportation, int biomeTeleportationLevel) {
        ArrayList<String> availableFish;
        Location location = player.getLocation();
        Biome currentBiome = location.getBlock().getBiome();
        List<String> allFishIds = this.getAllAvailableFish();
        if (allFishIds.isEmpty()) {
            this.plugin.getLogger().warning("No custom fish configured!");
            return null;
        }
        boolean isFishingInTsunami = this.tsunamiEffect.isPlayerInTsunami(player, location);
        boolean canCatchFromAnyBiome = false;
        if (hasBiomeTeleportation && biomeTeleportationLevel > 0) {
            double biomeTeleportationChance = (double)biomeTeleportationLevel * this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.BiomeTeleportation.Enchant.Bonus", 15.0);
            if (this.random.nextDouble() * 100.0 < biomeTeleportationChance) {
                String message;
                canCatchFromAnyBiome = true;
                if (player != null && (message = this.plugin.getMessageManager().getMessage("enchants.biome-teleportation-triggered")) != null && !message.isEmpty()) {
                    this.plugin.sendMessage(player, message);
                }
            }
        }
        if (isFishingInTsunami || canCatchFromAnyBiome) {
            availableFish = new ArrayList<String>(allFishIds);
        } else {
            availableFish = new ArrayList();
            for (String fishId : allFishIds) {
                if (!this.canCatchFishInBiome(fishId, currentBiome)) continue;
                availableFish.add(fishId);
            }
        }
        if (availableFish.isEmpty()) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("No fish available in biome " + currentBiome.name() + " for " + player.getName());
            }
            return null;
        }
        return this.selectRandomFish(availableFish, player);
    }

    private List<String> getAllAvailableFish() {
        ArrayList<String> allFish = new ArrayList<String>();
        Set<String> fishIds = this.configManager.getAllFishIds();
        if (fishIds != null) {
            allFish.addAll(fishIds);
        }
        if (this.configManager.isDebugEnabled()) {
            for (String fishId : allFish) {
                String string = this.configManager.getFishRarity(fishId);
            }
        }
        return allFish;
    }

    private String selectRandomFish(List<String> fishIds) {
        if (fishIds.isEmpty()) {
            return null;
        }
        double totalWeight = 0.0;
        for (String fishId : fishIds) {
            double chance = this.getFishCatchChance(fishId);
            totalWeight += chance;
        }
        if (totalWeight <= 0.0) {
            return fishIds.get(this.random.nextInt(fishIds.size()));
        }
        double randomValue = this.random.nextDouble() * totalWeight;
        double currentWeight = 0.0;
        for (String fishId : fishIds) {
            double chance = this.getFishCatchChance(fishId);
            if (!(randomValue <= (currentWeight += chance))) continue;
            return fishId;
        }
        return fishIds.get(fishIds.size() - 1);
    }

    private String selectRandomFish(List<String> fishIds, Player player) {
        List<String> rarityHierarchy;
        int currentIndex;
        String currentRarity;
        if (fishIds.isEmpty()) {
            return null;
        }
        String selectedFish = this.selectRandomFish(fishIds);
        MrUltimateFishing mrPlugin = this.plugin;
        if (mrPlugin.getBoosterManager() != null && (currentRarity = this.configManager.getFishRarity(selectedFish)) != null && (currentIndex = (rarityHierarchy = this.getDynamicRarityHierarchy()).indexOf(currentRarity.toUpperCase())) >= 0 && currentIndex < rarityHierarchy.size() - 1) {
            for (int i = currentIndex + 1; i < rarityHierarchy.size(); ++i) {
                String upgradedFish;
                String targetRarity = rarityHierarchy.get(i);
                double rarityBoostChance = mrPlugin.getBoosterManager().getRarityBoostChance(player, targetRarity);
                if (!(rarityBoostChance > 0.0) || !(this.random.nextDouble() * 100.0 < rarityBoostChance) || (upgradedFish = this.tryUpgradeToSpecificRarity(fishIds, targetRarity)) == null) continue;
                this.plugin.sendMessage(player, MrLibColors.colorize((String)("&a&lRarity Booster! &7Your " + currentRarity + " fish was upgraded to " + targetRarity + "!")));
                return upgradedFish;
            }
        }
        return selectedFish;
    }

    private List<String> getDynamicRarityHierarchy() {
        Set<String> allRarities = this.configManager.getAllRarities();
        if (allRarities == null || allRarities.isEmpty()) {
            return Arrays.asList("COMMON", "UNCOMMON", "RARE", "EPIC", "LEGENDARY", "MYTHIC", "ULTIMATE");
        }
        ArrayList rarityPrices = new ArrayList();
        for (String rarity : allRarities) {
            double d = this.configManager.getRaritySellPrice(rarity);
            rarityPrices.add(new AbstractMap.SimpleEntry<String, Double>(rarity, d));
        }
        rarityPrices.sort(Map.Entry.comparingByValue());
        ArrayList<String> sortedRarities = new ArrayList<String>();
        for (Map.Entry entry : rarityPrices) {
            sortedRarities.add(((String)entry.getKey()).toUpperCase());
        }
        return sortedRarities;
    }

    private String tryUpgradeToRarity(List<String> availableFish, String currentRarity) {
        List<String> rarityHierarchy = this.getDynamicRarityHierarchy();
        int currentIndex = rarityHierarchy.indexOf(currentRarity.toUpperCase());
        if (currentIndex == -1 || currentIndex >= rarityHierarchy.size() - 1) {
            return null;
        }
        for (int i = currentIndex + 1; i < rarityHierarchy.size(); ++i) {
            String targetRarity = rarityHierarchy.get(i);
            ArrayList<String> higherRarityFish = new ArrayList<String>();
            for (String fishId : availableFish) {
                String fishRarity = this.configManager.getFishRarity(fishId);
                if (!targetRarity.equalsIgnoreCase(fishRarity)) continue;
                higherRarityFish.add(fishId);
            }
            if (higherRarityFish.isEmpty()) continue;
            return (String)higherRarityFish.get(this.random.nextInt(higherRarityFish.size()));
        }
        return null;
    }

    private String tryUpgradeToSpecificRarity(List<String> availableFish, String targetRarity) {
        ArrayList<String> targetRarityFish = new ArrayList<String>();
        for (String fishId : availableFish) {
            String fishRarity = this.configManager.getFishRarity(fishId);
            if (!targetRarity.equalsIgnoreCase(fishRarity)) continue;
            targetRarityFish.add(fishId);
        }
        if (!targetRarityFish.isEmpty()) {
            return (String)targetRarityFish.get(this.random.nextInt(targetRarityFish.size()));
        }
        return null;
    }

    private double getFishCatchChance(String fishId) {
        boolean hasOverrideRarity = this.configManager.getFishOverrideRarity(fishId);
        if (hasOverrideRarity) {
            return this.configManager.getFishCatchChance(fishId);
        }
        String rarityId = this.configManager.getFishRarity(fishId);
        if (rarityId != null) {
            return this.configManager.getRarityChanceToCatch(rarityId);
        }
        return 1.0;
    }

    private boolean shouldCatchCustomFish() {
        return this.random.nextBoolean();
    }

    private boolean canCatchFishInBiome(String fishId, Biome currentBiome) {
        List<String> allowedBiomes = this.configManager.getFishBiomes(fishId);
        if (allowedBiomes == null || allowedBiomes.isEmpty()) {
            return true;
        }
        for (String biome : allowedBiomes) {
            if (!biome.equalsIgnoreCase("ALL") && !biome.equalsIgnoreCase(currentBiome.name())) continue;
            return true;
        }
        return false;
    }

    private void sendFishCaughtMessage(Player player, String fishId) {
        MrUltimateFishing mrPlugin = this.plugin;
        MessageManager messageManager = mrPlugin.getMessageManager();
        if (messageManager == null) {
            return;
        }
        String fishName = this.configManager.getFishDisplayName(fishId);
        String rarity = this.configManager.getFishRarity(fishId);
        String rarityName = this.configManager.getRarityName(rarity);
        messageManager.sendMessage((CommandSender)player, "fishing.fish-caught", "[fish]", fishName != null ? fishName : fishId, "[rarity]", rarityName != null ? rarityName : rarity, "[PlayerName]", player.getName());
    }

    private void sendBiomeRestrictionMessage(Player player) {
        MrUltimateFishing mrPlugin = this.plugin;
        MessageManager messageManager = mrPlugin.getMessageManager();
        if (messageManager == null) {
            return;
        }
        Location location = player.getLocation();
        Biome currentBiome = location.getBlock().getBiome();
        messageManager.sendMessage((CommandSender)player, "fishing.biome-restriction", "[biome]", currentBiome.name(), "[PlayerName]", player.getName());
    }

    private void handleFishCatch(Player player, String fishId, Location hookLocation, boolean hasProfessionalFisher, int professionalFisherLevel, boolean hasSharpBait, int sharpBaitLevel) {
        int nearbyFishingPlayers;
        double bonusPerLevel;
        MrUltimateFishing mrPlugin = this.plugin;
        PlayerDataManager playerDataManager = mrPlugin.getPlayerDataManager();
        if (playerDataManager == null) {
            return;
        }
        int baseXpGained = this.calculateXPGain(fishId);
        int baseFishScalesGained = this.calculateFishScaleGain(fishId);
        double fishScaleBoostMultiplier = this.getFishScaleBoostMultiplier();
        baseFishScalesGained = (int)((double)baseFishScalesGained * fishScaleBoostMultiplier);
        double enchantXpMultiplier = 1.0;
        double enchantFishScalesMultiplier = 1.0;
        if (hasProfessionalFisher && professionalFisherLevel > 0) {
            bonusPerLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.ProfessionalFisher.Enchant.Bonus", 0.25);
            enchantXpMultiplier += (double)professionalFisherLevel * bonusPerLevel;
        }
        if (hasSharpBait && sharpBaitLevel > 0) {
            bonusPerLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.SharpBait.Enchant.Bonus", 0.15);
            enchantFishScalesMultiplier += (double)sharpBaitLevel * bonusPerLevel;
        }
        int enchantXpGained = (int)((double)baseXpGained * enchantXpMultiplier);
        int enchantFishScalesGained = (int)((double)baseFishScalesGained * enchantFishScalesMultiplier);
        if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
            if (!hasProfessionalFisher || professionalFisherLevel > 0) {
                // empty if block
            }
            if (!hasSharpBait || sharpBaitLevel > 0) {
                // empty if block
            }
        }
        double upgradeXpMultiplier = mrPlugin.getMenuManager().getUpgradeMenuManager().getXPUpgradeMultiplier(player);
        double upgradeFishScalesMultiplier = mrPlugin.getMenuManager().getUpgradeMenuManager().getFSUpgradeMultiplier(player);
        double boosterXpMultiplier = mrPlugin.getBoosterManager().getBoosterMultiplier(player, BoosterManager.BoosterType.XP);
        double boosterFishScalesMultiplier = mrPlugin.getBoosterManager().getBoosterMultiplier(player, BoosterManager.BoosterType.FISHSCALES);
        int upgradeXpGained = (int)((double)enchantXpGained * upgradeXpMultiplier * boosterXpMultiplier);
        int upgradeFishScalesGained = (int)((double)enchantFishScalesGained * upgradeFishScalesMultiplier * boosterFishScalesMultiplier);
        boolean isFishingInTornado = this.tornadoEffect.isPlayerInTornado(player, hookLocation != null ? hookLocation : player.getLocation());
        boolean isFishingInTsunami = this.tsunamiEffect.isPlayerInTsunami(player, hookLocation != null ? hookLocation : player.getLocation());
        if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
            if (isFishingInTornado) {
                // empty if block
            }
            if (isFishingInTsunami) {
                // empty if block
            }
        }
        if (isFishingInTornado) {
            upgradeXpGained *= 2;
            upgradeFishScalesGained *= 2;
        }
        boolean isPartyFishing = false;
        int finalXpGained = upgradeXpGained;
        int finalFishScalesGained = upgradeFishScalesGained;
        if (this.isPartyFishingEnabled() && (nearbyFishingPlayers = this.getNearbyFishingPlayers(player)) >= 2) {
            isPartyFishing = true;
            int maxPlayerBonus = this.getMaxPlayerBonus();
            int effectivePlayers = Math.min(nearbyFishingPlayers, maxPlayerBonus);
            double partyXpMultiplier = this.getPartyXPMultiplier();
            double partyFishScalesMultiplier = this.getPartyFishScalesMultiplier();
            finalXpGained = (int)((double)upgradeXpGained * (1.0 + partyXpMultiplier * (double)(effectivePlayers - 1)));
            finalFishScalesGained = (int)((double)upgradeFishScalesGained * (1.0 + partyFishScalesMultiplier * (double)(effectivePlayers - 1)));
        }
        this.plugin.getPlayerDataManager().handleFishCatch(player, fishId);
        String rarity = this.configManager.getFishRarity(fishId);
        mrPlugin.getCommunityQuestIntegration().processFishCatch(player, fishId, rarity);
        mrPlugin.getCommunityQuestIntegration().processSpecificFishCatch(player, fishId);
        this.handleDeliveryFishCatch(player, fishId);
        this.sendActionBarMessage(player, finalXpGained, finalFishScalesGained, isPartyFishing, hasProfessionalFisher, professionalFisherLevel, hasSharpBait, sharpBaitLevel);
        if (fishScaleBoostMultiplier > 1.0) {
            String bonusMessage = this.plugin.getPrefix() + "&aYou received a &6" + String.format("%.1f", fishScaleBoostMultiplier) + "x&a fish scales bonus from the active event!";
            this.plugin.sendMessage(player, bonusMessage);
        }
        if (finalXpGained > baseXpGained || finalFishScalesGained > baseFishScalesGained) {
            int bonusXP = finalXpGained - baseXpGained;
            int bonusFishScales = finalFishScalesGained - baseFishScalesGained;
            if (bonusXP > 0) {
                this.plugin.getPlayerDataManager().addXP(player, bonusXP);
            }
            if (bonusFishScales > 0) {
                this.plugin.getPlayerDataManager().addFishScale(player, bonusFishScales);
                mrPlugin.getCommunityQuestIntegration().processFishScalesEarning(player, bonusFishScales);
            }
        }
        this.handleSpecialEffects(player, fishId, hookLocation);
    }

    private void handleDeliveryFishCatch(Player player, String fishId) {
        MrUltimateFishing mrPlugin = this.plugin;
        PlayerDataManager.PlayerData playerData = mrPlugin.getPlayerDataManager().getPlayerData(player);
        this.incrementWaitingDeliveryProgress(player, fishId);
        if (!playerData.hasActiveDelivery()) {
            return;
        }
        String deliveryType = playerData.getActiveDeliveryType();
        if (this.isFishValidForDelivery(fishId, deliveryType)) {
            playerData.incrementCaughtFishes();
            if (playerData.getCaughtFishes() >= playerData.getRequiredFishes()) {
                playerData.setDeliveryCompleted(true);
                String message = mrPlugin.getMessageManager().getMessage("delivery.completed");
                if (message != null && !message.isEmpty()) {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)message.replace("[PlayerName]", player.getName())));
                }
            }
            mrPlugin.getPlayerDataManager().savePlayerData(player);
        }
    }

    private void incrementWaitingDeliveryProgress(Player player, String fishId) {
        FileConfiguration deliveryConfig;
        MrUltimateFishing mrPlugin = this.plugin;
        PlayerDataManager.PlayerData playerData = mrPlugin.getPlayerDataManager().getPlayerData(player);
        int playerDeliverySlots = mrPlugin.getPlayerDataManager().getCurrentDeliverySlots(playerData);
        int firstWaitingSlotIndex = -1;
        for (int i = 0; i < playerDeliverySlots; ++i) {
            if (playerData.hasAvailableDelivery(i)) continue;
            firstWaitingSlotIndex = i;
            break;
        }
        if (firstWaitingSlotIndex >= 0 && (deliveryConfig = mrPlugin.getConfigManager().getDeliveryConfig()) != null) {
            int requiredFishesToGetDelivery = deliveryConfig.getInt("MrUltimateFishing.Delivery.Required-Fishes-To-Get-Delivery", 80);
            int lessFishesBonus = playerData.getLessFishesToGetBonus();
            requiredFishesToGetDelivery = Math.max(1, requiredFishesToGetDelivery - lessFishesBonus);
            playerData.incrementWaitingDeliveryProgress(firstWaitingSlotIndex);
            int currentProgress = playerData.getWaitingDeliveryProgress(firstWaitingSlotIndex);
            if (currentProgress >= requiredFishesToGetDelivery) {
                this.createAvailableDeliveryForSlot(player, firstWaitingSlotIndex);
                playerData.setWaitingDeliveryProgress(firstWaitingSlotIndex, 0);
            }
        }
        mrPlugin.getPlayerDataManager().savePlayerData(player);
        mrPlugin.getMenuManager().getDeliveryMenuManager().refreshDeliveryMenuForPlayer(player);
    }

    private void createAvailableDeliveryForSlot(Player player, int slotIndex) {
        MrUltimateFishing mrPlugin = this.plugin;
        PlayerDataManager.PlayerData playerData = mrPlugin.getPlayerDataManager().getPlayerData(player);
        FileConfiguration deliveryConfig = mrPlugin.getConfigManager().getDeliveryConfig();
        if (deliveryConfig == null) {
            return;
        }
        String deliveryType = this.selectRandomDeliveryType(player);
        ConfigurationSection deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
        if (deliverySettings == null) {
            return;
        }
        int minFishes = deliverySettings.getInt("Required-Fishes.Required-Fishes.Minimum", 10);
        int maxFishes = deliverySettings.getInt("Required-Fishes.Required-Fishes.Maximum", 25);
        int requiredFishes = minFishes + new Random().nextInt(maxFishes - minFishes + 1);
        int lessFishesCompleteBonus = playerData.getLessFishesToCompleteBonus();
        requiredFishes = Math.max(1, requiredFishes - lessFishesCompleteBonus);
        int minFishScales = deliverySettings.getInt("Rewards.FishScales.Minimum", 1000);
        int maxFishScales = deliverySettings.getInt("Rewards.FishScales.Maximum", 5000);
        int fishScalesReward = minFishScales + new Random().nextInt(maxFishScales - minFishScales + 1);
        HashMap<String, Integer> fishRequirements = new HashMap<String, Integer>();
        ConfigurationSection raritySection = deliverySettings.getConfigurationSection("Required-Fishes.CanPickFishesFromRarity");
        if (raritySection != null) {
            String firstRarity;
            List fishNames;
            ArrayList<String> fishNames2;
            HashMap rarityFishMap = new HashMap();
            HashMap<String, Integer> rarityPercentages = new HashMap<String, Integer>();
            for (String rarity : raritySection.getKeys(false)) {
                List<String> fishIds;
                int percentage;
                ConfigurationSection raritySettings = raritySection.getConfigurationSection(rarity);
                if (raritySettings == null || !raritySettings.getBoolean("Enabled", false) || (percentage = raritySettings.getInt("Percentage", 0)) <= 0 || (fishIds = mrPlugin.getConfigManager().getFishIdsByRarity(rarity)).isEmpty()) continue;
                fishNames2 = new ArrayList<String>();
                for (String fishId : fishIds) {
                    String fishName = mrPlugin.getConfigManager().getFishDisplayName(fishId);
                    if (fishName == null || fishName.isEmpty()) {
                        fishName = "Unknown Fish";
                    }
                    fishNames2.add(fishName);
                }
                rarityFishMap.put(rarity, fishNames2);
                rarityPercentages.put(rarity, percentage);
            }
            int remainingFishes = requiredFishes;
            ArrayList sortedRarities = new ArrayList(rarityPercentages.keySet());
            for (int i = 0; i < sortedRarities.size(); ++i) {
                int fishCount;
                String rarity = (String)sortedRarities.get(i);
                int percentage = (Integer)rarityPercentages.get(rarity);
                fishNames2 = (ArrayList<String>)rarityFishMap.get(rarity);
                if (fishNames2 == null || fishNames2.isEmpty()) continue;
                if (i == sortedRarities.size() - 1) {
                    fishCount = remainingFishes;
                } else {
                    fishCount = Math.max(1, requiredFishes * percentage / 100);
                    fishCount = Math.min(fishCount, remainingFishes);
                }
                Random fishRandom = new Random();
                for (int j = 0; j < fishCount; ++j) {
                    String selectedFish = (String)fishNames2.get(fishRandom.nextInt(fishNames2.size()));
                    fishRequirements.put(selectedFish, fishRequirements.getOrDefault(selectedFish, 0) + 1);
                }
                if ((remainingFishes -= fishCount) <= 0) break;
            }
            if (remainingFishes > 0 && !sortedRarities.isEmpty() && (fishNames = (List)rarityFishMap.get(firstRarity = (String)sortedRarities.get(0))) != null && !fishNames.isEmpty()) {
                Random fishRandom = new Random();
                for (int j = 0; j < remainingFishes; ++j) {
                    String selectedFish = (String)fishNames.get(fishRandom.nextInt(fishNames.size()));
                    fishRequirements.put(selectedFish, fishRequirements.getOrDefault(selectedFish, 0) + 1);
                }
            }
        }
        ArrayList<String> commandRewards = new ArrayList<String>();
        ConfigurationSection rewardsSection = deliverySettings.getConfigurationSection("Rewards.Command-Rewards.Rewards");
        if (rewardsSection != null) {
            int minRewards = deliverySettings.getInt("Rewards.Command-Rewards.Minimum", 1);
            int maxRewards = deliverySettings.getInt("Rewards.Command-Rewards.Maximum", 1);
            int rewardCount = minRewards + new Random().nextInt(maxRewards - minRewards + 1);
            int addedRewards = 0;
            ArrayList rewardKeys = new ArrayList(rewardsSection.getKeys(false));
            Collections.shuffle(rewardKeys);
            for (String rewardKey : rewardKeys) {
                String rewardText;
                if (addedRewards >= rewardCount) break;
                ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardKey);
                if (rewardSection == null || (rewardText = rewardSection.getString("Text", "")).isEmpty()) continue;
                commandRewards.add(rewardText);
                ++addedRewards;
            }
        }
        int shipmentTimeMinutes = 30;
        List shipmentTimes = deliverySettings.getStringList("Shipment-Times");
        if (!shipmentTimes.isEmpty()) {
            shipmentTimeMinutes = Integer.parseInt((String)shipmentTimes.get(new Random().nextInt(shipmentTimes.size())));
        }
        PlayerDataManager.AvailableDelivery availableDelivery = new PlayerDataManager.AvailableDelivery(deliveryType, requiredFishes, fishRequirements, fishScalesReward, commandRewards, shipmentTimeMinutes);
        playerData.setAvailableDelivery(slotIndex, availableDelivery);
        String message = mrPlugin.getMessageManager().getMessage("delivery.available");
        if (message != null && !message.isEmpty()) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)message));
        }
    }

    private String selectRandomDeliveryType(Player player) {
        MrUltimateFishing mrPlugin = this.plugin;
        FileConfiguration deliveryConfig = mrPlugin.getConfigManager().getDeliveryConfig();
        if (deliveryConfig == null) {
            return "COMMON";
        }
        ConfigurationSection deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings");
        if (deliverySettings == null) {
            return "COMMON";
        }
        double totalChance = 0.0;
        HashMap<String, Double> deliveryChances = new HashMap<String, Double>();
        for (String deliveryType : deliverySettings.getKeys(false)) {
            double chance;
            ConfigurationSection typeSection = deliverySettings.getConfigurationSection(deliveryType);
            if (typeSection == null || !((chance = typeSection.getDouble("Chance-To-This-Delivery", 0.0)) > 0.0)) continue;
            deliveryChances.put(deliveryType, chance);
            totalChance += chance;
        }
        if (totalChance <= 0.0) {
            return "COMMON";
        }
        double randomValue = new Random().nextDouble() * totalChance;
        double currentChance = 0.0;
        for (Map.Entry entry : deliveryChances.entrySet()) {
            if (!(randomValue <= (currentChance += ((Double)entry.getValue()).doubleValue()))) continue;
            return (String)entry.getKey();
        }
        return (String)deliveryChances.keySet().iterator().next();
    }

    private boolean isFishValidForDelivery(String fishId, String deliveryType) {
        MrUltimateFishing mrPlugin = this.plugin;
        FileConfiguration deliveryConfig = mrPlugin.getConfigManager().getDeliveryConfig();
        if (deliveryConfig == null) {
            return false;
        }
        String fishRarity = mrPlugin.getConfigManager().getFishRarity(fishId);
        if (fishRarity == null) {
            return false;
        }
        ConfigurationSection deliverySettings = deliveryConfig.getConfigurationSection("MrUltimateFishing.Delivery.Delivery-Settings." + deliveryType);
        if (deliverySettings == null) {
            return false;
        }
        ConfigurationSection raritySettings = deliverySettings.getConfigurationSection("Required-Fishes.CanPickFishesFromRarity." + fishRarity.toUpperCase());
        if (raritySettings == null) {
            return false;
        }
        boolean enabled = raritySettings.getBoolean("Enabled", false);
        return enabled;
    }

    private void handleSpecialEffects(Player player, String fishId, Location hookLocation) {
        String message;
        Location effectLocation;
        MrUltimateFishing mrPlugin = this.plugin;
        UpgradeMenuManager upgradeManager = mrPlugin.getMenuManager().getUpgradeMenuManager();
        int tornadoLevel = upgradeManager.getPlayerUpgradeLevel(player, "Tornado");
        int tsunamiLevel = upgradeManager.getPlayerUpgradeLevel(player, "Tsunami");
        Location location = effectLocation = hookLocation != null ? hookLocation : player.getLocation();
        if (tornadoLevel > 0 && this.plugin.getConfig().getBoolean("MrUltimateFishing.Upgrades.Tornado.enabled", false)) {
            int tornadoDuration;
            double tornadoChance = this.plugin.getConfig().getDouble("MrUltimateFishing.Upgrades.Tornado.TUpgradePercent", 0.3) * (double)tornadoLevel / 100.0;
            if (this.random.nextDouble() < tornadoChance && !this.tornadoEffect.hasActiveTornadoNear(effectLocation, 5.0) && !this.tsunamiEffect.hasActiveTsunamiNear(effectLocation, 5.0) && this.tornadoEffect.spawnTornado(player, effectLocation, tornadoDuration = this.plugin.getConfig().getInt("MrUltimateFishing.Upgrades.Tornado.TornadoTime", 10))) {
                if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
                    // empty if block
                }
                if ((message = this.plugin.getMessageManager().getMessage("upgrades.tornado-spawned", "[PlayerName]", player.getName())) != null && !message.isEmpty()) {
                    this.plugin.sendMessage(player, message);
                }
            }
        }
        if (tsunamiLevel > 0 && this.plugin.getConfig().getBoolean("MrUltimateFishing.Upgrades.Tsunami.enabled", false)) {
            int tsunamiDuration;
            double tsunamiChance = this.plugin.getConfig().getDouble("MrUltimateFishing.Upgrades.Tsunami.TUpgradePercent", 0.3) * (double)tsunamiLevel / 100.0;
            if (this.random.nextDouble() < tsunamiChance && !this.tsunamiEffect.hasActiveTsunamiNear(effectLocation, 5.0) && !this.tornadoEffect.hasActiveTornadoNear(effectLocation, 5.0) && this.tsunamiEffect.spawnTsunami(player, effectLocation, tsunamiDuration = this.plugin.getConfig().getInt("MrUltimateFishing.Upgrades.Tsunami.TsunamiTime", 10))) {
                if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.effects", false)) {
                    // empty if block
                }
                if ((message = this.plugin.getMessageManager().getMessage("upgrades.tsunami-spawned", "[PlayerName]", player.getName())) != null && !message.isEmpty()) {
                    this.plugin.sendMessage(player, message);
                }
            }
        }
    }

    private int calculateXPGain(String fishId) {
        int customXP;
        if (this.isVanillaFish(fishId)) {
            return (int)this.configManager.getVanillaFishXPReward();
        }
        String rarityId = this.configManager.getFishRarity(fishId);
        int baseXP = 10;
        if (rarityId != null) {
            baseXP = (int)this.configManager.getRarityXPReward(rarityId);
        }
        if ((customXP = (int)this.configManager.getFishXPReward(fishId)) > 0) {
            baseXP = customXP;
        }
        return baseXP;
    }

    private int calculateFishScaleGain(String fishId) {
        if (this.isVanillaFish(fishId)) {
            return (int)this.configManager.getVanillaFishScale();
        }
        String rarityId = this.configManager.getFishRarity(fishId);
        if (rarityId != null) {
            return (int)this.configManager.getRarityFishScale(rarityId);
        }
        return 1;
    }

    private void sendActionBarMessage(Player player, int xpGained, int fishScalesGained, boolean isPartyFishing, boolean hasProfessionalFisher, int professionalFisherLevel, boolean hasSharpBait, int sharpBaitLevel) {
        double enchantMultiplier;
        double bonusPerLevel;
        PlayerDataManager.PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        int currentXP = data.getFishingXP();
        int currentLevel = data.getFishingLevel();
        int nextLevel = currentLevel + 1;
        int needXP = this.plugin.getPlayerDataManager().getXPRequiredForNextLevel(player);
        Object professionalFisherXP = "0";
        Object sharpBaitFS = "0";
        if (hasProfessionalFisher && professionalFisherLevel > 0) {
            bonusPerLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.ProfessionalFisher.Enchant.Bonus", 0.25);
            enchantMultiplier = (double)professionalFisherLevel * bonusPerLevel;
            double baseXP = (double)xpGained / (1.0 + enchantMultiplier);
            int extraXP = xpGained - (int)baseXP;
            professionalFisherXP = "+" + extraXP;
        }
        if (hasSharpBait && sharpBaitLevel > 0) {
            bonusPerLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.SharpBait.Enchant.Bonus", 0.15);
            enchantMultiplier = (double)sharpBaitLevel * bonusPerLevel;
            double baseFishScales = (double)fishScalesGained / (1.0 + enchantMultiplier);
            int extraFishScales = fishScalesGained - (int)baseFishScales;
            sharpBaitFS = "+" + extraFishScales;
        }
        String messageKey = isPartyFishing ? "upgrades.actionbar-party-fishing" : "upgrades.actionbar-fishing";
        String message = this.plugin.getMessageManager().getMessage(messageKey, new String[]{"[xp]", String.valueOf(xpGained), "[scales]", String.valueOf(fishScalesGained), "[CurrentXp]", String.valueOf(currentXP), "[NeedXP]", String.valueOf(needXP), "[NextLevel]", String.valueOf(nextLevel), "[ProfessionalFisherXP]", professionalFisherXP, "[SharpBaitFS]", sharpBaitFS});
        if (message != null) {
            message = MrLibColors.colorize((String)message);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        }
    }

    private boolean isPartyFishingEnabled() {
        return this.plugin.getConfig().getBoolean("MrUltimateFishing.fishing.Party-Fishing.enabled", false);
    }

    private int getPartyRadius() {
        return this.plugin.getConfig().getInt("MrUltimateFishing.fishing.Party-Fishing.radius", 30);
    }

    private double getPartyXPMultiplier() {
        return this.plugin.getConfig().getDouble("MrUltimateFishing.fishing.Party-Fishing.xp-multiplier", 0.5);
    }

    private double getPartyFishScalesMultiplier() {
        return this.plugin.getConfig().getDouble("MrUltimateFishing.fishing.Party-Fishing.fish-scales-multiplier", 0.2);
    }

    private int getMaxPlayerBonus() {
        return this.plugin.getConfig().getInt("MrUltimateFishing.fishing.Party-Fishing.max-player-bonus", 10);
    }

    private int getNearbyFishingPlayers(Player player) {
        int count = 1;
        int radius = this.getPartyRadius();
        for (Player nearbyPlayer : player.getWorld().getPlayers()) {
            if (nearbyPlayer.equals((Object)player) || !(player.getLocation().distance(nearbyPlayer.getLocation()) <= (double)radius) || !this.isPlayerFishing(nearbyPlayer)) continue;
            ++count;
        }
        return count;
    }

    private boolean isPlayerFishing(Player player) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.activeFishers.containsKey(playerId)) {
            if (player.getInventory().getItemInMainHand().getType().name().contains("FISHING_ROD") || player.getInventory().getItemInOffHand().getType().name().contains("FISHING_ROD")) {
                return true;
            }
            this.activeFishers.remove(playerId);
            this.lastFishingActivity.put(playerId, currentTime);
        }
        if (this.lastFishingActivity.containsKey(playerId)) {
            long lastActivity = this.lastFishingActivity.get(playerId);
            if (currentTime - lastActivity <= 3000L) {
                return true;
            }
            this.lastFishingActivity.remove(playerId);
        }
        return false;
    }

    private boolean isVanillaFish(String fishId) {
        try {
            Material material = Material.valueOf((String)fishId.toUpperCase());
            return material == Material.COD || material == Material.SALMON || material == Material.TROPICAL_FISH || material == Material.PUFFERFISH;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void handleCrabCatch(Player player, Location hookLocation, boolean hasCrabBait, int crabBaitLevel) {
        double baseCrabChance;
        double finalCrabChance = baseCrabChance = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomDrops.Crab.catch-chance", 0.15);
        if (hasCrabBait && crabBaitLevel > 0) {
            double perLevelPercent = this.plugin.getConfig().getDouble("MrUltimateFishing.CustomEnchants.CrabBait.Enchant.Bonus", 1.0);
            double crabBaitBonus = (double)crabBaitLevel * (perLevelPercent / 100.0);
            finalCrabChance += crabBaitBonus;
        }
        if (this.random.nextDouble() < finalCrabChance) {
            Location spawnLocation;
            String crabName = this.plugin.getConfig().getString("MrUltimateFishing.CustomDrops.Crab.mob-name", "&cCrab");
            crabName = MrLibColors.colorize((String)crabName);
            Location location = spawnLocation = hookLocation != null ? hookLocation : player.getLocation();
            if (spawnLocation.getBlock().getType() == Material.WATER) {
                spawnLocation = spawnLocation.add(0.0, 1.0, 0.0);
            }
            Silverfish crab = (Silverfish)spawnLocation.getWorld().spawnEntity(spawnLocation, EntityType.SILVERFISH);
            crab.setCustomName(crabName);
            crab.setCustomNameVisible(true);
            crab.setMaxHealth(20.0);
            crab.setHealth(20.0);
            String message = this.plugin.getMessageManager().getMessage("fishing.crab-caught", "[PlayerName]", player.getName());
            if (message != null && !message.isEmpty()) {
                this.plugin.sendMessage(player, message);
            }
            if (this.plugin.getConfig().getBoolean("MrUltimateFishing.debug.drops", false)) {
                // empty if block
            }
        }
    }

    private String checkMythicWaterBonus(Player player, String originalFishId, Location hookLocation) {
        MrUltimateFishing mrPlugin = this.plugin;
        TotemManager totemManager = mrPlugin.getTotemManager();
        if (totemManager == null) {
            return originalFishId;
        }
        Location fishingLocation = hookLocation != null ? hookLocation : player.getLocation();
        for (TotemManager.TotemData totemData : totemManager.getAllTotems()) {
            double distance;
            if (!totemData.isActive() || !totemData.isCurrentlyActive() || !totemData.isMythicWaterActive() || !((distance = fishingLocation.distance(totemData.getLocation().clone().add(0.5, 0.5, 0.5))) <= (double)totemData.getCurrentRadius())) continue;
            String upgradedFishId = this.upgradeFishRarity(originalFishId);
            if (!upgradedFishId.equals(originalFishId)) {
                String oldRarity = this.getFishRarity(originalFishId);
                String newRarity = this.getFishRarity(upgradedFishId);
                String message = mrPlugin.getMessageManager().getMessage("totem-bonuses.mythic-water.fish-upgraded").replace("[old_rarity]", oldRarity).replace("[new_rarity]", newRarity);
                this.plugin.sendMessage(player, MrLibColors.colorize((String)message));
            }
            return upgradedFishId;
        }
        return originalFishId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String upgradeFishRarity(String fishId) {
        ConfigurationSection fishConfig = this.configManager.getFishConfig().getConfigurationSection("MrUltimateFishing." + fishId);
        if (fishConfig == null) {
            return fishId;
        }
        String currentRarity = fishConfig.getString("Fish.rarity", "COMMON");
        String targetRarity = null;
        FileConfiguration rarityCfg = this.configManager.getRarityConfig();
        if (rarityCfg == null) return fishId;
        ConfigurationSection raritiesSec = rarityCfg.getConfigurationSection("MrUltimateFishing.Rarity");
        if (raritiesSec == null) return fishId;
        Map entries = raritiesSec.getValues(false);
        ArrayList<String> orderedRarities = new ArrayList<String>();
        for (Map.Entry e : entries.entrySet()) {
            if (!(e.getValue() instanceof ConfigurationSection)) continue;
            orderedRarities.add((String)e.getKey());
        }
        int idx = -1;
        for (int i = 0; i < orderedRarities.size(); ++i) {
            if (!((String)orderedRarities.get(i)).equalsIgnoreCase(currentRarity)) continue;
            idx = i;
            break;
        }
        if (idx == -1 || idx >= orderedRarities.size() - 1) {
            return fishId;
        }
        targetRarity = (String)orderedRarities.get(idx + 1);
        List<String> targetRarityFish = this.getAllFishByRarity(targetRarity);
        if (!targetRarityFish.isEmpty()) return targetRarityFish.get(this.random.nextInt(targetRarityFish.size()));
        return fishId;
    }

    private String getFishRarity(String fishId) {
        ConfigurationSection fishConfig = this.configManager.getFishConfig().getConfigurationSection("MrUltimateFishing." + fishId);
        if (fishConfig == null) {
            return "UNKNOWN";
        }
        return fishConfig.getString("Fish.rarity", "COMMON");
    }

    private List<String> getAllFishByRarity(String rarity) {
        ArrayList<String> fishByRarity = new ArrayList<String>();
        List<String> allFishIds = this.getAllAvailableFish();
        for (String fishId : allFishIds) {
            String fishRarity;
            ConfigurationSection fishConfig = this.configManager.getFishConfig().getConfigurationSection("MrUltimateFishing." + fishId);
            if (fishConfig == null || !rarity.equalsIgnoreCase(fishRarity = fishConfig.getString("Fish.rarity", "COMMON"))) continue;
            fishByRarity.add(fishId);
        }
        return fishByRarity;
    }

    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void disable() {
    }

    public boolean giveFishToPlayer(Player player, String fishId, int amount) {
        ConfigurationSection fishConfig = this.configManager.getFishConfig().getConfigurationSection("MrUltimateFishing." + fishId);
        if (fishConfig == null) {
            return false;
        }
        FishItem fishItem = new FishItem(this.configManager);
        for (int i = 0; i < amount; ++i) {
            ItemStack fish = fishItem.createFishItem(fishId, player);
            if (fish == null) {
                return false;
            }
            player.getInventory().addItem(new ItemStack[]{fish});
        }
        return true;
    }

    public double getSellBoostMultiplier() {
        MrUltimateFishing plugin = this.plugin;
        if (plugin.getEventManager() != null && plugin.getEventManager().isEventActive()) {
            EventManager.ActiveEvent activeEvent = plugin.getEventManager().getActiveEvent();
            if (activeEvent.type == EventManager.EventType.SELLBOOST) {
                return activeEvent.getMultiplier();
            }
        }
        return 1.0;
    }

    public double getFishScaleBoostMultiplier() {
        MrUltimateFishing plugin = this.plugin;
        if (plugin.getEventManager() != null && plugin.getEventManager().isEventActive()) {
            EventManager.ActiveEvent activeEvent = plugin.getEventManager().getActiveEvent();
            if (activeEvent.type == EventManager.EventType.FISHSCALEBOOST) {
                return activeEvent.getMultiplier();
            }
        }
        return 1.0;
    }

    public double getGutBoostMultiplier() {
        MrUltimateFishing plugin = this.plugin;
        if (plugin.getEventManager() != null && plugin.getEventManager().isEventActive()) {
            EventManager.ActiveEvent activeEvent = plugin.getEventManager().getActiveEvent();
            if (activeEvent.type == EventManager.EventType.GUTBOOST) {
                return activeEvent.getMultiplier();
            }
        }
        return 1.0;
    }

    public double getXpLevelBoostMultiplier() {
        MrUltimateFishing plugin = this.plugin;
        if (plugin.getEventManager() != null && plugin.getEventManager().isEventActive()) {
            EventManager.ActiveEvent activeEvent = plugin.getEventManager().getActiveEvent();
            if (activeEvent.type == EventManager.EventType.BOOSTXPLEVEL) {
                return activeEvent.getMultiplier();
            }
        }
        return 1.0;
    }
}

